/*
* Media Element
* HTML5 <video> and <audio> Shim
* http://mediaelementjs.com/
*
* Creates a JavaScript object that mimics HTML5 media object
* for browsers that don't understand HTML5 or can't play the provided codec
* Can also play MP4 (H.264), Ogg, WebM, FLV, WMV, WMA, ACC, and MP3
*
* Copyright 2010, John Dyer
* Dual licensed under the MIT or GPL Version 2 licenses.
*
*/
var mejs=mejs||{};mejs.version="1.1.5";mejs.meIndex=0;mejs.plugins={silverlight:[{version:[3,0],types:["video/mp4","video/m4v","video/mov","video/wmv","audio/wma","audio/mp4","audio/m4a","audio/mp3"]}],flash:[{version:[9,0,124],types:["video/mp4","video/m4v","video/mov","video/flv","audio/flv","audio/mp3","audio/m4a","audio/mp3"]}]};mejs.PluginDetector={hasPluginVersion:function(c,a){var b=this.plugins[c];a[1]=a[1]||0;a[2]=a[2]||0;return(b[0]>a[0]||(b[0]==a[0]&&b[1]>a[1])||(b[0]==a[0]&&b[1]==a[1]&&b[2]>=a[2]))?true:false},nav:window.navigator,ua:window.navigator.userAgent.toLowerCase(),plugins:[],addPlugin:function(d,c,e,a,b){this.plugins[d]=this.detectPlugin(c,e,a,b)},detectPlugin:function(h,b,c,l){var j=[0,0,0],k,f,a;if(typeof(this.nav.plugins)!="undefined"&&typeof this.nav.plugins[h]=="object"){k=this.nav.plugins[h].description;if(k&&!(typeof this.nav.mimeTypes!="undefined"&&this.nav.mimeTypes[b]&&!this.nav.mimeTypes[b].enabledPlugin)){j=k.replace(h,"").replace(/^\s+/,"").replace(/\sr/gi,".").split(".");for(f=0;f<j.length;f++){j[f]=parseInt(j[f],10)}}}else{if(typeof(window.ActiveXObject)!="undefined"){try{a=new ActiveXObject(c);if(a){j=l(a)}}catch(g){}}}return j}};mejs.PluginDetector.addPlugin("flash","Shockwave Flash","application/x-shockwave-flash","ShockwaveFlash.ShockwaveFlash",function(b){var a=[],c=b.GetVariable("$version");if(c){c=c.split(" ")[1].split(",");a=[parseInt(c[0],10),parseInt(c[1],10),parseInt(c[2],10)]}return a});mejs.PluginDetector.addPlugin("silverlight","Silverlight Plug-In","application/x-silverlight-2","AgControl.AgControl",function(b){var a=[0,0,0,0],c=function(f,d,e,g){while(f.isVersionSupported(d[0]+"."+d[1]+"."+d[2]+"."+d[3])){d[e]+=g}d[e]-=g};c(b,a,0,1);c(b,a,1,1);c(b,a,2,10000);c(b,a,2,1000);c(b,a,2,100);c(b,a,2,10);c(b,a,2,1);c(b,a,3,1);return a});if(mejs.PluginDetector.ua.match(/Android 2\.[12]/)!==null){HTMLMediaElement.canPlayType=function(a){return(a.match(/video\/(mp4|m4v)/gi)!==null)?"probably":""}}mejs.MediaFeatures={init:function(){var e=mejs.PluginDetector.nav,c=mejs.PluginDetector.ua,b,a,d=["source","track","audio","video"];this.isiPad=(c.match(/iPad/i)!==null);this.isiPhone=(c.match(/iPhone/i)!==null);this.isAndroid=(c.match(/Android/i)!==null);this.isIE=(e.appName.indexOf("Microsoft")!=-1);for(b=0;b<d.length;b++){a=document.createElement(d[b])}this.hasNativeFullScreen=(typeof a.webkitEnterFullScreen!=="undefined");if(c.match(/Chrome/gi)){this.hasNativeFullScreen=false}}};mejs.MediaFeatures.init();mejs.Utility={escapeHTML:function(a){return a.split("&").join("&amp;").split("<").join("&lt;").split('"').join("&quot;")},absolutizeUrl:function(a){var b=document.createElement("div");b.innerHTML='<a href="'+this.escapeHTML(a)+'">x</a>';return b.firstChild.href},getScriptPath:function(b){var f=0,e,g="",d="",c,a=document.getElementsByTagName("script");for(;f<a.length;f++){c=a[f].src;for(e=0;e<b.length;e++){d=b[e];if(c.indexOf(d)>-1){g=c.substring(0,c.indexOf(d));break}}if(g!==""){break}}return g},secondsToTimeCode:function(b){b=Math.round(b);var a=Math.floor(b/60);a=(a>=10)?a:"0"+a;b=Math.floor(b%60);b=(b>=10)?b:"0"+b;return a+":"+b}};mejs.HtmlMediaElement={pluginType:"native",setCurrentTime:function(a){this.currentTime=a},setMuted:function(a){this.muted=a},setVolume:function(a){this.volume=a},setSrc:function(a){if(typeof a=="string"){this.src=a}else{var b,c;for(b=0;b<a.length;b++){c=a[b];if(this.canPlayType(c.type)){this.src=c.src}}}},setVideoSize:function(b,a){this.width=b;this.height=a}};mejs.PluginMediaElement=function(a,b){this.id=a;this.pluginType=b;this.events={}};mejs.PluginMediaElement.prototype={pluginElement:null,pluginType:"",playbackRate:-1,defaultPlaybackRate:-1,seekable:[],played:[],paused:true,ended:false,seeking:false,duration:0,muted:false,volume:1,currentTime:0,play:function(){if(this.pluginApi!=null){this.pluginApi.playMedia();this.paused=false}},load:function(){if(this.pluginApi!=null){this.pluginApi.loadMedia();this.paused=false}},pause:function(){if(this.pluginApi!=null){this.pluginApi.pauseMedia();this.paused=true}},canPlayType:function(e){var d,c,a,b=mejs.plugins[this.pluginType];for(d=0;d<b.length;d++){a=b[d];if(mejs.PluginDetector.hasPluginVersion(this.pluginType,a.version)){for(c=0;c<a.types.length;c++){if(e==a.types[c]){return true}}}}return false},setSrc:function(a){if(typeof a=="string"){this.pluginApi.setSrc(mejs.Utility.absolutizeUrl(a))}else{var b,c;for(b=0;b<a.length;b++){c=a[b];if(this.canPlayType(c.type)){this.pluginApi.setSrc(mejs.Utility.absolutizeUrl(c.src))}}}},setCurrentTime:function(a){if(this.pluginApi!=null){this.pluginApi.setCurrentTime(a);this.currentTime=a}},setVolume:function(a){if(this.pluginApi!=null){this.pluginApi.setVolume(a);this.volume=a}},setMuted:function(a){if(this.pluginApi!=null){this.pluginApi.setMuted(a);this.muted=a}},setVideoSize:function(b,a){if(this.pluginElement.style){this.pluginElement.style.width=b+"px";this.pluginElement.style.height=a+"px"}if(this.pluginApi!=null){this.pluginApi.setVideoSize(b,a)}},setFullscreen:function(a){if(this.pluginApi!=null){this.pluginApi.setFullscreen(a)}},addEventListener:function(b,c,a){this.events[b]=this.events[b]||[];this.events[b].push(c)},dispatchEvent:function(a){var c,b,d=this.events[a];if(d){b=Array.prototype.slice.call(arguments,1);for(c=0;c<d.length;c++){d[c].apply(null,b)}}}};mejs.MediaPluginBridge={pluginMediaElements:{},htmlMediaElements:{},registerPluginElement:function(c,a,b){this.pluginMediaElements[c]=a;this.htmlMediaElements[c]=b},initPlugin:function(c){var a=this.pluginMediaElements[c],b=this.htmlMediaElements[c];switch(a.pluginType){case"flash":a.pluginElement=a.pluginApi=document.getElementById(c);break;case"silverlight":a.pluginElement=document.getElementById(a.id);a.pluginApi=a.pluginElement.Content.SilverlightApp;break}if(a.success){a.success(a,b)}},fireEvent:function(h,c,b){var g,f,a,d=this.pluginMediaElements[h];d.ended=false;d.paused=true;g={type:c,target:d};for(f in b){d[f]=b[f];g[f]=b[f]}a=b.bufferedTime||0;g.target.buffered=g.buffered={start:function(e){return 0},end:function(e){return a},length:1};d.dispatchEvent(g.type,g)}};mejs.MediaElementDefaults={enablePluginDebug:false,plugins:["flash","silverlight"],type:"",pluginPath:mejs.Utility.getScriptPath(["mediaelement.js","mediaelement.min.js","mediaelement-and-player.js","mediaelement-and-player.min.js"]),flashName:"flashmediaelement.swf",silverlightName:"silverlightmediaelement.xap",defaultVideoWidth:480,defaultVideoHeight:270,pluginWidth:-1,pluginHeight:-1,timerRate:250,success:function(){},error:function(){}};mejs.MediaElement=function(a,b){mejs.HtmlMediaElementShim.create(a,b)};mejs.HtmlMediaElementShim={create:function(f,e){var j=mejs.MediaElementDefaults,h=(typeof(f)=="string")?document.getElementById(f):f,a=(h.tagName.toLowerCase()=="video"),b=(typeof(h.canPlayType)!="undefined"),c={method:"",url:""},i=h.getAttribute("poster"),g=h.getAttribute("autoplay"),d;for(d in e){j[d]=e[d]}i=(i=="undefined"||i===null)?"":i;c=this.determinePlayback(h,j,a,b);if(c.method=="native"){this.updateNative(h,j)}else{if(c.method!==""){this.createPlugin(h,j,a,c.method,(c.url!==null)?mejs.Utility.absolutizeUrl(c.url).replace("&","%26"):"",i,g)}else{this.createErrorMessage(h,j,(c.url!==null)?mejs.Utility.absolutizeUrl(c.url):"",i)}}},determinePlayback:function(s,v,b,c){var u=[],m,h,g,f,e,d,q,t={method:"",url:""},a=s.getAttribute("src"),o,p,r;if(typeof(v.type)!="undefined"&&v.type!==""){u.push({type:v.type,url:null})}else{if(a!="undefined"&&a!==null){d=s.getAttribute("src");q=this.checkType(d,s.getAttribute("type"),b);u.push({type:q,url:d})}else{for(m=0;m<s.childNodes.length;m++){e=s.childNodes[m];if(e.nodeType==1&&e.tagName.toLowerCase()=="source"){d=e.getAttribute("src");q=this.checkType(d,e.getAttribute("type"),b);u.push({type:q,url:d})}}}}if(c){for(m=0;m<u.length;m++){if(s.canPlayType(u[m].type).replace(/no/,"")!==""){t.method="native";t.url=u[m].url;return t}}}for(m=0;m<u.length;m++){q=u[m].type;for(h=0;h<v.plugins.length;h++){o=v.plugins[h];p=mejs.plugins[o];for(g=0;g<p.length;g++){r=p[g];if(mejs.PluginDetector.hasPluginVersion(o,r.version)){for(f=0;f<r.types.length;f++){if(q==r.types[f]){t.method=o;t.url=u[m].url;return t}}}}}}if(t.method===""){t.url=u[0].url}return t},checkType:function(a,c,d){var b;if(a&&!c){b=a.substring(a.lastIndexOf(".")+1);return((d)?"video":"audio")+"/"+b}else{return c}},createErrorMessage:function(c,b,f,g){var a=document.createElement("div");a.className="me-cannotplay";try{a.style.width=c.width+"px";a.style.height=c.height+"px"}catch(d){}a.innerHTML=(g!=="")?'<a href="'+f+'"><img src="'+g+'" /></a>':'<a href="'+f+'"><span>Download File</span></a>';c.parentNode.insertBefore(a,c);c.style.display="none";b.error(c)},createPlugin:function(j,n,b,f,i,k,g){var d=1,l=1,e="me_"+f+"_"+(mejs.meIndex++),m=new mejs.PluginMediaElement(e,f),c=document.createElement("div"),h,a;h=j.parentNode;while(h!==null&&h.tagName.toLowerCase()!="body"){if(h.parentNode.tagName.toLowerCase()=="p"){h.parentNode.parentNode.insertBefore(h,h.parentNode);break}h=h.parentNode}if(b){d=(n.videoWidth>0)?n.videoWidth:(j.getAttribute("width")!==null)?j.getAttribute("width"):n.defaultVideoWidth;l=(n.videoHeight>0)?n.videoHeight:(j.getAttribute("height")!==null)?j.getAttribute("height"):n.defaultVideoHeight}else{if(n.enablePluginDebug){d=320;l=240}}m.success=n.success;mejs.MediaPluginBridge.registerPluginElement(e,m,j);c.className="me-plugin";j.parentNode.insertBefore(c,j);a=["id="+e,"poster="+k,"isvideo="+b.toString(),"autoplay="+g,"width="+d,"timerrate="+n.timerRate,"height="+l];if(i!==null){a.push("file="+i)}if(n.enablePluginDebug){a.push("debug=true")}switch(f){case"silverlight":c.innerHTML='<object data="data:application/x-silverlight-2," type="application/x-silverlight-2" id="'+e+'" name="'+e+'" width="'+d+'" height="'+l+'"><param name="initParams" value="'+a.join(",")+'" /><param name="windowless" value="true" /><param name="background" value="black" /><param name="minRuntimeVersion" value="3.0.0.0" /><param name="autoUpgrade" value="true" /><param name="source" value="'+n.pluginPath+n.silverlightName+'" /></object>';break;case"flash":if(mejs.MediaFeatures.isIE){c.outerHTML='<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab" id="'+e+'" width="'+d+'" height="'+l+'"><param name="movie" value="'+n.pluginPath+n.flashName+"?x="+(new Date())+'" /><param name="flashvars" value="'+a.join("&")+'" /><param name="quality" value="high" /><param name="bgcolor" value="#000000" /><param name="wmode" value="transparent" /><param name="allowScriptAccess" value="sameDomain" /><param name="allowFullScreen" value="true" /></object>'}else{c.innerHTML='<embed id="'+e+'" name="'+e+'" play="true" loop="false" quality="high" bgcolor="#000000" wmode="transparent" allowScriptAccess="sameDomain" allowFullScreen="true" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" src="'+n.pluginPath+n.flashName+"?"+a.join("&")+'" width="'+d+'" height="'+l+'"></embed>'}break}j.style.display="none"},updateNative:function(c,b){for(var a in mejs.HtmlMediaElement){c[a]=mejs.HtmlMediaElement[a]}b.success(c,c)}};window.mejs=mejs;window.MediaElement=mejs.MediaElement;