import Vue, { mergeData } from '../../vue'
import { NAME_CARD_BODY } from '../../constants/components'
import { makePropsConfigurable } from '../../utils/config'
import { copyProps, pluckProps, prefixPropName } from '../../utils/props'
import { props as cardProps } from '../../mixins/card'
import { BCardTitle, props as titleProps } from './card-title'
import { BCardSubTitle, props as subTitleProps } from './card-sub-title'

export const props = makePropsConfigurable(
  {
    // Import common card props and prefix them with `body-`
    ...copyProps(cardProps, prefixPropName.bind(null, 'body')),
    bodyClass: {
      type: [String, Object, Array]
      // default: null
    },
    ...titleProps,
    ...subTitleProps,
    overlay: {
      type: Boolean,
      default: false
    }
  },
  NAME_CARD_BODY
)

// @vue/component
export const BCardBody = /*#__PURE__*/ Vue.extend({
  name: NAME_CARD_BODY,
  functional: true,
  props,
  render(h, { props, data, children }) {
    let cardTitle = h()
    let cardSubTitle = h()
    const cardContent = children || [h()]

    if (props.title) {
      cardTitle = h(BCardTitle, { props: pluckProps(titleProps, props) })
    }

    if (props.subTitle) {
      cardSubTitle = h(BCardSubTitle, {
        props: pluckProps(subTitleProps, props),
        class: ['mb-2']
      })
    }

    return h(
      props.bodyTag,
      mergeData(data, {
        staticClass: 'card-body',
        class: [
          {
            'card-img-overlay': props.overlay,
            [`bg-${props.bodyBgVariant}`]: props.bodyBgVariant,
            [`border-${props.bodyBorderVariant}`]: props.bodyBorderVariant,
            [`text-${props.bodyTextVariant}`]: props.bodyTextVariant
          },
          props.bodyClass || {}
        ]
      }),
      [cardTitle, cardSubTitle, ...cardContent]
    )
  }
})
