---
id: markdown
title: Markdown
sidebar_label: Markdown
---

The markdown file lives on the master branch and has a name of `TUTORIAL.md`. It describes the structure of a tutorial and contains all the lessons, their descriptions, and the text users will read.

### Example

See a rough example below:

```md
# Tutorial Title

> Tutorial introduction paragraph

## 1. Lesson 1

> Lesson 1 summary

Lesson 1 decription and instructions.

### 1.1 Lesson 1 Step 1

Test text for 1.1

#### HINTS

- This is a hint for 1.1
- This is another hint for 1.1

## 2. Lesson 2

> Lessons 2 summary

Lesson 2 content.

### 2.1 Lesson 2 Step 1

Test text

#### HINTS

- Hint for 2.1

### 2.2 Lesson 2 Step 2

Test text for 2.2

#### HINTS

- Hint for 2.2
```

#### Explanation

The example above has an introduction page and two lessons.

The introduction page is the first thing users will see when they start a tutorial. It shows an overview of all the lessons and displays the lesson summary.

Lessons need to start with `## x.` where `x` is the lesson number. The text after `x.` will display as the lesson title.

The "Steps", or test text, need to start with `x.y` where `x` matches the lesson number and `y` is the number for a "step".
