using System.IO;
using Microsoft.CodeAnalysis.CSharp.Syntax;
using Semmle.Extraction.Kinds;

namespace Semmle.Extraction.CSharp.Entities.Statements
{
    internal class Do : Statement<DoStatementSyntax>
    {
        private Do(Context cx, DoStatementSyntax node, IStatementParentEntity parent, int child)
            : base(cx, node, StmtKind.DO, parent, child, cx.CreateLocation(node.GetLocation())) { }

        public static Do Create(Context cx, DoStatementSyntax node, IStatementParentEntity parent, int child)
        {
            var ret = new Do(cx, node, parent, child);
            ret.TryPopulate();
            return ret;
        }

        protected override void PopulateStatement(TextWriter trapFile)
        {
            Create(Context, Stmt.Statement, this, 1);
            Expression.Create(Context, Stmt.Condition, this, 0);
        }
    }
}
