# Improvements to Go analysis

## General improvements

* You can now suppress alerts using either single-line block comments (`/* ... */`) or line comments (`// ...`).
* Analysis of flow through fields and elements of arrays and slices has been improved, which may lead to more results from the security queries.
* Detection of test code has been improved. LGTM will not show alerts in test code by default.
* Go 1.14 library changes have been modeled.
* More sources of untrusted input as well as vulnerable sinks are modeled, which may lead to more results from the security queries.

## New queries

The CodeQL library for Go now contains a folder of simple "cookbook" queries that show how to access basic Go elements using the predicates defined by the standard library. They're intended to give you a starting point for your own experiments and to help you work out the best way to frame your questions using CodeQL. You can find them in the `examples/snippets` folder in the [CodeQL for Go repository](https://github.com/github/codeql-go/tree/main/ql/examples/snippets).

| **Query**                                                                    | **Tags**                                                                                | **Purpose**                                                                                                                                                                         |
|------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Bad check of redirect URL (`go/bad-redirect-check`)                          | correctness, security, external/cwe/cwe-601                                             | Highlights checks that ensure redirect URLs start with `/` but don't check for `//` or `/\`. Results are shown on LGTM by default.                                                  |
| Constant length comparison (`go/constant-length-comparison`)                 | correctness                                                                             | Highlights code that checks the length of an array or slice against a constant before indexing it using a variable, suggesting a logic error. Results are shown on LGTM by default. |
| Disabled TLS certificate check (`go/disabled-certificate-check`)             | security, external/cwe/295                                                              | Highlights code that disables TLS certificate checking. Results are shown on LGTM by default.                                                                                       |
| Impossible interface nil check (`go/impossible-interface-nil-check`)         | correctness                                                                             | Highlights code that compares an interface value that cannot be `nil` to `nil`, suggesting a logic error. Results are shown on LGTM by default.                                     |
| Incomplete URL scheme check (`go/incomplete-url-scheme-check`)               | correctness, security, external/cwe/cwe-020                                             | Highlights checks for `javascript` URLs that do not take `data` or `vbscript` URLs into account. Results are shown on LGTM by default.                                              |
| Potentially unsafe quoting (`go/unsafe-quoting`)                             | correctness, security, external/cwe/cwe-078, external/cwe/cwe-089, external/cwe/cwe-094 | Highlights code that constructs a quoted string literal containing data that may itself contain quotes. Results are shown on LGTM by default.                                       |
| Size computation for allocation may overflow (`go/allocation-size-overflow`) | correctness, security, external/cwe/cwe-190                                             | Highlights code that computes the size of an allocation based on the size of a potentially large object. Results are shown on LGTM by default.                                      |
| Uncontrolled data used in network request (`go/request-forgery`)             | correctness, security, external/cwe/cwe-918                                             | Highlights code that uses uncontrolled user input to make a request. Results are shown on LGTM by default.                                                                          |
| XPath injection (`go/xml/xpath-injection`)                                   | security, external/cwe/cwe-643                                                          | Highlights code that uses remote input in an XPath expression. Results are shown on LGTM by default.                                                                                |

## Changes to existing queries

| **Query**                                                                     | **Expected impact**          | **Change**                                                                                                                                                                                                         |
|-------------------------------------------------------------------------------|------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Arbitrary file write during zip extraction ("zip slip") (`go/zipslip`)        | Fewer false positive results | The query now excludes more cases where it is safe to use a path extractor from an archive.                                                                                                                        |
| Bitwise exclusive-or used like exponentiation (`go/mistyped-exponentiation`)  | Fewer false positive results | The query now identifies when the value of an xor is assigned to a mask object, and excludes such results.                                                                                                         |
| Command built from user-controlled sources (`go/command-injection`)           | More results                 | The library models used by the query have been improved, allowing it to flag more potentially problematic cases, including sources that flow into shells, sudo, or programming-language interpreters as arguments. |
| Database query built from user-controlled sources (`go/sql-injection`)        | More results                 | The library models used by the query have been improved, allowing it to flag more potentially problematic cases.                                                                                                   |
| Identical operands (`go/redundant-operation`)                                 | Fewer false positive results | The query no longer flags cases where the operands have the same value but are syntactically distinct, since this is usually intentional.                                                                          |
| Incomplete regular expression for hostnames (`go/incomplete-hostname-regexp`) | More results                 | The query now flags unescaped dots before the TLD in a hostname regex.                                                                                                                                             |
| Open URL redirect (`go/unvalidated-url-redirection`)                          | Fewer false positive results | The query now identifies some sources that are not attacker-controlled, and excludes results with such sources.                                                                                                    |
| Reflected cross-site scripting (`go/reflected-xss`)                           | Fewer results                | Untrusted input flowing into an HTTP header definition or into an `fmt.Fprintf` call with a constant prefix is no longer flagged, since it is in both cases often harmless.                                        |
| Useless assignment to field (`go/useless-assignment-to-field`)                | Fewer false positive results | The query now conservatively handles fields promoted through embedded pointer types.                                                                                                                               |
