## 0.6.0

### Deprecated APIs

* The `execTainted` predicate in `CommandLineQuery.qll` has been deprecated and replaced with the predicate `execIsTainted`.
* The recently introduced new data flow and taint tracking APIs have had a
  number of module and predicate renamings. The old APIs remain in place for
  now.
* The `WebViewDubuggingQuery` library has been renamed to `WebViewDebuggingQuery` to fix the typo in the file name. `WebViewDubuggingQuery` is now deprecated. 

### New Features

* Predicates `Compilation.getExpandedArgument` and `Compilation.getAnExpandedArgument` has been added.

### Minor Analysis Improvements

* Fixed a bug in the regular expression used to identify sensitive information in `SensitiveActions::getCommonSensitiveInfoRegex`. This may affect the results of the queries `java/android/sensitive-communication`, `java/android/sensitive-keyboard-cache`, and `java/sensitive-log`. 
* Added a summary model for the `java.lang.UnsupportedOperationException(String)` constructor.
* The filenames embedded in `Compilation.toString()` now use `/` as the path separator on all platforms.
* Added models for the following packages:
  * `java.lang`
  * `java.net`
  * `java.nio.file`
  * `java.io`
  * `java.lang.module`
  * `org.apache.commons.httpclient.util`
  * `org.apache.commons.io`
  * `org.apache.http.client`
  * `org.eclipse.jetty.client`
  * `com.google.common.io`
  * `kotlin.io`
* Added the `TaintedPathQuery.qll` library to provide the `TaintedPathFlow` and `TaintedPathLocalFlow` taint-tracking modules to reason about tainted path vulnerabilities.
* Added the `ZipSlipQuery.qll` library to provide the `ZipSlipFlow` taint-tracking module to reason about zip-slip vulnerabilities.
* Added the `InsecureBeanValidationQuery.qll` library to provide the `BeanValidationFlow` taint-tracking module to reason about bean validation vulnerabilities.
* Added the `XssQuery.qll` library to provide the `XssFlow` taint-tracking module to reason about cross site scripting vulnerabilities.
* Added the `LdapInjectionQuery.qll` library to provide the `LdapInjectionFlow` taint-tracking module to reason about LDAP injection vulnerabilities.
* Added the `ResponseSplittingQuery.qll` library to provide the `ResponseSplittingFlow` taint-tracking module to reason about response splitting vulnerabilities.
* Added the `ExternallyControlledFormatStringQuery.qll` library to provide the `ExternallyControlledFormatStringFlow` taint-tracking module to reason about externally controlled format string vulnerabilities.
* Improved the handling of addition in the range analysis. This can cause in minor changes to the results produced by `java/index-out-of-bounds` and `java/constant-comparison`.
* A new models as data sink kind `command-injection` has been added.
* The queries `java/command-line-injection` and `java/concatenated-command-line` now can be extended using the `command-injection` models as data sink kind.
* Added more sink and summary dataflow models for the following packages:
  * `java.net`
  * `java.nio.file`
  * `javax.imageio.stream`
  * `javax.naming`
  * `javax.servlet`
  * `org.geogebra.web.full.main`
  * `hudson`
  * `hudson.cli`
  * `hudson.lifecycle`
  * `hudson.model`
  * `hudson.scm`
  * `hudson.util`
  * `hudson.util.io`
* Added the extensible abstract class `JndiInjectionSanitizer`. Now this class can be extended to add more sanitizers to the `java/jndi-injection` query.
* Added a summary model for the `nativeSQL` method of the `java.sql.Connection` interface.
* Added sink and summary dataflow models for the Jenkins and Netty frameworks.
* The Models as Data syntax for selecting the qualifier has been changed from `-1` to `this` (e.g. `Argument[-1]` is now written as `Argument[this]`).
* Added sources and flow step models for the Netty framework up to version 4.1.
* Added more dataflow models for frequently-used JDK APIs.

### Bug Fixes

* Fixed some accidental predicate visibility in the backwards-compatible wrapper for data flow configurations. In particular `DataFlow::hasFlowPath`, `DataFlow::hasFlow`, `DataFlow::hasFlowTo`, and `DataFlow::hasFlowToExpr` were accidentally exposed in a single version.
