###############################################################################
# @generated
# DO NOT MODIFY: This file is auto-generated by a crate_universe tool. To
# regenerate this file, run the following:
#
#     bazel run @@//misc/bazel/3rdparty:vendor_tree_sitter_extractors
###############################################################################
"""
# `crates_repository` API

- [aliases](#aliases)
- [crate_deps](#crate_deps)
- [all_crate_deps](#all_crate_deps)
- [crate_repositories](#crate_repositories)

"""

load("@bazel_skylib//lib:selects.bzl", "selects")
load("@bazel_tools//tools/build_defs/repo:http.bzl", "http_archive")
load("@bazel_tools//tools/build_defs/repo:utils.bzl", "maybe")

###############################################################################
# MACROS API
###############################################################################

# An identifier that represent common dependencies (unconditional).
_COMMON_CONDITION = ""

def _flatten_dependency_maps(all_dependency_maps):
    """Flatten a list of dependency maps into one dictionary.

    Dependency maps have the following structure:

    ```python
    DEPENDENCIES_MAP = {
        # The first key in the map is a Bazel package
        # name of the workspace this file is defined in.
        "workspace_member_package": {

            # Not all dependencies are supported for all platforms.
            # the condition key is the condition required to be true
            # on the host platform.
            "condition": {

                # An alias to a crate target.     # The label of the crate target the
                # Aliases are only crate names.   # package name refers to.
                "package_name":                   "@full//:label",
            }
        }
    }
    ```

    Args:
        all_dependency_maps (list): A list of dicts as described above

    Returns:
        dict: A dictionary as described above
    """
    dependencies = {}

    for workspace_deps_map in all_dependency_maps:
        for pkg_name, conditional_deps_map in workspace_deps_map.items():
            if pkg_name not in dependencies:
                non_frozen_map = dict()
                for key, values in conditional_deps_map.items():
                    non_frozen_map.update({key: dict(values.items())})
                dependencies.setdefault(pkg_name, non_frozen_map)
                continue

            for condition, deps_map in conditional_deps_map.items():
                # If the condition has not been recorded, do so and continue
                if condition not in dependencies[pkg_name]:
                    dependencies[pkg_name].setdefault(condition, dict(deps_map.items()))
                    continue

                # Alert on any miss-matched dependencies
                inconsistent_entries = []
                for crate_name, crate_label in deps_map.items():
                    existing = dependencies[pkg_name][condition].get(crate_name)
                    if existing and existing != crate_label:
                        inconsistent_entries.append((crate_name, existing, crate_label))
                    dependencies[pkg_name][condition].update({crate_name: crate_label})

    return dependencies

def crate_deps(deps, package_name = None):
    """Finds the fully qualified label of the requested crates for the package where this macro is called.

    Args:
        deps (list): The desired list of crate targets.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()`.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if not deps:
        return []

    if package_name == None:
        package_name = native.package_name()

    # Join both sets of dependencies
    dependencies = _flatten_dependency_maps([
        _NORMAL_DEPENDENCIES,
        _NORMAL_DEV_DEPENDENCIES,
        _PROC_MACRO_DEPENDENCIES,
        _PROC_MACRO_DEV_DEPENDENCIES,
        _BUILD_DEPENDENCIES,
        _BUILD_PROC_MACRO_DEPENDENCIES,
    ]).pop(package_name, {})

    # Combine all conditional packages so we can easily index over a flat list
    # TODO: Perhaps this should actually return select statements and maintain
    # the conditionals of the dependencies
    flat_deps = {}
    for deps_set in dependencies.values():
        for crate_name, crate_label in deps_set.items():
            flat_deps.update({crate_name: crate_label})

    missing_crates = []
    crate_targets = []
    for crate_target in deps:
        if crate_target not in flat_deps:
            missing_crates.append(crate_target)
        else:
            crate_targets.append(flat_deps[crate_target])

    if missing_crates:
        fail("Could not find crates `{}` among dependencies of `{}`. Available dependencies were `{}`".format(
            missing_crates,
            package_name,
            dependencies,
        ))

    return crate_targets

def all_crate_deps(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Finds the fully qualified label of all requested direct crate dependencies \
    for the package where this macro is called.

    If no parameters are set, all normal dependencies are returned. Setting any one flag will
    otherwise impact the contents of the returned list.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_dependency_maps = []
    if normal:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)
    if normal_dev:
        all_dependency_maps.append(_NORMAL_DEV_DEPENDENCIES)
    if proc_macro:
        all_dependency_maps.append(_PROC_MACRO_DEPENDENCIES)
    if proc_macro_dev:
        all_dependency_maps.append(_PROC_MACRO_DEV_DEPENDENCIES)
    if build:
        all_dependency_maps.append(_BUILD_DEPENDENCIES)
    if build_proc_macro:
        all_dependency_maps.append(_BUILD_PROC_MACRO_DEPENDENCIES)

    # Default to always using normal dependencies
    if not all_dependency_maps:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)

    dependencies = _flatten_dependency_maps(all_dependency_maps).pop(package_name, None)

    if not dependencies:
        if dependencies == None:
            fail("Tried to get all_crate_deps for package " + package_name + " but that package had no Cargo.toml file")
        else:
            return []

    crate_deps = list(dependencies.pop(_COMMON_CONDITION, {}).values())
    for condition, deps in dependencies.items():
        crate_deps += selects.with_or({
            tuple(_CONDITIONS[condition]): deps.values(),
            "//conditions:default": [],
        })

    return crate_deps

def aliases(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Produces a map of Crate alias names to their original label

    If no dependency kinds are specified, `normal` and `proc_macro` are used by default.
    Setting any one flag will otherwise determine the contents of the returned dict.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        dict: The aliases of all associated packages
    """
    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_aliases_maps = []
    if normal:
        all_aliases_maps.append(_NORMAL_ALIASES)
    if normal_dev:
        all_aliases_maps.append(_NORMAL_DEV_ALIASES)
    if proc_macro:
        all_aliases_maps.append(_PROC_MACRO_ALIASES)
    if proc_macro_dev:
        all_aliases_maps.append(_PROC_MACRO_DEV_ALIASES)
    if build:
        all_aliases_maps.append(_BUILD_ALIASES)
    if build_proc_macro:
        all_aliases_maps.append(_BUILD_PROC_MACRO_ALIASES)

    # Default to always using normal aliases
    if not all_aliases_maps:
        all_aliases_maps.append(_NORMAL_ALIASES)
        all_aliases_maps.append(_PROC_MACRO_ALIASES)

    aliases = _flatten_dependency_maps(all_aliases_maps).pop(package_name, None)

    if not aliases:
        return dict()

    common_items = aliases.pop(_COMMON_CONDITION, {}).items()

    # If there are only common items in the dictionary, immediately return them
    if not len(aliases.keys()) == 1:
        return dict(common_items)

    # Build a single select statement where each conditional has accounted for the
    # common set of aliases.
    crate_aliases = {"//conditions:default": dict(common_items)}
    for condition, deps in aliases.items():
        condition_triples = _CONDITIONS[condition]
        for triple in condition_triples:
            if triple in crate_aliases:
                crate_aliases[triple].update(deps)
            else:
                crate_aliases.update({triple: dict(deps.items() + common_items)})

    return select(crate_aliases)

###############################################################################
# WORKSPACE MEMBER DEPS AND ALIASES
###############################################################################

_NORMAL_DEPENDENCIES = {
    "ruby/extractor": {
        _COMMON_CONDITION: {
            "clap": Label("@vendor_ts__clap-4.5.40//:clap"),
            "encoding": Label("@vendor_ts__encoding-0.2.33//:encoding"),
            "lazy_static": Label("@vendor_ts__lazy_static-1.5.0//:lazy_static"),
            "rayon": Label("@vendor_ts__rayon-1.10.0//:rayon"),
            "regex": Label("@vendor_ts__regex-1.11.1//:regex"),
            "serde_json": Label("@vendor_ts__serde_json-1.0.140//:serde_json"),
            "tracing": Label("@vendor_ts__tracing-0.1.41//:tracing"),
            "tracing-subscriber": Label("@vendor_ts__tracing-subscriber-0.3.19//:tracing_subscriber"),
            "tree-sitter": Label("@vendor_ts__tree-sitter-0.24.6//:tree_sitter"),
            "tree-sitter-embedded-template": Label("@vendor_ts__tree-sitter-embedded-template-0.23.2//:tree_sitter_embedded_template"),
            "tree-sitter-ruby": Label("@vendor_ts__tree-sitter-ruby-0.23.1//:tree_sitter_ruby"),
        },
    },
    "rust/ast-generator": {
        _COMMON_CONDITION: {
            "anyhow": Label("@vendor_ts__anyhow-1.0.98//:anyhow"),
            "either": Label("@vendor_ts__either-1.15.0//:either"),
            "itertools": Label("@vendor_ts__itertools-0.14.0//:itertools"),
            "mustache": Label("@vendor_ts__mustache-0.9.0//:mustache"),
            "proc-macro2": Label("@vendor_ts__proc-macro2-1.0.95//:proc_macro2"),
            "quote": Label("@vendor_ts__quote-1.0.40//:quote"),
            "serde": Label("@vendor_ts__serde-1.0.219//:serde"),
            "stdx": Label("@vendor_ts__ra_ap_stdx-0.0.288//:ra_ap_stdx"),
            "ungrammar": Label("@vendor_ts__ungrammar-1.16.1//:ungrammar"),
        },
    },
    "rust/autobuild": {
    },
    "rust/extractor": {
        _COMMON_CONDITION: {
            "anyhow": Label("@vendor_ts__anyhow-1.0.98//:anyhow"),
            "argfile": Label("@vendor_ts__argfile-0.2.1//:argfile"),
            "chalk-ir": Label("@vendor_ts__chalk-ir-0.103.0//:chalk_ir"),
            "chrono": Label("@vendor_ts__chrono-0.4.41//:chrono"),
            "clap": Label("@vendor_ts__clap-4.5.40//:clap"),
            "dunce": Label("@vendor_ts__dunce-1.0.5//:dunce"),
            "figment": Label("@vendor_ts__figment-0.10.19//:figment"),
            "glob": Label("@vendor_ts__glob-0.3.2//:glob"),
            "itertools": Label("@vendor_ts__itertools-0.14.0//:itertools"),
            "mustache": Label("@vendor_ts__mustache-0.9.0//:mustache"),
            "num-traits": Label("@vendor_ts__num-traits-0.2.19//:num_traits"),
            "ra_ap_base_db": Label("@vendor_ts__ra_ap_base_db-0.0.288//:ra_ap_base_db"),
            "ra_ap_cfg": Label("@vendor_ts__ra_ap_cfg-0.0.288//:ra_ap_cfg"),
            "ra_ap_hir": Label("@vendor_ts__ra_ap_hir-0.0.288//:ra_ap_hir"),
            "ra_ap_hir_def": Label("@vendor_ts__ra_ap_hir_def-0.0.288//:ra_ap_hir_def"),
            "ra_ap_hir_expand": Label("@vendor_ts__ra_ap_hir_expand-0.0.288//:ra_ap_hir_expand"),
            "ra_ap_hir_ty": Label("@vendor_ts__ra_ap_hir_ty-0.0.288//:ra_ap_hir_ty"),
            "ra_ap_ide_db": Label("@vendor_ts__ra_ap_ide_db-0.0.288//:ra_ap_ide_db"),
            "ra_ap_intern": Label("@vendor_ts__ra_ap_intern-0.0.288//:ra_ap_intern"),
            "ra_ap_load-cargo": Label("@vendor_ts__ra_ap_load-cargo-0.0.288//:ra_ap_load_cargo"),
            "ra_ap_parser": Label("@vendor_ts__ra_ap_parser-0.0.288//:ra_ap_parser"),
            "ra_ap_paths": Label("@vendor_ts__ra_ap_paths-0.0.288//:ra_ap_paths"),
            "ra_ap_project_model": Label("@vendor_ts__ra_ap_project_model-0.0.288//:ra_ap_project_model"),
            "ra_ap_span": Label("@vendor_ts__ra_ap_span-0.0.288//:ra_ap_span"),
            "ra_ap_syntax": Label("@vendor_ts__ra_ap_syntax-0.0.288//:ra_ap_syntax"),
            "ra_ap_vfs": Label("@vendor_ts__ra_ap_vfs-0.0.288//:ra_ap_vfs"),
            "serde": Label("@vendor_ts__serde-1.0.219//:serde"),
            "serde_json": Label("@vendor_ts__serde_json-1.0.140//:serde_json"),
            "serde_with": Label("@vendor_ts__serde_with-3.13.0//:serde_with"),
            "toml": Label("@vendor_ts__toml-0.8.23//:toml"),
            "tracing": Label("@vendor_ts__tracing-0.1.41//:tracing"),
            "tracing-flame": Label("@vendor_ts__tracing-flame-0.2.0//:tracing_flame"),
            "tracing-subscriber": Label("@vendor_ts__tracing-subscriber-0.3.19//:tracing_subscriber"),
            "triomphe": Label("@vendor_ts__triomphe-0.1.14//:triomphe"),
        },
    },
    "rust/extractor/macros": {
        _COMMON_CONDITION: {
            "quote": Label("@vendor_ts__quote-1.0.40//:quote"),
            "syn": Label("@vendor_ts__syn-2.0.103//:syn"),
        },
    },
    "shared/tree-sitter-extractor": {
        _COMMON_CONDITION: {
            "chrono": Label("@vendor_ts__chrono-0.4.41//:chrono"),
            "encoding": Label("@vendor_ts__encoding-0.2.33//:encoding"),
            "flate2": Label("@vendor_ts__flate2-1.1.0//:flate2"),
            "globset": Label("@vendor_ts__globset-0.4.15//:globset"),
            "lazy_static": Label("@vendor_ts__lazy_static-1.5.0//:lazy_static"),
            "num_cpus": Label("@vendor_ts__num_cpus-1.17.0//:num_cpus"),
            "rayon": Label("@vendor_ts__rayon-1.10.0//:rayon"),
            "regex": Label("@vendor_ts__regex-1.11.1//:regex"),
            "serde": Label("@vendor_ts__serde-1.0.219//:serde"),
            "serde_json": Label("@vendor_ts__serde_json-1.0.140//:serde_json"),
            "tracing": Label("@vendor_ts__tracing-0.1.41//:tracing"),
            "tracing-subscriber": Label("@vendor_ts__tracing-subscriber-0.3.19//:tracing_subscriber"),
            "tree-sitter": Label("@vendor_ts__tree-sitter-0.24.6//:tree_sitter"),
            "zstd": Label("@vendor_ts__zstd-0.13.3//:zstd"),
        },
    },
}

_NORMAL_ALIASES = {
    "ruby/extractor": {
        _COMMON_CONDITION: {
        },
    },
    "rust/ast-generator": {
        _COMMON_CONDITION: {
            Label("@vendor_ts__ra_ap_stdx-0.0.288//:ra_ap_stdx"): "stdx",
        },
    },
    "rust/autobuild": {
    },
    "rust/extractor": {
        _COMMON_CONDITION: {
        },
    },
    "rust/extractor/macros": {
        _COMMON_CONDITION: {
        },
    },
    "shared/tree-sitter-extractor": {
        _COMMON_CONDITION: {
        },
    },
}

_NORMAL_DEV_DEPENDENCIES = {
    "ruby/extractor": {
    },
    "rust/ast-generator": {
    },
    "rust/autobuild": {
    },
    "rust/extractor": {
    },
    "rust/extractor/macros": {
    },
    "shared/tree-sitter-extractor": {
        _COMMON_CONDITION: {
            "rand": Label("@vendor_ts__rand-0.9.1//:rand"),
            "tree-sitter-json": Label("@vendor_ts__tree-sitter-json-0.24.8//:tree_sitter_json"),
            "tree-sitter-ql": Label("@vendor_ts__tree-sitter-ql-0.23.1//:tree_sitter_ql"),
        },
    },
}

_NORMAL_DEV_ALIASES = {
    "ruby/extractor": {
    },
    "rust/ast-generator": {
    },
    "rust/autobuild": {
    },
    "rust/extractor": {
    },
    "rust/extractor/macros": {
    },
    "shared/tree-sitter-extractor": {
        _COMMON_CONDITION: {
        },
    },
}

_PROC_MACRO_DEPENDENCIES = {
    "ruby/extractor": {
    },
    "rust/ast-generator": {
    },
    "rust/autobuild": {
    },
    "rust/extractor": {
    },
    "rust/extractor/macros": {
    },
    "shared/tree-sitter-extractor": {
    },
}

_PROC_MACRO_ALIASES = {
    "ruby/extractor": {
    },
    "rust/ast-generator": {
    },
    "rust/autobuild": {
    },
    "rust/extractor": {
    },
    "rust/extractor/macros": {
    },
    "shared/tree-sitter-extractor": {
    },
}

_PROC_MACRO_DEV_DEPENDENCIES = {
    "ruby/extractor": {
    },
    "rust/ast-generator": {
    },
    "rust/autobuild": {
    },
    "rust/extractor": {
    },
    "rust/extractor/macros": {
    },
    "shared/tree-sitter-extractor": {
    },
}

_PROC_MACRO_DEV_ALIASES = {
    "ruby/extractor": {
    },
    "rust/ast-generator": {
    },
    "rust/autobuild": {
    },
    "rust/extractor": {
    },
    "rust/extractor/macros": {
    },
    "shared/tree-sitter-extractor": {
        _COMMON_CONDITION: {
        },
    },
}

_BUILD_DEPENDENCIES = {
    "ruby/extractor": {
    },
    "rust/ast-generator": {
    },
    "rust/autobuild": {
    },
    "rust/extractor": {
    },
    "rust/extractor/macros": {
    },
    "shared/tree-sitter-extractor": {
    },
}

_BUILD_ALIASES = {
    "ruby/extractor": {
    },
    "rust/ast-generator": {
    },
    "rust/autobuild": {
    },
    "rust/extractor": {
    },
    "rust/extractor/macros": {
    },
    "shared/tree-sitter-extractor": {
    },
}

_BUILD_PROC_MACRO_DEPENDENCIES = {
    "ruby/extractor": {
    },
    "rust/ast-generator": {
    },
    "rust/autobuild": {
    },
    "rust/extractor": {
    },
    "rust/extractor/macros": {
    },
    "shared/tree-sitter-extractor": {
    },
}

_BUILD_PROC_MACRO_ALIASES = {
    "ruby/extractor": {
    },
    "rust/ast-generator": {
    },
    "rust/autobuild": {
    },
    "rust/extractor": {
    },
    "rust/extractor/macros": {
    },
    "shared/tree-sitter-extractor": {
    },
}

_CONDITIONS = {
    "aarch64-apple-darwin": ["@rules_rust//rust/platform:aarch64-apple-darwin"],
    "aarch64-apple-ios": ["@rules_rust//rust/platform:aarch64-apple-ios"],
    "aarch64-apple-ios-sim": ["@rules_rust//rust/platform:aarch64-apple-ios-sim"],
    "aarch64-linux-android": ["@rules_rust//rust/platform:aarch64-linux-android"],
    "aarch64-pc-windows-gnullvm": [],
    "aarch64-pc-windows-msvc": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "aarch64-unknown-fuchsia": ["@rules_rust//rust/platform:aarch64-unknown-fuchsia"],
    "aarch64-unknown-linux-gnu": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "aarch64-unknown-nixos-gnu": ["@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "aarch64-unknown-nto-qnx710": ["@rules_rust//rust/platform:aarch64-unknown-nto-qnx710"],
    "aarch64-unknown-uefi": ["@rules_rust//rust/platform:aarch64-unknown-uefi"],
    "arm-unknown-linux-gnueabi": ["@rules_rust//rust/platform:arm-unknown-linux-gnueabi"],
    "armv7-linux-androideabi": ["@rules_rust//rust/platform:armv7-linux-androideabi"],
    "armv7-unknown-linux-gnueabi": ["@rules_rust//rust/platform:armv7-unknown-linux-gnueabi"],
    "cfg(all(any(target_arch = \"x86_64\", target_arch = \"arm64ec\"), target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(all(any(target_os = \"linux\", target_os = \"android\"), not(any(getrandom_backend = \"custom\", getrandom_backend = \"rdrand\", getrandom_backend = \"rndr\"))))": ["@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(all(target_arch = \"aarch64\", target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "cfg(all(target_arch = \"wasm32\", target_os = \"unknown\"))": ["@rules_rust//rust/platform:wasm32-unknown-unknown"],
    "cfg(all(target_arch = \"wasm32\", target_os = \"wasi\", target_env = \"p2\"))": [],
    "cfg(all(target_arch = \"x86\", target_env = \"gnu\", not(target_abi = \"llvm\"), not(windows_raw_dylib)))": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "cfg(all(target_arch = \"x86\", target_env = \"gnu\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "cfg(all(target_arch = \"x86\", target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "cfg(all(target_arch = \"x86_64\", target_env = \"gnu\", not(target_abi = \"llvm\"), not(windows_raw_dylib)))": ["@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(all(target_arch = \"x86_64\", target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(all(target_os = \"linux\", not(target_env = \"ohos\")))": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(all(target_os = \"linux\", target_env = \"gnu\"))": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(all(windows, not(target_vendor = \"win7\")))": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(any())": [],
    "cfg(any(target_os = \"dragonfly\", target_os = \"freebsd\", target_os = \"hurd\", target_os = \"illumos\", all(target_os = \"horizon\", target_arch = \"arm\")))": ["@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "cfg(any(target_os = \"freebsd\", target_os = \"openbsd\", target_os = \"netbsd\", target_os = \"dragonflybsd\", target_os = \"ios\"))": ["@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "cfg(any(target_os = \"haiku\", target_os = \"redox\", target_os = \"nto\", target_os = \"aix\"))": ["@rules_rust//rust/platform:aarch64-unknown-nto-qnx710"],
    "cfg(any(target_os = \"ios\", target_os = \"visionos\", target_os = \"watchos\", target_os = \"tvos\"))": ["@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:x86_64-apple-ios"],
    "cfg(any(target_os = \"linux\", target_os = \"android\"))": ["@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(any(target_os = \"macos\", target_os = \"ios\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios"],
    "cfg(any(target_os = \"macos\", target_os = \"openbsd\", target_os = \"vita\", target_os = \"emscripten\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-darwin"],
    "cfg(any(target_pointer_width = \"8\", target_pointer_width = \"16\", target_pointer_width = \"32\"))": ["@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv32imc-unknown-none-elf", "@rules_rust//rust/platform:thumbv7em-none-eabi", "@rules_rust//rust/platform:thumbv8m.main-none-eabi", "@rules_rust//rust/platform:wasm32-unknown-unknown", "@rules_rust//rust/platform:wasm32-wasip1"],
    "cfg(not(windows))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:aarch64-unknown-uefi", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv32imc-unknown-none-elf", "@rules_rust//rust/platform:riscv64gc-unknown-none-elf", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:thumbv7em-none-eabi", "@rules_rust//rust/platform:thumbv8m.main-none-eabi", "@rules_rust//rust/platform:wasm32-unknown-unknown", "@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu", "@rules_rust//rust/platform:x86_64-unknown-none", "@rules_rust//rust/platform:x86_64-unknown-uefi"],
    "cfg(target_os = \"android\")": ["@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:x86_64-linux-android"],
    "cfg(target_os = \"haiku\")": [],
    "cfg(target_os = \"hermit\")": [],
    "cfg(target_os = \"macos\")": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-darwin"],
    "cfg(target_os = \"netbsd\")": [],
    "cfg(target_os = \"redox\")": [],
    "cfg(target_os = \"solaris\")": [],
    "cfg(target_os = \"vxworks\")": [],
    "cfg(target_os = \"wasi\")": ["@rules_rust//rust/platform:wasm32-wasip1"],
    "cfg(target_os = \"windows\")": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(unix)": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(windows)": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "i686-apple-darwin": ["@rules_rust//rust/platform:i686-apple-darwin"],
    "i686-linux-android": ["@rules_rust//rust/platform:i686-linux-android"],
    "i686-pc-windows-gnu": [],
    "i686-pc-windows-gnullvm": [],
    "i686-pc-windows-msvc": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "i686-unknown-freebsd": ["@rules_rust//rust/platform:i686-unknown-freebsd"],
    "i686-unknown-linux-gnu": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "powerpc-unknown-linux-gnu": ["@rules_rust//rust/platform:powerpc-unknown-linux-gnu"],
    "riscv32imc-unknown-none-elf": ["@rules_rust//rust/platform:riscv32imc-unknown-none-elf"],
    "riscv64gc-unknown-none-elf": ["@rules_rust//rust/platform:riscv64gc-unknown-none-elf"],
    "s390x-unknown-linux-gnu": ["@rules_rust//rust/platform:s390x-unknown-linux-gnu"],
    "thumbv7em-none-eabi": ["@rules_rust//rust/platform:thumbv7em-none-eabi"],
    "thumbv8m.main-none-eabi": ["@rules_rust//rust/platform:thumbv8m.main-none-eabi"],
    "wasm32-unknown-unknown": ["@rules_rust//rust/platform:wasm32-unknown-unknown"],
    "wasm32-wasip1": ["@rules_rust//rust/platform:wasm32-wasip1"],
    "x86_64-apple-darwin": ["@rules_rust//rust/platform:x86_64-apple-darwin"],
    "x86_64-apple-ios": ["@rules_rust//rust/platform:x86_64-apple-ios"],
    "x86_64-linux-android": ["@rules_rust//rust/platform:x86_64-linux-android"],
    "x86_64-pc-windows-gnu": [],
    "x86_64-pc-windows-gnullvm": [],
    "x86_64-pc-windows-msvc": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "x86_64-unknown-freebsd": ["@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "x86_64-unknown-fuchsia": ["@rules_rust//rust/platform:x86_64-unknown-fuchsia"],
    "x86_64-unknown-linux-gnu": ["@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "x86_64-unknown-nixos-gnu": ["@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "x86_64-unknown-none": ["@rules_rust//rust/platform:x86_64-unknown-none"],
    "x86_64-unknown-uefi": ["@rules_rust//rust/platform:x86_64-unknown-uefi"],
}

###############################################################################

def crate_repositories():
    """A macro for defining repositories for all generated crates.

    Returns:
      A list of repos visible to the module through the module extension.
    """
    maybe(
        http_archive,
        name = "vendor_ts__adler2-2.0.0",
        sha256 = "512761e0bb2578dd7380c6baaa0f4ce03e84f95e960231d1dec8bf4d7d6e2627",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/adler2/2.0.0/download"],
        strip_prefix = "adler2-2.0.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.adler2-2.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__aho-corasick-1.1.3",
        sha256 = "8e60d3430d3a69478ad0993f19238d2df97c507009a52b3c10addcd7f6bcb916",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/aho-corasick/1.1.3/download"],
        strip_prefix = "aho-corasick-1.1.3",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.aho-corasick-1.1.3.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__allocator-api2-0.2.21",
        sha256 = "683d7910e743518b0e34f1186f92494becacb047c7b6bf616c96772180fef923",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/allocator-api2/0.2.21/download"],
        strip_prefix = "allocator-api2-0.2.21",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.allocator-api2-0.2.21.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__android-tzdata-0.1.1",
        sha256 = "e999941b234f3131b00bc13c22d06e8c5ff726d1b6318ac7eb276997bbb4fef0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/android-tzdata/0.1.1/download"],
        strip_prefix = "android-tzdata-0.1.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.android-tzdata-0.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__android_system_properties-0.1.5",
        sha256 = "819e7219dbd41043ac279b19830f2efc897156490d7fd6ea916720117ee66311",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/android_system_properties/0.1.5/download"],
        strip_prefix = "android_system_properties-0.1.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.android_system_properties-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__anstream-0.6.18",
        sha256 = "8acc5369981196006228e28809f761875c0327210a891e941f4c683b3a99529b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstream/0.6.18/download"],
        strip_prefix = "anstream-0.6.18",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.anstream-0.6.18.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__anstyle-1.0.10",
        sha256 = "55cc3b69f167a1ef2e161439aa98aed94e6028e5f9a59be9a6ffb47aef1651f9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle/1.0.10/download"],
        strip_prefix = "anstyle-1.0.10",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.anstyle-1.0.10.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__anstyle-parse-0.2.6",
        sha256 = "3b2d16507662817a6a20a9ea92df6652ee4f94f914589377d69f3b21bc5798a9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle-parse/0.2.6/download"],
        strip_prefix = "anstyle-parse-0.2.6",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.anstyle-parse-0.2.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__anstyle-query-1.1.2",
        sha256 = "79947af37f4177cfead1110013d678905c37501914fba0efea834c3fe9a8d60c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle-query/1.1.2/download"],
        strip_prefix = "anstyle-query-1.1.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.anstyle-query-1.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__anstyle-wincon-3.0.7",
        sha256 = "ca3534e77181a9cc07539ad51f2141fe32f6c3ffd4df76db8ad92346b003ae4e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle-wincon/3.0.7/download"],
        strip_prefix = "anstyle-wincon-3.0.7",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.anstyle-wincon-3.0.7.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__anyhow-1.0.98",
        sha256 = "e16d2d3311acee920a9eb8d33b8cbc1787ce4a264e85f964c2404b969bdcd487",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anyhow/1.0.98/download"],
        strip_prefix = "anyhow-1.0.98",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.anyhow-1.0.98.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__argfile-0.2.1",
        sha256 = "0a1cc0ba69de57db40674c66f7cf2caee3981ddef084388482c95c0e2133e5e8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/argfile/0.2.1/download"],
        strip_prefix = "argfile-0.2.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.argfile-0.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__arrayvec-0.7.6",
        sha256 = "7c02d123df017efcdfbd739ef81735b36c5ba83ec3c59c80a9d7ecc718f92e50",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/arrayvec/0.7.6/download"],
        strip_prefix = "arrayvec-0.7.6",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.arrayvec-0.7.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__atomic-0.6.0",
        sha256 = "8d818003e740b63afc82337e3160717f4f63078720a810b7b903e70a5d1d2994",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/atomic/0.6.0/download"],
        strip_prefix = "atomic-0.6.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.atomic-0.6.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__autocfg-1.4.0",
        sha256 = "ace50bade8e6234aa140d9a2f552bbee1db4d353f69b8217bc503490fc1a9f26",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/autocfg/1.4.0/download"],
        strip_prefix = "autocfg-1.4.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.autocfg-1.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__base64-0.22.1",
        sha256 = "72b3254f16251a8381aa12e40e3c4d2f0199f8c6508fbecb9d91f575e0fbb8c6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/base64/0.22.1/download"],
        strip_prefix = "base64-0.22.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.base64-0.22.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__bitflags-1.3.2",
        sha256 = "bef38d45163c2f1dde094a7dfd33ccf595c92905c8f8f4fdc18d06fb1037718a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bitflags/1.3.2/download"],
        strip_prefix = "bitflags-1.3.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.bitflags-1.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__bitflags-2.9.1",
        sha256 = "1b8e56985ec62d17e9c1001dc89c88ecd7dc08e47eba5ec7c29c7b5eeecde967",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bitflags/2.9.1/download"],
        strip_prefix = "bitflags-2.9.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.bitflags-2.9.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__borsh-1.5.5",
        sha256 = "5430e3be710b68d984d1391c854eb431a9d548640711faa54eecb1df93db91cc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/borsh/1.5.5/download"],
        strip_prefix = "borsh-1.5.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.borsh-1.5.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__boxcar-0.2.13",
        sha256 = "26c4925bc979b677330a8c7fe7a8c94af2dbb4a2d37b4a20a80d884400f46baa",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/boxcar/0.2.13/download"],
        strip_prefix = "boxcar-0.2.13",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.boxcar-0.2.13.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__bstr-1.11.3",
        sha256 = "531a9155a481e2ee699d4f98f43c0ca4ff8ee1bfd55c31e9e98fb29d2b176fe0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bstr/1.11.3/download"],
        strip_prefix = "bstr-1.11.3",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.bstr-1.11.3.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__bumpalo-3.16.0",
        sha256 = "79296716171880943b8470b5f8d03aa55eb2e645a4874bdbb28adb49162e012c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bumpalo/3.16.0/download"],
        strip_prefix = "bumpalo-3.16.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.bumpalo-3.16.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__bytemuck-1.21.0",
        sha256 = "ef657dfab802224e671f5818e9a4935f9b1957ed18e58292690cc39e7a4092a3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bytemuck/1.21.0/download"],
        strip_prefix = "bytemuck-1.21.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.bytemuck-1.21.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__byteorder-1.5.0",
        sha256 = "1fd0f2584146f6f2ef48085050886acf353beff7305ebd1ae69500e27c67f64b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/byteorder/1.5.0/download"],
        strip_prefix = "byteorder-1.5.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.byteorder-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__camino-1.1.10",
        sha256 = "0da45bc31171d8d6960122e222a67740df867c1dd53b4d51caa297084c185cab",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/camino/1.1.10/download"],
        strip_prefix = "camino-1.1.10",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.camino-1.1.10.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__cargo-platform-0.2.0",
        sha256 = "84982c6c0ae343635a3a4ee6dedef965513735c8b183caa7289fa6e27399ebd4",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cargo-platform/0.2.0/download"],
        strip_prefix = "cargo-platform-0.2.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.cargo-platform-0.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__cargo-util-schemas-0.2.0",
        sha256 = "e63d2780ac94487eb9f1fea7b0d56300abc9eb488800854ca217f102f5caccca",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cargo-util-schemas/0.2.0/download"],
        strip_prefix = "cargo-util-schemas-0.2.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.cargo-util-schemas-0.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__cargo_metadata-0.20.0",
        sha256 = "4f7835cfc6135093070e95eb2b53e5d9b5c403dc3a6be6040ee026270aa82502",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cargo_metadata/0.20.0/download"],
        strip_prefix = "cargo_metadata-0.20.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.cargo_metadata-0.20.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__cc-1.2.7",
        sha256 = "a012a0df96dd6d06ba9a1b29d6402d1a5d77c6befd2566afdc26e10603dc93d7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cc/1.2.7/download"],
        strip_prefix = "cc-1.2.7",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.cc-1.2.7.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__cfg-if-1.0.1",
        sha256 = "9555578bc9e57714c812a1f84e4fc5b4d21fcb063490c624de019f7464c91268",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cfg-if/1.0.1/download"],
        strip_prefix = "cfg-if-1.0.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.cfg-if-1.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__cfg_aliases-0.2.1",
        sha256 = "613afe47fcd5fac7ccf1db93babcb082c5994d996f20b8b159f2ad1658eb5724",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cfg_aliases/0.2.1/download"],
        strip_prefix = "cfg_aliases-0.2.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.cfg_aliases-0.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__chalk-derive-0.103.0",
        sha256 = "eb4899682de915ca7c0b025bdd0a3d34c75fe12184122fda6805a7baddaa293c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/chalk-derive/0.103.0/download"],
        strip_prefix = "chalk-derive-0.103.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.chalk-derive-0.103.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__chalk-ir-0.103.0",
        sha256 = "90a37d2ab99352b4caca135061e7b4ac67024b648c28ed0b787feec4bea4caed",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/chalk-ir/0.103.0/download"],
        strip_prefix = "chalk-ir-0.103.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.chalk-ir-0.103.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__chalk-recursive-0.103.0",
        sha256 = "c855be60e646664bc37c2496d3dc81ca5ef60520930e5e0f0057a0575aff6c19",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/chalk-recursive/0.103.0/download"],
        strip_prefix = "chalk-recursive-0.103.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.chalk-recursive-0.103.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__chalk-solve-0.103.0",
        sha256 = "477ac6cdfd2013e9f93b09b036c2b607a67b2e728f4777b8422d55a79e9e3a34",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/chalk-solve/0.103.0/download"],
        strip_prefix = "chalk-solve-0.103.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.chalk-solve-0.103.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__chrono-0.4.41",
        sha256 = "c469d952047f47f91b68d1cba3f10d63c11d73e4636f24f08daf0278abf01c4d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/chrono/0.4.41/download"],
        strip_prefix = "chrono-0.4.41",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.chrono-0.4.41.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__clap-4.5.40",
        sha256 = "40b6887a1d8685cebccf115538db5c0efe625ccac9696ad45c409d96566e910f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap/4.5.40/download"],
        strip_prefix = "clap-4.5.40",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.clap-4.5.40.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__clap_builder-4.5.40",
        sha256 = "e0c66c08ce9f0c698cbce5c0279d0bb6ac936d8674174fe48f736533b964f59e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_builder/4.5.40/download"],
        strip_prefix = "clap_builder-4.5.40",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.clap_builder-4.5.40.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__clap_derive-4.5.40",
        sha256 = "d2c7947ae4cc3d851207c1adb5b5e260ff0cca11446b1d6d1423788e442257ce",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_derive/4.5.40/download"],
        strip_prefix = "clap_derive-4.5.40",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.clap_derive-4.5.40.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__clap_lex-0.7.4",
        sha256 = "f46ad14479a25103f283c0f10005961cf086d8dc42205bb44c46ac563475dca6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_lex/0.7.4/download"],
        strip_prefix = "clap_lex-0.7.4",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.clap_lex-0.7.4.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__colorchoice-1.0.3",
        sha256 = "5b63caa9aa9397e2d9480a9b13673856c78d8ac123288526c37d7839f2a86990",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/colorchoice/1.0.3/download"],
        strip_prefix = "colorchoice-1.0.3",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.colorchoice-1.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__core-foundation-sys-0.8.7",
        sha256 = "773648b94d0e5d620f64f280777445740e61fe701025087ec8b57f45c791888b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/core-foundation-sys/0.8.7/download"],
        strip_prefix = "core-foundation-sys-0.8.7",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.core-foundation-sys-0.8.7.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__countme-3.0.1",
        sha256 = "7704b5fdd17b18ae31c4c1da5a2e0305a2bf17b5249300a9ee9ed7b72114c636",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/countme/3.0.1/download"],
        strip_prefix = "countme-3.0.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.countme-3.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__cov-mark-2.0.0",
        sha256 = "0570650661aa447e7335f1d5e4f499d8e58796e617bedc9267d971e51c8b49d4",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cov-mark/2.0.0/download"],
        strip_prefix = "cov-mark-2.0.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.cov-mark-2.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__crc32fast-1.4.2",
        sha256 = "a97769d94ddab943e4510d138150169a2758b5ef3eb191a9ee688de3e23ef7b3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crc32fast/1.4.2/download"],
        strip_prefix = "crc32fast-1.4.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.crc32fast-1.4.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__crossbeam-channel-0.5.15",
        sha256 = "82b8f8f868b36967f9606790d1903570de9ceaf870a7bf9fbbd3016d636a2cb2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crossbeam-channel/0.5.15/download"],
        strip_prefix = "crossbeam-channel-0.5.15",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.crossbeam-channel-0.5.15.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__crossbeam-deque-0.8.6",
        sha256 = "9dd111b7b7f7d55b72c0a6ae361660ee5853c9af73f70c3c2ef6858b950e2e51",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crossbeam-deque/0.8.6/download"],
        strip_prefix = "crossbeam-deque-0.8.6",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.crossbeam-deque-0.8.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__crossbeam-epoch-0.9.18",
        sha256 = "5b82ac4a3c2ca9c3460964f020e1402edd5753411d7737aa39c3714ad1b5420e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crossbeam-epoch/0.9.18/download"],
        strip_prefix = "crossbeam-epoch-0.9.18",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.crossbeam-epoch-0.9.18.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__crossbeam-queue-0.3.12",
        sha256 = "0f58bbc28f91df819d0aa2a2c00cd19754769c2fad90579b3592b1c9ba7a3115",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crossbeam-queue/0.3.12/download"],
        strip_prefix = "crossbeam-queue-0.3.12",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.crossbeam-queue-0.3.12.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__crossbeam-utils-0.8.21",
        sha256 = "d0a5c400df2834b80a4c3327b3aad3a4c4cd4de0629063962b03235697506a28",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crossbeam-utils/0.8.21/download"],
        strip_prefix = "crossbeam-utils-0.8.21",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.crossbeam-utils-0.8.21.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__darling-0.20.10",
        sha256 = "6f63b86c8a8826a49b8c21f08a2d07338eec8d900540f8630dc76284be802989",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/darling/0.20.10/download"],
        strip_prefix = "darling-0.20.10",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.darling-0.20.10.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__darling_core-0.20.10",
        sha256 = "95133861a8032aaea082871032f5815eb9e98cef03fa916ab4500513994df9e5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/darling_core/0.20.10/download"],
        strip_prefix = "darling_core-0.20.10",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.darling_core-0.20.10.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__darling_macro-0.20.10",
        sha256 = "d336a2a514f6ccccaa3e09b02d41d35330c07ddf03a62165fcec10bb561c7806",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/darling_macro/0.20.10/download"],
        strip_prefix = "darling_macro-0.20.10",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.darling_macro-0.20.10.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__dashmap-6.1.0",
        sha256 = "5041cc499144891f3790297212f32a74fb938e5136a14943f338ef9e0ae276cf",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/dashmap/6.1.0/download"],
        strip_prefix = "dashmap-6.1.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.dashmap-6.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__deranged-0.3.11",
        sha256 = "b42b6fa04a440b495c8b04d0e71b707c585f83cb9cb28cf8cd0d976c315e31b4",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/deranged/0.3.11/download"],
        strip_prefix = "deranged-0.3.11",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.deranged-0.3.11.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__displaydoc-0.2.5",
        sha256 = "97369cbbc041bc366949bc74d34658d6cda5621039731c6310521892a3a20ae0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/displaydoc/0.2.5/download"],
        strip_prefix = "displaydoc-0.2.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.displaydoc-0.2.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__drop_bomb-0.1.5",
        sha256 = "9bda8e21c04aca2ae33ffc2fd8c23134f3cac46db123ba97bd9d3f3b8a4a85e1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/drop_bomb/0.1.5/download"],
        strip_prefix = "drop_bomb-0.1.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.drop_bomb-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__dunce-1.0.5",
        sha256 = "92773504d58c093f6de2459af4af33faa518c13451eb8f2b5698ed3d36e7c813",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/dunce/1.0.5/download"],
        strip_prefix = "dunce-1.0.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.dunce-1.0.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__dyn-clone-1.0.19",
        sha256 = "1c7a8fb8a9fbf66c1f703fe16184d10ca0ee9d23be5b4436400408ba54a95005",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/dyn-clone/1.0.19/download"],
        strip_prefix = "dyn-clone-1.0.19",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.dyn-clone-1.0.19.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__either-1.15.0",
        sha256 = "48c757948c5ede0e46177b7add2e67155f70e33c07fea8284df6576da70b3719",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/either/1.15.0/download"],
        strip_prefix = "either-1.15.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.either-1.15.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ena-0.14.3",
        sha256 = "3d248bdd43ce613d87415282f69b9bb99d947d290b10962dd6c56233312c2ad5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ena/0.14.3/download"],
        strip_prefix = "ena-0.14.3",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ena-0.14.3.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__encoding-0.2.33",
        sha256 = "6b0d943856b990d12d3b55b359144ff341533e516d94098b1d3fc1ac666d36ec",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/encoding/0.2.33/download"],
        strip_prefix = "encoding-0.2.33",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.encoding-0.2.33.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__encoding-index-japanese-1.20141219.5",
        sha256 = "04e8b2ff42e9a05335dbf8b5c6f7567e5591d0d916ccef4e0b1710d32a0d0c91",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/encoding-index-japanese/1.20141219.5/download"],
        strip_prefix = "encoding-index-japanese-1.20141219.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.encoding-index-japanese-1.20141219.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__encoding-index-korean-1.20141219.5",
        sha256 = "4dc33fb8e6bcba213fe2f14275f0963fd16f0a02c878e3095ecfdf5bee529d81",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/encoding-index-korean/1.20141219.5/download"],
        strip_prefix = "encoding-index-korean-1.20141219.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.encoding-index-korean-1.20141219.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__encoding-index-simpchinese-1.20141219.5",
        sha256 = "d87a7194909b9118fc707194baa434a4e3b0fb6a5a757c73c3adb07aa25031f7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/encoding-index-simpchinese/1.20141219.5/download"],
        strip_prefix = "encoding-index-simpchinese-1.20141219.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.encoding-index-simpchinese-1.20141219.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__encoding-index-singlebyte-1.20141219.5",
        sha256 = "3351d5acffb224af9ca265f435b859c7c01537c0849754d3db3fdf2bfe2ae84a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/encoding-index-singlebyte/1.20141219.5/download"],
        strip_prefix = "encoding-index-singlebyte-1.20141219.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.encoding-index-singlebyte-1.20141219.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__encoding-index-tradchinese-1.20141219.5",
        sha256 = "fd0e20d5688ce3cab59eb3ef3a2083a5c77bf496cb798dc6fcdb75f323890c18",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/encoding-index-tradchinese/1.20141219.5/download"],
        strip_prefix = "encoding-index-tradchinese-1.20141219.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.encoding-index-tradchinese-1.20141219.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__encoding_index_tests-0.1.4",
        sha256 = "a246d82be1c9d791c5dfde9a2bd045fc3cbba3fa2b11ad558f27d01712f00569",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/encoding_index_tests/0.1.4/download"],
        strip_prefix = "encoding_index_tests-0.1.4",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.encoding_index_tests-0.1.4.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__equivalent-1.0.2",
        sha256 = "877a4ace8713b0bcf2a4e7eec82529c029f1d0619886d18145fea96c3ffe5c0f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/equivalent/1.0.2/download"],
        strip_prefix = "equivalent-1.0.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.equivalent-1.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__erased-serde-0.4.6",
        sha256 = "e004d887f51fcb9fef17317a2f3525c887d8aa3f4f50fed920816a688284a5b7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/erased-serde/0.4.6/download"],
        strip_prefix = "erased-serde-0.4.6",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.erased-serde-0.4.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__figment-0.10.19",
        sha256 = "8cb01cd46b0cf372153850f4c6c272d9cbea2da513e07538405148f95bd789f3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/figment/0.10.19/download"],
        strip_prefix = "figment-0.10.19",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.figment-0.10.19.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__filetime-0.2.25",
        sha256 = "35c0522e981e68cbfa8c3f978441a5f34b30b96e146b33cd3359176b50fe8586",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/filetime/0.2.25/download"],
        strip_prefix = "filetime-0.2.25",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.filetime-0.2.25.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__fixedbitset-0.4.2",
        sha256 = "0ce7134b9999ecaf8bcd65542e436736ef32ddca1b3e06094cb6ec5755203b80",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/fixedbitset/0.4.2/download"],
        strip_prefix = "fixedbitset-0.4.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.fixedbitset-0.4.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__flate2-1.1.0",
        sha256 = "11faaf5a5236997af9848be0bef4db95824b1d534ebc64d0f0c6cf3e67bd38dc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/flate2/1.1.0/download"],
        strip_prefix = "flate2-1.1.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.flate2-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__fnv-1.0.7",
        sha256 = "3f9eec918d3f24069decb9af1554cad7c880e2da24a9afd88aca000531ab82c1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/fnv/1.0.7/download"],
        strip_prefix = "fnv-1.0.7",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.fnv-1.0.7.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__foldhash-0.1.5",
        sha256 = "d9c4f5dac5e15c24eb999c26181a6ca40b39fe946cbe4c263c7209467bc83af2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/foldhash/0.1.5/download"],
        strip_prefix = "foldhash-0.1.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.foldhash-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__form_urlencoded-1.2.1",
        sha256 = "e13624c2627564efccf4934284bdd98cbaa14e79b0b5a141218e507b3a823456",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/form_urlencoded/1.2.1/download"],
        strip_prefix = "form_urlencoded-1.2.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.form_urlencoded-1.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__fs-err-2.11.0",
        sha256 = "88a41f105fe1d5b6b34b2055e3dc59bb79b46b48b2040b9e6c7b4b5de097aa41",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/fs-err/2.11.0/download"],
        strip_prefix = "fs-err-2.11.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.fs-err-2.11.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__fsevent-sys-4.1.0",
        sha256 = "76ee7a02da4d231650c7cea31349b889be2f45ddb3ef3032d2ec8185f6313fd2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/fsevent-sys/4.1.0/download"],
        strip_prefix = "fsevent-sys-4.1.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.fsevent-sys-4.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__fst-0.4.7",
        sha256 = "7ab85b9b05e3978cc9a9cf8fea7f01b494e1a09ed3037e16ba39edc7a29eb61a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/fst/0.4.7/download"],
        strip_prefix = "fst-0.4.7",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.fst-0.4.7.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__getrandom-0.3.1",
        sha256 = "43a49c392881ce6d5c3b8cb70f98717b7c07aabbdff06687b9030dbfbe2725f8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/getrandom/0.3.1/download"],
        strip_prefix = "getrandom-0.3.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.getrandom-0.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__glob-0.3.2",
        sha256 = "a8d1add55171497b4705a648c6b583acafb01d58050a51727785f0b2c8e0a2b2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/glob/0.3.2/download"],
        strip_prefix = "glob-0.3.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.glob-0.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__globset-0.4.15",
        sha256 = "15f1ce686646e7f1e19bf7d5533fe443a45dbfb990e00629110797578b42fb19",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/globset/0.4.15/download"],
        strip_prefix = "globset-0.4.15",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.globset-0.4.15.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__hashbrown-0.12.3",
        sha256 = "8a9ee70c43aaf417c914396645a0fa852624801b24ebb7ae78fe8272889ac888",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hashbrown/0.12.3/download"],
        strip_prefix = "hashbrown-0.12.3",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.hashbrown-0.12.3.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__hashbrown-0.14.5",
        sha256 = "e5274423e17b7c9fc20b6e7e208532f9b19825d82dfd615708b70edd83df41f1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hashbrown/0.14.5/download"],
        strip_prefix = "hashbrown-0.14.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.hashbrown-0.14.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__hashbrown-0.15.2",
        sha256 = "bf151400ff0baff5465007dd2f3e717f3fe502074ca563069ce3a6629d07b289",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hashbrown/0.15.2/download"],
        strip_prefix = "hashbrown-0.15.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.hashbrown-0.15.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__hashlink-0.10.0",
        sha256 = "7382cf6263419f2d8df38c55d7da83da5c18aef87fc7a7fc1fb1e344edfe14c1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hashlink/0.10.0/download"],
        strip_prefix = "hashlink-0.10.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.hashlink-0.10.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__heck-0.5.0",
        sha256 = "2304e00983f87ffb38b55b444b5e3b60a884b5d30c0fca7d82fe33449bbe55ea",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/heck/0.5.0/download"],
        strip_prefix = "heck-0.5.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.heck-0.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__hermit-abi-0.5.2",
        sha256 = "fc0fef456e4baa96da950455cd02c081ca953b141298e41db3fc7e36b1da849c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hermit-abi/0.5.2/download"],
        strip_prefix = "hermit-abi-0.5.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.hermit-abi-0.5.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__hex-0.4.3",
        sha256 = "7f24254aa9a54b5c858eaee2f5bccdb46aaf0e486a595ed5fd8f86ba55232a70",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hex/0.4.3/download"],
        strip_prefix = "hex-0.4.3",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.hex-0.4.3.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__home-0.5.11",
        sha256 = "589533453244b0995c858700322199b2becb13b627df2851f64a2775d024abcf",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/home/0.5.11/download"],
        strip_prefix = "home-0.5.11",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.home-0.5.11.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__iana-time-zone-0.1.61",
        sha256 = "235e081f3925a06703c2d0117ea8b91f042756fd6e7a6e5d901e8ca1a996b220",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/iana-time-zone/0.1.61/download"],
        strip_prefix = "iana-time-zone-0.1.61",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.iana-time-zone-0.1.61.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__iana-time-zone-haiku-0.1.2",
        sha256 = "f31827a206f56af32e590ba56d5d2d085f558508192593743f16b2306495269f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/iana-time-zone-haiku/0.1.2/download"],
        strip_prefix = "iana-time-zone-haiku-0.1.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.iana-time-zone-haiku-0.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__icu_collections-2.0.0",
        sha256 = "200072f5d0e3614556f94a9930d5dc3e0662a652823904c3a75dc3b0af7fee47",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_collections/2.0.0/download"],
        strip_prefix = "icu_collections-2.0.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.icu_collections-2.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__icu_locale_core-2.0.0",
        sha256 = "0cde2700ccaed3872079a65fb1a78f6c0a36c91570f28755dda67bc8f7d9f00a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_locale_core/2.0.0/download"],
        strip_prefix = "icu_locale_core-2.0.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.icu_locale_core-2.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__icu_normalizer-2.0.0",
        sha256 = "436880e8e18df4d7bbc06d58432329d6458cc84531f7ac5f024e93deadb37979",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_normalizer/2.0.0/download"],
        strip_prefix = "icu_normalizer-2.0.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.icu_normalizer-2.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__icu_normalizer_data-2.0.0",
        sha256 = "00210d6893afc98edb752b664b8890f0ef174c8adbb8d0be9710fa66fbbf72d3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_normalizer_data/2.0.0/download"],
        strip_prefix = "icu_normalizer_data-2.0.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.icu_normalizer_data-2.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__icu_properties-2.0.1",
        sha256 = "016c619c1eeb94efb86809b015c58f479963de65bdb6253345c1a1276f22e32b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_properties/2.0.1/download"],
        strip_prefix = "icu_properties-2.0.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.icu_properties-2.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__icu_properties_data-2.0.1",
        sha256 = "298459143998310acd25ffe6810ed544932242d3f07083eee1084d83a71bd632",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_properties_data/2.0.1/download"],
        strip_prefix = "icu_properties_data-2.0.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.icu_properties_data-2.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__icu_provider-2.0.0",
        sha256 = "03c80da27b5f4187909049ee2d72f276f0d9f99a42c306bd0131ecfe04d8e5af",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_provider/2.0.0/download"],
        strip_prefix = "icu_provider-2.0.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.icu_provider-2.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ident_case-1.0.1",
        sha256 = "b9e0384b61958566e926dc50660321d12159025e767c18e043daf26b70104c39",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ident_case/1.0.1/download"],
        strip_prefix = "ident_case-1.0.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ident_case-1.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__idna-1.0.3",
        sha256 = "686f825264d630750a544639377bae737628043f20d38bbc029e8f29ea968a7e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/idna/1.0.3/download"],
        strip_prefix = "idna-1.0.3",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.idna-1.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__idna_adapter-1.2.1",
        sha256 = "3acae9609540aa318d1bc588455225fb2085b9ed0c4f6bd0d9d5bcd86f1a0344",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/idna_adapter/1.2.1/download"],
        strip_prefix = "idna_adapter-1.2.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.idna_adapter-1.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__indexmap-1.9.3",
        sha256 = "bd070e393353796e801d209ad339e89596eb4c8d430d18ede6a1cced8fafbd99",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/indexmap/1.9.3/download"],
        strip_prefix = "indexmap-1.9.3",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.indexmap-1.9.3.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__indexmap-2.9.0",
        sha256 = "cea70ddb795996207ad57735b50c5982d8844f38ba9ee5f1aedcfb708a2aa11e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/indexmap/2.9.0/download"],
        strip_prefix = "indexmap-2.9.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.indexmap-2.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__inlinable_string-0.1.15",
        sha256 = "c8fae54786f62fb2918dcfae3d568594e50eb9b5c25bf04371af6fe7516452fb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/inlinable_string/0.1.15/download"],
        strip_prefix = "inlinable_string-0.1.15",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.inlinable_string-0.1.15.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__inotify-0.11.0",
        sha256 = "f37dccff2791ab604f9babef0ba14fbe0be30bd368dc541e2b08d07c8aa908f3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/inotify/0.11.0/download"],
        strip_prefix = "inotify-0.11.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.inotify-0.11.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__inotify-sys-0.1.5",
        sha256 = "e05c02b5e89bff3b946cedeca278abc628fe811e604f027c45a8aa3cf793d0eb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/inotify-sys/0.1.5/download"],
        strip_prefix = "inotify-sys-0.1.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.inotify-sys-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__is_terminal_polyfill-1.70.1",
        sha256 = "7943c866cc5cd64cbc25b2e01621d07fa8eb2a1a23160ee81ce38704e97b8ecf",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/is_terminal_polyfill/1.70.1/download"],
        strip_prefix = "is_terminal_polyfill-1.70.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.is_terminal_polyfill-1.70.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__itertools-0.12.1",
        sha256 = "ba291022dbbd398a455acf126c1e341954079855bc60dfdda641363bd6922569",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/itertools/0.12.1/download"],
        strip_prefix = "itertools-0.12.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.itertools-0.12.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__itertools-0.14.0",
        sha256 = "2b192c782037fadd9cfa75548310488aabdbf3d2da73885b31bd0abd03351285",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/itertools/0.14.0/download"],
        strip_prefix = "itertools-0.14.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.itertools-0.14.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__itoa-1.0.15",
        sha256 = "4a5f13b858c8d314ee3e8f639011f7ccefe71f97f96e50151fb991f267928e2c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/itoa/1.0.15/download"],
        strip_prefix = "itoa-1.0.15",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.itoa-1.0.15.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__jobserver-0.1.32",
        sha256 = "48d1dbcbbeb6a7fec7e059840aa538bd62aaccf972c7346c4d9d2059312853d0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/jobserver/0.1.32/download"],
        strip_prefix = "jobserver-0.1.32",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.jobserver-0.1.32.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__jod-thread-1.0.0",
        sha256 = "a037eddb7d28de1d0fc42411f501b53b75838d313908078d6698d064f3029b24",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/jod-thread/1.0.0/download"],
        strip_prefix = "jod-thread-1.0.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.jod-thread-1.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__js-sys-0.3.76",
        sha256 = "6717b6b5b077764fb5966237269cb3c64edddde4b14ce42647430a78ced9e7b7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/js-sys/0.3.76/download"],
        strip_prefix = "js-sys-0.3.76",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.js-sys-0.3.76.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__kqueue-1.0.8",
        sha256 = "7447f1ca1b7b563588a205fe93dea8df60fd981423a768bc1c0ded35ed147d0c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/kqueue/1.0.8/download"],
        strip_prefix = "kqueue-1.0.8",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.kqueue-1.0.8.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__kqueue-sys-1.0.4",
        sha256 = "ed9625ffda8729b85e45cf04090035ac368927b8cebc34898e7c120f52e4838b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/kqueue-sys/1.0.4/download"],
        strip_prefix = "kqueue-sys-1.0.4",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.kqueue-sys-1.0.4.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__la-arena-0.3.1",
        sha256 = "3752f229dcc5a481d60f385fa479ff46818033d881d2d801aa27dffcfb5e8306",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/la-arena/0.3.1/download"],
        strip_prefix = "la-arena-0.3.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.la-arena-0.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__lazy_static-1.5.0",
        sha256 = "bbd2bcb4c963f2ddae06a2efc7e9f3591312473c50c6685e1f298068316e66fe",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/lazy_static/1.5.0/download"],
        strip_prefix = "lazy_static-1.5.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.lazy_static-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__libc-0.2.174",
        sha256 = "1171693293099992e19cddea4e8b849964e9846f4acee11b3948bcc337be8776",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/libc/0.2.174/download"],
        strip_prefix = "libc-0.2.174",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.libc-0.2.174.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__libredox-0.1.3",
        sha256 = "c0ff37bd590ca25063e35af745c343cb7a0271906fb7b37e4813e8f79f00268d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/libredox/0.1.3/download"],
        strip_prefix = "libredox-0.1.3",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.libredox-0.1.3.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__line-index-0.1.2",
        sha256 = "3e27e0ed5a392a7f5ba0b3808a2afccff16c64933312c84b57618b49d1209bd2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/line-index/0.1.2/download"],
        strip_prefix = "line-index-0.1.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.line-index-0.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__litemap-0.8.0",
        sha256 = "241eaef5fd12c88705a01fc1066c48c4b36e0dd4377dcdc7ec3942cea7a69956",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/litemap/0.8.0/download"],
        strip_prefix = "litemap-0.8.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.litemap-0.8.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__lock_api-0.4.12",
        sha256 = "07af8b9cdd281b7915f413fa73f29ebd5d55d0d3f0155584dade1ff18cea1b17",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/lock_api/0.4.12/download"],
        strip_prefix = "lock_api-0.4.12",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.lock_api-0.4.12.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__log-0.3.9",
        sha256 = "e19e8d5c34a3e0e2223db8e060f9e8264aeeb5c5fc64a4ee9965c062211c024b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/log/0.3.9/download"],
        strip_prefix = "log-0.3.9",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.log-0.3.9.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__log-0.4.27",
        sha256 = "13dc2df351e3202783a1fe0d44375f7295ffb4049267b0f3018346dc122a1d94",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/log/0.4.27/download"],
        strip_prefix = "log-0.4.27",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.log-0.4.27.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__matchers-0.1.0",
        sha256 = "8263075bb86c5a1b1427b5ae862e8889656f126e9f77c484496e8b47cf5c5558",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/matchers/0.1.0/download"],
        strip_prefix = "matchers-0.1.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.matchers-0.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__memchr-2.7.5",
        sha256 = "32a282da65faaf38286cf3be983213fcf1d2e2a58700e808f83f4ea9a4804bc0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/memchr/2.7.5/download"],
        strip_prefix = "memchr-2.7.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.memchr-2.7.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__memoffset-0.9.1",
        sha256 = "488016bfae457b036d996092f6cb448677611ce4449e970ceaf42695203f218a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/memoffset/0.9.1/download"],
        strip_prefix = "memoffset-0.9.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.memoffset-0.9.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__miniz_oxide-0.8.5",
        sha256 = "8e3e04debbb59698c15bacbb6d93584a8c0ca9cc3213cb423d31f760d8843ce5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/miniz_oxide/0.8.5/download"],
        strip_prefix = "miniz_oxide-0.8.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.miniz_oxide-0.8.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__mio-1.0.3",
        sha256 = "2886843bf800fba2e3377cff24abf6379b4c4d5c6681eaf9ea5b0d15090450bd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/mio/1.0.3/download"],
        strip_prefix = "mio-1.0.3",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.mio-1.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__miow-0.6.0",
        sha256 = "359f76430b20a79f9e20e115b3428614e654f04fab314482fc0fda0ebd3c6044",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/miow/0.6.0/download"],
        strip_prefix = "miow-0.6.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.miow-0.6.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__mustache-0.9.0",
        sha256 = "51956ef1c5d20a1384524d91e616fb44dfc7d8f249bf696d49c97dd3289ecab5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/mustache/0.9.0/download"],
        strip_prefix = "mustache-0.9.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.mustache-0.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__nohash-hasher-0.2.0",
        sha256 = "2bf50223579dc7cdcfb3bfcacf7069ff68243f8c363f62ffa99cf000a6b9c451",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/nohash-hasher/0.2.0/download"],
        strip_prefix = "nohash-hasher-0.2.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.nohash-hasher-0.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__notify-8.0.0",
        sha256 = "2fee8403b3d66ac7b26aee6e40a897d85dc5ce26f44da36b8b73e987cc52e943",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/notify/8.0.0/download"],
        strip_prefix = "notify-8.0.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.notify-8.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__notify-types-2.0.0",
        sha256 = "5e0826a989adedc2a244799e823aece04662b66609d96af8dff7ac6df9a8925d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/notify-types/2.0.0/download"],
        strip_prefix = "notify-types-2.0.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.notify-types-2.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__nu-ansi-term-0.46.0",
        sha256 = "77a8165726e8236064dbb45459242600304b42a5ea24ee2948e18e023bf7ba84",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/nu-ansi-term/0.46.0/download"],
        strip_prefix = "nu-ansi-term-0.46.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.nu-ansi-term-0.46.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__num-conv-0.1.0",
        sha256 = "51d515d32fb182ee37cda2ccdcb92950d6a3c2893aa280e540671c2cd0f3b1d9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/num-conv/0.1.0/download"],
        strip_prefix = "num-conv-0.1.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.num-conv-0.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__num-traits-0.2.19",
        sha256 = "071dfc062690e90b734c0b2273ce72ad0ffa95f0c74596bc250dcfd960262841",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/num-traits/0.2.19/download"],
        strip_prefix = "num-traits-0.2.19",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.num-traits-0.2.19.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__num_cpus-1.17.0",
        sha256 = "91df4bbde75afed763b708b7eee1e8e7651e02d97f6d5dd763e89367e957b23b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/num_cpus/1.17.0/download"],
        strip_prefix = "num_cpus-1.17.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.num_cpus-1.17.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__once_cell-1.20.3",
        sha256 = "945462a4b81e43c4e3ba96bd7b49d834c6f61198356aa858733bc4acf3cbe62e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/once_cell/1.20.3/download"],
        strip_prefix = "once_cell-1.20.3",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.once_cell-1.20.3.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__oorandom-11.1.5",
        sha256 = "d6790f58c7ff633d8771f42965289203411a5e5c68388703c06e14f24770b41e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/oorandom/11.1.5/download"],
        strip_prefix = "oorandom-11.1.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.oorandom-11.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ordered-float-2.10.1",
        sha256 = "68f19d67e5a2795c94e73e0bb1cc1a7edeb2e28efd39e2e1c9b7a40c1108b11c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ordered-float/2.10.1/download"],
        strip_prefix = "ordered-float-2.10.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ordered-float-2.10.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__os_str_bytes-7.0.0",
        sha256 = "7ac44c994af577c799b1b4bd80dc214701e349873ad894d6cdf96f4f7526e0b9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/os_str_bytes/7.0.0/download"],
        strip_prefix = "os_str_bytes-7.0.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.os_str_bytes-7.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__overload-0.1.1",
        sha256 = "b15813163c1d831bf4a13c3610c05c0d03b39feb07f7e09fa234dac9b15aaf39",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/overload/0.1.1/download"],
        strip_prefix = "overload-0.1.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.overload-0.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__parking_lot-0.12.3",
        sha256 = "f1bf18183cf54e8d6059647fc3063646a1801cf30896933ec2311622cc4b9a27",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/parking_lot/0.12.3/download"],
        strip_prefix = "parking_lot-0.12.3",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.parking_lot-0.12.3.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__parking_lot_core-0.9.10",
        sha256 = "1e401f977ab385c9e4e3ab30627d6f26d00e2c73eef317493c4ec6d468726cf8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/parking_lot_core/0.9.10/download"],
        strip_prefix = "parking_lot_core-0.9.10",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.parking_lot_core-0.9.10.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__pear-0.2.9",
        sha256 = "bdeeaa00ce488657faba8ebf44ab9361f9365a97bd39ffb8a60663f57ff4b467",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pear/0.2.9/download"],
        strip_prefix = "pear-0.2.9",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.pear-0.2.9.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__pear_codegen-0.2.9",
        sha256 = "4bab5b985dc082b345f812b7df84e1bef27e7207b39e448439ba8bd69c93f147",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pear_codegen/0.2.9/download"],
        strip_prefix = "pear_codegen-0.2.9",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.pear_codegen-0.2.9.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__percent-encoding-2.3.1",
        sha256 = "e3148f5046208a5d56bcfc03053e3ca6334e51da8dfb19b6cdc8b306fae3283e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/percent-encoding/2.3.1/download"],
        strip_prefix = "percent-encoding-2.3.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.percent-encoding-2.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__perf-event-0.4.7",
        sha256 = "5396562cd2eaa828445d6d34258ae21ee1eb9d40fe626ca7f51c8dccb4af9d66",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/perf-event/0.4.7/download"],
        strip_prefix = "perf-event-0.4.7",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.perf-event-0.4.7.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__perf-event-open-sys-1.0.1",
        sha256 = "ce9bedf5da2c234fdf2391ede2b90fabf585355f33100689bc364a3ea558561a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/perf-event-open-sys/1.0.1/download"],
        strip_prefix = "perf-event-open-sys-1.0.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.perf-event-open-sys-1.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__petgraph-0.6.5",
        sha256 = "b4c5cc86750666a3ed20bdaf5ca2a0344f9c67674cae0515bec2da16fbaa47db",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/petgraph/0.6.5/download"],
        strip_prefix = "petgraph-0.6.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.petgraph-0.6.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__pin-project-lite-0.2.16",
        sha256 = "3b3cff922bd51709b605d9ead9aa71031d81447142d828eb4a6eba76fe619f9b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pin-project-lite/0.2.16/download"],
        strip_prefix = "pin-project-lite-0.2.16",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.pin-project-lite-0.2.16.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__pkg-config-0.3.32",
        sha256 = "7edddbd0b52d732b21ad9a5fab5c704c14cd949e5e9a1ec5929a24fded1b904c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pkg-config/0.3.32/download"],
        strip_prefix = "pkg-config-0.3.32",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.pkg-config-0.3.32.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__portable-atomic-1.11.0",
        sha256 = "350e9b48cbc6b0e028b0473b114454c6316e57336ee184ceab6e53f72c178b3e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/portable-atomic/1.11.0/download"],
        strip_prefix = "portable-atomic-1.11.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.portable-atomic-1.11.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__potential_utf-0.1.2",
        sha256 = "e5a7c30837279ca13e7c867e9e40053bc68740f988cb07f7ca6df43cc734b585",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/potential_utf/0.1.2/download"],
        strip_prefix = "potential_utf-0.1.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.potential_utf-0.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__powerfmt-0.2.0",
        sha256 = "439ee305def115ba05938db6eb1644ff94165c5ab5e9420d1c1bcedbba909391",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/powerfmt/0.2.0/download"],
        strip_prefix = "powerfmt-0.2.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.powerfmt-0.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ppv-lite86-0.2.20",
        sha256 = "77957b295656769bb8ad2b6a6b09d897d94f05c41b069aede1fcdaa675eaea04",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ppv-lite86/0.2.20/download"],
        strip_prefix = "ppv-lite86-0.2.20",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ppv-lite86-0.2.20.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__proc-macro2-1.0.95",
        sha256 = "02b3e5e68a3a1a02aad3ec490a98007cbc13c37cbe84a3cd7b8e406d76e7f778",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/proc-macro2/1.0.95/download"],
        strip_prefix = "proc-macro2-1.0.95",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.proc-macro2-1.0.95.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__proc-macro2-diagnostics-0.10.1",
        sha256 = "af066a9c399a26e020ada66a034357a868728e72cd426f3adcd35f80d88d88c8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/proc-macro2-diagnostics/0.10.1/download"],
        strip_prefix = "proc-macro2-diagnostics-0.10.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.proc-macro2-diagnostics-0.10.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__quote-1.0.40",
        sha256 = "1885c039570dc00dcb4ff087a89e185fd56bae234ddc7f056a945bf36467248d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/quote/1.0.40/download"],
        strip_prefix = "quote-1.0.40",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.quote-1.0.40.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra-ap-rustc_abi-0.116.0",
        sha256 = "a967e3a9cd3e38b543f503978e0eccee461e3aea3f7b10e944959bff41dbe612",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra-ap-rustc_abi/0.116.0/download"],
        strip_prefix = "ra-ap-rustc_abi-0.116.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra-ap-rustc_abi-0.116.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra-ap-rustc_hashes-0.116.0",
        sha256 = "1ea4c755ecbbffa5743c251344f484ebe571ec7bc5b36d80b2a8ae775d1a7a40",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra-ap-rustc_hashes/0.116.0/download"],
        strip_prefix = "ra-ap-rustc_hashes-0.116.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra-ap-rustc_hashes-0.116.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra-ap-rustc_index-0.116.0",
        sha256 = "aca7ad7cf911538c619caa2162339fe98637e9e46f11bb0484ef96735df4d64a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra-ap-rustc_index/0.116.0/download"],
        strip_prefix = "ra-ap-rustc_index-0.116.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra-ap-rustc_index-0.116.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra-ap-rustc_index_macros-0.116.0",
        sha256 = "8767ba551c9355bc3031be072cc4bb0381106e5e7cd275e72b7a8c76051c4070",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra-ap-rustc_index_macros/0.116.0/download"],
        strip_prefix = "ra-ap-rustc_index_macros-0.116.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra-ap-rustc_index_macros-0.116.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra-ap-rustc_lexer-0.116.0",
        sha256 = "6101374afb267e6c27e4e2eb0b1352e9f3504c1a8f716f619cd39244e2ed92ab",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra-ap-rustc_lexer/0.116.0/download"],
        strip_prefix = "ra-ap-rustc_lexer-0.116.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra-ap-rustc_lexer-0.116.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra-ap-rustc_parse_format-0.116.0",
        sha256 = "ecd88a19f00da4f43e6727d5013444cbc399804b5046dfa2bbcd28ebed3970ce",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra-ap-rustc_parse_format/0.116.0/download"],
        strip_prefix = "ra-ap-rustc_parse_format-0.116.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra-ap-rustc_parse_format-0.116.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra-ap-rustc_pattern_analysis-0.116.0",
        sha256 = "bb332dd32d7850a799862533b1c021e6062558861a4ad57817bf522499fbb892",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra-ap-rustc_pattern_analysis/0.116.0/download"],
        strip_prefix = "ra-ap-rustc_pattern_analysis-0.116.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra-ap-rustc_pattern_analysis-0.116.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_base_db-0.0.288",
        sha256 = "edf27fccb119fe85faf51f51847df9695d3cca30c2427fed9b4d71e6adebb54f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_base_db/0.0.288/download"],
        strip_prefix = "ra_ap_base_db-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_base_db-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_cfg-0.0.288",
        sha256 = "3cea86a5d6e84fd73824c26f52442807af911db038db821124b2ac65fac24209",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_cfg/0.0.288/download"],
        strip_prefix = "ra_ap_cfg-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_cfg-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_edition-0.0.288",
        sha256 = "fb5538d534eeb8526071610664dc64b71ca336b78f6933ff7241d10c1f37e91b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_edition/0.0.288/download"],
        strip_prefix = "ra_ap_edition-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_edition-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_hir-0.0.288",
        sha256 = "44796828650900565917ddcc944fecdf6c7d5c3a8a31141f17268ea8c1d2e6f0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_hir/0.0.288/download"],
        strip_prefix = "ra_ap_hir-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_hir-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_hir_def-0.0.288",
        sha256 = "8949b2fb362a1e4eab4d90c7299f0fad3f2c887d9f7d9c286ac6530da4141f85",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_hir_def/0.0.288/download"],
        strip_prefix = "ra_ap_hir_def-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_hir_def-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_hir_expand-0.0.288",
        sha256 = "22457a431b5eeb67517e03266fddefe48839b060a674a6b18bd84269012ede1e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_hir_expand/0.0.288/download"],
        strip_prefix = "ra_ap_hir_expand-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_hir_expand-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_hir_ty-0.0.288",
        sha256 = "3a4b7a7531414203e11ae447627e2909250eff392c06278ab53ae2a022ecc9fc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_hir_ty/0.0.288/download"],
        strip_prefix = "ra_ap_hir_ty-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_hir_ty-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_ide_db-0.0.288",
        sha256 = "77741ceb096d4f5ecf5384210ea5a2b46878125047c6b0df2bdcfac08a20ea0c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_ide_db/0.0.288/download"],
        strip_prefix = "ra_ap_ide_db-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_ide_db-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_intern-0.0.288",
        sha256 = "4a1872cd5a425db6d5247a7deca11526e3104757f6732447ac6ee93c3e795725",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_intern/0.0.288/download"],
        strip_prefix = "ra_ap_intern-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_intern-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_load-cargo-0.0.288",
        sha256 = "f30f5433f056594b02f1879c5c2ce76ea9fd395f21e2a55df6ce3229db993caa",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_load-cargo/0.0.288/download"],
        strip_prefix = "ra_ap_load-cargo-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_load-cargo-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_mbe-0.0.288",
        sha256 = "222a993acaec35e90c08357aecd530b7170cc3a7f13b3ddfd15a200029ccd555",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_mbe/0.0.288/download"],
        strip_prefix = "ra_ap_mbe-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_mbe-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_parser-0.0.288",
        sha256 = "1c5693f5efd27832e1ac572ea756a1a4a3f7eba07f1287268ca111710971c2e5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_parser/0.0.288/download"],
        strip_prefix = "ra_ap_parser-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_parser-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_paths-0.0.288",
        sha256 = "39418eff64e59d4bf90dd825ac7d242576e9554669824ebc55a6628bde0aaf10",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_paths/0.0.288/download"],
        strip_prefix = "ra_ap_paths-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_paths-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_proc_macro_api-0.0.288",
        sha256 = "14a315af8c4a9379c26abe7baa143d62e3975ff26f27c65332f9a5edccc56d38",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_proc_macro_api/0.0.288/download"],
        strip_prefix = "ra_ap_proc_macro_api-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_proc_macro_api-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_profile-0.0.288",
        sha256 = "08274a0adbf8255f8b2672302452e31bbb2ed4d38324da9c72a7bf9cf1428483",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_profile/0.0.288/download"],
        strip_prefix = "ra_ap_profile-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_profile-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_project_model-0.0.288",
        sha256 = "33deecb3724faf91f13b0f1b5115af7c4f5c9dc1dfbbf45f55261aa28f874838",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_project_model/0.0.288/download"],
        strip_prefix = "ra_ap_project_model-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_project_model-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_query-group-macro-0.0.288",
        sha256 = "5fdefdc9c8d6fd7d85ac572649378e83266262e09400bfdb7c8a7407d3cc2a3e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_query-group-macro/0.0.288/download"],
        strip_prefix = "ra_ap_query-group-macro-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_query-group-macro-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_span-0.0.288",
        sha256 = "c20071c89e1f7dd63c803130634f4bb6ce7783dc0e7ff90839d1d0f4e625b7a8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_span/0.0.288/download"],
        strip_prefix = "ra_ap_span-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_span-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_stdx-0.0.288",
        sha256 = "552df390b26624eca7936aea1dbbb3786d7a12477e26ef917ffabba19f75ad44",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_stdx/0.0.288/download"],
        strip_prefix = "ra_ap_stdx-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_stdx-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_syntax-0.0.288",
        sha256 = "a78db1a9966c0fa05446b8185da35a325680741119366c6246e4a9800f29143a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_syntax/0.0.288/download"],
        strip_prefix = "ra_ap_syntax-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_syntax-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_syntax-bridge-0.0.288",
        sha256 = "e69ef7fad8598d5c9f14a375d56ec12200fa927bc805b600af419611f4642fdb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_syntax-bridge/0.0.288/download"],
        strip_prefix = "ra_ap_syntax-bridge-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_syntax-bridge-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_toolchain-0.0.288",
        sha256 = "628f3f190def67b1116d8bdd6ec4f6f206fada2c93b84ba71086d60c63429282",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_toolchain/0.0.288/download"],
        strip_prefix = "ra_ap_toolchain-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_toolchain-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_tt-0.0.288",
        sha256 = "e050f4ad13df59e90e38332860304a3e85ff2fa8d4585b8cc44fc982923c82b1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_tt/0.0.288/download"],
        strip_prefix = "ra_ap_tt-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_tt-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_vfs-0.0.288",
        sha256 = "62082190f0b3551e4d941bcaaac51a7c39c85b2e193bcc50d0807e1701da4083",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_vfs/0.0.288/download"],
        strip_prefix = "ra_ap_vfs-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_vfs-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ra_ap_vfs-notify-0.0.288",
        sha256 = "efd7cfa1095b81bd1994ab70e5543c97a8733987eb0ddf390cf3ad58d4e2dc57",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ra_ap_vfs-notify/0.0.288/download"],
        strip_prefix = "ra_ap_vfs-notify-0.0.288",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ra_ap_vfs-notify-0.0.288.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__rand-0.9.1",
        sha256 = "9fbfd9d094a40bf3ae768db9361049ace4c0e04a4fd6b359518bd7b73a73dd97",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rand/0.9.1/download"],
        strip_prefix = "rand-0.9.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.rand-0.9.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__rand_chacha-0.9.0",
        sha256 = "d3022b5f1df60f26e1ffddd6c66e8aa15de382ae63b3a0c1bfc0e4d3e3f325cb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rand_chacha/0.9.0/download"],
        strip_prefix = "rand_chacha-0.9.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.rand_chacha-0.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__rand_core-0.9.2",
        sha256 = "7a509b1a2ffbe92afab0e55c8fd99dea1c280e8171bd2d88682bb20bc41cbc2c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rand_core/0.9.2/download"],
        strip_prefix = "rand_core-0.9.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.rand_core-0.9.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__rayon-1.10.0",
        sha256 = "b418a60154510ca1a002a752ca9714984e21e4241e804d32555251faf8b78ffa",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rayon/1.10.0/download"],
        strip_prefix = "rayon-1.10.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.rayon-1.10.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__rayon-core-1.12.1",
        sha256 = "1465873a3dfdaa8ae7cb14b4383657caab0b3e8a0aa9ae8e04b044854c8dfce2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rayon-core/1.12.1/download"],
        strip_prefix = "rayon-core-1.12.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.rayon-core-1.12.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__redox_syscall-0.5.8",
        sha256 = "03a862b389f93e68874fbf580b9de08dd02facb9a788ebadaf4a3fd33cf58834",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/redox_syscall/0.5.8/download"],
        strip_prefix = "redox_syscall-0.5.8",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.redox_syscall-0.5.8.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ref-cast-1.0.24",
        sha256 = "4a0ae411dbe946a674d89546582cea4ba2bb8defac896622d6496f14c23ba5cf",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ref-cast/1.0.24/download"],
        strip_prefix = "ref-cast-1.0.24",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ref-cast-1.0.24.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ref-cast-impl-1.0.24",
        sha256 = "1165225c21bff1f3bbce98f5a1f889949bc902d3575308cc7b0de30b4f6d27c7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ref-cast-impl/1.0.24/download"],
        strip_prefix = "ref-cast-impl-1.0.24",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ref-cast-impl-1.0.24.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__regex-1.11.1",
        sha256 = "b544ef1b4eac5dc2db33ea63606ae9ffcfac26c1416a2806ae0bf5f56b201191",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex/1.11.1/download"],
        strip_prefix = "regex-1.11.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.regex-1.11.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__regex-automata-0.1.10",
        sha256 = "6c230d73fb8d8c1b9c0b3135c5142a8acee3a0558fb8db5cf1cb65f8d7862132",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex-automata/0.1.10/download"],
        strip_prefix = "regex-automata-0.1.10",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.regex-automata-0.1.10.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__regex-automata-0.4.9",
        sha256 = "809e8dc61f6de73b46c85f4c96486310fe304c434cfa43669d7b40f711150908",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex-automata/0.4.9/download"],
        strip_prefix = "regex-automata-0.4.9",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.regex-automata-0.4.9.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__regex-syntax-0.6.29",
        sha256 = "f162c6dd7b008981e4d40210aca20b4bd0f9b60ca9271061b07f78537722f2e1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex-syntax/0.6.29/download"],
        strip_prefix = "regex-syntax-0.6.29",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.regex-syntax-0.6.29.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__regex-syntax-0.8.5",
        sha256 = "2b15c43186be67a4fd63bee50d0303afffcef381492ebe2c5d87f324e1b8815c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex-syntax/0.8.5/download"],
        strip_prefix = "regex-syntax-0.8.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.regex-syntax-0.8.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__rowan-0.15.15",
        sha256 = "32a58fa8a7ccff2aec4f39cc45bf5f985cec7125ab271cf681c279fd00192b49",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rowan/0.15.15/download"],
        strip_prefix = "rowan-0.15.15",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.rowan-0.15.15.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__rustc-hash-1.1.0",
        sha256 = "08d43f7aa6b08d49f382cde6a7982047c3426db949b1424bc4b7ec9ae12c6ce2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustc-hash/1.1.0/download"],
        strip_prefix = "rustc-hash-1.1.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.rustc-hash-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__rustc-hash-2.1.1",
        sha256 = "357703d41365b4b27c590e3ed91eabb1b663f07c4c084095e60cbed4362dff0d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustc-hash/2.1.1/download"],
        strip_prefix = "rustc-hash-2.1.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.rustc-hash-2.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__rustc-literal-escaper-0.0.2",
        sha256 = "0041b6238913c41fe704213a4a9329e2f685a156d1781998128b4149c230ad04",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustc-literal-escaper/0.0.2/download"],
        strip_prefix = "rustc-literal-escaper-0.0.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.rustc-literal-escaper-0.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__rustc-literal-escaper-0.0.3",
        sha256 = "78744cd17f5d01c75b709e49807d1363e02a940ccee2e9e72435843fdb0d076e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustc-literal-escaper/0.0.3/download"],
        strip_prefix = "rustc-literal-escaper-0.0.3",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.rustc-literal-escaper-0.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__rustc-stable-hash-0.1.1",
        sha256 = "2febf9acc5ee5e99d1ad0afcdbccc02d87aa3f857a1f01f825b80eacf8edfcd1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustc-stable-hash/0.1.1/download"],
        strip_prefix = "rustc-stable-hash-0.1.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.rustc-stable-hash-0.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__rustc_apfloat-0.2.3-llvm-462a31f5a5ab",
        sha256 = "486c2179b4796f65bfe2ee33679acf0927ac83ecf583ad6c91c3b4570911b9ad",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustc_apfloat/0.2.3+llvm-462a31f5a5ab/download"],
        strip_prefix = "rustc_apfloat-0.2.3+llvm-462a31f5a5ab",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.rustc_apfloat-0.2.3+llvm-462a31f5a5ab.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ryu-1.0.19",
        sha256 = "6ea1a2d0a644769cc99faa24c3ad26b379b786fe7c36fd3c546254801650e6dd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ryu/1.0.19/download"],
        strip_prefix = "ryu-1.0.19",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ryu-1.0.19.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__salsa-0.22.0",
        sha256 = "c8fff508e3d6ef42a32607f7538e17171a877a12015e32036f46e99d00c95781",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/salsa/0.22.0/download"],
        strip_prefix = "salsa-0.22.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.salsa-0.22.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__salsa-macro-rules-0.22.0",
        sha256 = "8ea72b3c06f2ce6350fe3a0eeb7aaaf842d1d8352b706973c19c4f02e298a87c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/salsa-macro-rules/0.22.0/download"],
        strip_prefix = "salsa-macro-rules-0.22.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.salsa-macro-rules-0.22.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__salsa-macros-0.22.0",
        sha256 = "0ce92025bc160b27814a207cb78d680973af17f863c7f4fc56cf3a535e22f378",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/salsa-macros/0.22.0/download"],
        strip_prefix = "salsa-macros-0.22.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.salsa-macros-0.22.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__same-file-1.0.6",
        sha256 = "93fc1dc3aaa9bfed95e02e6eadabb4baf7e3078b0bd1b4d7b6b0b68378900502",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/same-file/1.0.6/download"],
        strip_prefix = "same-file-1.0.6",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.same-file-1.0.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__schemars-0.9.0",
        sha256 = "4cd191f9397d57d581cddd31014772520aa448f65ef991055d7f61582c65165f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/schemars/0.9.0/download"],
        strip_prefix = "schemars-0.9.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.schemars-0.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__scoped-tls-1.0.1",
        sha256 = "e1cf6437eb19a8f4a6cc0f7dca544973b0b78843adbfeb3683d1a94a0024a294",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/scoped-tls/1.0.1/download"],
        strip_prefix = "scoped-tls-1.0.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.scoped-tls-1.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__scopeguard-1.2.0",
        sha256 = "94143f37725109f92c262ed2cf5e59bce7498c01bcc1502d7b9afe439a4e9f49",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/scopeguard/1.2.0/download"],
        strip_prefix = "scopeguard-1.2.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.scopeguard-1.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__semver-1.0.26",
        sha256 = "56e6fa9c48d24d85fb3de5ad847117517440f6beceb7798af16b4a87d616b8d0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/semver/1.0.26/download"],
        strip_prefix = "semver-1.0.26",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.semver-1.0.26.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__serde-1.0.219",
        sha256 = "5f0e2c6ed6606019b4e29e69dbaba95b11854410e5347d525002456dbbb786b6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde/1.0.219/download"],
        strip_prefix = "serde-1.0.219",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.serde-1.0.219.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__serde-untagged-0.1.7",
        sha256 = "299d9c19d7d466db4ab10addd5703e4c615dec2a5a16dbbafe191045e87ee66e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde-untagged/0.1.7/download"],
        strip_prefix = "serde-untagged-0.1.7",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.serde-untagged-0.1.7.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__serde-value-0.7.0",
        sha256 = "f3a1a3341211875ef120e117ea7fd5228530ae7e7036a779fdc9117be6b3282c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde-value/0.7.0/download"],
        strip_prefix = "serde-value-0.7.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.serde-value-0.7.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__serde_derive-1.0.219",
        sha256 = "5b0276cf7f2c73365f7157c8123c21cd9a50fbbd844757af28ca1f5925fc2a00",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_derive/1.0.219/download"],
        strip_prefix = "serde_derive-1.0.219",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.serde_derive-1.0.219.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__serde_json-1.0.140",
        sha256 = "20068b6e96dc6c9bd23e01df8827e6c7e1f2fddd43c21810382803c136b99373",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_json/1.0.140/download"],
        strip_prefix = "serde_json-1.0.140",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.serde_json-1.0.140.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__serde_spanned-0.6.9",
        sha256 = "bf41e0cfaf7226dca15e8197172c295a782857fcb97fad1808a166870dee75a3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_spanned/0.6.9/download"],
        strip_prefix = "serde_spanned-0.6.9",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.serde_spanned-0.6.9.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__serde_with-3.13.0",
        sha256 = "bf65a400f8f66fb7b0552869ad70157166676db75ed8181f8104ea91cf9d0b42",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_with/3.13.0/download"],
        strip_prefix = "serde_with-3.13.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.serde_with-3.13.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__serde_with_macros-3.13.0",
        sha256 = "81679d9ed988d5e9a5e6531dc3f2c28efbd639cbd1dfb628df08edea6004da77",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_with_macros/3.13.0/download"],
        strip_prefix = "serde_with_macros-3.13.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.serde_with_macros-3.13.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__serde_yaml-0.9.34-deprecated",
        sha256 = "6a8b1a1a2ebf674015cc02edccce75287f1a0130d394307b36743c2f5d504b47",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_yaml/0.9.34+deprecated/download"],
        strip_prefix = "serde_yaml-0.9.34+deprecated",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.serde_yaml-0.9.34+deprecated.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__sharded-slab-0.1.7",
        sha256 = "f40ca3c46823713e0d4209592e8d6e826aa57e928f09752619fc696c499637f6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/sharded-slab/0.1.7/download"],
        strip_prefix = "sharded-slab-0.1.7",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.sharded-slab-0.1.7.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__shlex-1.3.0",
        sha256 = "0fda2ff0d084019ba4d7c6f371c95d8fd75ce3524c3cb8fb653a3023f6323e64",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/shlex/1.3.0/download"],
        strip_prefix = "shlex-1.3.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.shlex-1.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__smallvec-1.15.1",
        sha256 = "67b1b7a3b5fe4f1376887184045fcf45c69e92af734b7aaddc05fb777b6fbd03",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/smallvec/1.15.1/download"],
        strip_prefix = "smallvec-1.15.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.smallvec-1.15.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__smol_str-0.3.2",
        sha256 = "9676b89cd56310a87b93dec47b11af744f34d5fc9f367b829474eec0a891350d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/smol_str/0.3.2/download"],
        strip_prefix = "smol_str-0.3.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.smol_str-0.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__stable_deref_trait-1.2.0",
        sha256 = "a8f112729512f8e442d81f95a8a7ddf2b7c6b8a1a6f509a95864142b30cab2d3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/stable_deref_trait/1.2.0/download"],
        strip_prefix = "stable_deref_trait-1.2.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.stable_deref_trait-1.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__streaming-iterator-0.1.9",
        sha256 = "2b2231b7c3057d5e4ad0156fb3dc807d900806020c5ffa3ee6ff2c8c76fb8520",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/streaming-iterator/0.1.9/download"],
        strip_prefix = "streaming-iterator-0.1.9",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.streaming-iterator-0.1.9.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__strsim-0.11.1",
        sha256 = "7da8b5736845d9f2fcb837ea5d9e2628564b3b043a70948a3f0b778838c5fb4f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/strsim/0.11.1/download"],
        strip_prefix = "strsim-0.11.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.strsim-0.11.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__syn-2.0.103",
        sha256 = "e4307e30089d6fd6aff212f2da3a1f9e32f3223b1f010fb09b7c95f90f3ca1e8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/syn/2.0.103/download"],
        strip_prefix = "syn-2.0.103",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.syn-2.0.103.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__synstructure-0.13.1",
        sha256 = "c8af7666ab7b6390ab78131fb5b0fce11d6b7a6951602017c35fa82800708971",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/synstructure/0.13.1/download"],
        strip_prefix = "synstructure-0.13.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.synstructure-0.13.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__text-size-1.1.1",
        sha256 = "f18aa187839b2bdb1ad2fa35ead8c4c2976b64e4363c386d45ac0f7ee85c9233",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/text-size/1.1.1/download"],
        strip_prefix = "text-size-1.1.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.text-size-1.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__thin-vec-0.2.14",
        sha256 = "144f754d318415ac792f9d69fc87abbbfc043ce2ef041c60f16ad828f638717d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/thin-vec/0.2.14/download"],
        strip_prefix = "thin-vec-0.2.14",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.thin-vec-0.2.14.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__thiserror-1.0.69",
        sha256 = "b6aaf5339b578ea85b50e080feb250a3e8ae8cfcdff9a461c9ec2904bc923f52",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/thiserror/1.0.69/download"],
        strip_prefix = "thiserror-1.0.69",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.thiserror-1.0.69.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__thiserror-2.0.12",
        sha256 = "567b8a2dae586314f7be2a752ec7474332959c6460e02bde30d702a66d488708",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/thiserror/2.0.12/download"],
        strip_prefix = "thiserror-2.0.12",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.thiserror-2.0.12.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__thiserror-impl-1.0.69",
        sha256 = "4fee6c4efc90059e10f81e6d42c60a18f76588c3d74cb83a0b242a2b6c7504c1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/thiserror-impl/1.0.69/download"],
        strip_prefix = "thiserror-impl-1.0.69",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.thiserror-impl-1.0.69.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__thiserror-impl-2.0.12",
        sha256 = "7f7cf42b4507d8ea322120659672cf1b9dbb93f8f2d4ecfd6e51350ff5b17a1d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/thiserror-impl/2.0.12/download"],
        strip_prefix = "thiserror-impl-2.0.12",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.thiserror-impl-2.0.12.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__thread_local-1.1.8",
        sha256 = "8b9ef9bad013ada3808854ceac7b46812a6465ba368859a37e2100283d2d719c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/thread_local/1.1.8/download"],
        strip_prefix = "thread_local-1.1.8",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.thread_local-1.1.8.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__time-0.3.37",
        sha256 = "35e7868883861bd0e56d9ac6efcaaca0d6d5d82a2a7ec8209ff492c07cf37b21",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/time/0.3.37/download"],
        strip_prefix = "time-0.3.37",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.time-0.3.37.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__time-core-0.1.2",
        sha256 = "ef927ca75afb808a4d64dd374f00a2adf8d0fcff8e7b184af886c3c87ec4a3f3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/time-core/0.1.2/download"],
        strip_prefix = "time-core-0.1.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.time-core-0.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__time-macros-0.2.19",
        sha256 = "2834e6017e3e5e4b9834939793b282bc03b37a3336245fa820e35e233e2a85de",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/time-macros/0.2.19/download"],
        strip_prefix = "time-macros-0.2.19",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.time-macros-0.2.19.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__tinystr-0.8.1",
        sha256 = "5d4f6d1145dcb577acf783d4e601bc1d76a13337bb54e6233add580b07344c8b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tinystr/0.8.1/download"],
        strip_prefix = "tinystr-0.8.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.tinystr-0.8.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__toml-0.8.23",
        sha256 = "dc1beb996b9d83529a9e75c17a1686767d148d70663143c7854d8b4a09ced362",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/toml/0.8.23/download"],
        strip_prefix = "toml-0.8.23",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.toml-0.8.23.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__toml_datetime-0.6.11",
        sha256 = "22cddaf88f4fbc13c51aebbf5f8eceb5c7c5a9da2ac40a13519eb5b0a0e8f11c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/toml_datetime/0.6.11/download"],
        strip_prefix = "toml_datetime-0.6.11",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.toml_datetime-0.6.11.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__toml_edit-0.22.27",
        sha256 = "41fe8c660ae4257887cf66394862d21dbca4a6ddd26f04a3560410406a2f819a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/toml_edit/0.22.27/download"],
        strip_prefix = "toml_edit-0.22.27",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.toml_edit-0.22.27.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__toml_write-0.1.2",
        sha256 = "5d99f8c9a7727884afe522e9bd5edbfc91a3312b36a77b5fb8926e4c31a41801",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/toml_write/0.1.2/download"],
        strip_prefix = "toml_write-0.1.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.toml_write-0.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__tracing-0.1.41",
        sha256 = "784e0ac535deb450455cbfa28a6f0df145ea1bb7ae51b821cf5e7927fdcfbdd0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tracing/0.1.41/download"],
        strip_prefix = "tracing-0.1.41",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.tracing-0.1.41.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__tracing-attributes-0.1.28",
        sha256 = "395ae124c09f9e6918a2310af6038fba074bcf474ac352496d5910dd59a2226d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tracing-attributes/0.1.28/download"],
        strip_prefix = "tracing-attributes-0.1.28",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.tracing-attributes-0.1.28.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__tracing-core-0.1.33",
        sha256 = "e672c95779cf947c5311f83787af4fa8fffd12fb27e4993211a84bdfd9610f9c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tracing-core/0.1.33/download"],
        strip_prefix = "tracing-core-0.1.33",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.tracing-core-0.1.33.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__tracing-flame-0.2.0",
        sha256 = "0bae117ee14789185e129aaee5d93750abe67fdc5a9a62650452bfe4e122a3a9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tracing-flame/0.2.0/download"],
        strip_prefix = "tracing-flame-0.2.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.tracing-flame-0.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__tracing-log-0.2.0",
        sha256 = "ee855f1f400bd0e5c02d150ae5de3840039a3f54b025156404e34c23c03f47c3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tracing-log/0.2.0/download"],
        strip_prefix = "tracing-log-0.2.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.tracing-log-0.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__tracing-subscriber-0.3.19",
        sha256 = "e8189decb5ac0fa7bc8b96b7cb9b2701d60d48805aca84a238004d665fcc4008",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tracing-subscriber/0.3.19/download"],
        strip_prefix = "tracing-subscriber-0.3.19",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.tracing-subscriber-0.3.19.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__tree-sitter-0.24.6",
        sha256 = "5f2434c86ba59ed15af56039cc5bf1acf8ba76ce301e32ef08827388ef285ec5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tree-sitter/0.24.6/download"],
        strip_prefix = "tree-sitter-0.24.6",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.tree-sitter-0.24.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__tree-sitter-embedded-template-0.23.2",
        sha256 = "790063ef14e5b67556abc0b3be0ed863fb41d65ee791cf8c0b20eb42a1fa46af",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tree-sitter-embedded-template/0.23.2/download"],
        strip_prefix = "tree-sitter-embedded-template-0.23.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.tree-sitter-embedded-template-0.23.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__tree-sitter-json-0.24.8",
        sha256 = "4d727acca406c0020cffc6cf35516764f36c8e3dc4408e5ebe2cb35a947ec471",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tree-sitter-json/0.24.8/download"],
        strip_prefix = "tree-sitter-json-0.24.8",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.tree-sitter-json-0.24.8.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__tree-sitter-language-0.1.3",
        sha256 = "c199356c799a8945965bb5f2c55b2ad9d9aa7c4b4f6e587fe9dea0bc715e5f9c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tree-sitter-language/0.1.3/download"],
        strip_prefix = "tree-sitter-language-0.1.3",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.tree-sitter-language-0.1.3.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__tree-sitter-ql-0.23.1",
        sha256 = "80b7bcaf39acefbb199417a6ec2fd0c038083ba115da3e4f4426c820dc76d386",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tree-sitter-ql/0.23.1/download"],
        strip_prefix = "tree-sitter-ql-0.23.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.tree-sitter-ql-0.23.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__tree-sitter-ruby-0.23.1",
        sha256 = "be0484ea4ef6bb9c575b4fdabde7e31340a8d2dbc7d52b321ac83da703249f95",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tree-sitter-ruby/0.23.1/download"],
        strip_prefix = "tree-sitter-ruby-0.23.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.tree-sitter-ruby-0.23.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__triomphe-0.1.14",
        sha256 = "ef8f7726da4807b58ea5c96fdc122f80702030edc33b35aff9190a51148ccc85",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/triomphe/0.1.14/download"],
        strip_prefix = "triomphe-0.1.14",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.triomphe-0.1.14.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__typed-arena-2.0.2",
        sha256 = "6af6ae20167a9ece4bcb41af5b80f8a1f1df981f6391189ce00fd257af04126a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/typed-arena/2.0.2/download"],
        strip_prefix = "typed-arena-2.0.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.typed-arena-2.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__typeid-1.0.3",
        sha256 = "bc7d623258602320d5c55d1bc22793b57daff0ec7efc270ea7d55ce1d5f5471c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/typeid/1.0.3/download"],
        strip_prefix = "typeid-1.0.3",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.typeid-1.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__uncased-0.9.10",
        sha256 = "e1b88fcfe09e89d3866a5c11019378088af2d24c3fbd4f0543f96b479ec90697",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/uncased/0.9.10/download"],
        strip_prefix = "uncased-0.9.10",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.uncased-0.9.10.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__ungrammar-1.16.1",
        sha256 = "a3e5df347f0bf3ec1d670aad6ca5c6a1859cd9ea61d2113125794654ccced68f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ungrammar/1.16.1/download"],
        strip_prefix = "ungrammar-1.16.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.ungrammar-1.16.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__unicode-ident-1.0.17",
        sha256 = "00e2473a93778eb0bad35909dff6a10d28e63f792f16ed15e404fca9d5eeedbe",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicode-ident/1.0.17/download"],
        strip_prefix = "unicode-ident-1.0.17",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.unicode-ident-1.0.17.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__unicode-properties-0.1.3",
        sha256 = "e70f2a8b45122e719eb623c01822704c4e0907e7e426a05927e1a1cfff5b75d0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicode-properties/0.1.3/download"],
        strip_prefix = "unicode-properties-0.1.3",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.unicode-properties-0.1.3.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__unicode-xid-0.2.6",
        sha256 = "ebc1c04c71510c7f702b52b7c350734c9ff1295c464a03335b00bb84fc54f853",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicode-xid/0.2.6/download"],
        strip_prefix = "unicode-xid-0.2.6",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.unicode-xid-0.2.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__unsafe-libyaml-0.2.11",
        sha256 = "673aac59facbab8a9007c7f6108d11f63b603f7cabff99fabf650fea5c32b861",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unsafe-libyaml/0.2.11/download"],
        strip_prefix = "unsafe-libyaml-0.2.11",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.unsafe-libyaml-0.2.11.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__url-2.5.4",
        sha256 = "32f8b686cadd1473f4bd0117a5d28d36b1ade384ea9b5069a1c40aefed7fda60",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/url/2.5.4/download"],
        strip_prefix = "url-2.5.4",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.url-2.5.4.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__utf8_iter-1.0.4",
        sha256 = "b6c140620e7ffbb22c2dee59cafe6084a59b5ffc27a8859a5f0d494b5d52b6be",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/utf8_iter/1.0.4/download"],
        strip_prefix = "utf8_iter-1.0.4",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.utf8_iter-1.0.4.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__utf8parse-0.2.2",
        sha256 = "06abde3611657adf66d383f00b093d7faecc7fa57071cce2578660c9f1010821",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/utf8parse/0.2.2/download"],
        strip_prefix = "utf8parse-0.2.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.utf8parse-0.2.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__valuable-0.1.0",
        sha256 = "830b7e5d4d90034032940e4ace0d9a9a057e7a45cd94e6c007832e39edb82f6d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/valuable/0.1.0/download"],
        strip_prefix = "valuable-0.1.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.valuable-0.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__version_check-0.9.5",
        sha256 = "0b928f33d975fc6ad9f86c8f283853ad26bdd5b10b7f1542aa2fa15e2289105a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/version_check/0.9.5/download"],
        strip_prefix = "version_check-0.9.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.version_check-0.9.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__walkdir-2.5.0",
        sha256 = "29790946404f91d9c5d06f9874efddea1dc06c5efe94541a7d6863108e3a5e4b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/walkdir/2.5.0/download"],
        strip_prefix = "walkdir-2.5.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.walkdir-2.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__wasi-0.11.0-wasi-snapshot-preview1",
        sha256 = "9c8d87e72b64a3b4db28d11ce29237c246188f4f51057d65a7eab63b7987e423",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasi/0.11.0+wasi-snapshot-preview1/download"],
        strip_prefix = "wasi-0.11.0+wasi-snapshot-preview1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.wasi-0.11.0+wasi-snapshot-preview1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__wasi-0.13.3-wasi-0.2.2",
        sha256 = "26816d2e1a4a36a2940b96c5296ce403917633dff8f3440e9b236ed6f6bacad2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasi/0.13.3+wasi-0.2.2/download"],
        strip_prefix = "wasi-0.13.3+wasi-0.2.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.wasi-0.13.3+wasi-0.2.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__wasm-bindgen-0.2.99",
        sha256 = "a474f6281d1d70c17ae7aa6a613c87fce69a127e2624002df63dcb39d6cf6396",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasm-bindgen/0.2.99/download"],
        strip_prefix = "wasm-bindgen-0.2.99",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.wasm-bindgen-0.2.99.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__wasm-bindgen-backend-0.2.99",
        sha256 = "5f89bb38646b4f81674e8f5c3fb81b562be1fd936d84320f3264486418519c79",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasm-bindgen-backend/0.2.99/download"],
        strip_prefix = "wasm-bindgen-backend-0.2.99",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.wasm-bindgen-backend-0.2.99.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__wasm-bindgen-macro-0.2.99",
        sha256 = "2cc6181fd9a7492eef6fef1f33961e3695e4579b9872a6f7c83aee556666d4fe",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasm-bindgen-macro/0.2.99/download"],
        strip_prefix = "wasm-bindgen-macro-0.2.99",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.wasm-bindgen-macro-0.2.99.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__wasm-bindgen-macro-support-0.2.99",
        sha256 = "30d7a95b763d3c45903ed6c81f156801839e5ee968bb07e534c44df0fcd330c2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasm-bindgen-macro-support/0.2.99/download"],
        strip_prefix = "wasm-bindgen-macro-support-0.2.99",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.wasm-bindgen-macro-support-0.2.99.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__wasm-bindgen-shared-0.2.99",
        sha256 = "943aab3fdaaa029a6e0271b35ea10b72b943135afe9bffca82384098ad0e06a6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasm-bindgen-shared/0.2.99/download"],
        strip_prefix = "wasm-bindgen-shared-0.2.99",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.wasm-bindgen-shared-0.2.99.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__winapi-0.3.9",
        sha256 = "5c839a674fcd7a98952e593242ea400abe93992746761e38641405d28b00f419",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi/0.3.9/download"],
        strip_prefix = "winapi-0.3.9",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.winapi-0.3.9.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__winapi-i686-pc-windows-gnu-0.4.0",
        sha256 = "ac3b87c63620426dd9b991e5ce0329eff545bccbbb34f3be09ff6fb6ab51b7b6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi-i686-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-i686-pc-windows-gnu-0.4.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.winapi-i686-pc-windows-gnu-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__winapi-util-0.1.9",
        sha256 = "cf221c93e13a30d793f7645a0e7762c55d169dbb0a49671918a2319d289b10bb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi-util/0.1.9/download"],
        strip_prefix = "winapi-util-0.1.9",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.winapi-util-0.1.9.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__winapi-x86_64-pc-windows-gnu-0.4.0",
        sha256 = "712e227841d057c1ee1cd2fb22fa7e5a5461ae8e48fa2ca79ec42cfc1931183f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi-x86_64-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-x86_64-pc-windows-gnu-0.4.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.winapi-x86_64-pc-windows-gnu-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows-core-0.52.0",
        sha256 = "33ab640c8d7e35bf8ba19b884ba838ceb4fba93a4e8c65a9059d08afcfc683d9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-core/0.52.0/download"],
        strip_prefix = "windows-core-0.52.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows-core-0.52.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows-link-0.1.1",
        sha256 = "76840935b766e1b0a05c0066835fb9ec80071d4c09a16f6bd5f7e655e3c14c38",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-link/0.1.1/download"],
        strip_prefix = "windows-link-0.1.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows-link-0.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows-sys-0.48.0",
        sha256 = "677d2418bec65e3338edb076e806bc1ec15693c5d0104683f2efe857f61056a9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-sys/0.48.0/download"],
        strip_prefix = "windows-sys-0.48.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows-sys-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows-sys-0.52.0",
        sha256 = "282be5f36a8ce781fad8c8ae18fa3f9beff57ec1b52cb3de0789201425d9a33d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-sys/0.52.0/download"],
        strip_prefix = "windows-sys-0.52.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows-sys-0.52.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows-sys-0.59.0",
        sha256 = "1e38bc4d79ed67fd075bcc251a1c39b32a1776bbe92e5bef1f0bf1f8c531853b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-sys/0.59.0/download"],
        strip_prefix = "windows-sys-0.59.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows-sys-0.59.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows-sys-0.60.2",
        sha256 = "f2f500e4d28234f72040990ec9d39e3a6b950f9f22d3dba18416c35882612bcb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-sys/0.60.2/download"],
        strip_prefix = "windows-sys-0.60.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows-sys-0.60.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows-targets-0.48.5",
        sha256 = "9a2fa6e2155d7247be68c096456083145c183cbbbc2764150dda45a87197940c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-targets/0.48.5/download"],
        strip_prefix = "windows-targets-0.48.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows-targets-0.48.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows-targets-0.52.6",
        sha256 = "9b724f72796e036ab90c1021d4780d4d3d648aca59e491e6b98e725b84e99973",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-targets/0.52.6/download"],
        strip_prefix = "windows-targets-0.52.6",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows-targets-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows-targets-0.53.2",
        sha256 = "c66f69fcc9ce11da9966ddb31a40968cad001c5bedeb5c2b82ede4253ab48aef",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-targets/0.53.2/download"],
        strip_prefix = "windows-targets-0.53.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows-targets-0.53.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_aarch64_gnullvm-0.48.5",
        sha256 = "2b38e32f0abccf9987a4e3079dfb67dcd799fb61361e53e2882c3cbaf0d905d8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_gnullvm/0.48.5/download"],
        strip_prefix = "windows_aarch64_gnullvm-0.48.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_aarch64_gnullvm-0.48.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_aarch64_gnullvm-0.52.6",
        sha256 = "32a4622180e7a0ec044bb555404c800bc9fd9ec262ec147edd5989ccd0c02cd3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_gnullvm/0.52.6/download"],
        strip_prefix = "windows_aarch64_gnullvm-0.52.6",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_aarch64_gnullvm-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_aarch64_gnullvm-0.53.0",
        sha256 = "86b8d5f90ddd19cb4a147a5fa63ca848db3df085e25fee3cc10b39b6eebae764",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_gnullvm/0.53.0/download"],
        strip_prefix = "windows_aarch64_gnullvm-0.53.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_aarch64_gnullvm-0.53.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_aarch64_msvc-0.48.5",
        sha256 = "dc35310971f3b2dbbf3f0690a219f40e2d9afcf64f9ab7cc1be722937c26b4bc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_msvc/0.48.5/download"],
        strip_prefix = "windows_aarch64_msvc-0.48.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_aarch64_msvc-0.48.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_aarch64_msvc-0.52.6",
        sha256 = "09ec2a7bb152e2252b53fa7803150007879548bc709c039df7627cabbd05d469",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_msvc/0.52.6/download"],
        strip_prefix = "windows_aarch64_msvc-0.52.6",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_aarch64_msvc-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_aarch64_msvc-0.53.0",
        sha256 = "c7651a1f62a11b8cbd5e0d42526e55f2c99886c77e007179efff86c2b137e66c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_msvc/0.53.0/download"],
        strip_prefix = "windows_aarch64_msvc-0.53.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_aarch64_msvc-0.53.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_i686_gnu-0.48.5",
        sha256 = "a75915e7def60c94dcef72200b9a8e58e5091744960da64ec734a6c6e9b3743e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnu/0.48.5/download"],
        strip_prefix = "windows_i686_gnu-0.48.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_i686_gnu-0.48.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_i686_gnu-0.52.6",
        sha256 = "8e9b5ad5ab802e97eb8e295ac6720e509ee4c243f69d781394014ebfe8bbfa0b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnu/0.52.6/download"],
        strip_prefix = "windows_i686_gnu-0.52.6",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_i686_gnu-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_i686_gnu-0.53.0",
        sha256 = "c1dc67659d35f387f5f6c479dc4e28f1d4bb90ddd1a5d3da2e5d97b42d6272c3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnu/0.53.0/download"],
        strip_prefix = "windows_i686_gnu-0.53.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_i686_gnu-0.53.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_i686_gnullvm-0.52.6",
        sha256 = "0eee52d38c090b3caa76c563b86c3a4bd71ef1a819287c19d586d7334ae8ed66",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnullvm/0.52.6/download"],
        strip_prefix = "windows_i686_gnullvm-0.52.6",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_i686_gnullvm-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_i686_gnullvm-0.53.0",
        sha256 = "9ce6ccbdedbf6d6354471319e781c0dfef054c81fbc7cf83f338a4296c0cae11",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnullvm/0.53.0/download"],
        strip_prefix = "windows_i686_gnullvm-0.53.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_i686_gnullvm-0.53.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_i686_msvc-0.48.5",
        sha256 = "8f55c233f70c4b27f66c523580f78f1004e8b5a8b659e05a4eb49d4166cca406",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_msvc/0.48.5/download"],
        strip_prefix = "windows_i686_msvc-0.48.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_i686_msvc-0.48.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_i686_msvc-0.52.6",
        sha256 = "240948bc05c5e7c6dabba28bf89d89ffce3e303022809e73deaefe4f6ec56c66",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_msvc/0.52.6/download"],
        strip_prefix = "windows_i686_msvc-0.52.6",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_i686_msvc-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_i686_msvc-0.53.0",
        sha256 = "581fee95406bb13382d2f65cd4a908ca7b1e4c2f1917f143ba16efe98a589b5d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_msvc/0.53.0/download"],
        strip_prefix = "windows_i686_msvc-0.53.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_i686_msvc-0.53.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_x86_64_gnu-0.48.5",
        sha256 = "53d40abd2583d23e4718fddf1ebec84dbff8381c07cae67ff7768bbf19c6718e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnu/0.48.5/download"],
        strip_prefix = "windows_x86_64_gnu-0.48.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_x86_64_gnu-0.48.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_x86_64_gnu-0.52.6",
        sha256 = "147a5c80aabfbf0c7d901cb5895d1de30ef2907eb21fbbab29ca94c5b08b1a78",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnu/0.52.6/download"],
        strip_prefix = "windows_x86_64_gnu-0.52.6",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_x86_64_gnu-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_x86_64_gnu-0.53.0",
        sha256 = "2e55b5ac9ea33f2fc1716d1742db15574fd6fc8dadc51caab1c16a3d3b4190ba",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnu/0.53.0/download"],
        strip_prefix = "windows_x86_64_gnu-0.53.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_x86_64_gnu-0.53.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_x86_64_gnullvm-0.48.5",
        sha256 = "0b7b52767868a23d5bab768e390dc5f5c55825b6d30b86c844ff2dc7414044cc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnullvm/0.48.5/download"],
        strip_prefix = "windows_x86_64_gnullvm-0.48.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_x86_64_gnullvm-0.48.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_x86_64_gnullvm-0.52.6",
        sha256 = "24d5b23dc417412679681396f2b49f3de8c1473deb516bd34410872eff51ed0d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnullvm/0.52.6/download"],
        strip_prefix = "windows_x86_64_gnullvm-0.52.6",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_x86_64_gnullvm-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_x86_64_gnullvm-0.53.0",
        sha256 = "0a6e035dd0599267ce1ee132e51c27dd29437f63325753051e71dd9e42406c57",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnullvm/0.53.0/download"],
        strip_prefix = "windows_x86_64_gnullvm-0.53.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_x86_64_gnullvm-0.53.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_x86_64_msvc-0.48.5",
        sha256 = "ed94fce61571a4006852b7389a063ab983c02eb1bb37b47f8272ce92d06d9538",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_msvc/0.48.5/download"],
        strip_prefix = "windows_x86_64_msvc-0.48.5",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_x86_64_msvc-0.48.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_x86_64_msvc-0.52.6",
        sha256 = "589f6da84c646204747d1270a2a5661ea66ed1cced2631d546fdfb155959f9ec",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_msvc/0.52.6/download"],
        strip_prefix = "windows_x86_64_msvc-0.52.6",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_x86_64_msvc-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__windows_x86_64_msvc-0.53.0",
        sha256 = "271414315aff87387382ec3d271b52d7ae78726f5d44ac98b4f4030c91880486",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_msvc/0.53.0/download"],
        strip_prefix = "windows_x86_64_msvc-0.53.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.windows_x86_64_msvc-0.53.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__winnow-0.7.11",
        sha256 = "74c7b26e3480b707944fc872477815d29a8e429d2f93a1ce000f5fa84a15cbcd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winnow/0.7.11/download"],
        strip_prefix = "winnow-0.7.11",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.winnow-0.7.11.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__wit-bindgen-rt-0.33.0",
        sha256 = "3268f3d866458b787f390cf61f4bbb563b922d091359f9608842999eaee3943c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wit-bindgen-rt/0.33.0/download"],
        strip_prefix = "wit-bindgen-rt-0.33.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.wit-bindgen-rt-0.33.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__writeable-0.6.1",
        sha256 = "ea2f10b9bb0928dfb1b42b65e1f9e36f7f54dbdf08457afefb38afcdec4fa2bb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/writeable/0.6.1/download"],
        strip_prefix = "writeable-0.6.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.writeable-0.6.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__yansi-1.0.1",
        sha256 = "cfe53a6657fd280eaa890a3bc59152892ffa3e30101319d168b781ed6529b049",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/yansi/1.0.1/download"],
        strip_prefix = "yansi-1.0.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.yansi-1.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__yoke-0.8.0",
        sha256 = "5f41bb01b8226ef4bfd589436a297c53d118f65921786300e427be8d487695cc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/yoke/0.8.0/download"],
        strip_prefix = "yoke-0.8.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.yoke-0.8.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__yoke-derive-0.8.0",
        sha256 = "38da3c9736e16c5d3c8c597a9aaa5d1fa565d0532ae05e27c24aa62fb32c0ab6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/yoke-derive/0.8.0/download"],
        strip_prefix = "yoke-derive-0.8.0",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.yoke-derive-0.8.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__zerocopy-0.7.35",
        sha256 = "1b9b4fd18abc82b8136838da5d50bae7bdea537c574d8dc1a34ed098d6c166f0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerocopy/0.7.35/download"],
        strip_prefix = "zerocopy-0.7.35",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.zerocopy-0.7.35.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__zerocopy-0.8.20",
        sha256 = "dde3bb8c68a8f3f1ed4ac9221aad6b10cece3e60a8e2ea54a6a2dec806d0084c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerocopy/0.8.20/download"],
        strip_prefix = "zerocopy-0.8.20",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.zerocopy-0.8.20.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__zerocopy-derive-0.7.35",
        sha256 = "fa4f8080344d4671fb4e831a13ad1e68092748387dfc4f55e356242fae12ce3e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerocopy-derive/0.7.35/download"],
        strip_prefix = "zerocopy-derive-0.7.35",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.zerocopy-derive-0.7.35.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__zerocopy-derive-0.8.20",
        sha256 = "eea57037071898bf96a6da35fd626f4f27e9cee3ead2a6c703cf09d472b2e700",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerocopy-derive/0.8.20/download"],
        strip_prefix = "zerocopy-derive-0.8.20",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.zerocopy-derive-0.8.20.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__zerofrom-0.1.6",
        sha256 = "50cc42e0333e05660c3587f3bf9d0478688e15d870fab3346451ce7f8c9fbea5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerofrom/0.1.6/download"],
        strip_prefix = "zerofrom-0.1.6",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.zerofrom-0.1.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__zerofrom-derive-0.1.6",
        sha256 = "d71e5d6e06ab090c67b5e44993ec16b72dcbaabc526db883a360057678b48502",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerofrom-derive/0.1.6/download"],
        strip_prefix = "zerofrom-derive-0.1.6",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.zerofrom-derive-0.1.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__zerotrie-0.2.2",
        sha256 = "36f0bbd478583f79edad978b407914f61b2972f5af6fa089686016be8f9af595",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerotrie/0.2.2/download"],
        strip_prefix = "zerotrie-0.2.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.zerotrie-0.2.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__zerovec-0.11.2",
        sha256 = "4a05eb080e015ba39cc9e23bbe5e7fb04d5fb040350f99f34e338d5fdd294428",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerovec/0.11.2/download"],
        strip_prefix = "zerovec-0.11.2",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.zerovec-0.11.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__zerovec-derive-0.11.1",
        sha256 = "5b96237efa0c878c64bd89c436f661be4e46b2f3eff1ebb976f7ef2321d2f58f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerovec-derive/0.11.1/download"],
        strip_prefix = "zerovec-derive-0.11.1",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.zerovec-derive-0.11.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__zstd-0.13.3",
        sha256 = "e91ee311a569c327171651566e07972200e76fcfe2242a4fa446149a3881c08a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zstd/0.13.3/download"],
        strip_prefix = "zstd-0.13.3",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.zstd-0.13.3.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__zstd-safe-7.2.4",
        sha256 = "8f49c4d5f0abb602a93fb8736af2a4f4dd9512e36f7f570d66e65ff867ed3b9d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zstd-safe/7.2.4/download"],
        strip_prefix = "zstd-safe-7.2.4",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.zstd-safe-7.2.4.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_ts__zstd-sys-2.0.15-zstd.1.5.7",
        sha256 = "eb81183ddd97d0c74cedf1d50d85c8d08c1b8b68ee863bdee9e706eedba1a237",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zstd-sys/2.0.15+zstd.1.5.7/download"],
        strip_prefix = "zstd-sys-2.0.15+zstd.1.5.7",
        build_file = Label("//misc/bazel/3rdparty/tree_sitter_extractors_deps:BUILD.zstd-sys-2.0.15+zstd.1.5.7.bazel"),
    )

    return [
        struct(repo = "vendor_ts__anyhow-1.0.98", is_dev_dep = False),
        struct(repo = "vendor_ts__argfile-0.2.1", is_dev_dep = False),
        struct(repo = "vendor_ts__chalk-ir-0.103.0", is_dev_dep = False),
        struct(repo = "vendor_ts__chrono-0.4.41", is_dev_dep = False),
        struct(repo = "vendor_ts__clap-4.5.40", is_dev_dep = False),
        struct(repo = "vendor_ts__dunce-1.0.5", is_dev_dep = False),
        struct(repo = "vendor_ts__either-1.15.0", is_dev_dep = False),
        struct(repo = "vendor_ts__encoding-0.2.33", is_dev_dep = False),
        struct(repo = "vendor_ts__figment-0.10.19", is_dev_dep = False),
        struct(repo = "vendor_ts__flate2-1.1.0", is_dev_dep = False),
        struct(repo = "vendor_ts__glob-0.3.2", is_dev_dep = False),
        struct(repo = "vendor_ts__globset-0.4.15", is_dev_dep = False),
        struct(repo = "vendor_ts__itertools-0.14.0", is_dev_dep = False),
        struct(repo = "vendor_ts__lazy_static-1.5.0", is_dev_dep = False),
        struct(repo = "vendor_ts__mustache-0.9.0", is_dev_dep = False),
        struct(repo = "vendor_ts__num-traits-0.2.19", is_dev_dep = False),
        struct(repo = "vendor_ts__num_cpus-1.17.0", is_dev_dep = False),
        struct(repo = "vendor_ts__proc-macro2-1.0.95", is_dev_dep = False),
        struct(repo = "vendor_ts__quote-1.0.40", is_dev_dep = False),
        struct(repo = "vendor_ts__ra_ap_base_db-0.0.288", is_dev_dep = False),
        struct(repo = "vendor_ts__ra_ap_cfg-0.0.288", is_dev_dep = False),
        struct(repo = "vendor_ts__ra_ap_hir-0.0.288", is_dev_dep = False),
        struct(repo = "vendor_ts__ra_ap_hir_def-0.0.288", is_dev_dep = False),
        struct(repo = "vendor_ts__ra_ap_hir_expand-0.0.288", is_dev_dep = False),
        struct(repo = "vendor_ts__ra_ap_hir_ty-0.0.288", is_dev_dep = False),
        struct(repo = "vendor_ts__ra_ap_ide_db-0.0.288", is_dev_dep = False),
        struct(repo = "vendor_ts__ra_ap_intern-0.0.288", is_dev_dep = False),
        struct(repo = "vendor_ts__ra_ap_load-cargo-0.0.288", is_dev_dep = False),
        struct(repo = "vendor_ts__ra_ap_parser-0.0.288", is_dev_dep = False),
        struct(repo = "vendor_ts__ra_ap_paths-0.0.288", is_dev_dep = False),
        struct(repo = "vendor_ts__ra_ap_project_model-0.0.288", is_dev_dep = False),
        struct(repo = "vendor_ts__ra_ap_span-0.0.288", is_dev_dep = False),
        struct(repo = "vendor_ts__ra_ap_stdx-0.0.288", is_dev_dep = False),
        struct(repo = "vendor_ts__ra_ap_syntax-0.0.288", is_dev_dep = False),
        struct(repo = "vendor_ts__ra_ap_vfs-0.0.288", is_dev_dep = False),
        struct(repo = "vendor_ts__rayon-1.10.0", is_dev_dep = False),
        struct(repo = "vendor_ts__regex-1.11.1", is_dev_dep = False),
        struct(repo = "vendor_ts__serde-1.0.219", is_dev_dep = False),
        struct(repo = "vendor_ts__serde_json-1.0.140", is_dev_dep = False),
        struct(repo = "vendor_ts__serde_with-3.13.0", is_dev_dep = False),
        struct(repo = "vendor_ts__syn-2.0.103", is_dev_dep = False),
        struct(repo = "vendor_ts__toml-0.8.23", is_dev_dep = False),
        struct(repo = "vendor_ts__tracing-0.1.41", is_dev_dep = False),
        struct(repo = "vendor_ts__tracing-flame-0.2.0", is_dev_dep = False),
        struct(repo = "vendor_ts__tracing-subscriber-0.3.19", is_dev_dep = False),
        struct(repo = "vendor_ts__tree-sitter-0.24.6", is_dev_dep = False),
        struct(repo = "vendor_ts__tree-sitter-embedded-template-0.23.2", is_dev_dep = False),
        struct(repo = "vendor_ts__tree-sitter-ruby-0.23.1", is_dev_dep = False),
        struct(repo = "vendor_ts__triomphe-0.1.14", is_dev_dep = False),
        struct(repo = "vendor_ts__ungrammar-1.16.1", is_dev_dep = False),
        struct(repo = "vendor_ts__zstd-0.13.3", is_dev_dep = False),
        struct(repo = "vendor_ts__rand-0.9.1", is_dev_dep = True),
        struct(repo = "vendor_ts__tree-sitter-json-0.24.8", is_dev_dep = True),
        struct(repo = "vendor_ts__tree-sitter-ql-0.23.1", is_dev_dep = True),
    ]
