// generated by codegen, do not edit

#![cfg_attr(any(), rustfmt::skip)]

use crate::trap;

#[derive(Debug)]
pub struct File {
    _unused: ()
}

impl trap::TrapClass for File {
    fn class_name() -> &'static str { "File" }
}

#[derive(Debug)]
pub struct Element {
    _unused: ()
}

impl trap::TrapClass for Element {
    fn class_name() -> &'static str { "Element" }
}

#[derive(Debug)]
pub struct ExtractorStep {
    pub id: trap::TrapId<ExtractorStep>,
    pub action: String,
    pub file: Option<trap::Label<File>>,
    pub duration_ms: usize,
}

impl trap::TrapEntry for ExtractorStep {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("extractor_steps", vec![id.into(), self.action.into(), self.duration_ms.into()]);
        if let Some(v) = self.file {
            out.add_tuple("extractor_step_files", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for ExtractorStep {
    fn class_name() -> &'static str { "ExtractorStep" }
}

impl From<trap::Label<ExtractorStep>> for trap::Label<Element> {
    fn from(value: trap::Label<ExtractorStep>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExtractorStep is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Locatable {
    _unused: ()
}

impl trap::TrapClass for Locatable {
    fn class_name() -> &'static str { "Locatable" }
}

impl From<trap::Label<Locatable>> for trap::Label<Element> {
    fn from(value: trap::Label<Locatable>) -> Self {
        // SAFETY: this is safe because in the dbscheme Locatable is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct NamedCrate {
    pub id: trap::TrapId<NamedCrate>,
    pub name: String,
    pub crate_: trap::Label<Crate>,
}

impl trap::TrapEntry for NamedCrate {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("named_crates", vec![id.into(), self.name.into(), self.crate_.into()]);
    }
}

impl trap::TrapClass for NamedCrate {
    fn class_name() -> &'static str { "NamedCrate" }
}

impl From<trap::Label<NamedCrate>> for trap::Label<Element> {
    fn from(value: trap::Label<NamedCrate>) -> Self {
        // SAFETY: this is safe because in the dbscheme NamedCrate is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Unextracted {
    _unused: ()
}

impl trap::TrapClass for Unextracted {
    fn class_name() -> &'static str { "Unextracted" }
}

impl From<trap::Label<Unextracted>> for trap::Label<Element> {
    fn from(value: trap::Label<Unextracted>) -> Self {
        // SAFETY: this is safe because in the dbscheme Unextracted is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct AstNode {
    _unused: ()
}

impl trap::TrapClass for AstNode {
    fn class_name() -> &'static str { "AstNode" }
}

impl From<trap::Label<AstNode>> for trap::Label<Locatable> {
    fn from(value: trap::Label<AstNode>) -> Self {
        // SAFETY: this is safe because in the dbscheme AstNode is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AstNode>> for trap::Label<Element> {
    fn from(value: trap::Label<AstNode>) -> Self {
        // SAFETY: this is safe because in the dbscheme AstNode is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Crate {
    pub id: trap::TrapId<Crate>,
    pub name: Option<String>,
    pub version: Option<String>,
    pub cfg_options: Vec<String>,
    pub named_dependencies: Vec<trap::Label<NamedCrate>>,
}

impl trap::TrapEntry for Crate {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("crates", vec![id.into()]);
        if let Some(v) = self.name {
            out.add_tuple("crate_names", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.version {
            out.add_tuple("crate_versions", vec![id.into(), v.into()]);
        }
        for (i, v) in self.cfg_options.into_iter().enumerate() {
            out.add_tuple("crate_cfg_options", vec![id.into(), i.into(), v.into()]);
        }
        for (i, v) in self.named_dependencies.into_iter().enumerate() {
            out.add_tuple("crate_named_dependencies", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for Crate {
    fn class_name() -> &'static str { "Crate" }
}

impl From<trap::Label<Crate>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Crate>) -> Self {
        // SAFETY: this is safe because in the dbscheme Crate is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Crate>> for trap::Label<Element> {
    fn from(value: trap::Label<Crate>) -> Self {
        // SAFETY: this is safe because in the dbscheme Crate is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Missing {
    pub id: trap::TrapId<Missing>,
}

impl trap::TrapEntry for Missing {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("missings", vec![id.into()]);
    }
}

impl trap::TrapClass for Missing {
    fn class_name() -> &'static str { "Missing" }
}

impl From<trap::Label<Missing>> for trap::Label<Unextracted> {
    fn from(value: trap::Label<Missing>) -> Self {
        // SAFETY: this is safe because in the dbscheme Missing is a subclass of Unextracted
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Missing>> for trap::Label<Element> {
    fn from(value: trap::Label<Missing>) -> Self {
        // SAFETY: this is safe because in the dbscheme Missing is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Unimplemented {
    pub id: trap::TrapId<Unimplemented>,
}

impl trap::TrapEntry for Unimplemented {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("unimplementeds", vec![id.into()]);
    }
}

impl trap::TrapClass for Unimplemented {
    fn class_name() -> &'static str { "Unimplemented" }
}

impl From<trap::Label<Unimplemented>> for trap::Label<Unextracted> {
    fn from(value: trap::Label<Unimplemented>) -> Self {
        // SAFETY: this is safe because in the dbscheme Unimplemented is a subclass of Unextracted
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Unimplemented>> for trap::Label<Element> {
    fn from(value: trap::Label<Unimplemented>) -> Self {
        // SAFETY: this is safe because in the dbscheme Unimplemented is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Abi {
    pub id: trap::TrapId<Abi>,
    pub abi_string: Option<String>,
}

impl trap::TrapEntry for Abi {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("abis", vec![id.into()]);
        if let Some(v) = self.abi_string {
            out.add_tuple("abi_abi_strings", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for Abi {
    fn class_name() -> &'static str { "Abi" }
}

impl From<trap::Label<Abi>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Abi>) -> Self {
        // SAFETY: this is safe because in the dbscheme Abi is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Abi>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Abi>) -> Self {
        // SAFETY: this is safe because in the dbscheme Abi is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Abi>> for trap::Label<Element> {
    fn from(value: trap::Label<Abi>) -> Self {
        // SAFETY: this is safe because in the dbscheme Abi is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Addressable {
    _unused: ()
}

impl Addressable {
    pub fn emit_extended_canonical_path(id: trap::Label<Self>, value: String, out: &mut trap::Writer) {
        out.add_tuple("addressable_extended_canonical_paths", vec![id.into(), value.into()]);
    }

    pub fn emit_crate_origin(id: trap::Label<Self>, value: String, out: &mut trap::Writer) {
        out.add_tuple("addressable_crate_origins", vec![id.into(), value.into()]);
    }

}

impl trap::TrapClass for Addressable {
    fn class_name() -> &'static str { "Addressable" }
}

impl From<trap::Label<Addressable>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Addressable>) -> Self {
        // SAFETY: this is safe because in the dbscheme Addressable is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Addressable>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Addressable>) -> Self {
        // SAFETY: this is safe because in the dbscheme Addressable is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Addressable>> for trap::Label<Element> {
    fn from(value: trap::Label<Addressable>) -> Self {
        // SAFETY: this is safe because in the dbscheme Addressable is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ArgList {
    pub id: trap::TrapId<ArgList>,
    pub args: Vec<trap::Label<Expr>>,
}

impl trap::TrapEntry for ArgList {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("arg_lists", vec![id.into()]);
        for (i, v) in self.args.into_iter().enumerate() {
            out.add_tuple("arg_list_args", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for ArgList {
    fn class_name() -> &'static str { "ArgList" }
}

impl From<trap::Label<ArgList>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ArgList>) -> Self {
        // SAFETY: this is safe because in the dbscheme ArgList is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ArgList>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ArgList>) -> Self {
        // SAFETY: this is safe because in the dbscheme ArgList is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ArgList>> for trap::Label<Element> {
    fn from(value: trap::Label<ArgList>) -> Self {
        // SAFETY: this is safe because in the dbscheme ArgList is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct AsmDirSpec {
    pub id: trap::TrapId<AsmDirSpec>,
}

impl trap::TrapEntry for AsmDirSpec {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("asm_dir_specs", vec![id.into()]);
    }
}

impl trap::TrapClass for AsmDirSpec {
    fn class_name() -> &'static str { "AsmDirSpec" }
}

impl From<trap::Label<AsmDirSpec>> for trap::Label<AstNode> {
    fn from(value: trap::Label<AsmDirSpec>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmDirSpec is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmDirSpec>> for trap::Label<Locatable> {
    fn from(value: trap::Label<AsmDirSpec>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmDirSpec is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmDirSpec>> for trap::Label<Element> {
    fn from(value: trap::Label<AsmDirSpec>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmDirSpec is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct AsmOperand {
    _unused: ()
}

impl trap::TrapClass for AsmOperand {
    fn class_name() -> &'static str { "AsmOperand" }
}

impl From<trap::Label<AsmOperand>> for trap::Label<AstNode> {
    fn from(value: trap::Label<AsmOperand>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmOperand is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmOperand>> for trap::Label<Locatable> {
    fn from(value: trap::Label<AsmOperand>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmOperand is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmOperand>> for trap::Label<Element> {
    fn from(value: trap::Label<AsmOperand>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmOperand is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct AsmOperandExpr {
    pub id: trap::TrapId<AsmOperandExpr>,
    pub in_expr: Option<trap::Label<Expr>>,
    pub out_expr: Option<trap::Label<Expr>>,
}

impl trap::TrapEntry for AsmOperandExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("asm_operand_exprs", vec![id.into()]);
        if let Some(v) = self.in_expr {
            out.add_tuple("asm_operand_expr_in_exprs", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.out_expr {
            out.add_tuple("asm_operand_expr_out_exprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for AsmOperandExpr {
    fn class_name() -> &'static str { "AsmOperandExpr" }
}

impl From<trap::Label<AsmOperandExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<AsmOperandExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmOperandExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmOperandExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<AsmOperandExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmOperandExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmOperandExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<AsmOperandExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmOperandExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct AsmOption {
    pub id: trap::TrapId<AsmOption>,
    pub is_raw: bool,
}

impl trap::TrapEntry for AsmOption {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("asm_options", vec![id.into()]);
        if self.is_raw {
            out.add_tuple("asm_option_is_raw", vec![id.into()]);
        }
    }
}

impl trap::TrapClass for AsmOption {
    fn class_name() -> &'static str { "AsmOption" }
}

impl From<trap::Label<AsmOption>> for trap::Label<AstNode> {
    fn from(value: trap::Label<AsmOption>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmOption is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmOption>> for trap::Label<Locatable> {
    fn from(value: trap::Label<AsmOption>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmOption is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmOption>> for trap::Label<Element> {
    fn from(value: trap::Label<AsmOption>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmOption is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct AsmPiece {
    _unused: ()
}

impl trap::TrapClass for AsmPiece {
    fn class_name() -> &'static str { "AsmPiece" }
}

impl From<trap::Label<AsmPiece>> for trap::Label<AstNode> {
    fn from(value: trap::Label<AsmPiece>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmPiece is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmPiece>> for trap::Label<Locatable> {
    fn from(value: trap::Label<AsmPiece>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmPiece is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmPiece>> for trap::Label<Element> {
    fn from(value: trap::Label<AsmPiece>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmPiece is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct AsmRegSpec {
    pub id: trap::TrapId<AsmRegSpec>,
    pub identifier: Option<trap::Label<NameRef>>,
}

impl trap::TrapEntry for AsmRegSpec {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("asm_reg_specs", vec![id.into()]);
        if let Some(v) = self.identifier {
            out.add_tuple("asm_reg_spec_identifiers", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for AsmRegSpec {
    fn class_name() -> &'static str { "AsmRegSpec" }
}

impl From<trap::Label<AsmRegSpec>> for trap::Label<AstNode> {
    fn from(value: trap::Label<AsmRegSpec>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmRegSpec is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmRegSpec>> for trap::Label<Locatable> {
    fn from(value: trap::Label<AsmRegSpec>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmRegSpec is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmRegSpec>> for trap::Label<Element> {
    fn from(value: trap::Label<AsmRegSpec>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmRegSpec is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct AssocItemList {
    pub id: trap::TrapId<AssocItemList>,
    pub assoc_items: Vec<trap::Label<AssocItem>>,
    pub attrs: Vec<trap::Label<Attr>>,
}

impl trap::TrapEntry for AssocItemList {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("assoc_item_lists", vec![id.into()]);
        for (i, v) in self.assoc_items.into_iter().enumerate() {
            out.add_tuple("assoc_item_list_assoc_items", vec![id.into(), i.into(), v.into()]);
        }
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("assoc_item_list_attrs", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for AssocItemList {
    fn class_name() -> &'static str { "AssocItemList" }
}

impl From<trap::Label<AssocItemList>> for trap::Label<AstNode> {
    fn from(value: trap::Label<AssocItemList>) -> Self {
        // SAFETY: this is safe because in the dbscheme AssocItemList is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AssocItemList>> for trap::Label<Locatable> {
    fn from(value: trap::Label<AssocItemList>) -> Self {
        // SAFETY: this is safe because in the dbscheme AssocItemList is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AssocItemList>> for trap::Label<Element> {
    fn from(value: trap::Label<AssocItemList>) -> Self {
        // SAFETY: this is safe because in the dbscheme AssocItemList is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Attr {
    pub id: trap::TrapId<Attr>,
    pub meta: Option<trap::Label<Meta>>,
}

impl trap::TrapEntry for Attr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("attrs", vec![id.into()]);
        if let Some(v) = self.meta {
            out.add_tuple("attr_meta", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for Attr {
    fn class_name() -> &'static str { "Attr" }
}

impl From<trap::Label<Attr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Attr>) -> Self {
        // SAFETY: this is safe because in the dbscheme Attr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Attr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Attr>) -> Self {
        // SAFETY: this is safe because in the dbscheme Attr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Attr>> for trap::Label<Element> {
    fn from(value: trap::Label<Attr>) -> Self {
        // SAFETY: this is safe because in the dbscheme Attr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Callable {
    _unused: ()
}

impl trap::TrapClass for Callable {
    fn class_name() -> &'static str { "Callable" }
}

impl From<trap::Label<Callable>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Callable>) -> Self {
        // SAFETY: this is safe because in the dbscheme Callable is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Callable>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Callable>) -> Self {
        // SAFETY: this is safe because in the dbscheme Callable is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Callable>> for trap::Label<Element> {
    fn from(value: trap::Label<Callable>) -> Self {
        // SAFETY: this is safe because in the dbscheme Callable is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ClosureBinder {
    pub id: trap::TrapId<ClosureBinder>,
    pub generic_param_list: Option<trap::Label<GenericParamList>>,
}

impl trap::TrapEntry for ClosureBinder {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("closure_binders", vec![id.into()]);
        if let Some(v) = self.generic_param_list {
            out.add_tuple("closure_binder_generic_param_lists", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for ClosureBinder {
    fn class_name() -> &'static str { "ClosureBinder" }
}

impl From<trap::Label<ClosureBinder>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ClosureBinder>) -> Self {
        // SAFETY: this is safe because in the dbscheme ClosureBinder is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ClosureBinder>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ClosureBinder>) -> Self {
        // SAFETY: this is safe because in the dbscheme ClosureBinder is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ClosureBinder>> for trap::Label<Element> {
    fn from(value: trap::Label<ClosureBinder>) -> Self {
        // SAFETY: this is safe because in the dbscheme ClosureBinder is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Expr {
    _unused: ()
}

impl trap::TrapClass for Expr {
    fn class_name() -> &'static str { "Expr" }
}

impl From<trap::Label<Expr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Expr>) -> Self {
        // SAFETY: this is safe because in the dbscheme Expr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Expr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Expr>) -> Self {
        // SAFETY: this is safe because in the dbscheme Expr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Expr>> for trap::Label<Element> {
    fn from(value: trap::Label<Expr>) -> Self {
        // SAFETY: this is safe because in the dbscheme Expr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ExternItemList {
    pub id: trap::TrapId<ExternItemList>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub extern_items: Vec<trap::Label<ExternItem>>,
}

impl trap::TrapEntry for ExternItemList {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("extern_item_lists", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("extern_item_list_attrs", vec![id.into(), i.into(), v.into()]);
        }
        for (i, v) in self.extern_items.into_iter().enumerate() {
            out.add_tuple("extern_item_list_extern_items", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for ExternItemList {
    fn class_name() -> &'static str { "ExternItemList" }
}

impl From<trap::Label<ExternItemList>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ExternItemList>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExternItemList is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ExternItemList>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ExternItemList>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExternItemList is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ExternItemList>> for trap::Label<Element> {
    fn from(value: trap::Label<ExternItemList>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExternItemList is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct FieldList {
    _unused: ()
}

impl trap::TrapClass for FieldList {
    fn class_name() -> &'static str { "FieldList" }
}

impl From<trap::Label<FieldList>> for trap::Label<AstNode> {
    fn from(value: trap::Label<FieldList>) -> Self {
        // SAFETY: this is safe because in the dbscheme FieldList is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<FieldList>> for trap::Label<Locatable> {
    fn from(value: trap::Label<FieldList>) -> Self {
        // SAFETY: this is safe because in the dbscheme FieldList is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<FieldList>> for trap::Label<Element> {
    fn from(value: trap::Label<FieldList>) -> Self {
        // SAFETY: this is safe because in the dbscheme FieldList is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct FormatArgsArg {
    pub id: trap::TrapId<FormatArgsArg>,
    pub expr: Option<trap::Label<Expr>>,
    pub name: Option<trap::Label<Name>>,
}

impl trap::TrapEntry for FormatArgsArg {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("format_args_args", vec![id.into()]);
        if let Some(v) = self.expr {
            out.add_tuple("format_args_arg_exprs", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.name {
            out.add_tuple("format_args_arg_names", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for FormatArgsArg {
    fn class_name() -> &'static str { "FormatArgsArg" }
}

impl From<trap::Label<FormatArgsArg>> for trap::Label<AstNode> {
    fn from(value: trap::Label<FormatArgsArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme FormatArgsArg is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<FormatArgsArg>> for trap::Label<Locatable> {
    fn from(value: trap::Label<FormatArgsArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme FormatArgsArg is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<FormatArgsArg>> for trap::Label<Element> {
    fn from(value: trap::Label<FormatArgsArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme FormatArgsArg is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct GenericArg {
    _unused: ()
}

impl trap::TrapClass for GenericArg {
    fn class_name() -> &'static str { "GenericArg" }
}

impl From<trap::Label<GenericArg>> for trap::Label<AstNode> {
    fn from(value: trap::Label<GenericArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme GenericArg is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<GenericArg>> for trap::Label<Locatable> {
    fn from(value: trap::Label<GenericArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme GenericArg is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<GenericArg>> for trap::Label<Element> {
    fn from(value: trap::Label<GenericArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme GenericArg is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct GenericArgList {
    pub id: trap::TrapId<GenericArgList>,
    pub generic_args: Vec<trap::Label<GenericArg>>,
}

impl trap::TrapEntry for GenericArgList {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("generic_arg_lists", vec![id.into()]);
        for (i, v) in self.generic_args.into_iter().enumerate() {
            out.add_tuple("generic_arg_list_generic_args", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for GenericArgList {
    fn class_name() -> &'static str { "GenericArgList" }
}

impl From<trap::Label<GenericArgList>> for trap::Label<AstNode> {
    fn from(value: trap::Label<GenericArgList>) -> Self {
        // SAFETY: this is safe because in the dbscheme GenericArgList is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<GenericArgList>> for trap::Label<Locatable> {
    fn from(value: trap::Label<GenericArgList>) -> Self {
        // SAFETY: this is safe because in the dbscheme GenericArgList is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<GenericArgList>> for trap::Label<Element> {
    fn from(value: trap::Label<GenericArgList>) -> Self {
        // SAFETY: this is safe because in the dbscheme GenericArgList is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct GenericParam {
    _unused: ()
}

impl trap::TrapClass for GenericParam {
    fn class_name() -> &'static str { "GenericParam" }
}

impl From<trap::Label<GenericParam>> for trap::Label<AstNode> {
    fn from(value: trap::Label<GenericParam>) -> Self {
        // SAFETY: this is safe because in the dbscheme GenericParam is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<GenericParam>> for trap::Label<Locatable> {
    fn from(value: trap::Label<GenericParam>) -> Self {
        // SAFETY: this is safe because in the dbscheme GenericParam is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<GenericParam>> for trap::Label<Element> {
    fn from(value: trap::Label<GenericParam>) -> Self {
        // SAFETY: this is safe because in the dbscheme GenericParam is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct GenericParamList {
    pub id: trap::TrapId<GenericParamList>,
    pub generic_params: Vec<trap::Label<GenericParam>>,
}

impl trap::TrapEntry for GenericParamList {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("generic_param_lists", vec![id.into()]);
        for (i, v) in self.generic_params.into_iter().enumerate() {
            out.add_tuple("generic_param_list_generic_params", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for GenericParamList {
    fn class_name() -> &'static str { "GenericParamList" }
}

impl From<trap::Label<GenericParamList>> for trap::Label<AstNode> {
    fn from(value: trap::Label<GenericParamList>) -> Self {
        // SAFETY: this is safe because in the dbscheme GenericParamList is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<GenericParamList>> for trap::Label<Locatable> {
    fn from(value: trap::Label<GenericParamList>) -> Self {
        // SAFETY: this is safe because in the dbscheme GenericParamList is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<GenericParamList>> for trap::Label<Element> {
    fn from(value: trap::Label<GenericParamList>) -> Self {
        // SAFETY: this is safe because in the dbscheme GenericParamList is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ItemList {
    pub id: trap::TrapId<ItemList>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub items: Vec<trap::Label<Item>>,
}

impl trap::TrapEntry for ItemList {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("item_lists", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("item_list_attrs", vec![id.into(), i.into(), v.into()]);
        }
        for (i, v) in self.items.into_iter().enumerate() {
            out.add_tuple("item_list_items", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for ItemList {
    fn class_name() -> &'static str { "ItemList" }
}

impl From<trap::Label<ItemList>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ItemList>) -> Self {
        // SAFETY: this is safe because in the dbscheme ItemList is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ItemList>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ItemList>) -> Self {
        // SAFETY: this is safe because in the dbscheme ItemList is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ItemList>> for trap::Label<Element> {
    fn from(value: trap::Label<ItemList>) -> Self {
        // SAFETY: this is safe because in the dbscheme ItemList is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Label {
    pub id: trap::TrapId<Label>,
    pub lifetime: Option<trap::Label<Lifetime>>,
}

impl trap::TrapEntry for Label {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("labels", vec![id.into()]);
        if let Some(v) = self.lifetime {
            out.add_tuple("label_lifetimes", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for Label {
    fn class_name() -> &'static str { "Label" }
}

impl From<trap::Label<Label>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Label>) -> Self {
        // SAFETY: this is safe because in the dbscheme Label is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Label>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Label>) -> Self {
        // SAFETY: this is safe because in the dbscheme Label is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Label>> for trap::Label<Element> {
    fn from(value: trap::Label<Label>) -> Self {
        // SAFETY: this is safe because in the dbscheme Label is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct LetElse {
    pub id: trap::TrapId<LetElse>,
    pub block_expr: Option<trap::Label<BlockExpr>>,
}

impl trap::TrapEntry for LetElse {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("let_elses", vec![id.into()]);
        if let Some(v) = self.block_expr {
            out.add_tuple("let_else_block_exprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for LetElse {
    fn class_name() -> &'static str { "LetElse" }
}

impl From<trap::Label<LetElse>> for trap::Label<AstNode> {
    fn from(value: trap::Label<LetElse>) -> Self {
        // SAFETY: this is safe because in the dbscheme LetElse is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LetElse>> for trap::Label<Locatable> {
    fn from(value: trap::Label<LetElse>) -> Self {
        // SAFETY: this is safe because in the dbscheme LetElse is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LetElse>> for trap::Label<Element> {
    fn from(value: trap::Label<LetElse>) -> Self {
        // SAFETY: this is safe because in the dbscheme LetElse is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct MacroItems {
    pub id: trap::TrapId<MacroItems>,
    pub items: Vec<trap::Label<Item>>,
}

impl trap::TrapEntry for MacroItems {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("macro_items", vec![id.into()]);
        for (i, v) in self.items.into_iter().enumerate() {
            out.add_tuple("macro_items_items", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for MacroItems {
    fn class_name() -> &'static str { "MacroItems" }
}

impl From<trap::Label<MacroItems>> for trap::Label<AstNode> {
    fn from(value: trap::Label<MacroItems>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroItems is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroItems>> for trap::Label<Locatable> {
    fn from(value: trap::Label<MacroItems>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroItems is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroItems>> for trap::Label<Element> {
    fn from(value: trap::Label<MacroItems>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroItems is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct MatchArm {
    pub id: trap::TrapId<MatchArm>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub expr: Option<trap::Label<Expr>>,
    pub guard: Option<trap::Label<MatchGuard>>,
    pub pat: Option<trap::Label<Pat>>,
}

impl trap::TrapEntry for MatchArm {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("match_arms", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("match_arm_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.expr {
            out.add_tuple("match_arm_exprs", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.guard {
            out.add_tuple("match_arm_guards", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.pat {
            out.add_tuple("match_arm_pats", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for MatchArm {
    fn class_name() -> &'static str { "MatchArm" }
}

impl From<trap::Label<MatchArm>> for trap::Label<AstNode> {
    fn from(value: trap::Label<MatchArm>) -> Self {
        // SAFETY: this is safe because in the dbscheme MatchArm is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MatchArm>> for trap::Label<Locatable> {
    fn from(value: trap::Label<MatchArm>) -> Self {
        // SAFETY: this is safe because in the dbscheme MatchArm is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MatchArm>> for trap::Label<Element> {
    fn from(value: trap::Label<MatchArm>) -> Self {
        // SAFETY: this is safe because in the dbscheme MatchArm is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct MatchArmList {
    pub id: trap::TrapId<MatchArmList>,
    pub arms: Vec<trap::Label<MatchArm>>,
    pub attrs: Vec<trap::Label<Attr>>,
}

impl trap::TrapEntry for MatchArmList {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("match_arm_lists", vec![id.into()]);
        for (i, v) in self.arms.into_iter().enumerate() {
            out.add_tuple("match_arm_list_arms", vec![id.into(), i.into(), v.into()]);
        }
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("match_arm_list_attrs", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for MatchArmList {
    fn class_name() -> &'static str { "MatchArmList" }
}

impl From<trap::Label<MatchArmList>> for trap::Label<AstNode> {
    fn from(value: trap::Label<MatchArmList>) -> Self {
        // SAFETY: this is safe because in the dbscheme MatchArmList is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MatchArmList>> for trap::Label<Locatable> {
    fn from(value: trap::Label<MatchArmList>) -> Self {
        // SAFETY: this is safe because in the dbscheme MatchArmList is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MatchArmList>> for trap::Label<Element> {
    fn from(value: trap::Label<MatchArmList>) -> Self {
        // SAFETY: this is safe because in the dbscheme MatchArmList is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct MatchGuard {
    pub id: trap::TrapId<MatchGuard>,
    pub condition: Option<trap::Label<Expr>>,
}

impl trap::TrapEntry for MatchGuard {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("match_guards", vec![id.into()]);
        if let Some(v) = self.condition {
            out.add_tuple("match_guard_conditions", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for MatchGuard {
    fn class_name() -> &'static str { "MatchGuard" }
}

impl From<trap::Label<MatchGuard>> for trap::Label<AstNode> {
    fn from(value: trap::Label<MatchGuard>) -> Self {
        // SAFETY: this is safe because in the dbscheme MatchGuard is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MatchGuard>> for trap::Label<Locatable> {
    fn from(value: trap::Label<MatchGuard>) -> Self {
        // SAFETY: this is safe because in the dbscheme MatchGuard is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MatchGuard>> for trap::Label<Element> {
    fn from(value: trap::Label<MatchGuard>) -> Self {
        // SAFETY: this is safe because in the dbscheme MatchGuard is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Meta {
    pub id: trap::TrapId<Meta>,
    pub expr: Option<trap::Label<Expr>>,
    pub is_unsafe: bool,
    pub path: Option<trap::Label<Path>>,
    pub token_tree: Option<trap::Label<TokenTree>>,
}

impl trap::TrapEntry for Meta {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("meta", vec![id.into()]);
        if let Some(v) = self.expr {
            out.add_tuple("meta_exprs", vec![id.into(), v.into()]);
        }
        if self.is_unsafe {
            out.add_tuple("meta_is_unsafe", vec![id.into()]);
        }
        if let Some(v) = self.path {
            out.add_tuple("meta_paths", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.token_tree {
            out.add_tuple("meta_token_trees", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for Meta {
    fn class_name() -> &'static str { "Meta" }
}

impl From<trap::Label<Meta>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Meta>) -> Self {
        // SAFETY: this is safe because in the dbscheme Meta is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Meta>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Meta>) -> Self {
        // SAFETY: this is safe because in the dbscheme Meta is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Meta>> for trap::Label<Element> {
    fn from(value: trap::Label<Meta>) -> Self {
        // SAFETY: this is safe because in the dbscheme Meta is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Name {
    pub id: trap::TrapId<Name>,
    pub text: Option<String>,
}

impl trap::TrapEntry for Name {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("names", vec![id.into()]);
        if let Some(v) = self.text {
            out.add_tuple("name_texts", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for Name {
    fn class_name() -> &'static str { "Name" }
}

impl From<trap::Label<Name>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Name>) -> Self {
        // SAFETY: this is safe because in the dbscheme Name is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Name>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Name>) -> Self {
        // SAFETY: this is safe because in the dbscheme Name is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Name>> for trap::Label<Element> {
    fn from(value: trap::Label<Name>) -> Self {
        // SAFETY: this is safe because in the dbscheme Name is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ParamBase {
    _unused: ()
}

impl trap::TrapClass for ParamBase {
    fn class_name() -> &'static str { "ParamBase" }
}

impl From<trap::Label<ParamBase>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ParamBase>) -> Self {
        // SAFETY: this is safe because in the dbscheme ParamBase is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ParamBase>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ParamBase>) -> Self {
        // SAFETY: this is safe because in the dbscheme ParamBase is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ParamBase>> for trap::Label<Element> {
    fn from(value: trap::Label<ParamBase>) -> Self {
        // SAFETY: this is safe because in the dbscheme ParamBase is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ParamList {
    pub id: trap::TrapId<ParamList>,
    pub params: Vec<trap::Label<Param>>,
    pub self_param: Option<trap::Label<SelfParam>>,
}

impl trap::TrapEntry for ParamList {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("param_lists", vec![id.into()]);
        for (i, v) in self.params.into_iter().enumerate() {
            out.add_tuple("param_list_params", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.self_param {
            out.add_tuple("param_list_self_params", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for ParamList {
    fn class_name() -> &'static str { "ParamList" }
}

impl From<trap::Label<ParamList>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ParamList>) -> Self {
        // SAFETY: this is safe because in the dbscheme ParamList is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ParamList>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ParamList>) -> Self {
        // SAFETY: this is safe because in the dbscheme ParamList is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ParamList>> for trap::Label<Element> {
    fn from(value: trap::Label<ParamList>) -> Self {
        // SAFETY: this is safe because in the dbscheme ParamList is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ParenthesizedArgList {
    pub id: trap::TrapId<ParenthesizedArgList>,
    pub type_args: Vec<trap::Label<TypeArg>>,
}

impl trap::TrapEntry for ParenthesizedArgList {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("parenthesized_arg_lists", vec![id.into()]);
        for (i, v) in self.type_args.into_iter().enumerate() {
            out.add_tuple("parenthesized_arg_list_type_args", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for ParenthesizedArgList {
    fn class_name() -> &'static str { "ParenthesizedArgList" }
}

impl From<trap::Label<ParenthesizedArgList>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ParenthesizedArgList>) -> Self {
        // SAFETY: this is safe because in the dbscheme ParenthesizedArgList is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ParenthesizedArgList>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ParenthesizedArgList>) -> Self {
        // SAFETY: this is safe because in the dbscheme ParenthesizedArgList is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ParenthesizedArgList>> for trap::Label<Element> {
    fn from(value: trap::Label<ParenthesizedArgList>) -> Self {
        // SAFETY: this is safe because in the dbscheme ParenthesizedArgList is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Pat {
    _unused: ()
}

impl trap::TrapClass for Pat {
    fn class_name() -> &'static str { "Pat" }
}

impl From<trap::Label<Pat>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Pat>) -> Self {
        // SAFETY: this is safe because in the dbscheme Pat is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Pat>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Pat>) -> Self {
        // SAFETY: this is safe because in the dbscheme Pat is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Pat>> for trap::Label<Element> {
    fn from(value: trap::Label<Pat>) -> Self {
        // SAFETY: this is safe because in the dbscheme Pat is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Path {
    pub id: trap::TrapId<Path>,
    pub qualifier: Option<trap::Label<Path>>,
    pub segment: Option<trap::Label<PathSegment>>,
}

impl trap::TrapEntry for Path {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("paths", vec![id.into()]);
        if let Some(v) = self.qualifier {
            out.add_tuple("path_qualifiers", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.segment {
            out.add_tuple("path_segments_", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for Path {
    fn class_name() -> &'static str { "Path" }
}

impl From<trap::Label<Path>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Path>) -> Self {
        // SAFETY: this is safe because in the dbscheme Path is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Path>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Path>) -> Self {
        // SAFETY: this is safe because in the dbscheme Path is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Path>> for trap::Label<Element> {
    fn from(value: trap::Label<Path>) -> Self {
        // SAFETY: this is safe because in the dbscheme Path is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct PathSegment {
    pub id: trap::TrapId<PathSegment>,
    pub generic_arg_list: Option<trap::Label<GenericArgList>>,
    pub identifier: Option<trap::Label<NameRef>>,
    pub parenthesized_arg_list: Option<trap::Label<ParenthesizedArgList>>,
    pub ret_type: Option<trap::Label<RetTypeRepr>>,
    pub return_type_syntax: Option<trap::Label<ReturnTypeSyntax>>,
}

impl trap::TrapEntry for PathSegment {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("path_segments", vec![id.into()]);
        if let Some(v) = self.generic_arg_list {
            out.add_tuple("path_segment_generic_arg_lists", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.identifier {
            out.add_tuple("path_segment_identifiers", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.parenthesized_arg_list {
            out.add_tuple("path_segment_parenthesized_arg_lists", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.ret_type {
            out.add_tuple("path_segment_ret_types", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.return_type_syntax {
            out.add_tuple("path_segment_return_type_syntaxes", vec![id.into(), v.into()]);
        }
    }
}

impl PathSegment {
    pub fn emit_type_repr(id: trap::Label<Self>, value: trap::Label<TypeRepr>, out: &mut trap::Writer) {
        out.add_tuple("path_segment_type_reprs", vec![id.into(), value.into()]);
    }

    pub fn emit_trait_type_repr(id: trap::Label<Self>, value: trap::Label<PathTypeRepr>, out: &mut trap::Writer) {
        out.add_tuple("path_segment_trait_type_reprs", vec![id.into(), value.into()]);
    }

}

impl trap::TrapClass for PathSegment {
    fn class_name() -> &'static str { "PathSegment" }
}

impl From<trap::Label<PathSegment>> for trap::Label<AstNode> {
    fn from(value: trap::Label<PathSegment>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathSegment is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathSegment>> for trap::Label<Locatable> {
    fn from(value: trap::Label<PathSegment>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathSegment is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathSegment>> for trap::Label<Element> {
    fn from(value: trap::Label<PathSegment>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathSegment is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Rename {
    pub id: trap::TrapId<Rename>,
    pub name: Option<trap::Label<Name>>,
}

impl trap::TrapEntry for Rename {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("renames", vec![id.into()]);
        if let Some(v) = self.name {
            out.add_tuple("rename_names", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for Rename {
    fn class_name() -> &'static str { "Rename" }
}

impl From<trap::Label<Rename>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Rename>) -> Self {
        // SAFETY: this is safe because in the dbscheme Rename is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Rename>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Rename>) -> Self {
        // SAFETY: this is safe because in the dbscheme Rename is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Rename>> for trap::Label<Element> {
    fn from(value: trap::Label<Rename>) -> Self {
        // SAFETY: this is safe because in the dbscheme Rename is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Resolvable {
    _unused: ()
}

impl Resolvable {
    pub fn emit_resolved_path(id: trap::Label<Self>, value: String, out: &mut trap::Writer) {
        out.add_tuple("resolvable_resolved_paths", vec![id.into(), value.into()]);
    }

    pub fn emit_resolved_crate_origin(id: trap::Label<Self>, value: String, out: &mut trap::Writer) {
        out.add_tuple("resolvable_resolved_crate_origins", vec![id.into(), value.into()]);
    }

}

impl trap::TrapClass for Resolvable {
    fn class_name() -> &'static str { "Resolvable" }
}

impl From<trap::Label<Resolvable>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Resolvable>) -> Self {
        // SAFETY: this is safe because in the dbscheme Resolvable is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Resolvable>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Resolvable>) -> Self {
        // SAFETY: this is safe because in the dbscheme Resolvable is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Resolvable>> for trap::Label<Element> {
    fn from(value: trap::Label<Resolvable>) -> Self {
        // SAFETY: this is safe because in the dbscheme Resolvable is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct RetTypeRepr {
    pub id: trap::TrapId<RetTypeRepr>,
    pub type_repr: Option<trap::Label<TypeRepr>>,
}

impl trap::TrapEntry for RetTypeRepr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("ret_type_reprs", vec![id.into()]);
        if let Some(v) = self.type_repr {
            out.add_tuple("ret_type_repr_type_reprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for RetTypeRepr {
    fn class_name() -> &'static str { "RetTypeRepr" }
}

impl From<trap::Label<RetTypeRepr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<RetTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme RetTypeRepr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<RetTypeRepr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<RetTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme RetTypeRepr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<RetTypeRepr>> for trap::Label<Element> {
    fn from(value: trap::Label<RetTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme RetTypeRepr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ReturnTypeSyntax {
    pub id: trap::TrapId<ReturnTypeSyntax>,
}

impl trap::TrapEntry for ReturnTypeSyntax {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("return_type_syntaxes", vec![id.into()]);
    }
}

impl trap::TrapClass for ReturnTypeSyntax {
    fn class_name() -> &'static str { "ReturnTypeSyntax" }
}

impl From<trap::Label<ReturnTypeSyntax>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ReturnTypeSyntax>) -> Self {
        // SAFETY: this is safe because in the dbscheme ReturnTypeSyntax is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ReturnTypeSyntax>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ReturnTypeSyntax>) -> Self {
        // SAFETY: this is safe because in the dbscheme ReturnTypeSyntax is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ReturnTypeSyntax>> for trap::Label<Element> {
    fn from(value: trap::Label<ReturnTypeSyntax>) -> Self {
        // SAFETY: this is safe because in the dbscheme ReturnTypeSyntax is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct SourceFile {
    pub id: trap::TrapId<SourceFile>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub items: Vec<trap::Label<Item>>,
}

impl trap::TrapEntry for SourceFile {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("source_files", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("source_file_attrs", vec![id.into(), i.into(), v.into()]);
        }
        for (i, v) in self.items.into_iter().enumerate() {
            out.add_tuple("source_file_items", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for SourceFile {
    fn class_name() -> &'static str { "SourceFile" }
}

impl From<trap::Label<SourceFile>> for trap::Label<AstNode> {
    fn from(value: trap::Label<SourceFile>) -> Self {
        // SAFETY: this is safe because in the dbscheme SourceFile is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<SourceFile>> for trap::Label<Locatable> {
    fn from(value: trap::Label<SourceFile>) -> Self {
        // SAFETY: this is safe because in the dbscheme SourceFile is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<SourceFile>> for trap::Label<Element> {
    fn from(value: trap::Label<SourceFile>) -> Self {
        // SAFETY: this is safe because in the dbscheme SourceFile is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Stmt {
    _unused: ()
}

impl trap::TrapClass for Stmt {
    fn class_name() -> &'static str { "Stmt" }
}

impl From<trap::Label<Stmt>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Stmt>) -> Self {
        // SAFETY: this is safe because in the dbscheme Stmt is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Stmt>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Stmt>) -> Self {
        // SAFETY: this is safe because in the dbscheme Stmt is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Stmt>> for trap::Label<Element> {
    fn from(value: trap::Label<Stmt>) -> Self {
        // SAFETY: this is safe because in the dbscheme Stmt is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct StmtList {
    pub id: trap::TrapId<StmtList>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub statements: Vec<trap::Label<Stmt>>,
    pub tail_expr: Option<trap::Label<Expr>>,
}

impl trap::TrapEntry for StmtList {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("stmt_lists", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("stmt_list_attrs", vec![id.into(), i.into(), v.into()]);
        }
        for (i, v) in self.statements.into_iter().enumerate() {
            out.add_tuple("stmt_list_statements", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.tail_expr {
            out.add_tuple("stmt_list_tail_exprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for StmtList {
    fn class_name() -> &'static str { "StmtList" }
}

impl From<trap::Label<StmtList>> for trap::Label<AstNode> {
    fn from(value: trap::Label<StmtList>) -> Self {
        // SAFETY: this is safe because in the dbscheme StmtList is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StmtList>> for trap::Label<Locatable> {
    fn from(value: trap::Label<StmtList>) -> Self {
        // SAFETY: this is safe because in the dbscheme StmtList is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StmtList>> for trap::Label<Element> {
    fn from(value: trap::Label<StmtList>) -> Self {
        // SAFETY: this is safe because in the dbscheme StmtList is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct StructExprField {
    pub id: trap::TrapId<StructExprField>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub expr: Option<trap::Label<Expr>>,
    pub identifier: Option<trap::Label<NameRef>>,
}

impl trap::TrapEntry for StructExprField {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("struct_expr_fields", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("struct_expr_field_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.expr {
            out.add_tuple("struct_expr_field_exprs", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.identifier {
            out.add_tuple("struct_expr_field_identifiers", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for StructExprField {
    fn class_name() -> &'static str { "StructExprField" }
}

impl From<trap::Label<StructExprField>> for trap::Label<AstNode> {
    fn from(value: trap::Label<StructExprField>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructExprField is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructExprField>> for trap::Label<Locatable> {
    fn from(value: trap::Label<StructExprField>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructExprField is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructExprField>> for trap::Label<Element> {
    fn from(value: trap::Label<StructExprField>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructExprField is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct StructExprFieldList {
    pub id: trap::TrapId<StructExprFieldList>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub fields: Vec<trap::Label<StructExprField>>,
    pub spread: Option<trap::Label<Expr>>,
}

impl trap::TrapEntry for StructExprFieldList {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("struct_expr_field_lists", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("struct_expr_field_list_attrs", vec![id.into(), i.into(), v.into()]);
        }
        for (i, v) in self.fields.into_iter().enumerate() {
            out.add_tuple("struct_expr_field_list_fields", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.spread {
            out.add_tuple("struct_expr_field_list_spreads", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for StructExprFieldList {
    fn class_name() -> &'static str { "StructExprFieldList" }
}

impl From<trap::Label<StructExprFieldList>> for trap::Label<AstNode> {
    fn from(value: trap::Label<StructExprFieldList>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructExprFieldList is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructExprFieldList>> for trap::Label<Locatable> {
    fn from(value: trap::Label<StructExprFieldList>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructExprFieldList is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructExprFieldList>> for trap::Label<Element> {
    fn from(value: trap::Label<StructExprFieldList>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructExprFieldList is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct StructField {
    pub id: trap::TrapId<StructField>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub default: Option<trap::Label<Expr>>,
    pub is_unsafe: bool,
    pub name: Option<trap::Label<Name>>,
    pub type_repr: Option<trap::Label<TypeRepr>>,
    pub visibility: Option<trap::Label<Visibility>>,
}

impl trap::TrapEntry for StructField {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("struct_fields", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("struct_field_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.default {
            out.add_tuple("struct_field_defaults", vec![id.into(), v.into()]);
        }
        if self.is_unsafe {
            out.add_tuple("struct_field_is_unsafe", vec![id.into()]);
        }
        if let Some(v) = self.name {
            out.add_tuple("struct_field_names", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.type_repr {
            out.add_tuple("struct_field_type_reprs", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.visibility {
            out.add_tuple("struct_field_visibilities", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for StructField {
    fn class_name() -> &'static str { "StructField" }
}

impl From<trap::Label<StructField>> for trap::Label<AstNode> {
    fn from(value: trap::Label<StructField>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructField is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructField>> for trap::Label<Locatable> {
    fn from(value: trap::Label<StructField>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructField is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructField>> for trap::Label<Element> {
    fn from(value: trap::Label<StructField>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructField is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct StructPatField {
    pub id: trap::TrapId<StructPatField>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub identifier: Option<trap::Label<NameRef>>,
    pub pat: Option<trap::Label<Pat>>,
}

impl trap::TrapEntry for StructPatField {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("struct_pat_fields", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("struct_pat_field_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.identifier {
            out.add_tuple("struct_pat_field_identifiers", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.pat {
            out.add_tuple("struct_pat_field_pats", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for StructPatField {
    fn class_name() -> &'static str { "StructPatField" }
}

impl From<trap::Label<StructPatField>> for trap::Label<AstNode> {
    fn from(value: trap::Label<StructPatField>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructPatField is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructPatField>> for trap::Label<Locatable> {
    fn from(value: trap::Label<StructPatField>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructPatField is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructPatField>> for trap::Label<Element> {
    fn from(value: trap::Label<StructPatField>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructPatField is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct StructPatFieldList {
    pub id: trap::TrapId<StructPatFieldList>,
    pub fields: Vec<trap::Label<StructPatField>>,
    pub rest_pat: Option<trap::Label<RestPat>>,
}

impl trap::TrapEntry for StructPatFieldList {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("struct_pat_field_lists", vec![id.into()]);
        for (i, v) in self.fields.into_iter().enumerate() {
            out.add_tuple("struct_pat_field_list_fields", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.rest_pat {
            out.add_tuple("struct_pat_field_list_rest_pats", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for StructPatFieldList {
    fn class_name() -> &'static str { "StructPatFieldList" }
}

impl From<trap::Label<StructPatFieldList>> for trap::Label<AstNode> {
    fn from(value: trap::Label<StructPatFieldList>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructPatFieldList is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructPatFieldList>> for trap::Label<Locatable> {
    fn from(value: trap::Label<StructPatFieldList>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructPatFieldList is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructPatFieldList>> for trap::Label<Element> {
    fn from(value: trap::Label<StructPatFieldList>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructPatFieldList is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Token {
    _unused: ()
}

impl trap::TrapClass for Token {
    fn class_name() -> &'static str { "Token" }
}

impl From<trap::Label<Token>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Token>) -> Self {
        // SAFETY: this is safe because in the dbscheme Token is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Token>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Token>) -> Self {
        // SAFETY: this is safe because in the dbscheme Token is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Token>> for trap::Label<Element> {
    fn from(value: trap::Label<Token>) -> Self {
        // SAFETY: this is safe because in the dbscheme Token is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct TokenTree {
    pub id: trap::TrapId<TokenTree>,
}

impl trap::TrapEntry for TokenTree {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("token_trees", vec![id.into()]);
    }
}

impl trap::TrapClass for TokenTree {
    fn class_name() -> &'static str { "TokenTree" }
}

impl From<trap::Label<TokenTree>> for trap::Label<AstNode> {
    fn from(value: trap::Label<TokenTree>) -> Self {
        // SAFETY: this is safe because in the dbscheme TokenTree is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TokenTree>> for trap::Label<Locatable> {
    fn from(value: trap::Label<TokenTree>) -> Self {
        // SAFETY: this is safe because in the dbscheme TokenTree is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TokenTree>> for trap::Label<Element> {
    fn from(value: trap::Label<TokenTree>) -> Self {
        // SAFETY: this is safe because in the dbscheme TokenTree is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct TupleField {
    pub id: trap::TrapId<TupleField>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub type_repr: Option<trap::Label<TypeRepr>>,
    pub visibility: Option<trap::Label<Visibility>>,
}

impl trap::TrapEntry for TupleField {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("tuple_fields", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("tuple_field_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.type_repr {
            out.add_tuple("tuple_field_type_reprs", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.visibility {
            out.add_tuple("tuple_field_visibilities", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for TupleField {
    fn class_name() -> &'static str { "TupleField" }
}

impl From<trap::Label<TupleField>> for trap::Label<AstNode> {
    fn from(value: trap::Label<TupleField>) -> Self {
        // SAFETY: this is safe because in the dbscheme TupleField is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TupleField>> for trap::Label<Locatable> {
    fn from(value: trap::Label<TupleField>) -> Self {
        // SAFETY: this is safe because in the dbscheme TupleField is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TupleField>> for trap::Label<Element> {
    fn from(value: trap::Label<TupleField>) -> Self {
        // SAFETY: this is safe because in the dbscheme TupleField is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct TypeBound {
    pub id: trap::TrapId<TypeBound>,
    pub is_async: bool,
    pub is_const: bool,
    pub lifetime: Option<trap::Label<Lifetime>>,
    pub type_repr: Option<trap::Label<TypeRepr>>,
    pub use_bound_generic_args: Option<trap::Label<UseBoundGenericArgs>>,
}

impl trap::TrapEntry for TypeBound {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("type_bounds", vec![id.into()]);
        if self.is_async {
            out.add_tuple("type_bound_is_async", vec![id.into()]);
        }
        if self.is_const {
            out.add_tuple("type_bound_is_const", vec![id.into()]);
        }
        if let Some(v) = self.lifetime {
            out.add_tuple("type_bound_lifetimes", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.type_repr {
            out.add_tuple("type_bound_type_reprs", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.use_bound_generic_args {
            out.add_tuple("type_bound_use_bound_generic_args", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for TypeBound {
    fn class_name() -> &'static str { "TypeBound" }
}

impl From<trap::Label<TypeBound>> for trap::Label<AstNode> {
    fn from(value: trap::Label<TypeBound>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeBound is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TypeBound>> for trap::Label<Locatable> {
    fn from(value: trap::Label<TypeBound>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeBound is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TypeBound>> for trap::Label<Element> {
    fn from(value: trap::Label<TypeBound>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeBound is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct TypeBoundList {
    pub id: trap::TrapId<TypeBoundList>,
    pub bounds: Vec<trap::Label<TypeBound>>,
}

impl trap::TrapEntry for TypeBoundList {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("type_bound_lists", vec![id.into()]);
        for (i, v) in self.bounds.into_iter().enumerate() {
            out.add_tuple("type_bound_list_bounds", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for TypeBoundList {
    fn class_name() -> &'static str { "TypeBoundList" }
}

impl From<trap::Label<TypeBoundList>> for trap::Label<AstNode> {
    fn from(value: trap::Label<TypeBoundList>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeBoundList is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TypeBoundList>> for trap::Label<Locatable> {
    fn from(value: trap::Label<TypeBoundList>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeBoundList is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TypeBoundList>> for trap::Label<Element> {
    fn from(value: trap::Label<TypeBoundList>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeBoundList is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct TypeRepr {
    _unused: ()
}

impl trap::TrapClass for TypeRepr {
    fn class_name() -> &'static str { "TypeRepr" }
}

impl From<trap::Label<TypeRepr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<TypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeRepr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TypeRepr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<TypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeRepr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TypeRepr>> for trap::Label<Element> {
    fn from(value: trap::Label<TypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeRepr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct UseBoundGenericArg {
    _unused: ()
}

impl trap::TrapClass for UseBoundGenericArg {
    fn class_name() -> &'static str { "UseBoundGenericArg" }
}

impl From<trap::Label<UseBoundGenericArg>> for trap::Label<AstNode> {
    fn from(value: trap::Label<UseBoundGenericArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme UseBoundGenericArg is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<UseBoundGenericArg>> for trap::Label<Locatable> {
    fn from(value: trap::Label<UseBoundGenericArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme UseBoundGenericArg is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<UseBoundGenericArg>> for trap::Label<Element> {
    fn from(value: trap::Label<UseBoundGenericArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme UseBoundGenericArg is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct UseBoundGenericArgs {
    pub id: trap::TrapId<UseBoundGenericArgs>,
    pub use_bound_generic_args: Vec<trap::Label<UseBoundGenericArg>>,
}

impl trap::TrapEntry for UseBoundGenericArgs {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("use_bound_generic_args", vec![id.into()]);
        for (i, v) in self.use_bound_generic_args.into_iter().enumerate() {
            out.add_tuple("use_bound_generic_args_use_bound_generic_args", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for UseBoundGenericArgs {
    fn class_name() -> &'static str { "UseBoundGenericArgs" }
}

impl From<trap::Label<UseBoundGenericArgs>> for trap::Label<AstNode> {
    fn from(value: trap::Label<UseBoundGenericArgs>) -> Self {
        // SAFETY: this is safe because in the dbscheme UseBoundGenericArgs is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<UseBoundGenericArgs>> for trap::Label<Locatable> {
    fn from(value: trap::Label<UseBoundGenericArgs>) -> Self {
        // SAFETY: this is safe because in the dbscheme UseBoundGenericArgs is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<UseBoundGenericArgs>> for trap::Label<Element> {
    fn from(value: trap::Label<UseBoundGenericArgs>) -> Self {
        // SAFETY: this is safe because in the dbscheme UseBoundGenericArgs is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct UseTree {
    pub id: trap::TrapId<UseTree>,
    pub is_glob: bool,
    pub path: Option<trap::Label<Path>>,
    pub rename: Option<trap::Label<Rename>>,
    pub use_tree_list: Option<trap::Label<UseTreeList>>,
}

impl trap::TrapEntry for UseTree {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("use_trees", vec![id.into()]);
        if self.is_glob {
            out.add_tuple("use_tree_is_glob", vec![id.into()]);
        }
        if let Some(v) = self.path {
            out.add_tuple("use_tree_paths", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.rename {
            out.add_tuple("use_tree_renames", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.use_tree_list {
            out.add_tuple("use_tree_use_tree_lists", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for UseTree {
    fn class_name() -> &'static str { "UseTree" }
}

impl From<trap::Label<UseTree>> for trap::Label<AstNode> {
    fn from(value: trap::Label<UseTree>) -> Self {
        // SAFETY: this is safe because in the dbscheme UseTree is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<UseTree>> for trap::Label<Locatable> {
    fn from(value: trap::Label<UseTree>) -> Self {
        // SAFETY: this is safe because in the dbscheme UseTree is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<UseTree>> for trap::Label<Element> {
    fn from(value: trap::Label<UseTree>) -> Self {
        // SAFETY: this is safe because in the dbscheme UseTree is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct UseTreeList {
    pub id: trap::TrapId<UseTreeList>,
    pub use_trees: Vec<trap::Label<UseTree>>,
}

impl trap::TrapEntry for UseTreeList {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("use_tree_lists", vec![id.into()]);
        for (i, v) in self.use_trees.into_iter().enumerate() {
            out.add_tuple("use_tree_list_use_trees", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for UseTreeList {
    fn class_name() -> &'static str { "UseTreeList" }
}

impl From<trap::Label<UseTreeList>> for trap::Label<AstNode> {
    fn from(value: trap::Label<UseTreeList>) -> Self {
        // SAFETY: this is safe because in the dbscheme UseTreeList is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<UseTreeList>> for trap::Label<Locatable> {
    fn from(value: trap::Label<UseTreeList>) -> Self {
        // SAFETY: this is safe because in the dbscheme UseTreeList is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<UseTreeList>> for trap::Label<Element> {
    fn from(value: trap::Label<UseTreeList>) -> Self {
        // SAFETY: this is safe because in the dbscheme UseTreeList is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct VariantList {
    pub id: trap::TrapId<VariantList>,
    pub variants: Vec<trap::Label<Variant>>,
}

impl trap::TrapEntry for VariantList {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("variant_lists", vec![id.into()]);
        for (i, v) in self.variants.into_iter().enumerate() {
            out.add_tuple("variant_list_variants", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for VariantList {
    fn class_name() -> &'static str { "VariantList" }
}

impl From<trap::Label<VariantList>> for trap::Label<AstNode> {
    fn from(value: trap::Label<VariantList>) -> Self {
        // SAFETY: this is safe because in the dbscheme VariantList is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<VariantList>> for trap::Label<Locatable> {
    fn from(value: trap::Label<VariantList>) -> Self {
        // SAFETY: this is safe because in the dbscheme VariantList is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<VariantList>> for trap::Label<Element> {
    fn from(value: trap::Label<VariantList>) -> Self {
        // SAFETY: this is safe because in the dbscheme VariantList is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Visibility {
    pub id: trap::TrapId<Visibility>,
    pub path: Option<trap::Label<Path>>,
}

impl trap::TrapEntry for Visibility {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("visibilities", vec![id.into()]);
        if let Some(v) = self.path {
            out.add_tuple("visibility_paths", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for Visibility {
    fn class_name() -> &'static str { "Visibility" }
}

impl From<trap::Label<Visibility>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Visibility>) -> Self {
        // SAFETY: this is safe because in the dbscheme Visibility is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Visibility>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Visibility>) -> Self {
        // SAFETY: this is safe because in the dbscheme Visibility is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Visibility>> for trap::Label<Element> {
    fn from(value: trap::Label<Visibility>) -> Self {
        // SAFETY: this is safe because in the dbscheme Visibility is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct WhereClause {
    pub id: trap::TrapId<WhereClause>,
    pub predicates: Vec<trap::Label<WherePred>>,
}

impl trap::TrapEntry for WhereClause {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("where_clauses", vec![id.into()]);
        for (i, v) in self.predicates.into_iter().enumerate() {
            out.add_tuple("where_clause_predicates", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for WhereClause {
    fn class_name() -> &'static str { "WhereClause" }
}

impl From<trap::Label<WhereClause>> for trap::Label<AstNode> {
    fn from(value: trap::Label<WhereClause>) -> Self {
        // SAFETY: this is safe because in the dbscheme WhereClause is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<WhereClause>> for trap::Label<Locatable> {
    fn from(value: trap::Label<WhereClause>) -> Self {
        // SAFETY: this is safe because in the dbscheme WhereClause is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<WhereClause>> for trap::Label<Element> {
    fn from(value: trap::Label<WhereClause>) -> Self {
        // SAFETY: this is safe because in the dbscheme WhereClause is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct WherePred {
    pub id: trap::TrapId<WherePred>,
    pub generic_param_list: Option<trap::Label<GenericParamList>>,
    pub lifetime: Option<trap::Label<Lifetime>>,
    pub type_repr: Option<trap::Label<TypeRepr>>,
    pub type_bound_list: Option<trap::Label<TypeBoundList>>,
}

impl trap::TrapEntry for WherePred {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("where_preds", vec![id.into()]);
        if let Some(v) = self.generic_param_list {
            out.add_tuple("where_pred_generic_param_lists", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.lifetime {
            out.add_tuple("where_pred_lifetimes", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.type_repr {
            out.add_tuple("where_pred_type_reprs", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.type_bound_list {
            out.add_tuple("where_pred_type_bound_lists", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for WherePred {
    fn class_name() -> &'static str { "WherePred" }
}

impl From<trap::Label<WherePred>> for trap::Label<AstNode> {
    fn from(value: trap::Label<WherePred>) -> Self {
        // SAFETY: this is safe because in the dbscheme WherePred is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<WherePred>> for trap::Label<Locatable> {
    fn from(value: trap::Label<WherePred>) -> Self {
        // SAFETY: this is safe because in the dbscheme WherePred is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<WherePred>> for trap::Label<Element> {
    fn from(value: trap::Label<WherePred>) -> Self {
        // SAFETY: this is safe because in the dbscheme WherePred is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ArrayExprInternal {
    pub id: trap::TrapId<ArrayExprInternal>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub exprs: Vec<trap::Label<Expr>>,
    pub is_semicolon: bool,
}

impl trap::TrapEntry for ArrayExprInternal {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("array_expr_internals", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("array_expr_internal_attrs", vec![id.into(), i.into(), v.into()]);
        }
        for (i, v) in self.exprs.into_iter().enumerate() {
            out.add_tuple("array_expr_internal_exprs", vec![id.into(), i.into(), v.into()]);
        }
        if self.is_semicolon {
            out.add_tuple("array_expr_internal_is_semicolon", vec![id.into()]);
        }
    }
}

impl trap::TrapClass for ArrayExprInternal {
    fn class_name() -> &'static str { "ArrayExprInternal" }
}

impl From<trap::Label<ArrayExprInternal>> for trap::Label<Expr> {
    fn from(value: trap::Label<ArrayExprInternal>) -> Self {
        // SAFETY: this is safe because in the dbscheme ArrayExprInternal is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ArrayExprInternal>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ArrayExprInternal>) -> Self {
        // SAFETY: this is safe because in the dbscheme ArrayExprInternal is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ArrayExprInternal>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ArrayExprInternal>) -> Self {
        // SAFETY: this is safe because in the dbscheme ArrayExprInternal is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ArrayExprInternal>> for trap::Label<Element> {
    fn from(value: trap::Label<ArrayExprInternal>) -> Self {
        // SAFETY: this is safe because in the dbscheme ArrayExprInternal is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ArrayTypeRepr {
    pub id: trap::TrapId<ArrayTypeRepr>,
    pub const_arg: Option<trap::Label<ConstArg>>,
    pub element_type_repr: Option<trap::Label<TypeRepr>>,
}

impl trap::TrapEntry for ArrayTypeRepr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("array_type_reprs", vec![id.into()]);
        if let Some(v) = self.const_arg {
            out.add_tuple("array_type_repr_const_args", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.element_type_repr {
            out.add_tuple("array_type_repr_element_type_reprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for ArrayTypeRepr {
    fn class_name() -> &'static str { "ArrayTypeRepr" }
}

impl From<trap::Label<ArrayTypeRepr>> for trap::Label<TypeRepr> {
    fn from(value: trap::Label<ArrayTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ArrayTypeRepr is a subclass of TypeRepr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ArrayTypeRepr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ArrayTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ArrayTypeRepr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ArrayTypeRepr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ArrayTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ArrayTypeRepr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ArrayTypeRepr>> for trap::Label<Element> {
    fn from(value: trap::Label<ArrayTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ArrayTypeRepr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct AsmClobberAbi {
    pub id: trap::TrapId<AsmClobberAbi>,
}

impl trap::TrapEntry for AsmClobberAbi {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("asm_clobber_abis", vec![id.into()]);
    }
}

impl trap::TrapClass for AsmClobberAbi {
    fn class_name() -> &'static str { "AsmClobberAbi" }
}

impl From<trap::Label<AsmClobberAbi>> for trap::Label<AsmPiece> {
    fn from(value: trap::Label<AsmClobberAbi>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmClobberAbi is a subclass of AsmPiece
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmClobberAbi>> for trap::Label<AstNode> {
    fn from(value: trap::Label<AsmClobberAbi>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmClobberAbi is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmClobberAbi>> for trap::Label<Locatable> {
    fn from(value: trap::Label<AsmClobberAbi>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmClobberAbi is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmClobberAbi>> for trap::Label<Element> {
    fn from(value: trap::Label<AsmClobberAbi>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmClobberAbi is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct AsmConst {
    pub id: trap::TrapId<AsmConst>,
    pub expr: Option<trap::Label<Expr>>,
    pub is_const: bool,
}

impl trap::TrapEntry for AsmConst {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("asm_consts", vec![id.into()]);
        if let Some(v) = self.expr {
            out.add_tuple("asm_const_exprs", vec![id.into(), v.into()]);
        }
        if self.is_const {
            out.add_tuple("asm_const_is_const", vec![id.into()]);
        }
    }
}

impl trap::TrapClass for AsmConst {
    fn class_name() -> &'static str { "AsmConst" }
}

impl From<trap::Label<AsmConst>> for trap::Label<AsmOperand> {
    fn from(value: trap::Label<AsmConst>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmConst is a subclass of AsmOperand
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmConst>> for trap::Label<AstNode> {
    fn from(value: trap::Label<AsmConst>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmConst is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmConst>> for trap::Label<Locatable> {
    fn from(value: trap::Label<AsmConst>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmConst is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmConst>> for trap::Label<Element> {
    fn from(value: trap::Label<AsmConst>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmConst is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct AsmExpr {
    pub id: trap::TrapId<AsmExpr>,
    pub asm_pieces: Vec<trap::Label<AsmPiece>>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub template: Vec<trap::Label<Expr>>,
}

impl trap::TrapEntry for AsmExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("asm_exprs", vec![id.into()]);
        for (i, v) in self.asm_pieces.into_iter().enumerate() {
            out.add_tuple("asm_expr_asm_pieces", vec![id.into(), i.into(), v.into()]);
        }
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("asm_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        for (i, v) in self.template.into_iter().enumerate() {
            out.add_tuple("asm_expr_templates", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for AsmExpr {
    fn class_name() -> &'static str { "AsmExpr" }
}

impl From<trap::Label<AsmExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<AsmExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<AsmExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<AsmExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<AsmExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct AsmLabel {
    pub id: trap::TrapId<AsmLabel>,
    pub block_expr: Option<trap::Label<BlockExpr>>,
}

impl trap::TrapEntry for AsmLabel {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("asm_labels", vec![id.into()]);
        if let Some(v) = self.block_expr {
            out.add_tuple("asm_label_block_exprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for AsmLabel {
    fn class_name() -> &'static str { "AsmLabel" }
}

impl From<trap::Label<AsmLabel>> for trap::Label<AsmOperand> {
    fn from(value: trap::Label<AsmLabel>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmLabel is a subclass of AsmOperand
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmLabel>> for trap::Label<AstNode> {
    fn from(value: trap::Label<AsmLabel>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmLabel is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmLabel>> for trap::Label<Locatable> {
    fn from(value: trap::Label<AsmLabel>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmLabel is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmLabel>> for trap::Label<Element> {
    fn from(value: trap::Label<AsmLabel>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmLabel is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct AsmOperandNamed {
    pub id: trap::TrapId<AsmOperandNamed>,
    pub asm_operand: Option<trap::Label<AsmOperand>>,
    pub name: Option<trap::Label<Name>>,
}

impl trap::TrapEntry for AsmOperandNamed {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("asm_operand_nameds", vec![id.into()]);
        if let Some(v) = self.asm_operand {
            out.add_tuple("asm_operand_named_asm_operands", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.name {
            out.add_tuple("asm_operand_named_names", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for AsmOperandNamed {
    fn class_name() -> &'static str { "AsmOperandNamed" }
}

impl From<trap::Label<AsmOperandNamed>> for trap::Label<AsmPiece> {
    fn from(value: trap::Label<AsmOperandNamed>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmOperandNamed is a subclass of AsmPiece
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmOperandNamed>> for trap::Label<AstNode> {
    fn from(value: trap::Label<AsmOperandNamed>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmOperandNamed is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmOperandNamed>> for trap::Label<Locatable> {
    fn from(value: trap::Label<AsmOperandNamed>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmOperandNamed is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmOperandNamed>> for trap::Label<Element> {
    fn from(value: trap::Label<AsmOperandNamed>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmOperandNamed is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct AsmOptionsList {
    pub id: trap::TrapId<AsmOptionsList>,
    pub asm_options: Vec<trap::Label<AsmOption>>,
}

impl trap::TrapEntry for AsmOptionsList {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("asm_options_lists", vec![id.into()]);
        for (i, v) in self.asm_options.into_iter().enumerate() {
            out.add_tuple("asm_options_list_asm_options", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for AsmOptionsList {
    fn class_name() -> &'static str { "AsmOptionsList" }
}

impl From<trap::Label<AsmOptionsList>> for trap::Label<AsmPiece> {
    fn from(value: trap::Label<AsmOptionsList>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmOptionsList is a subclass of AsmPiece
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmOptionsList>> for trap::Label<AstNode> {
    fn from(value: trap::Label<AsmOptionsList>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmOptionsList is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmOptionsList>> for trap::Label<Locatable> {
    fn from(value: trap::Label<AsmOptionsList>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmOptionsList is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmOptionsList>> for trap::Label<Element> {
    fn from(value: trap::Label<AsmOptionsList>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmOptionsList is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct AsmRegOperand {
    pub id: trap::TrapId<AsmRegOperand>,
    pub asm_dir_spec: Option<trap::Label<AsmDirSpec>>,
    pub asm_operand_expr: Option<trap::Label<AsmOperandExpr>>,
    pub asm_reg_spec: Option<trap::Label<AsmRegSpec>>,
}

impl trap::TrapEntry for AsmRegOperand {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("asm_reg_operands", vec![id.into()]);
        if let Some(v) = self.asm_dir_spec {
            out.add_tuple("asm_reg_operand_asm_dir_specs", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.asm_operand_expr {
            out.add_tuple("asm_reg_operand_asm_operand_exprs", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.asm_reg_spec {
            out.add_tuple("asm_reg_operand_asm_reg_specs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for AsmRegOperand {
    fn class_name() -> &'static str { "AsmRegOperand" }
}

impl From<trap::Label<AsmRegOperand>> for trap::Label<AsmOperand> {
    fn from(value: trap::Label<AsmRegOperand>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmRegOperand is a subclass of AsmOperand
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmRegOperand>> for trap::Label<AstNode> {
    fn from(value: trap::Label<AsmRegOperand>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmRegOperand is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmRegOperand>> for trap::Label<Locatable> {
    fn from(value: trap::Label<AsmRegOperand>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmRegOperand is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmRegOperand>> for trap::Label<Element> {
    fn from(value: trap::Label<AsmRegOperand>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmRegOperand is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct AsmSym {
    pub id: trap::TrapId<AsmSym>,
    pub path: Option<trap::Label<Path>>,
}

impl trap::TrapEntry for AsmSym {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("asm_syms", vec![id.into()]);
        if let Some(v) = self.path {
            out.add_tuple("asm_sym_paths", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for AsmSym {
    fn class_name() -> &'static str { "AsmSym" }
}

impl From<trap::Label<AsmSym>> for trap::Label<AsmOperand> {
    fn from(value: trap::Label<AsmSym>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmSym is a subclass of AsmOperand
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmSym>> for trap::Label<AstNode> {
    fn from(value: trap::Label<AsmSym>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmSym is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmSym>> for trap::Label<Locatable> {
    fn from(value: trap::Label<AsmSym>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmSym is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AsmSym>> for trap::Label<Element> {
    fn from(value: trap::Label<AsmSym>) -> Self {
        // SAFETY: this is safe because in the dbscheme AsmSym is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct AssocTypeArg {
    pub id: trap::TrapId<AssocTypeArg>,
    pub const_arg: Option<trap::Label<ConstArg>>,
    pub generic_arg_list: Option<trap::Label<GenericArgList>>,
    pub identifier: Option<trap::Label<NameRef>>,
    pub param_list: Option<trap::Label<ParamList>>,
    pub ret_type: Option<trap::Label<RetTypeRepr>>,
    pub return_type_syntax: Option<trap::Label<ReturnTypeSyntax>>,
    pub type_repr: Option<trap::Label<TypeRepr>>,
    pub type_bound_list: Option<trap::Label<TypeBoundList>>,
}

impl trap::TrapEntry for AssocTypeArg {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("assoc_type_args", vec![id.into()]);
        if let Some(v) = self.const_arg {
            out.add_tuple("assoc_type_arg_const_args", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.generic_arg_list {
            out.add_tuple("assoc_type_arg_generic_arg_lists", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.identifier {
            out.add_tuple("assoc_type_arg_identifiers", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.param_list {
            out.add_tuple("assoc_type_arg_param_lists", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.ret_type {
            out.add_tuple("assoc_type_arg_ret_types", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.return_type_syntax {
            out.add_tuple("assoc_type_arg_return_type_syntaxes", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.type_repr {
            out.add_tuple("assoc_type_arg_type_reprs", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.type_bound_list {
            out.add_tuple("assoc_type_arg_type_bound_lists", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for AssocTypeArg {
    fn class_name() -> &'static str { "AssocTypeArg" }
}

impl From<trap::Label<AssocTypeArg>> for trap::Label<GenericArg> {
    fn from(value: trap::Label<AssocTypeArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme AssocTypeArg is a subclass of GenericArg
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AssocTypeArg>> for trap::Label<AstNode> {
    fn from(value: trap::Label<AssocTypeArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme AssocTypeArg is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AssocTypeArg>> for trap::Label<Locatable> {
    fn from(value: trap::Label<AssocTypeArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme AssocTypeArg is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AssocTypeArg>> for trap::Label<Element> {
    fn from(value: trap::Label<AssocTypeArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme AssocTypeArg is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct AwaitExpr {
    pub id: trap::TrapId<AwaitExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub expr: Option<trap::Label<Expr>>,
}

impl trap::TrapEntry for AwaitExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("await_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("await_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.expr {
            out.add_tuple("await_expr_exprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for AwaitExpr {
    fn class_name() -> &'static str { "AwaitExpr" }
}

impl From<trap::Label<AwaitExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<AwaitExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme AwaitExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AwaitExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<AwaitExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme AwaitExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AwaitExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<AwaitExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme AwaitExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AwaitExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<AwaitExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme AwaitExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct BecomeExpr {
    pub id: trap::TrapId<BecomeExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub expr: Option<trap::Label<Expr>>,
}

impl trap::TrapEntry for BecomeExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("become_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("become_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.expr {
            out.add_tuple("become_expr_exprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for BecomeExpr {
    fn class_name() -> &'static str { "BecomeExpr" }
}

impl From<trap::Label<BecomeExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<BecomeExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme BecomeExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<BecomeExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<BecomeExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme BecomeExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<BecomeExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<BecomeExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme BecomeExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<BecomeExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<BecomeExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme BecomeExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct BinaryExpr {
    pub id: trap::TrapId<BinaryExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub lhs: Option<trap::Label<Expr>>,
    pub operator_name: Option<String>,
    pub rhs: Option<trap::Label<Expr>>,
}

impl trap::TrapEntry for BinaryExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("binary_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("binary_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.lhs {
            out.add_tuple("binary_expr_lhs", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.operator_name {
            out.add_tuple("binary_expr_operator_names", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.rhs {
            out.add_tuple("binary_expr_rhs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for BinaryExpr {
    fn class_name() -> &'static str { "BinaryExpr" }
}

impl From<trap::Label<BinaryExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<BinaryExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme BinaryExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<BinaryExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<BinaryExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme BinaryExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<BinaryExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<BinaryExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme BinaryExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<BinaryExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<BinaryExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme BinaryExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct BoxPat {
    pub id: trap::TrapId<BoxPat>,
    pub pat: Option<trap::Label<Pat>>,
}

impl trap::TrapEntry for BoxPat {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("box_pats", vec![id.into()]);
        if let Some(v) = self.pat {
            out.add_tuple("box_pat_pats", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for BoxPat {
    fn class_name() -> &'static str { "BoxPat" }
}

impl From<trap::Label<BoxPat>> for trap::Label<Pat> {
    fn from(value: trap::Label<BoxPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme BoxPat is a subclass of Pat
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<BoxPat>> for trap::Label<AstNode> {
    fn from(value: trap::Label<BoxPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme BoxPat is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<BoxPat>> for trap::Label<Locatable> {
    fn from(value: trap::Label<BoxPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme BoxPat is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<BoxPat>> for trap::Label<Element> {
    fn from(value: trap::Label<BoxPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme BoxPat is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct BreakExpr {
    pub id: trap::TrapId<BreakExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub expr: Option<trap::Label<Expr>>,
    pub lifetime: Option<trap::Label<Lifetime>>,
}

impl trap::TrapEntry for BreakExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("break_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("break_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.expr {
            out.add_tuple("break_expr_exprs", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.lifetime {
            out.add_tuple("break_expr_lifetimes", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for BreakExpr {
    fn class_name() -> &'static str { "BreakExpr" }
}

impl From<trap::Label<BreakExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<BreakExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme BreakExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<BreakExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<BreakExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme BreakExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<BreakExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<BreakExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme BreakExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<BreakExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<BreakExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme BreakExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct CallExprBase {
    _unused: ()
}

impl trap::TrapClass for CallExprBase {
    fn class_name() -> &'static str { "CallExprBase" }
}

impl From<trap::Label<CallExprBase>> for trap::Label<Expr> {
    fn from(value: trap::Label<CallExprBase>) -> Self {
        // SAFETY: this is safe because in the dbscheme CallExprBase is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<CallExprBase>> for trap::Label<AstNode> {
    fn from(value: trap::Label<CallExprBase>) -> Self {
        // SAFETY: this is safe because in the dbscheme CallExprBase is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<CallExprBase>> for trap::Label<Locatable> {
    fn from(value: trap::Label<CallExprBase>) -> Self {
        // SAFETY: this is safe because in the dbscheme CallExprBase is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<CallExprBase>> for trap::Label<Element> {
    fn from(value: trap::Label<CallExprBase>) -> Self {
        // SAFETY: this is safe because in the dbscheme CallExprBase is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct CastExpr {
    pub id: trap::TrapId<CastExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub expr: Option<trap::Label<Expr>>,
    pub type_repr: Option<trap::Label<TypeRepr>>,
}

impl trap::TrapEntry for CastExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("cast_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("cast_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.expr {
            out.add_tuple("cast_expr_exprs", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.type_repr {
            out.add_tuple("cast_expr_type_reprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for CastExpr {
    fn class_name() -> &'static str { "CastExpr" }
}

impl From<trap::Label<CastExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<CastExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme CastExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<CastExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<CastExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme CastExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<CastExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<CastExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme CastExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<CastExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<CastExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme CastExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ClosureExpr {
    pub id: trap::TrapId<ClosureExpr>,
    pub param_list: Option<trap::Label<ParamList>>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub body: Option<trap::Label<Expr>>,
    pub closure_binder: Option<trap::Label<ClosureBinder>>,
    pub is_async: bool,
    pub is_const: bool,
    pub is_gen: bool,
    pub is_move: bool,
    pub is_static: bool,
    pub ret_type: Option<trap::Label<RetTypeRepr>>,
}

impl trap::TrapEntry for ClosureExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("closure_exprs", vec![id.into()]);
        if let Some(v) = self.param_list {
            out.add_tuple("callable_param_lists", vec![id.into(), v.into()]);
        }
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("callable_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.body {
            out.add_tuple("closure_expr_bodies", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.closure_binder {
            out.add_tuple("closure_expr_closure_binders", vec![id.into(), v.into()]);
        }
        if self.is_async {
            out.add_tuple("closure_expr_is_async", vec![id.into()]);
        }
        if self.is_const {
            out.add_tuple("closure_expr_is_const", vec![id.into()]);
        }
        if self.is_gen {
            out.add_tuple("closure_expr_is_gen", vec![id.into()]);
        }
        if self.is_move {
            out.add_tuple("closure_expr_is_move", vec![id.into()]);
        }
        if self.is_static {
            out.add_tuple("closure_expr_is_static", vec![id.into()]);
        }
        if let Some(v) = self.ret_type {
            out.add_tuple("closure_expr_ret_types", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for ClosureExpr {
    fn class_name() -> &'static str { "ClosureExpr" }
}

impl From<trap::Label<ClosureExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<ClosureExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ClosureExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ClosureExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ClosureExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ClosureExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ClosureExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ClosureExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ClosureExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ClosureExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<ClosureExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ClosureExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ClosureExpr>> for trap::Label<Callable> {
    fn from(value: trap::Label<ClosureExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ClosureExpr is a subclass of Callable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Comment {
    pub id: trap::TrapId<Comment>,
    pub parent: trap::Label<AstNode>,
    pub text: String,
}

impl trap::TrapEntry for Comment {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("comments", vec![id.into(), self.parent.into(), self.text.into()]);
    }
}

impl trap::TrapClass for Comment {
    fn class_name() -> &'static str { "Comment" }
}

impl From<trap::Label<Comment>> for trap::Label<Token> {
    fn from(value: trap::Label<Comment>) -> Self {
        // SAFETY: this is safe because in the dbscheme Comment is a subclass of Token
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Comment>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Comment>) -> Self {
        // SAFETY: this is safe because in the dbscheme Comment is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Comment>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Comment>) -> Self {
        // SAFETY: this is safe because in the dbscheme Comment is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Comment>> for trap::Label<Element> {
    fn from(value: trap::Label<Comment>) -> Self {
        // SAFETY: this is safe because in the dbscheme Comment is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ConstArg {
    pub id: trap::TrapId<ConstArg>,
    pub expr: Option<trap::Label<Expr>>,
}

impl trap::TrapEntry for ConstArg {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("const_args", vec![id.into()]);
        if let Some(v) = self.expr {
            out.add_tuple("const_arg_exprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for ConstArg {
    fn class_name() -> &'static str { "ConstArg" }
}

impl From<trap::Label<ConstArg>> for trap::Label<GenericArg> {
    fn from(value: trap::Label<ConstArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme ConstArg is a subclass of GenericArg
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ConstArg>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ConstArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme ConstArg is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ConstArg>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ConstArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme ConstArg is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ConstArg>> for trap::Label<Element> {
    fn from(value: trap::Label<ConstArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme ConstArg is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ConstBlockPat {
    pub id: trap::TrapId<ConstBlockPat>,
    pub block_expr: Option<trap::Label<BlockExpr>>,
    pub is_const: bool,
}

impl trap::TrapEntry for ConstBlockPat {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("const_block_pats", vec![id.into()]);
        if let Some(v) = self.block_expr {
            out.add_tuple("const_block_pat_block_exprs", vec![id.into(), v.into()]);
        }
        if self.is_const {
            out.add_tuple("const_block_pat_is_const", vec![id.into()]);
        }
    }
}

impl trap::TrapClass for ConstBlockPat {
    fn class_name() -> &'static str { "ConstBlockPat" }
}

impl From<trap::Label<ConstBlockPat>> for trap::Label<Pat> {
    fn from(value: trap::Label<ConstBlockPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme ConstBlockPat is a subclass of Pat
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ConstBlockPat>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ConstBlockPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme ConstBlockPat is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ConstBlockPat>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ConstBlockPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme ConstBlockPat is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ConstBlockPat>> for trap::Label<Element> {
    fn from(value: trap::Label<ConstBlockPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme ConstBlockPat is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ConstParam {
    pub id: trap::TrapId<ConstParam>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub default_val: Option<trap::Label<ConstArg>>,
    pub is_const: bool,
    pub name: Option<trap::Label<Name>>,
    pub type_repr: Option<trap::Label<TypeRepr>>,
}

impl trap::TrapEntry for ConstParam {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("const_params", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("const_param_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.default_val {
            out.add_tuple("const_param_default_vals", vec![id.into(), v.into()]);
        }
        if self.is_const {
            out.add_tuple("const_param_is_const", vec![id.into()]);
        }
        if let Some(v) = self.name {
            out.add_tuple("const_param_names", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.type_repr {
            out.add_tuple("const_param_type_reprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for ConstParam {
    fn class_name() -> &'static str { "ConstParam" }
}

impl From<trap::Label<ConstParam>> for trap::Label<GenericParam> {
    fn from(value: trap::Label<ConstParam>) -> Self {
        // SAFETY: this is safe because in the dbscheme ConstParam is a subclass of GenericParam
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ConstParam>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ConstParam>) -> Self {
        // SAFETY: this is safe because in the dbscheme ConstParam is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ConstParam>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ConstParam>) -> Self {
        // SAFETY: this is safe because in the dbscheme ConstParam is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ConstParam>> for trap::Label<Element> {
    fn from(value: trap::Label<ConstParam>) -> Self {
        // SAFETY: this is safe because in the dbscheme ConstParam is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ContinueExpr {
    pub id: trap::TrapId<ContinueExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub lifetime: Option<trap::Label<Lifetime>>,
}

impl trap::TrapEntry for ContinueExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("continue_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("continue_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.lifetime {
            out.add_tuple("continue_expr_lifetimes", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for ContinueExpr {
    fn class_name() -> &'static str { "ContinueExpr" }
}

impl From<trap::Label<ContinueExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<ContinueExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ContinueExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ContinueExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ContinueExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ContinueExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ContinueExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ContinueExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ContinueExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ContinueExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<ContinueExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ContinueExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct DynTraitTypeRepr {
    pub id: trap::TrapId<DynTraitTypeRepr>,
    pub type_bound_list: Option<trap::Label<TypeBoundList>>,
}

impl trap::TrapEntry for DynTraitTypeRepr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("dyn_trait_type_reprs", vec![id.into()]);
        if let Some(v) = self.type_bound_list {
            out.add_tuple("dyn_trait_type_repr_type_bound_lists", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for DynTraitTypeRepr {
    fn class_name() -> &'static str { "DynTraitTypeRepr" }
}

impl From<trap::Label<DynTraitTypeRepr>> for trap::Label<TypeRepr> {
    fn from(value: trap::Label<DynTraitTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme DynTraitTypeRepr is a subclass of TypeRepr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<DynTraitTypeRepr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<DynTraitTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme DynTraitTypeRepr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<DynTraitTypeRepr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<DynTraitTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme DynTraitTypeRepr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<DynTraitTypeRepr>> for trap::Label<Element> {
    fn from(value: trap::Label<DynTraitTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme DynTraitTypeRepr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ExprStmt {
    pub id: trap::TrapId<ExprStmt>,
    pub expr: Option<trap::Label<Expr>>,
}

impl trap::TrapEntry for ExprStmt {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("expr_stmts", vec![id.into()]);
        if let Some(v) = self.expr {
            out.add_tuple("expr_stmt_exprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for ExprStmt {
    fn class_name() -> &'static str { "ExprStmt" }
}

impl From<trap::Label<ExprStmt>> for trap::Label<Stmt> {
    fn from(value: trap::Label<ExprStmt>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExprStmt is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ExprStmt>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ExprStmt>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExprStmt is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ExprStmt>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ExprStmt>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExprStmt is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ExprStmt>> for trap::Label<Element> {
    fn from(value: trap::Label<ExprStmt>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExprStmt is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct FieldExpr {
    pub id: trap::TrapId<FieldExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub container: Option<trap::Label<Expr>>,
    pub identifier: Option<trap::Label<NameRef>>,
}

impl trap::TrapEntry for FieldExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("field_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("field_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.container {
            out.add_tuple("field_expr_containers", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.identifier {
            out.add_tuple("field_expr_identifiers", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for FieldExpr {
    fn class_name() -> &'static str { "FieldExpr" }
}

impl From<trap::Label<FieldExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<FieldExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme FieldExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<FieldExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<FieldExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme FieldExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<FieldExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<FieldExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme FieldExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<FieldExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<FieldExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme FieldExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct FnPtrTypeRepr {
    pub id: trap::TrapId<FnPtrTypeRepr>,
    pub abi: Option<trap::Label<Abi>>,
    pub is_async: bool,
    pub is_const: bool,
    pub is_unsafe: bool,
    pub param_list: Option<trap::Label<ParamList>>,
    pub ret_type: Option<trap::Label<RetTypeRepr>>,
}

impl trap::TrapEntry for FnPtrTypeRepr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("fn_ptr_type_reprs", vec![id.into()]);
        if let Some(v) = self.abi {
            out.add_tuple("fn_ptr_type_repr_abis", vec![id.into(), v.into()]);
        }
        if self.is_async {
            out.add_tuple("fn_ptr_type_repr_is_async", vec![id.into()]);
        }
        if self.is_const {
            out.add_tuple("fn_ptr_type_repr_is_const", vec![id.into()]);
        }
        if self.is_unsafe {
            out.add_tuple("fn_ptr_type_repr_is_unsafe", vec![id.into()]);
        }
        if let Some(v) = self.param_list {
            out.add_tuple("fn_ptr_type_repr_param_lists", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.ret_type {
            out.add_tuple("fn_ptr_type_repr_ret_types", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for FnPtrTypeRepr {
    fn class_name() -> &'static str { "FnPtrTypeRepr" }
}

impl From<trap::Label<FnPtrTypeRepr>> for trap::Label<TypeRepr> {
    fn from(value: trap::Label<FnPtrTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme FnPtrTypeRepr is a subclass of TypeRepr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<FnPtrTypeRepr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<FnPtrTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme FnPtrTypeRepr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<FnPtrTypeRepr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<FnPtrTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme FnPtrTypeRepr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<FnPtrTypeRepr>> for trap::Label<Element> {
    fn from(value: trap::Label<FnPtrTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme FnPtrTypeRepr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ForTypeRepr {
    pub id: trap::TrapId<ForTypeRepr>,
    pub generic_param_list: Option<trap::Label<GenericParamList>>,
    pub type_repr: Option<trap::Label<TypeRepr>>,
}

impl trap::TrapEntry for ForTypeRepr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("for_type_reprs", vec![id.into()]);
        if let Some(v) = self.generic_param_list {
            out.add_tuple("for_type_repr_generic_param_lists", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.type_repr {
            out.add_tuple("for_type_repr_type_reprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for ForTypeRepr {
    fn class_name() -> &'static str { "ForTypeRepr" }
}

impl From<trap::Label<ForTypeRepr>> for trap::Label<TypeRepr> {
    fn from(value: trap::Label<ForTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ForTypeRepr is a subclass of TypeRepr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ForTypeRepr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ForTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ForTypeRepr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ForTypeRepr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ForTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ForTypeRepr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ForTypeRepr>> for trap::Label<Element> {
    fn from(value: trap::Label<ForTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ForTypeRepr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct FormatArgsExpr {
    pub id: trap::TrapId<FormatArgsExpr>,
    pub args: Vec<trap::Label<FormatArgsArg>>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub template: Option<trap::Label<Expr>>,
}

impl trap::TrapEntry for FormatArgsExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("format_args_exprs", vec![id.into()]);
        for (i, v) in self.args.into_iter().enumerate() {
            out.add_tuple("format_args_expr_args", vec![id.into(), i.into(), v.into()]);
        }
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("format_args_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.template {
            out.add_tuple("format_args_expr_templates", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for FormatArgsExpr {
    fn class_name() -> &'static str { "FormatArgsExpr" }
}

impl From<trap::Label<FormatArgsExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<FormatArgsExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme FormatArgsExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<FormatArgsExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<FormatArgsExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme FormatArgsExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<FormatArgsExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<FormatArgsExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme FormatArgsExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<FormatArgsExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<FormatArgsExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme FormatArgsExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct IdentPat {
    pub id: trap::TrapId<IdentPat>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub is_mut: bool,
    pub is_ref: bool,
    pub name: Option<trap::Label<Name>>,
    pub pat: Option<trap::Label<Pat>>,
}

impl trap::TrapEntry for IdentPat {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("ident_pats", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("ident_pat_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if self.is_mut {
            out.add_tuple("ident_pat_is_mut", vec![id.into()]);
        }
        if self.is_ref {
            out.add_tuple("ident_pat_is_ref", vec![id.into()]);
        }
        if let Some(v) = self.name {
            out.add_tuple("ident_pat_names", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.pat {
            out.add_tuple("ident_pat_pats", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for IdentPat {
    fn class_name() -> &'static str { "IdentPat" }
}

impl From<trap::Label<IdentPat>> for trap::Label<Pat> {
    fn from(value: trap::Label<IdentPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme IdentPat is a subclass of Pat
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<IdentPat>> for trap::Label<AstNode> {
    fn from(value: trap::Label<IdentPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme IdentPat is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<IdentPat>> for trap::Label<Locatable> {
    fn from(value: trap::Label<IdentPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme IdentPat is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<IdentPat>> for trap::Label<Element> {
    fn from(value: trap::Label<IdentPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme IdentPat is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct IfExpr {
    pub id: trap::TrapId<IfExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub condition: Option<trap::Label<Expr>>,
    pub else_: Option<trap::Label<Expr>>,
    pub then: Option<trap::Label<BlockExpr>>,
}

impl trap::TrapEntry for IfExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("if_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("if_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.condition {
            out.add_tuple("if_expr_conditions", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.else_ {
            out.add_tuple("if_expr_elses", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.then {
            out.add_tuple("if_expr_thens", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for IfExpr {
    fn class_name() -> &'static str { "IfExpr" }
}

impl From<trap::Label<IfExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<IfExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme IfExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<IfExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<IfExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme IfExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<IfExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<IfExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme IfExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<IfExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<IfExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme IfExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ImplTraitTypeRepr {
    pub id: trap::TrapId<ImplTraitTypeRepr>,
    pub type_bound_list: Option<trap::Label<TypeBoundList>>,
}

impl trap::TrapEntry for ImplTraitTypeRepr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("impl_trait_type_reprs", vec![id.into()]);
        if let Some(v) = self.type_bound_list {
            out.add_tuple("impl_trait_type_repr_type_bound_lists", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for ImplTraitTypeRepr {
    fn class_name() -> &'static str { "ImplTraitTypeRepr" }
}

impl From<trap::Label<ImplTraitTypeRepr>> for trap::Label<TypeRepr> {
    fn from(value: trap::Label<ImplTraitTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ImplTraitTypeRepr is a subclass of TypeRepr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ImplTraitTypeRepr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ImplTraitTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ImplTraitTypeRepr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ImplTraitTypeRepr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ImplTraitTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ImplTraitTypeRepr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ImplTraitTypeRepr>> for trap::Label<Element> {
    fn from(value: trap::Label<ImplTraitTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ImplTraitTypeRepr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct IndexExpr {
    pub id: trap::TrapId<IndexExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub base: Option<trap::Label<Expr>>,
    pub index: Option<trap::Label<Expr>>,
}

impl trap::TrapEntry for IndexExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("index_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("index_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.base {
            out.add_tuple("index_expr_bases", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.index {
            out.add_tuple("index_expr_indices", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for IndexExpr {
    fn class_name() -> &'static str { "IndexExpr" }
}

impl From<trap::Label<IndexExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<IndexExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme IndexExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<IndexExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<IndexExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme IndexExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<IndexExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<IndexExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme IndexExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<IndexExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<IndexExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme IndexExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct InferTypeRepr {
    pub id: trap::TrapId<InferTypeRepr>,
}

impl trap::TrapEntry for InferTypeRepr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("infer_type_reprs", vec![id.into()]);
    }
}

impl trap::TrapClass for InferTypeRepr {
    fn class_name() -> &'static str { "InferTypeRepr" }
}

impl From<trap::Label<InferTypeRepr>> for trap::Label<TypeRepr> {
    fn from(value: trap::Label<InferTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme InferTypeRepr is a subclass of TypeRepr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<InferTypeRepr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<InferTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme InferTypeRepr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<InferTypeRepr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<InferTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme InferTypeRepr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<InferTypeRepr>> for trap::Label<Element> {
    fn from(value: trap::Label<InferTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme InferTypeRepr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Item {
    _unused: ()
}

impl Item {
    pub fn emit_attribute_macro_expansion(id: trap::Label<Self>, value: trap::Label<MacroItems>, out: &mut trap::Writer) {
        out.add_tuple("item_attribute_macro_expansions", vec![id.into(), value.into()]);
    }

}

impl trap::TrapClass for Item {
    fn class_name() -> &'static str { "Item" }
}

impl From<trap::Label<Item>> for trap::Label<Stmt> {
    fn from(value: trap::Label<Item>) -> Self {
        // SAFETY: this is safe because in the dbscheme Item is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Item>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Item>) -> Self {
        // SAFETY: this is safe because in the dbscheme Item is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Item>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Item>) -> Self {
        // SAFETY: this is safe because in the dbscheme Item is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Item>> for trap::Label<Element> {
    fn from(value: trap::Label<Item>) -> Self {
        // SAFETY: this is safe because in the dbscheme Item is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Item>> for trap::Label<Addressable> {
    fn from(value: trap::Label<Item>) -> Self {
        // SAFETY: this is safe because in the dbscheme Item is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct LabelableExpr {
    _unused: ()
}

impl trap::TrapClass for LabelableExpr {
    fn class_name() -> &'static str { "LabelableExpr" }
}

impl From<trap::Label<LabelableExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<LabelableExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LabelableExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LabelableExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<LabelableExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LabelableExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LabelableExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<LabelableExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LabelableExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LabelableExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<LabelableExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LabelableExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct LetExpr {
    pub id: trap::TrapId<LetExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub scrutinee: Option<trap::Label<Expr>>,
    pub pat: Option<trap::Label<Pat>>,
}

impl trap::TrapEntry for LetExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("let_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("let_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.scrutinee {
            out.add_tuple("let_expr_scrutinees", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.pat {
            out.add_tuple("let_expr_pats", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for LetExpr {
    fn class_name() -> &'static str { "LetExpr" }
}

impl From<trap::Label<LetExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<LetExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LetExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LetExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<LetExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LetExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LetExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<LetExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LetExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LetExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<LetExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LetExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct LetStmt {
    pub id: trap::TrapId<LetStmt>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub initializer: Option<trap::Label<Expr>>,
    pub let_else: Option<trap::Label<LetElse>>,
    pub pat: Option<trap::Label<Pat>>,
    pub type_repr: Option<trap::Label<TypeRepr>>,
}

impl trap::TrapEntry for LetStmt {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("let_stmts", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("let_stmt_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.initializer {
            out.add_tuple("let_stmt_initializers", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.let_else {
            out.add_tuple("let_stmt_let_elses", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.pat {
            out.add_tuple("let_stmt_pats", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.type_repr {
            out.add_tuple("let_stmt_type_reprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for LetStmt {
    fn class_name() -> &'static str { "LetStmt" }
}

impl From<trap::Label<LetStmt>> for trap::Label<Stmt> {
    fn from(value: trap::Label<LetStmt>) -> Self {
        // SAFETY: this is safe because in the dbscheme LetStmt is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LetStmt>> for trap::Label<AstNode> {
    fn from(value: trap::Label<LetStmt>) -> Self {
        // SAFETY: this is safe because in the dbscheme LetStmt is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LetStmt>> for trap::Label<Locatable> {
    fn from(value: trap::Label<LetStmt>) -> Self {
        // SAFETY: this is safe because in the dbscheme LetStmt is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LetStmt>> for trap::Label<Element> {
    fn from(value: trap::Label<LetStmt>) -> Self {
        // SAFETY: this is safe because in the dbscheme LetStmt is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Lifetime {
    pub id: trap::TrapId<Lifetime>,
    pub text: Option<String>,
}

impl trap::TrapEntry for Lifetime {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("lifetimes", vec![id.into()]);
        if let Some(v) = self.text {
            out.add_tuple("lifetime_texts", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for Lifetime {
    fn class_name() -> &'static str { "Lifetime" }
}

impl From<trap::Label<Lifetime>> for trap::Label<UseBoundGenericArg> {
    fn from(value: trap::Label<Lifetime>) -> Self {
        // SAFETY: this is safe because in the dbscheme Lifetime is a subclass of UseBoundGenericArg
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Lifetime>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Lifetime>) -> Self {
        // SAFETY: this is safe because in the dbscheme Lifetime is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Lifetime>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Lifetime>) -> Self {
        // SAFETY: this is safe because in the dbscheme Lifetime is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Lifetime>> for trap::Label<Element> {
    fn from(value: trap::Label<Lifetime>) -> Self {
        // SAFETY: this is safe because in the dbscheme Lifetime is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct LifetimeArg {
    pub id: trap::TrapId<LifetimeArg>,
    pub lifetime: Option<trap::Label<Lifetime>>,
}

impl trap::TrapEntry for LifetimeArg {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("lifetime_args", vec![id.into()]);
        if let Some(v) = self.lifetime {
            out.add_tuple("lifetime_arg_lifetimes", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for LifetimeArg {
    fn class_name() -> &'static str { "LifetimeArg" }
}

impl From<trap::Label<LifetimeArg>> for trap::Label<GenericArg> {
    fn from(value: trap::Label<LifetimeArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme LifetimeArg is a subclass of GenericArg
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LifetimeArg>> for trap::Label<AstNode> {
    fn from(value: trap::Label<LifetimeArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme LifetimeArg is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LifetimeArg>> for trap::Label<Locatable> {
    fn from(value: trap::Label<LifetimeArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme LifetimeArg is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LifetimeArg>> for trap::Label<Element> {
    fn from(value: trap::Label<LifetimeArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme LifetimeArg is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct LifetimeParam {
    pub id: trap::TrapId<LifetimeParam>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub lifetime: Option<trap::Label<Lifetime>>,
    pub type_bound_list: Option<trap::Label<TypeBoundList>>,
}

impl trap::TrapEntry for LifetimeParam {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("lifetime_params", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("lifetime_param_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.lifetime {
            out.add_tuple("lifetime_param_lifetimes", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.type_bound_list {
            out.add_tuple("lifetime_param_type_bound_lists", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for LifetimeParam {
    fn class_name() -> &'static str { "LifetimeParam" }
}

impl From<trap::Label<LifetimeParam>> for trap::Label<GenericParam> {
    fn from(value: trap::Label<LifetimeParam>) -> Self {
        // SAFETY: this is safe because in the dbscheme LifetimeParam is a subclass of GenericParam
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LifetimeParam>> for trap::Label<AstNode> {
    fn from(value: trap::Label<LifetimeParam>) -> Self {
        // SAFETY: this is safe because in the dbscheme LifetimeParam is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LifetimeParam>> for trap::Label<Locatable> {
    fn from(value: trap::Label<LifetimeParam>) -> Self {
        // SAFETY: this is safe because in the dbscheme LifetimeParam is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LifetimeParam>> for trap::Label<Element> {
    fn from(value: trap::Label<LifetimeParam>) -> Self {
        // SAFETY: this is safe because in the dbscheme LifetimeParam is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct LiteralExpr {
    pub id: trap::TrapId<LiteralExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub text_value: Option<String>,
}

impl trap::TrapEntry for LiteralExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("literal_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("literal_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.text_value {
            out.add_tuple("literal_expr_text_values", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for LiteralExpr {
    fn class_name() -> &'static str { "LiteralExpr" }
}

impl From<trap::Label<LiteralExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<LiteralExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LiteralExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LiteralExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<LiteralExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LiteralExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LiteralExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<LiteralExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LiteralExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LiteralExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<LiteralExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LiteralExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct LiteralPat {
    pub id: trap::TrapId<LiteralPat>,
    pub literal: Option<trap::Label<LiteralExpr>>,
}

impl trap::TrapEntry for LiteralPat {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("literal_pats", vec![id.into()]);
        if let Some(v) = self.literal {
            out.add_tuple("literal_pat_literals", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for LiteralPat {
    fn class_name() -> &'static str { "LiteralPat" }
}

impl From<trap::Label<LiteralPat>> for trap::Label<Pat> {
    fn from(value: trap::Label<LiteralPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme LiteralPat is a subclass of Pat
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LiteralPat>> for trap::Label<AstNode> {
    fn from(value: trap::Label<LiteralPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme LiteralPat is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LiteralPat>> for trap::Label<Locatable> {
    fn from(value: trap::Label<LiteralPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme LiteralPat is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LiteralPat>> for trap::Label<Element> {
    fn from(value: trap::Label<LiteralPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme LiteralPat is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct MacroBlockExpr {
    pub id: trap::TrapId<MacroBlockExpr>,
    pub tail_expr: Option<trap::Label<Expr>>,
    pub statements: Vec<trap::Label<Stmt>>,
}

impl trap::TrapEntry for MacroBlockExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("macro_block_exprs", vec![id.into()]);
        if let Some(v) = self.tail_expr {
            out.add_tuple("macro_block_expr_tail_exprs", vec![id.into(), v.into()]);
        }
        for (i, v) in self.statements.into_iter().enumerate() {
            out.add_tuple("macro_block_expr_statements", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for MacroBlockExpr {
    fn class_name() -> &'static str { "MacroBlockExpr" }
}

impl From<trap::Label<MacroBlockExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<MacroBlockExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroBlockExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroBlockExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<MacroBlockExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroBlockExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroBlockExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<MacroBlockExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroBlockExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroBlockExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<MacroBlockExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroBlockExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct MacroExpr {
    pub id: trap::TrapId<MacroExpr>,
    pub macro_call: Option<trap::Label<MacroCall>>,
}

impl trap::TrapEntry for MacroExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("macro_exprs", vec![id.into()]);
        if let Some(v) = self.macro_call {
            out.add_tuple("macro_expr_macro_calls", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for MacroExpr {
    fn class_name() -> &'static str { "MacroExpr" }
}

impl From<trap::Label<MacroExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<MacroExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<MacroExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<MacroExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<MacroExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct MacroPat {
    pub id: trap::TrapId<MacroPat>,
    pub macro_call: Option<trap::Label<MacroCall>>,
}

impl trap::TrapEntry for MacroPat {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("macro_pats", vec![id.into()]);
        if let Some(v) = self.macro_call {
            out.add_tuple("macro_pat_macro_calls", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for MacroPat {
    fn class_name() -> &'static str { "MacroPat" }
}

impl From<trap::Label<MacroPat>> for trap::Label<Pat> {
    fn from(value: trap::Label<MacroPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroPat is a subclass of Pat
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroPat>> for trap::Label<AstNode> {
    fn from(value: trap::Label<MacroPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroPat is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroPat>> for trap::Label<Locatable> {
    fn from(value: trap::Label<MacroPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroPat is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroPat>> for trap::Label<Element> {
    fn from(value: trap::Label<MacroPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroPat is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct MacroTypeRepr {
    pub id: trap::TrapId<MacroTypeRepr>,
    pub macro_call: Option<trap::Label<MacroCall>>,
}

impl trap::TrapEntry for MacroTypeRepr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("macro_type_reprs", vec![id.into()]);
        if let Some(v) = self.macro_call {
            out.add_tuple("macro_type_repr_macro_calls", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for MacroTypeRepr {
    fn class_name() -> &'static str { "MacroTypeRepr" }
}

impl From<trap::Label<MacroTypeRepr>> for trap::Label<TypeRepr> {
    fn from(value: trap::Label<MacroTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroTypeRepr is a subclass of TypeRepr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroTypeRepr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<MacroTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroTypeRepr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroTypeRepr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<MacroTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroTypeRepr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroTypeRepr>> for trap::Label<Element> {
    fn from(value: trap::Label<MacroTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroTypeRepr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct MatchExpr {
    pub id: trap::TrapId<MatchExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub scrutinee: Option<trap::Label<Expr>>,
    pub match_arm_list: Option<trap::Label<MatchArmList>>,
}

impl trap::TrapEntry for MatchExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("match_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("match_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.scrutinee {
            out.add_tuple("match_expr_scrutinees", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.match_arm_list {
            out.add_tuple("match_expr_match_arm_lists", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for MatchExpr {
    fn class_name() -> &'static str { "MatchExpr" }
}

impl From<trap::Label<MatchExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<MatchExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MatchExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MatchExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<MatchExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MatchExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MatchExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<MatchExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MatchExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MatchExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<MatchExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MatchExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct NameRef {
    pub id: trap::TrapId<NameRef>,
    pub text: Option<String>,
}

impl trap::TrapEntry for NameRef {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("name_refs", vec![id.into()]);
        if let Some(v) = self.text {
            out.add_tuple("name_ref_texts", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for NameRef {
    fn class_name() -> &'static str { "NameRef" }
}

impl From<trap::Label<NameRef>> for trap::Label<UseBoundGenericArg> {
    fn from(value: trap::Label<NameRef>) -> Self {
        // SAFETY: this is safe because in the dbscheme NameRef is a subclass of UseBoundGenericArg
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<NameRef>> for trap::Label<AstNode> {
    fn from(value: trap::Label<NameRef>) -> Self {
        // SAFETY: this is safe because in the dbscheme NameRef is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<NameRef>> for trap::Label<Locatable> {
    fn from(value: trap::Label<NameRef>) -> Self {
        // SAFETY: this is safe because in the dbscheme NameRef is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<NameRef>> for trap::Label<Element> {
    fn from(value: trap::Label<NameRef>) -> Self {
        // SAFETY: this is safe because in the dbscheme NameRef is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct NeverTypeRepr {
    pub id: trap::TrapId<NeverTypeRepr>,
}

impl trap::TrapEntry for NeverTypeRepr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("never_type_reprs", vec![id.into()]);
    }
}

impl trap::TrapClass for NeverTypeRepr {
    fn class_name() -> &'static str { "NeverTypeRepr" }
}

impl From<trap::Label<NeverTypeRepr>> for trap::Label<TypeRepr> {
    fn from(value: trap::Label<NeverTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme NeverTypeRepr is a subclass of TypeRepr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<NeverTypeRepr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<NeverTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme NeverTypeRepr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<NeverTypeRepr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<NeverTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme NeverTypeRepr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<NeverTypeRepr>> for trap::Label<Element> {
    fn from(value: trap::Label<NeverTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme NeverTypeRepr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct OffsetOfExpr {
    pub id: trap::TrapId<OffsetOfExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub fields: Vec<trap::Label<NameRef>>,
    pub type_repr: Option<trap::Label<TypeRepr>>,
}

impl trap::TrapEntry for OffsetOfExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("offset_of_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("offset_of_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        for (i, v) in self.fields.into_iter().enumerate() {
            out.add_tuple("offset_of_expr_fields", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.type_repr {
            out.add_tuple("offset_of_expr_type_reprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for OffsetOfExpr {
    fn class_name() -> &'static str { "OffsetOfExpr" }
}

impl From<trap::Label<OffsetOfExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<OffsetOfExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme OffsetOfExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<OffsetOfExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<OffsetOfExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme OffsetOfExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<OffsetOfExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<OffsetOfExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme OffsetOfExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<OffsetOfExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<OffsetOfExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme OffsetOfExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct OrPat {
    pub id: trap::TrapId<OrPat>,
    pub pats: Vec<trap::Label<Pat>>,
}

impl trap::TrapEntry for OrPat {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("or_pats", vec![id.into()]);
        for (i, v) in self.pats.into_iter().enumerate() {
            out.add_tuple("or_pat_pats", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for OrPat {
    fn class_name() -> &'static str { "OrPat" }
}

impl From<trap::Label<OrPat>> for trap::Label<Pat> {
    fn from(value: trap::Label<OrPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme OrPat is a subclass of Pat
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<OrPat>> for trap::Label<AstNode> {
    fn from(value: trap::Label<OrPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme OrPat is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<OrPat>> for trap::Label<Locatable> {
    fn from(value: trap::Label<OrPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme OrPat is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<OrPat>> for trap::Label<Element> {
    fn from(value: trap::Label<OrPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme OrPat is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Param {
    pub id: trap::TrapId<Param>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub type_repr: Option<trap::Label<TypeRepr>>,
    pub pat: Option<trap::Label<Pat>>,
}

impl trap::TrapEntry for Param {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("params", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("param_base_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.type_repr {
            out.add_tuple("param_base_type_reprs", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.pat {
            out.add_tuple("param_pats", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for Param {
    fn class_name() -> &'static str { "Param" }
}

impl From<trap::Label<Param>> for trap::Label<ParamBase> {
    fn from(value: trap::Label<Param>) -> Self {
        // SAFETY: this is safe because in the dbscheme Param is a subclass of ParamBase
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Param>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Param>) -> Self {
        // SAFETY: this is safe because in the dbscheme Param is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Param>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Param>) -> Self {
        // SAFETY: this is safe because in the dbscheme Param is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Param>> for trap::Label<Element> {
    fn from(value: trap::Label<Param>) -> Self {
        // SAFETY: this is safe because in the dbscheme Param is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ParenExpr {
    pub id: trap::TrapId<ParenExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub expr: Option<trap::Label<Expr>>,
}

impl trap::TrapEntry for ParenExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("paren_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("paren_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.expr {
            out.add_tuple("paren_expr_exprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for ParenExpr {
    fn class_name() -> &'static str { "ParenExpr" }
}

impl From<trap::Label<ParenExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<ParenExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ParenExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ParenExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ParenExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ParenExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ParenExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ParenExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ParenExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ParenExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<ParenExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ParenExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ParenPat {
    pub id: trap::TrapId<ParenPat>,
    pub pat: Option<trap::Label<Pat>>,
}

impl trap::TrapEntry for ParenPat {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("paren_pats", vec![id.into()]);
        if let Some(v) = self.pat {
            out.add_tuple("paren_pat_pats", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for ParenPat {
    fn class_name() -> &'static str { "ParenPat" }
}

impl From<trap::Label<ParenPat>> for trap::Label<Pat> {
    fn from(value: trap::Label<ParenPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme ParenPat is a subclass of Pat
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ParenPat>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ParenPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme ParenPat is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ParenPat>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ParenPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme ParenPat is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ParenPat>> for trap::Label<Element> {
    fn from(value: trap::Label<ParenPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme ParenPat is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ParenTypeRepr {
    pub id: trap::TrapId<ParenTypeRepr>,
    pub type_repr: Option<trap::Label<TypeRepr>>,
}

impl trap::TrapEntry for ParenTypeRepr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("paren_type_reprs", vec![id.into()]);
        if let Some(v) = self.type_repr {
            out.add_tuple("paren_type_repr_type_reprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for ParenTypeRepr {
    fn class_name() -> &'static str { "ParenTypeRepr" }
}

impl From<trap::Label<ParenTypeRepr>> for trap::Label<TypeRepr> {
    fn from(value: trap::Label<ParenTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ParenTypeRepr is a subclass of TypeRepr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ParenTypeRepr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ParenTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ParenTypeRepr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ParenTypeRepr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ParenTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ParenTypeRepr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ParenTypeRepr>> for trap::Label<Element> {
    fn from(value: trap::Label<ParenTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ParenTypeRepr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct PathAstNode {
    _unused: ()
}

impl trap::TrapClass for PathAstNode {
    fn class_name() -> &'static str { "PathAstNode" }
}

impl From<trap::Label<PathAstNode>> for trap::Label<Resolvable> {
    fn from(value: trap::Label<PathAstNode>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathAstNode is a subclass of Resolvable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathAstNode>> for trap::Label<AstNode> {
    fn from(value: trap::Label<PathAstNode>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathAstNode is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathAstNode>> for trap::Label<Locatable> {
    fn from(value: trap::Label<PathAstNode>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathAstNode is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathAstNode>> for trap::Label<Element> {
    fn from(value: trap::Label<PathAstNode>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathAstNode is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct PathExprBase {
    _unused: ()
}

impl trap::TrapClass for PathExprBase {
    fn class_name() -> &'static str { "PathExprBase" }
}

impl From<trap::Label<PathExprBase>> for trap::Label<Expr> {
    fn from(value: trap::Label<PathExprBase>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathExprBase is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathExprBase>> for trap::Label<AstNode> {
    fn from(value: trap::Label<PathExprBase>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathExprBase is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathExprBase>> for trap::Label<Locatable> {
    fn from(value: trap::Label<PathExprBase>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathExprBase is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathExprBase>> for trap::Label<Element> {
    fn from(value: trap::Label<PathExprBase>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathExprBase is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct PathTypeRepr {
    pub id: trap::TrapId<PathTypeRepr>,
    pub path: Option<trap::Label<Path>>,
}

impl trap::TrapEntry for PathTypeRepr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("path_type_reprs", vec![id.into()]);
        if let Some(v) = self.path {
            out.add_tuple("path_type_repr_paths", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for PathTypeRepr {
    fn class_name() -> &'static str { "PathTypeRepr" }
}

impl From<trap::Label<PathTypeRepr>> for trap::Label<TypeRepr> {
    fn from(value: trap::Label<PathTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathTypeRepr is a subclass of TypeRepr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathTypeRepr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<PathTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathTypeRepr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathTypeRepr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<PathTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathTypeRepr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathTypeRepr>> for trap::Label<Element> {
    fn from(value: trap::Label<PathTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathTypeRepr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct PrefixExpr {
    pub id: trap::TrapId<PrefixExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub expr: Option<trap::Label<Expr>>,
    pub operator_name: Option<String>,
}

impl trap::TrapEntry for PrefixExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("prefix_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("prefix_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.expr {
            out.add_tuple("prefix_expr_exprs", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.operator_name {
            out.add_tuple("prefix_expr_operator_names", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for PrefixExpr {
    fn class_name() -> &'static str { "PrefixExpr" }
}

impl From<trap::Label<PrefixExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<PrefixExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme PrefixExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PrefixExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<PrefixExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme PrefixExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PrefixExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<PrefixExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme PrefixExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PrefixExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<PrefixExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme PrefixExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct PtrTypeRepr {
    pub id: trap::TrapId<PtrTypeRepr>,
    pub is_const: bool,
    pub is_mut: bool,
    pub type_repr: Option<trap::Label<TypeRepr>>,
}

impl trap::TrapEntry for PtrTypeRepr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("ptr_type_reprs", vec![id.into()]);
        if self.is_const {
            out.add_tuple("ptr_type_repr_is_const", vec![id.into()]);
        }
        if self.is_mut {
            out.add_tuple("ptr_type_repr_is_mut", vec![id.into()]);
        }
        if let Some(v) = self.type_repr {
            out.add_tuple("ptr_type_repr_type_reprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for PtrTypeRepr {
    fn class_name() -> &'static str { "PtrTypeRepr" }
}

impl From<trap::Label<PtrTypeRepr>> for trap::Label<TypeRepr> {
    fn from(value: trap::Label<PtrTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme PtrTypeRepr is a subclass of TypeRepr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PtrTypeRepr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<PtrTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme PtrTypeRepr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PtrTypeRepr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<PtrTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme PtrTypeRepr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PtrTypeRepr>> for trap::Label<Element> {
    fn from(value: trap::Label<PtrTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme PtrTypeRepr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct RangeExpr {
    pub id: trap::TrapId<RangeExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub end: Option<trap::Label<Expr>>,
    pub operator_name: Option<String>,
    pub start: Option<trap::Label<Expr>>,
}

impl trap::TrapEntry for RangeExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("range_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("range_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.end {
            out.add_tuple("range_expr_ends", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.operator_name {
            out.add_tuple("range_expr_operator_names", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.start {
            out.add_tuple("range_expr_starts", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for RangeExpr {
    fn class_name() -> &'static str { "RangeExpr" }
}

impl From<trap::Label<RangeExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<RangeExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme RangeExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<RangeExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<RangeExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme RangeExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<RangeExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<RangeExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme RangeExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<RangeExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<RangeExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme RangeExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct RangePat {
    pub id: trap::TrapId<RangePat>,
    pub end: Option<trap::Label<Pat>>,
    pub operator_name: Option<String>,
    pub start: Option<trap::Label<Pat>>,
}

impl trap::TrapEntry for RangePat {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("range_pats", vec![id.into()]);
        if let Some(v) = self.end {
            out.add_tuple("range_pat_ends", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.operator_name {
            out.add_tuple("range_pat_operator_names", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.start {
            out.add_tuple("range_pat_starts", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for RangePat {
    fn class_name() -> &'static str { "RangePat" }
}

impl From<trap::Label<RangePat>> for trap::Label<Pat> {
    fn from(value: trap::Label<RangePat>) -> Self {
        // SAFETY: this is safe because in the dbscheme RangePat is a subclass of Pat
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<RangePat>> for trap::Label<AstNode> {
    fn from(value: trap::Label<RangePat>) -> Self {
        // SAFETY: this is safe because in the dbscheme RangePat is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<RangePat>> for trap::Label<Locatable> {
    fn from(value: trap::Label<RangePat>) -> Self {
        // SAFETY: this is safe because in the dbscheme RangePat is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<RangePat>> for trap::Label<Element> {
    fn from(value: trap::Label<RangePat>) -> Self {
        // SAFETY: this is safe because in the dbscheme RangePat is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct RefExpr {
    pub id: trap::TrapId<RefExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub expr: Option<trap::Label<Expr>>,
    pub is_const: bool,
    pub is_mut: bool,
    pub is_raw: bool,
}

impl trap::TrapEntry for RefExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("ref_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("ref_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.expr {
            out.add_tuple("ref_expr_exprs", vec![id.into(), v.into()]);
        }
        if self.is_const {
            out.add_tuple("ref_expr_is_const", vec![id.into()]);
        }
        if self.is_mut {
            out.add_tuple("ref_expr_is_mut", vec![id.into()]);
        }
        if self.is_raw {
            out.add_tuple("ref_expr_is_raw", vec![id.into()]);
        }
    }
}

impl trap::TrapClass for RefExpr {
    fn class_name() -> &'static str { "RefExpr" }
}

impl From<trap::Label<RefExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<RefExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme RefExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<RefExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<RefExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme RefExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<RefExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<RefExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme RefExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<RefExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<RefExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme RefExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct RefPat {
    pub id: trap::TrapId<RefPat>,
    pub is_mut: bool,
    pub pat: Option<trap::Label<Pat>>,
}

impl trap::TrapEntry for RefPat {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("ref_pats", vec![id.into()]);
        if self.is_mut {
            out.add_tuple("ref_pat_is_mut", vec![id.into()]);
        }
        if let Some(v) = self.pat {
            out.add_tuple("ref_pat_pats", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for RefPat {
    fn class_name() -> &'static str { "RefPat" }
}

impl From<trap::Label<RefPat>> for trap::Label<Pat> {
    fn from(value: trap::Label<RefPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme RefPat is a subclass of Pat
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<RefPat>> for trap::Label<AstNode> {
    fn from(value: trap::Label<RefPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme RefPat is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<RefPat>> for trap::Label<Locatable> {
    fn from(value: trap::Label<RefPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme RefPat is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<RefPat>> for trap::Label<Element> {
    fn from(value: trap::Label<RefPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme RefPat is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct RefTypeRepr {
    pub id: trap::TrapId<RefTypeRepr>,
    pub is_mut: bool,
    pub lifetime: Option<trap::Label<Lifetime>>,
    pub type_repr: Option<trap::Label<TypeRepr>>,
}

impl trap::TrapEntry for RefTypeRepr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("ref_type_reprs", vec![id.into()]);
        if self.is_mut {
            out.add_tuple("ref_type_repr_is_mut", vec![id.into()]);
        }
        if let Some(v) = self.lifetime {
            out.add_tuple("ref_type_repr_lifetimes", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.type_repr {
            out.add_tuple("ref_type_repr_type_reprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for RefTypeRepr {
    fn class_name() -> &'static str { "RefTypeRepr" }
}

impl From<trap::Label<RefTypeRepr>> for trap::Label<TypeRepr> {
    fn from(value: trap::Label<RefTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme RefTypeRepr is a subclass of TypeRepr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<RefTypeRepr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<RefTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme RefTypeRepr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<RefTypeRepr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<RefTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme RefTypeRepr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<RefTypeRepr>> for trap::Label<Element> {
    fn from(value: trap::Label<RefTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme RefTypeRepr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct RestPat {
    pub id: trap::TrapId<RestPat>,
    pub attrs: Vec<trap::Label<Attr>>,
}

impl trap::TrapEntry for RestPat {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("rest_pats", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("rest_pat_attrs", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for RestPat {
    fn class_name() -> &'static str { "RestPat" }
}

impl From<trap::Label<RestPat>> for trap::Label<Pat> {
    fn from(value: trap::Label<RestPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme RestPat is a subclass of Pat
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<RestPat>> for trap::Label<AstNode> {
    fn from(value: trap::Label<RestPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme RestPat is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<RestPat>> for trap::Label<Locatable> {
    fn from(value: trap::Label<RestPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme RestPat is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<RestPat>> for trap::Label<Element> {
    fn from(value: trap::Label<RestPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme RestPat is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ReturnExpr {
    pub id: trap::TrapId<ReturnExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub expr: Option<trap::Label<Expr>>,
}

impl trap::TrapEntry for ReturnExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("return_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("return_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.expr {
            out.add_tuple("return_expr_exprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for ReturnExpr {
    fn class_name() -> &'static str { "ReturnExpr" }
}

impl From<trap::Label<ReturnExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<ReturnExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ReturnExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ReturnExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ReturnExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ReturnExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ReturnExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ReturnExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ReturnExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ReturnExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<ReturnExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ReturnExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct SelfParam {
    pub id: trap::TrapId<SelfParam>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub type_repr: Option<trap::Label<TypeRepr>>,
    pub is_ref: bool,
    pub is_mut: bool,
    pub lifetime: Option<trap::Label<Lifetime>>,
    pub name: Option<trap::Label<Name>>,
}

impl trap::TrapEntry for SelfParam {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("self_params", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("param_base_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.type_repr {
            out.add_tuple("param_base_type_reprs", vec![id.into(), v.into()]);
        }
        if self.is_ref {
            out.add_tuple("self_param_is_ref", vec![id.into()]);
        }
        if self.is_mut {
            out.add_tuple("self_param_is_mut", vec![id.into()]);
        }
        if let Some(v) = self.lifetime {
            out.add_tuple("self_param_lifetimes", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.name {
            out.add_tuple("self_param_names", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for SelfParam {
    fn class_name() -> &'static str { "SelfParam" }
}

impl From<trap::Label<SelfParam>> for trap::Label<ParamBase> {
    fn from(value: trap::Label<SelfParam>) -> Self {
        // SAFETY: this is safe because in the dbscheme SelfParam is a subclass of ParamBase
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<SelfParam>> for trap::Label<AstNode> {
    fn from(value: trap::Label<SelfParam>) -> Self {
        // SAFETY: this is safe because in the dbscheme SelfParam is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<SelfParam>> for trap::Label<Locatable> {
    fn from(value: trap::Label<SelfParam>) -> Self {
        // SAFETY: this is safe because in the dbscheme SelfParam is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<SelfParam>> for trap::Label<Element> {
    fn from(value: trap::Label<SelfParam>) -> Self {
        // SAFETY: this is safe because in the dbscheme SelfParam is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct SlicePat {
    pub id: trap::TrapId<SlicePat>,
    pub pats: Vec<trap::Label<Pat>>,
}

impl trap::TrapEntry for SlicePat {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("slice_pats", vec![id.into()]);
        for (i, v) in self.pats.into_iter().enumerate() {
            out.add_tuple("slice_pat_pats", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for SlicePat {
    fn class_name() -> &'static str { "SlicePat" }
}

impl From<trap::Label<SlicePat>> for trap::Label<Pat> {
    fn from(value: trap::Label<SlicePat>) -> Self {
        // SAFETY: this is safe because in the dbscheme SlicePat is a subclass of Pat
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<SlicePat>> for trap::Label<AstNode> {
    fn from(value: trap::Label<SlicePat>) -> Self {
        // SAFETY: this is safe because in the dbscheme SlicePat is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<SlicePat>> for trap::Label<Locatable> {
    fn from(value: trap::Label<SlicePat>) -> Self {
        // SAFETY: this is safe because in the dbscheme SlicePat is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<SlicePat>> for trap::Label<Element> {
    fn from(value: trap::Label<SlicePat>) -> Self {
        // SAFETY: this is safe because in the dbscheme SlicePat is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct SliceTypeRepr {
    pub id: trap::TrapId<SliceTypeRepr>,
    pub type_repr: Option<trap::Label<TypeRepr>>,
}

impl trap::TrapEntry for SliceTypeRepr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("slice_type_reprs", vec![id.into()]);
        if let Some(v) = self.type_repr {
            out.add_tuple("slice_type_repr_type_reprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for SliceTypeRepr {
    fn class_name() -> &'static str { "SliceTypeRepr" }
}

impl From<trap::Label<SliceTypeRepr>> for trap::Label<TypeRepr> {
    fn from(value: trap::Label<SliceTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme SliceTypeRepr is a subclass of TypeRepr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<SliceTypeRepr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<SliceTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme SliceTypeRepr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<SliceTypeRepr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<SliceTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme SliceTypeRepr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<SliceTypeRepr>> for trap::Label<Element> {
    fn from(value: trap::Label<SliceTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme SliceTypeRepr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct StructFieldList {
    pub id: trap::TrapId<StructFieldList>,
    pub fields: Vec<trap::Label<StructField>>,
}

impl trap::TrapEntry for StructFieldList {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("struct_field_lists", vec![id.into()]);
        for (i, v) in self.fields.into_iter().enumerate() {
            out.add_tuple("struct_field_list_fields", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for StructFieldList {
    fn class_name() -> &'static str { "StructFieldList" }
}

impl From<trap::Label<StructFieldList>> for trap::Label<FieldList> {
    fn from(value: trap::Label<StructFieldList>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructFieldList is a subclass of FieldList
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructFieldList>> for trap::Label<AstNode> {
    fn from(value: trap::Label<StructFieldList>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructFieldList is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructFieldList>> for trap::Label<Locatable> {
    fn from(value: trap::Label<StructFieldList>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructFieldList is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructFieldList>> for trap::Label<Element> {
    fn from(value: trap::Label<StructFieldList>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructFieldList is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct TryExpr {
    pub id: trap::TrapId<TryExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub expr: Option<trap::Label<Expr>>,
}

impl trap::TrapEntry for TryExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("try_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("try_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.expr {
            out.add_tuple("try_expr_exprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for TryExpr {
    fn class_name() -> &'static str { "TryExpr" }
}

impl From<trap::Label<TryExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<TryExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme TryExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TryExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<TryExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme TryExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TryExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<TryExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme TryExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TryExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<TryExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme TryExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct TupleExpr {
    pub id: trap::TrapId<TupleExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub fields: Vec<trap::Label<Expr>>,
}

impl trap::TrapEntry for TupleExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("tuple_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("tuple_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        for (i, v) in self.fields.into_iter().enumerate() {
            out.add_tuple("tuple_expr_fields", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for TupleExpr {
    fn class_name() -> &'static str { "TupleExpr" }
}

impl From<trap::Label<TupleExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<TupleExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme TupleExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TupleExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<TupleExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme TupleExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TupleExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<TupleExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme TupleExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TupleExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<TupleExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme TupleExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct TupleFieldList {
    pub id: trap::TrapId<TupleFieldList>,
    pub fields: Vec<trap::Label<TupleField>>,
}

impl trap::TrapEntry for TupleFieldList {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("tuple_field_lists", vec![id.into()]);
        for (i, v) in self.fields.into_iter().enumerate() {
            out.add_tuple("tuple_field_list_fields", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for TupleFieldList {
    fn class_name() -> &'static str { "TupleFieldList" }
}

impl From<trap::Label<TupleFieldList>> for trap::Label<FieldList> {
    fn from(value: trap::Label<TupleFieldList>) -> Self {
        // SAFETY: this is safe because in the dbscheme TupleFieldList is a subclass of FieldList
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TupleFieldList>> for trap::Label<AstNode> {
    fn from(value: trap::Label<TupleFieldList>) -> Self {
        // SAFETY: this is safe because in the dbscheme TupleFieldList is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TupleFieldList>> for trap::Label<Locatable> {
    fn from(value: trap::Label<TupleFieldList>) -> Self {
        // SAFETY: this is safe because in the dbscheme TupleFieldList is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TupleFieldList>> for trap::Label<Element> {
    fn from(value: trap::Label<TupleFieldList>) -> Self {
        // SAFETY: this is safe because in the dbscheme TupleFieldList is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct TuplePat {
    pub id: trap::TrapId<TuplePat>,
    pub fields: Vec<trap::Label<Pat>>,
}

impl trap::TrapEntry for TuplePat {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("tuple_pats", vec![id.into()]);
        for (i, v) in self.fields.into_iter().enumerate() {
            out.add_tuple("tuple_pat_fields", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for TuplePat {
    fn class_name() -> &'static str { "TuplePat" }
}

impl From<trap::Label<TuplePat>> for trap::Label<Pat> {
    fn from(value: trap::Label<TuplePat>) -> Self {
        // SAFETY: this is safe because in the dbscheme TuplePat is a subclass of Pat
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TuplePat>> for trap::Label<AstNode> {
    fn from(value: trap::Label<TuplePat>) -> Self {
        // SAFETY: this is safe because in the dbscheme TuplePat is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TuplePat>> for trap::Label<Locatable> {
    fn from(value: trap::Label<TuplePat>) -> Self {
        // SAFETY: this is safe because in the dbscheme TuplePat is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TuplePat>> for trap::Label<Element> {
    fn from(value: trap::Label<TuplePat>) -> Self {
        // SAFETY: this is safe because in the dbscheme TuplePat is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct TupleTypeRepr {
    pub id: trap::TrapId<TupleTypeRepr>,
    pub fields: Vec<trap::Label<TypeRepr>>,
}

impl trap::TrapEntry for TupleTypeRepr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("tuple_type_reprs", vec![id.into()]);
        for (i, v) in self.fields.into_iter().enumerate() {
            out.add_tuple("tuple_type_repr_fields", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for TupleTypeRepr {
    fn class_name() -> &'static str { "TupleTypeRepr" }
}

impl From<trap::Label<TupleTypeRepr>> for trap::Label<TypeRepr> {
    fn from(value: trap::Label<TupleTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme TupleTypeRepr is a subclass of TypeRepr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TupleTypeRepr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<TupleTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme TupleTypeRepr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TupleTypeRepr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<TupleTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme TupleTypeRepr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TupleTypeRepr>> for trap::Label<Element> {
    fn from(value: trap::Label<TupleTypeRepr>) -> Self {
        // SAFETY: this is safe because in the dbscheme TupleTypeRepr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct TypeArg {
    pub id: trap::TrapId<TypeArg>,
    pub type_repr: Option<trap::Label<TypeRepr>>,
}

impl trap::TrapEntry for TypeArg {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("type_args", vec![id.into()]);
        if let Some(v) = self.type_repr {
            out.add_tuple("type_arg_type_reprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for TypeArg {
    fn class_name() -> &'static str { "TypeArg" }
}

impl From<trap::Label<TypeArg>> for trap::Label<GenericArg> {
    fn from(value: trap::Label<TypeArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeArg is a subclass of GenericArg
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TypeArg>> for trap::Label<AstNode> {
    fn from(value: trap::Label<TypeArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeArg is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TypeArg>> for trap::Label<Locatable> {
    fn from(value: trap::Label<TypeArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeArg is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TypeArg>> for trap::Label<Element> {
    fn from(value: trap::Label<TypeArg>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeArg is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct TypeParam {
    pub id: trap::TrapId<TypeParam>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub default_type: Option<trap::Label<TypeRepr>>,
    pub name: Option<trap::Label<Name>>,
    pub type_bound_list: Option<trap::Label<TypeBoundList>>,
}

impl trap::TrapEntry for TypeParam {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("type_params", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("type_param_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.default_type {
            out.add_tuple("type_param_default_types", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.name {
            out.add_tuple("type_param_names", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.type_bound_list {
            out.add_tuple("type_param_type_bound_lists", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for TypeParam {
    fn class_name() -> &'static str { "TypeParam" }
}

impl From<trap::Label<TypeParam>> for trap::Label<GenericParam> {
    fn from(value: trap::Label<TypeParam>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeParam is a subclass of GenericParam
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TypeParam>> for trap::Label<AstNode> {
    fn from(value: trap::Label<TypeParam>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeParam is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TypeParam>> for trap::Label<Locatable> {
    fn from(value: trap::Label<TypeParam>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeParam is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TypeParam>> for trap::Label<Element> {
    fn from(value: trap::Label<TypeParam>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeParam is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct UnderscoreExpr {
    pub id: trap::TrapId<UnderscoreExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
}

impl trap::TrapEntry for UnderscoreExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("underscore_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("underscore_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for UnderscoreExpr {
    fn class_name() -> &'static str { "UnderscoreExpr" }
}

impl From<trap::Label<UnderscoreExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<UnderscoreExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme UnderscoreExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<UnderscoreExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<UnderscoreExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme UnderscoreExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<UnderscoreExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<UnderscoreExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme UnderscoreExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<UnderscoreExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<UnderscoreExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme UnderscoreExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Variant {
    pub id: trap::TrapId<Variant>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub discriminant: Option<trap::Label<Expr>>,
    pub field_list: Option<trap::Label<FieldList>>,
    pub name: Option<trap::Label<Name>>,
    pub visibility: Option<trap::Label<Visibility>>,
}

impl trap::TrapEntry for Variant {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("variants", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("variant_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.discriminant {
            out.add_tuple("variant_discriminants", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.field_list {
            out.add_tuple("variant_field_lists", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.name {
            out.add_tuple("variant_names", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.visibility {
            out.add_tuple("variant_visibilities", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for Variant {
    fn class_name() -> &'static str { "Variant" }
}

impl From<trap::Label<Variant>> for trap::Label<Addressable> {
    fn from(value: trap::Label<Variant>) -> Self {
        // SAFETY: this is safe because in the dbscheme Variant is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Variant>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Variant>) -> Self {
        // SAFETY: this is safe because in the dbscheme Variant is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Variant>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Variant>) -> Self {
        // SAFETY: this is safe because in the dbscheme Variant is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Variant>> for trap::Label<Element> {
    fn from(value: trap::Label<Variant>) -> Self {
        // SAFETY: this is safe because in the dbscheme Variant is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct WildcardPat {
    pub id: trap::TrapId<WildcardPat>,
}

impl trap::TrapEntry for WildcardPat {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("wildcard_pats", vec![id.into()]);
    }
}

impl trap::TrapClass for WildcardPat {
    fn class_name() -> &'static str { "WildcardPat" }
}

impl From<trap::Label<WildcardPat>> for trap::Label<Pat> {
    fn from(value: trap::Label<WildcardPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme WildcardPat is a subclass of Pat
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<WildcardPat>> for trap::Label<AstNode> {
    fn from(value: trap::Label<WildcardPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme WildcardPat is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<WildcardPat>> for trap::Label<Locatable> {
    fn from(value: trap::Label<WildcardPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme WildcardPat is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<WildcardPat>> for trap::Label<Element> {
    fn from(value: trap::Label<WildcardPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme WildcardPat is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct YeetExpr {
    pub id: trap::TrapId<YeetExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub expr: Option<trap::Label<Expr>>,
}

impl trap::TrapEntry for YeetExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("yeet_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("yeet_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.expr {
            out.add_tuple("yeet_expr_exprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for YeetExpr {
    fn class_name() -> &'static str { "YeetExpr" }
}

impl From<trap::Label<YeetExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<YeetExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme YeetExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<YeetExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<YeetExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme YeetExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<YeetExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<YeetExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme YeetExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<YeetExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<YeetExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme YeetExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct YieldExpr {
    pub id: trap::TrapId<YieldExpr>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub expr: Option<trap::Label<Expr>>,
}

impl trap::TrapEntry for YieldExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("yield_exprs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("yield_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.expr {
            out.add_tuple("yield_expr_exprs", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for YieldExpr {
    fn class_name() -> &'static str { "YieldExpr" }
}

impl From<trap::Label<YieldExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<YieldExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme YieldExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<YieldExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<YieldExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme YieldExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<YieldExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<YieldExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme YieldExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<YieldExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<YieldExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme YieldExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Adt {
    _unused: ()
}

impl Adt {
    pub fn emit_derive_macro_expansion(id: trap::Label<Self>, i: usize, value: trap::Label<MacroItems>, out: &mut trap::Writer) {
        out.add_tuple("adt_derive_macro_expansions", vec![id.into(), i.into(), value.into()]);
    }

    pub fn emit_derive_macro_expansions(id: trap::Label<Self>, values: impl IntoIterator<Item=trap::Label<MacroItems>>, out: &mut trap::Writer) {
        values
            .into_iter()
            .enumerate()
            .for_each(|(i, value)| Self::emit_derive_macro_expansion(id, i, value, out));
    }
}

impl trap::TrapClass for Adt {
    fn class_name() -> &'static str { "Adt" }
}

impl From<trap::Label<Adt>> for trap::Label<Item> {
    fn from(value: trap::Label<Adt>) -> Self {
        // SAFETY: this is safe because in the dbscheme Adt is a subclass of Item
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Adt>> for trap::Label<Stmt> {
    fn from(value: trap::Label<Adt>) -> Self {
        // SAFETY: this is safe because in the dbscheme Adt is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Adt>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Adt>) -> Self {
        // SAFETY: this is safe because in the dbscheme Adt is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Adt>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Adt>) -> Self {
        // SAFETY: this is safe because in the dbscheme Adt is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Adt>> for trap::Label<Element> {
    fn from(value: trap::Label<Adt>) -> Self {
        // SAFETY: this is safe because in the dbscheme Adt is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Adt>> for trap::Label<Addressable> {
    fn from(value: trap::Label<Adt>) -> Self {
        // SAFETY: this is safe because in the dbscheme Adt is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct AssocItem {
    _unused: ()
}

impl trap::TrapClass for AssocItem {
    fn class_name() -> &'static str { "AssocItem" }
}

impl From<trap::Label<AssocItem>> for trap::Label<Item> {
    fn from(value: trap::Label<AssocItem>) -> Self {
        // SAFETY: this is safe because in the dbscheme AssocItem is a subclass of Item
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AssocItem>> for trap::Label<Stmt> {
    fn from(value: trap::Label<AssocItem>) -> Self {
        // SAFETY: this is safe because in the dbscheme AssocItem is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AssocItem>> for trap::Label<AstNode> {
    fn from(value: trap::Label<AssocItem>) -> Self {
        // SAFETY: this is safe because in the dbscheme AssocItem is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AssocItem>> for trap::Label<Locatable> {
    fn from(value: trap::Label<AssocItem>) -> Self {
        // SAFETY: this is safe because in the dbscheme AssocItem is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AssocItem>> for trap::Label<Element> {
    fn from(value: trap::Label<AssocItem>) -> Self {
        // SAFETY: this is safe because in the dbscheme AssocItem is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<AssocItem>> for trap::Label<Addressable> {
    fn from(value: trap::Label<AssocItem>) -> Self {
        // SAFETY: this is safe because in the dbscheme AssocItem is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct BlockExpr {
    pub id: trap::TrapId<BlockExpr>,
    pub label: Option<trap::Label<Label>>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub is_async: bool,
    pub is_const: bool,
    pub is_gen: bool,
    pub is_move: bool,
    pub is_try: bool,
    pub is_unsafe: bool,
    pub stmt_list: Option<trap::Label<StmtList>>,
}

impl trap::TrapEntry for BlockExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("block_exprs", vec![id.into()]);
        if let Some(v) = self.label {
            out.add_tuple("labelable_expr_labels", vec![id.into(), v.into()]);
        }
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("block_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if self.is_async {
            out.add_tuple("block_expr_is_async", vec![id.into()]);
        }
        if self.is_const {
            out.add_tuple("block_expr_is_const", vec![id.into()]);
        }
        if self.is_gen {
            out.add_tuple("block_expr_is_gen", vec![id.into()]);
        }
        if self.is_move {
            out.add_tuple("block_expr_is_move", vec![id.into()]);
        }
        if self.is_try {
            out.add_tuple("block_expr_is_try", vec![id.into()]);
        }
        if self.is_unsafe {
            out.add_tuple("block_expr_is_unsafe", vec![id.into()]);
        }
        if let Some(v) = self.stmt_list {
            out.add_tuple("block_expr_stmt_lists", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for BlockExpr {
    fn class_name() -> &'static str { "BlockExpr" }
}

impl From<trap::Label<BlockExpr>> for trap::Label<LabelableExpr> {
    fn from(value: trap::Label<BlockExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme BlockExpr is a subclass of LabelableExpr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<BlockExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<BlockExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme BlockExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<BlockExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<BlockExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme BlockExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<BlockExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<BlockExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme BlockExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<BlockExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<BlockExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme BlockExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct CallExpr {
    pub id: trap::TrapId<CallExpr>,
    pub arg_list: Option<trap::Label<ArgList>>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub function: Option<trap::Label<Expr>>,
}

impl trap::TrapEntry for CallExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("call_exprs", vec![id.into()]);
        if let Some(v) = self.arg_list {
            out.add_tuple("call_expr_base_arg_lists", vec![id.into(), v.into()]);
        }
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("call_expr_base_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.function {
            out.add_tuple("call_expr_functions", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for CallExpr {
    fn class_name() -> &'static str { "CallExpr" }
}

impl From<trap::Label<CallExpr>> for trap::Label<CallExprBase> {
    fn from(value: trap::Label<CallExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme CallExpr is a subclass of CallExprBase
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<CallExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<CallExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme CallExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<CallExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<CallExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme CallExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<CallExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<CallExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme CallExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<CallExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<CallExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme CallExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ExternBlock {
    pub id: trap::TrapId<ExternBlock>,
    pub abi: Option<trap::Label<Abi>>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub extern_item_list: Option<trap::Label<ExternItemList>>,
    pub is_unsafe: bool,
}

impl trap::TrapEntry for ExternBlock {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("extern_blocks", vec![id.into()]);
        if let Some(v) = self.abi {
            out.add_tuple("extern_block_abis", vec![id.into(), v.into()]);
        }
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("extern_block_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.extern_item_list {
            out.add_tuple("extern_block_extern_item_lists", vec![id.into(), v.into()]);
        }
        if self.is_unsafe {
            out.add_tuple("extern_block_is_unsafe", vec![id.into()]);
        }
    }
}

impl trap::TrapClass for ExternBlock {
    fn class_name() -> &'static str { "ExternBlock" }
}

impl From<trap::Label<ExternBlock>> for trap::Label<Item> {
    fn from(value: trap::Label<ExternBlock>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExternBlock is a subclass of Item
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ExternBlock>> for trap::Label<Stmt> {
    fn from(value: trap::Label<ExternBlock>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExternBlock is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ExternBlock>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ExternBlock>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExternBlock is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ExternBlock>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ExternBlock>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExternBlock is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ExternBlock>> for trap::Label<Element> {
    fn from(value: trap::Label<ExternBlock>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExternBlock is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ExternBlock>> for trap::Label<Addressable> {
    fn from(value: trap::Label<ExternBlock>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExternBlock is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ExternCrate {
    pub id: trap::TrapId<ExternCrate>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub identifier: Option<trap::Label<NameRef>>,
    pub rename: Option<trap::Label<Rename>>,
    pub visibility: Option<trap::Label<Visibility>>,
}

impl trap::TrapEntry for ExternCrate {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("extern_crates", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("extern_crate_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.identifier {
            out.add_tuple("extern_crate_identifiers", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.rename {
            out.add_tuple("extern_crate_renames", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.visibility {
            out.add_tuple("extern_crate_visibilities", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for ExternCrate {
    fn class_name() -> &'static str { "ExternCrate" }
}

impl From<trap::Label<ExternCrate>> for trap::Label<Item> {
    fn from(value: trap::Label<ExternCrate>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExternCrate is a subclass of Item
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ExternCrate>> for trap::Label<Stmt> {
    fn from(value: trap::Label<ExternCrate>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExternCrate is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ExternCrate>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ExternCrate>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExternCrate is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ExternCrate>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ExternCrate>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExternCrate is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ExternCrate>> for trap::Label<Element> {
    fn from(value: trap::Label<ExternCrate>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExternCrate is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ExternCrate>> for trap::Label<Addressable> {
    fn from(value: trap::Label<ExternCrate>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExternCrate is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ExternItem {
    _unused: ()
}

impl trap::TrapClass for ExternItem {
    fn class_name() -> &'static str { "ExternItem" }
}

impl From<trap::Label<ExternItem>> for trap::Label<Item> {
    fn from(value: trap::Label<ExternItem>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExternItem is a subclass of Item
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ExternItem>> for trap::Label<Stmt> {
    fn from(value: trap::Label<ExternItem>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExternItem is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ExternItem>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ExternItem>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExternItem is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ExternItem>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ExternItem>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExternItem is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ExternItem>> for trap::Label<Element> {
    fn from(value: trap::Label<ExternItem>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExternItem is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ExternItem>> for trap::Label<Addressable> {
    fn from(value: trap::Label<ExternItem>) -> Self {
        // SAFETY: this is safe because in the dbscheme ExternItem is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Impl {
    pub id: trap::TrapId<Impl>,
    pub assoc_item_list: Option<trap::Label<AssocItemList>>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub generic_param_list: Option<trap::Label<GenericParamList>>,
    pub is_const: bool,
    pub is_default: bool,
    pub is_unsafe: bool,
    pub self_ty: Option<trap::Label<TypeRepr>>,
    pub trait_: Option<trap::Label<TypeRepr>>,
    pub visibility: Option<trap::Label<Visibility>>,
    pub where_clause: Option<trap::Label<WhereClause>>,
}

impl trap::TrapEntry for Impl {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("impls", vec![id.into()]);
        if let Some(v) = self.assoc_item_list {
            out.add_tuple("impl_assoc_item_lists", vec![id.into(), v.into()]);
        }
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("impl_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.generic_param_list {
            out.add_tuple("impl_generic_param_lists", vec![id.into(), v.into()]);
        }
        if self.is_const {
            out.add_tuple("impl_is_const", vec![id.into()]);
        }
        if self.is_default {
            out.add_tuple("impl_is_default", vec![id.into()]);
        }
        if self.is_unsafe {
            out.add_tuple("impl_is_unsafe", vec![id.into()]);
        }
        if let Some(v) = self.self_ty {
            out.add_tuple("impl_self_ties", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.trait_ {
            out.add_tuple("impl_traits", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.visibility {
            out.add_tuple("impl_visibilities", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.where_clause {
            out.add_tuple("impl_where_clauses", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for Impl {
    fn class_name() -> &'static str { "Impl" }
}

impl From<trap::Label<Impl>> for trap::Label<Item> {
    fn from(value: trap::Label<Impl>) -> Self {
        // SAFETY: this is safe because in the dbscheme Impl is a subclass of Item
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Impl>> for trap::Label<Stmt> {
    fn from(value: trap::Label<Impl>) -> Self {
        // SAFETY: this is safe because in the dbscheme Impl is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Impl>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Impl>) -> Self {
        // SAFETY: this is safe because in the dbscheme Impl is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Impl>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Impl>) -> Self {
        // SAFETY: this is safe because in the dbscheme Impl is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Impl>> for trap::Label<Element> {
    fn from(value: trap::Label<Impl>) -> Self {
        // SAFETY: this is safe because in the dbscheme Impl is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Impl>> for trap::Label<Addressable> {
    fn from(value: trap::Label<Impl>) -> Self {
        // SAFETY: this is safe because in the dbscheme Impl is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct LoopingExpr {
    _unused: ()
}

impl trap::TrapClass for LoopingExpr {
    fn class_name() -> &'static str { "LoopingExpr" }
}

impl From<trap::Label<LoopingExpr>> for trap::Label<LabelableExpr> {
    fn from(value: trap::Label<LoopingExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LoopingExpr is a subclass of LabelableExpr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LoopingExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<LoopingExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LoopingExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LoopingExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<LoopingExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LoopingExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LoopingExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<LoopingExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LoopingExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LoopingExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<LoopingExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LoopingExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct MacroDef {
    pub id: trap::TrapId<MacroDef>,
    pub args: Option<trap::Label<TokenTree>>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub body: Option<trap::Label<TokenTree>>,
    pub name: Option<trap::Label<Name>>,
    pub visibility: Option<trap::Label<Visibility>>,
}

impl trap::TrapEntry for MacroDef {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("macro_defs", vec![id.into()]);
        if let Some(v) = self.args {
            out.add_tuple("macro_def_args", vec![id.into(), v.into()]);
        }
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("macro_def_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.body {
            out.add_tuple("macro_def_bodies", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.name {
            out.add_tuple("macro_def_names", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.visibility {
            out.add_tuple("macro_def_visibilities", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for MacroDef {
    fn class_name() -> &'static str { "MacroDef" }
}

impl From<trap::Label<MacroDef>> for trap::Label<Item> {
    fn from(value: trap::Label<MacroDef>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroDef is a subclass of Item
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroDef>> for trap::Label<Stmt> {
    fn from(value: trap::Label<MacroDef>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroDef is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroDef>> for trap::Label<AstNode> {
    fn from(value: trap::Label<MacroDef>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroDef is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroDef>> for trap::Label<Locatable> {
    fn from(value: trap::Label<MacroDef>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroDef is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroDef>> for trap::Label<Element> {
    fn from(value: trap::Label<MacroDef>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroDef is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroDef>> for trap::Label<Addressable> {
    fn from(value: trap::Label<MacroDef>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroDef is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct MacroRules {
    pub id: trap::TrapId<MacroRules>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub name: Option<trap::Label<Name>>,
    pub token_tree: Option<trap::Label<TokenTree>>,
    pub visibility: Option<trap::Label<Visibility>>,
}

impl trap::TrapEntry for MacroRules {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("macro_rules", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("macro_rules_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.name {
            out.add_tuple("macro_rules_names", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.token_tree {
            out.add_tuple("macro_rules_token_trees", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.visibility {
            out.add_tuple("macro_rules_visibilities", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for MacroRules {
    fn class_name() -> &'static str { "MacroRules" }
}

impl From<trap::Label<MacroRules>> for trap::Label<Item> {
    fn from(value: trap::Label<MacroRules>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroRules is a subclass of Item
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroRules>> for trap::Label<Stmt> {
    fn from(value: trap::Label<MacroRules>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroRules is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroRules>> for trap::Label<AstNode> {
    fn from(value: trap::Label<MacroRules>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroRules is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroRules>> for trap::Label<Locatable> {
    fn from(value: trap::Label<MacroRules>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroRules is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroRules>> for trap::Label<Element> {
    fn from(value: trap::Label<MacroRules>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroRules is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroRules>> for trap::Label<Addressable> {
    fn from(value: trap::Label<MacroRules>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroRules is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct MethodCallExpr {
    pub id: trap::TrapId<MethodCallExpr>,
    pub arg_list: Option<trap::Label<ArgList>>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub generic_arg_list: Option<trap::Label<GenericArgList>>,
    pub identifier: Option<trap::Label<NameRef>>,
    pub receiver: Option<trap::Label<Expr>>,
}

impl trap::TrapEntry for MethodCallExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("method_call_exprs", vec![id.into()]);
        if let Some(v) = self.arg_list {
            out.add_tuple("call_expr_base_arg_lists", vec![id.into(), v.into()]);
        }
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("call_expr_base_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.generic_arg_list {
            out.add_tuple("method_call_expr_generic_arg_lists", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.identifier {
            out.add_tuple("method_call_expr_identifiers", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.receiver {
            out.add_tuple("method_call_expr_receivers", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for MethodCallExpr {
    fn class_name() -> &'static str { "MethodCallExpr" }
}

impl From<trap::Label<MethodCallExpr>> for trap::Label<CallExprBase> {
    fn from(value: trap::Label<MethodCallExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MethodCallExpr is a subclass of CallExprBase
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MethodCallExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<MethodCallExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MethodCallExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MethodCallExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<MethodCallExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MethodCallExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MethodCallExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<MethodCallExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MethodCallExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MethodCallExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<MethodCallExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MethodCallExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MethodCallExpr>> for trap::Label<Resolvable> {
    fn from(value: trap::Label<MethodCallExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme MethodCallExpr is a subclass of Resolvable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Module {
    pub id: trap::TrapId<Module>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub item_list: Option<trap::Label<ItemList>>,
    pub name: Option<trap::Label<Name>>,
    pub visibility: Option<trap::Label<Visibility>>,
}

impl trap::TrapEntry for Module {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("modules", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("module_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.item_list {
            out.add_tuple("module_item_lists", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.name {
            out.add_tuple("module_names", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.visibility {
            out.add_tuple("module_visibilities", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for Module {
    fn class_name() -> &'static str { "Module" }
}

impl From<trap::Label<Module>> for trap::Label<Item> {
    fn from(value: trap::Label<Module>) -> Self {
        // SAFETY: this is safe because in the dbscheme Module is a subclass of Item
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Module>> for trap::Label<Stmt> {
    fn from(value: trap::Label<Module>) -> Self {
        // SAFETY: this is safe because in the dbscheme Module is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Module>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Module>) -> Self {
        // SAFETY: this is safe because in the dbscheme Module is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Module>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Module>) -> Self {
        // SAFETY: this is safe because in the dbscheme Module is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Module>> for trap::Label<Element> {
    fn from(value: trap::Label<Module>) -> Self {
        // SAFETY: this is safe because in the dbscheme Module is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Module>> for trap::Label<Addressable> {
    fn from(value: trap::Label<Module>) -> Self {
        // SAFETY: this is safe because in the dbscheme Module is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct PathExpr {
    pub id: trap::TrapId<PathExpr>,
    pub path: Option<trap::Label<Path>>,
    pub attrs: Vec<trap::Label<Attr>>,
}

impl trap::TrapEntry for PathExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("path_exprs", vec![id.into()]);
        if let Some(v) = self.path {
            out.add_tuple("path_ast_node_paths", vec![id.into(), v.into()]);
        }
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("path_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for PathExpr {
    fn class_name() -> &'static str { "PathExpr" }
}

impl From<trap::Label<PathExpr>> for trap::Label<PathExprBase> {
    fn from(value: trap::Label<PathExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathExpr is a subclass of PathExprBase
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<PathExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<PathExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<PathExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<PathExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathExpr>> for trap::Label<PathAstNode> {
    fn from(value: trap::Label<PathExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathExpr is a subclass of PathAstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathExpr>> for trap::Label<Resolvable> {
    fn from(value: trap::Label<PathExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathExpr is a subclass of Resolvable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct PathPat {
    pub id: trap::TrapId<PathPat>,
    pub path: Option<trap::Label<Path>>,
}

impl trap::TrapEntry for PathPat {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("path_pats", vec![id.into()]);
        if let Some(v) = self.path {
            out.add_tuple("path_ast_node_paths", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for PathPat {
    fn class_name() -> &'static str { "PathPat" }
}

impl From<trap::Label<PathPat>> for trap::Label<Pat> {
    fn from(value: trap::Label<PathPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathPat is a subclass of Pat
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathPat>> for trap::Label<AstNode> {
    fn from(value: trap::Label<PathPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathPat is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathPat>> for trap::Label<Locatable> {
    fn from(value: trap::Label<PathPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathPat is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathPat>> for trap::Label<Element> {
    fn from(value: trap::Label<PathPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathPat is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathPat>> for trap::Label<PathAstNode> {
    fn from(value: trap::Label<PathPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathPat is a subclass of PathAstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<PathPat>> for trap::Label<Resolvable> {
    fn from(value: trap::Label<PathPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme PathPat is a subclass of Resolvable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct StructExpr {
    pub id: trap::TrapId<StructExpr>,
    pub path: Option<trap::Label<Path>>,
    pub struct_expr_field_list: Option<trap::Label<StructExprFieldList>>,
}

impl trap::TrapEntry for StructExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("struct_exprs", vec![id.into()]);
        if let Some(v) = self.path {
            out.add_tuple("path_ast_node_paths", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.struct_expr_field_list {
            out.add_tuple("struct_expr_struct_expr_field_lists", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for StructExpr {
    fn class_name() -> &'static str { "StructExpr" }
}

impl From<trap::Label<StructExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<StructExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<StructExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<StructExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<StructExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructExpr>> for trap::Label<PathAstNode> {
    fn from(value: trap::Label<StructExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructExpr is a subclass of PathAstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructExpr>> for trap::Label<Resolvable> {
    fn from(value: trap::Label<StructExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructExpr is a subclass of Resolvable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct StructPat {
    pub id: trap::TrapId<StructPat>,
    pub path: Option<trap::Label<Path>>,
    pub struct_pat_field_list: Option<trap::Label<StructPatFieldList>>,
}

impl trap::TrapEntry for StructPat {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("struct_pats", vec![id.into()]);
        if let Some(v) = self.path {
            out.add_tuple("path_ast_node_paths", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.struct_pat_field_list {
            out.add_tuple("struct_pat_struct_pat_field_lists", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for StructPat {
    fn class_name() -> &'static str { "StructPat" }
}

impl From<trap::Label<StructPat>> for trap::Label<Pat> {
    fn from(value: trap::Label<StructPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructPat is a subclass of Pat
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructPat>> for trap::Label<AstNode> {
    fn from(value: trap::Label<StructPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructPat is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructPat>> for trap::Label<Locatable> {
    fn from(value: trap::Label<StructPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructPat is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructPat>> for trap::Label<Element> {
    fn from(value: trap::Label<StructPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructPat is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructPat>> for trap::Label<PathAstNode> {
    fn from(value: trap::Label<StructPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructPat is a subclass of PathAstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<StructPat>> for trap::Label<Resolvable> {
    fn from(value: trap::Label<StructPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme StructPat is a subclass of Resolvable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Trait {
    pub id: trap::TrapId<Trait>,
    pub assoc_item_list: Option<trap::Label<AssocItemList>>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub generic_param_list: Option<trap::Label<GenericParamList>>,
    pub is_auto: bool,
    pub is_unsafe: bool,
    pub name: Option<trap::Label<Name>>,
    pub type_bound_list: Option<trap::Label<TypeBoundList>>,
    pub visibility: Option<trap::Label<Visibility>>,
    pub where_clause: Option<trap::Label<WhereClause>>,
}

impl trap::TrapEntry for Trait {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("traits", vec![id.into()]);
        if let Some(v) = self.assoc_item_list {
            out.add_tuple("trait_assoc_item_lists", vec![id.into(), v.into()]);
        }
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("trait_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.generic_param_list {
            out.add_tuple("trait_generic_param_lists", vec![id.into(), v.into()]);
        }
        if self.is_auto {
            out.add_tuple("trait_is_auto", vec![id.into()]);
        }
        if self.is_unsafe {
            out.add_tuple("trait_is_unsafe", vec![id.into()]);
        }
        if let Some(v) = self.name {
            out.add_tuple("trait_names", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.type_bound_list {
            out.add_tuple("trait_type_bound_lists", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.visibility {
            out.add_tuple("trait_visibilities", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.where_clause {
            out.add_tuple("trait_where_clauses", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for Trait {
    fn class_name() -> &'static str { "Trait" }
}

impl From<trap::Label<Trait>> for trap::Label<Item> {
    fn from(value: trap::Label<Trait>) -> Self {
        // SAFETY: this is safe because in the dbscheme Trait is a subclass of Item
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Trait>> for trap::Label<Stmt> {
    fn from(value: trap::Label<Trait>) -> Self {
        // SAFETY: this is safe because in the dbscheme Trait is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Trait>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Trait>) -> Self {
        // SAFETY: this is safe because in the dbscheme Trait is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Trait>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Trait>) -> Self {
        // SAFETY: this is safe because in the dbscheme Trait is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Trait>> for trap::Label<Element> {
    fn from(value: trap::Label<Trait>) -> Self {
        // SAFETY: this is safe because in the dbscheme Trait is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Trait>> for trap::Label<Addressable> {
    fn from(value: trap::Label<Trait>) -> Self {
        // SAFETY: this is safe because in the dbscheme Trait is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct TraitAlias {
    pub id: trap::TrapId<TraitAlias>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub generic_param_list: Option<trap::Label<GenericParamList>>,
    pub name: Option<trap::Label<Name>>,
    pub type_bound_list: Option<trap::Label<TypeBoundList>>,
    pub visibility: Option<trap::Label<Visibility>>,
    pub where_clause: Option<trap::Label<WhereClause>>,
}

impl trap::TrapEntry for TraitAlias {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("trait_aliases", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("trait_alias_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.generic_param_list {
            out.add_tuple("trait_alias_generic_param_lists", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.name {
            out.add_tuple("trait_alias_names", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.type_bound_list {
            out.add_tuple("trait_alias_type_bound_lists", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.visibility {
            out.add_tuple("trait_alias_visibilities", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.where_clause {
            out.add_tuple("trait_alias_where_clauses", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for TraitAlias {
    fn class_name() -> &'static str { "TraitAlias" }
}

impl From<trap::Label<TraitAlias>> for trap::Label<Item> {
    fn from(value: trap::Label<TraitAlias>) -> Self {
        // SAFETY: this is safe because in the dbscheme TraitAlias is a subclass of Item
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TraitAlias>> for trap::Label<Stmt> {
    fn from(value: trap::Label<TraitAlias>) -> Self {
        // SAFETY: this is safe because in the dbscheme TraitAlias is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TraitAlias>> for trap::Label<AstNode> {
    fn from(value: trap::Label<TraitAlias>) -> Self {
        // SAFETY: this is safe because in the dbscheme TraitAlias is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TraitAlias>> for trap::Label<Locatable> {
    fn from(value: trap::Label<TraitAlias>) -> Self {
        // SAFETY: this is safe because in the dbscheme TraitAlias is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TraitAlias>> for trap::Label<Element> {
    fn from(value: trap::Label<TraitAlias>) -> Self {
        // SAFETY: this is safe because in the dbscheme TraitAlias is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TraitAlias>> for trap::Label<Addressable> {
    fn from(value: trap::Label<TraitAlias>) -> Self {
        // SAFETY: this is safe because in the dbscheme TraitAlias is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct TupleStructPat {
    pub id: trap::TrapId<TupleStructPat>,
    pub path: Option<trap::Label<Path>>,
    pub fields: Vec<trap::Label<Pat>>,
}

impl trap::TrapEntry for TupleStructPat {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("tuple_struct_pats", vec![id.into()]);
        if let Some(v) = self.path {
            out.add_tuple("path_ast_node_paths", vec![id.into(), v.into()]);
        }
        for (i, v) in self.fields.into_iter().enumerate() {
            out.add_tuple("tuple_struct_pat_fields", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for TupleStructPat {
    fn class_name() -> &'static str { "TupleStructPat" }
}

impl From<trap::Label<TupleStructPat>> for trap::Label<Pat> {
    fn from(value: trap::Label<TupleStructPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme TupleStructPat is a subclass of Pat
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TupleStructPat>> for trap::Label<AstNode> {
    fn from(value: trap::Label<TupleStructPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme TupleStructPat is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TupleStructPat>> for trap::Label<Locatable> {
    fn from(value: trap::Label<TupleStructPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme TupleStructPat is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TupleStructPat>> for trap::Label<Element> {
    fn from(value: trap::Label<TupleStructPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme TupleStructPat is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TupleStructPat>> for trap::Label<PathAstNode> {
    fn from(value: trap::Label<TupleStructPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme TupleStructPat is a subclass of PathAstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TupleStructPat>> for trap::Label<Resolvable> {
    fn from(value: trap::Label<TupleStructPat>) -> Self {
        // SAFETY: this is safe because in the dbscheme TupleStructPat is a subclass of Resolvable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Use {
    pub id: trap::TrapId<Use>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub use_tree: Option<trap::Label<UseTree>>,
    pub visibility: Option<trap::Label<Visibility>>,
}

impl trap::TrapEntry for Use {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("uses", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("use_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.use_tree {
            out.add_tuple("use_use_trees", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.visibility {
            out.add_tuple("use_visibilities", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for Use {
    fn class_name() -> &'static str { "Use" }
}

impl From<trap::Label<Use>> for trap::Label<Item> {
    fn from(value: trap::Label<Use>) -> Self {
        // SAFETY: this is safe because in the dbscheme Use is a subclass of Item
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Use>> for trap::Label<Stmt> {
    fn from(value: trap::Label<Use>) -> Self {
        // SAFETY: this is safe because in the dbscheme Use is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Use>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Use>) -> Self {
        // SAFETY: this is safe because in the dbscheme Use is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Use>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Use>) -> Self {
        // SAFETY: this is safe because in the dbscheme Use is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Use>> for trap::Label<Element> {
    fn from(value: trap::Label<Use>) -> Self {
        // SAFETY: this is safe because in the dbscheme Use is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Use>> for trap::Label<Addressable> {
    fn from(value: trap::Label<Use>) -> Self {
        // SAFETY: this is safe because in the dbscheme Use is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Const {
    pub id: trap::TrapId<Const>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub body: Option<trap::Label<Expr>>,
    pub generic_param_list: Option<trap::Label<GenericParamList>>,
    pub is_const: bool,
    pub is_default: bool,
    pub name: Option<trap::Label<Name>>,
    pub type_repr: Option<trap::Label<TypeRepr>>,
    pub visibility: Option<trap::Label<Visibility>>,
    pub where_clause: Option<trap::Label<WhereClause>>,
}

impl trap::TrapEntry for Const {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("consts", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("const_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.body {
            out.add_tuple("const_bodies", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.generic_param_list {
            out.add_tuple("const_generic_param_lists", vec![id.into(), v.into()]);
        }
        if self.is_const {
            out.add_tuple("const_is_const", vec![id.into()]);
        }
        if self.is_default {
            out.add_tuple("const_is_default", vec![id.into()]);
        }
        if let Some(v) = self.name {
            out.add_tuple("const_names", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.type_repr {
            out.add_tuple("const_type_reprs", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.visibility {
            out.add_tuple("const_visibilities", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.where_clause {
            out.add_tuple("const_where_clauses", vec![id.into(), v.into()]);
        }
    }
}

impl Const {
    pub fn emit_has_implementation(id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("const_has_implementation", vec![id.into()]);
    }

}

impl trap::TrapClass for Const {
    fn class_name() -> &'static str { "Const" }
}

impl From<trap::Label<Const>> for trap::Label<AssocItem> {
    fn from(value: trap::Label<Const>) -> Self {
        // SAFETY: this is safe because in the dbscheme Const is a subclass of AssocItem
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Const>> for trap::Label<Item> {
    fn from(value: trap::Label<Const>) -> Self {
        // SAFETY: this is safe because in the dbscheme Const is a subclass of Item
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Const>> for trap::Label<Stmt> {
    fn from(value: trap::Label<Const>) -> Self {
        // SAFETY: this is safe because in the dbscheme Const is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Const>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Const>) -> Self {
        // SAFETY: this is safe because in the dbscheme Const is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Const>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Const>) -> Self {
        // SAFETY: this is safe because in the dbscheme Const is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Const>> for trap::Label<Element> {
    fn from(value: trap::Label<Const>) -> Self {
        // SAFETY: this is safe because in the dbscheme Const is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Const>> for trap::Label<Addressable> {
    fn from(value: trap::Label<Const>) -> Self {
        // SAFETY: this is safe because in the dbscheme Const is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Enum {
    pub id: trap::TrapId<Enum>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub generic_param_list: Option<trap::Label<GenericParamList>>,
    pub name: Option<trap::Label<Name>>,
    pub variant_list: Option<trap::Label<VariantList>>,
    pub visibility: Option<trap::Label<Visibility>>,
    pub where_clause: Option<trap::Label<WhereClause>>,
}

impl trap::TrapEntry for Enum {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("enums", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("enum_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.generic_param_list {
            out.add_tuple("enum_generic_param_lists", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.name {
            out.add_tuple("enum_names", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.variant_list {
            out.add_tuple("enum_variant_lists", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.visibility {
            out.add_tuple("enum_visibilities", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.where_clause {
            out.add_tuple("enum_where_clauses", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for Enum {
    fn class_name() -> &'static str { "Enum" }
}

impl From<trap::Label<Enum>> for trap::Label<Adt> {
    fn from(value: trap::Label<Enum>) -> Self {
        // SAFETY: this is safe because in the dbscheme Enum is a subclass of Adt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Enum>> for trap::Label<Item> {
    fn from(value: trap::Label<Enum>) -> Self {
        // SAFETY: this is safe because in the dbscheme Enum is a subclass of Item
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Enum>> for trap::Label<Stmt> {
    fn from(value: trap::Label<Enum>) -> Self {
        // SAFETY: this is safe because in the dbscheme Enum is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Enum>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Enum>) -> Self {
        // SAFETY: this is safe because in the dbscheme Enum is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Enum>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Enum>) -> Self {
        // SAFETY: this is safe because in the dbscheme Enum is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Enum>> for trap::Label<Element> {
    fn from(value: trap::Label<Enum>) -> Self {
        // SAFETY: this is safe because in the dbscheme Enum is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Enum>> for trap::Label<Addressable> {
    fn from(value: trap::Label<Enum>) -> Self {
        // SAFETY: this is safe because in the dbscheme Enum is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct ForExpr {
    pub id: trap::TrapId<ForExpr>,
    pub label: Option<trap::Label<Label>>,
    pub loop_body: Option<trap::Label<BlockExpr>>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub iterable: Option<trap::Label<Expr>>,
    pub pat: Option<trap::Label<Pat>>,
}

impl trap::TrapEntry for ForExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("for_exprs", vec![id.into()]);
        if let Some(v) = self.label {
            out.add_tuple("labelable_expr_labels", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.loop_body {
            out.add_tuple("looping_expr_loop_bodies", vec![id.into(), v.into()]);
        }
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("for_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.iterable {
            out.add_tuple("for_expr_iterables", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.pat {
            out.add_tuple("for_expr_pats", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for ForExpr {
    fn class_name() -> &'static str { "ForExpr" }
}

impl From<trap::Label<ForExpr>> for trap::Label<LoopingExpr> {
    fn from(value: trap::Label<ForExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ForExpr is a subclass of LoopingExpr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ForExpr>> for trap::Label<LabelableExpr> {
    fn from(value: trap::Label<ForExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ForExpr is a subclass of LabelableExpr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ForExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<ForExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ForExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ForExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<ForExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ForExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ForExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<ForExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ForExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<ForExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<ForExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme ForExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Function {
    pub id: trap::TrapId<Function>,
    pub param_list: Option<trap::Label<ParamList>>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub abi: Option<trap::Label<Abi>>,
    pub body: Option<trap::Label<BlockExpr>>,
    pub generic_param_list: Option<trap::Label<GenericParamList>>,
    pub is_async: bool,
    pub is_const: bool,
    pub is_default: bool,
    pub is_gen: bool,
    pub is_unsafe: bool,
    pub name: Option<trap::Label<Name>>,
    pub ret_type: Option<trap::Label<RetTypeRepr>>,
    pub visibility: Option<trap::Label<Visibility>>,
    pub where_clause: Option<trap::Label<WhereClause>>,
}

impl trap::TrapEntry for Function {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("functions", vec![id.into()]);
        if let Some(v) = self.param_list {
            out.add_tuple("callable_param_lists", vec![id.into(), v.into()]);
        }
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("callable_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.abi {
            out.add_tuple("function_abis", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.body {
            out.add_tuple("function_bodies", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.generic_param_list {
            out.add_tuple("function_generic_param_lists", vec![id.into(), v.into()]);
        }
        if self.is_async {
            out.add_tuple("function_is_async", vec![id.into()]);
        }
        if self.is_const {
            out.add_tuple("function_is_const", vec![id.into()]);
        }
        if self.is_default {
            out.add_tuple("function_is_default", vec![id.into()]);
        }
        if self.is_gen {
            out.add_tuple("function_is_gen", vec![id.into()]);
        }
        if self.is_unsafe {
            out.add_tuple("function_is_unsafe", vec![id.into()]);
        }
        if let Some(v) = self.name {
            out.add_tuple("function_names", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.ret_type {
            out.add_tuple("function_ret_types", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.visibility {
            out.add_tuple("function_visibilities", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.where_clause {
            out.add_tuple("function_where_clauses", vec![id.into(), v.into()]);
        }
    }
}

impl Function {
    pub fn emit_has_implementation(id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("function_has_implementation", vec![id.into()]);
    }

}

impl trap::TrapClass for Function {
    fn class_name() -> &'static str { "Function" }
}

impl From<trap::Label<Function>> for trap::Label<AssocItem> {
    fn from(value: trap::Label<Function>) -> Self {
        // SAFETY: this is safe because in the dbscheme Function is a subclass of AssocItem
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Function>> for trap::Label<Item> {
    fn from(value: trap::Label<Function>) -> Self {
        // SAFETY: this is safe because in the dbscheme Function is a subclass of Item
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Function>> for trap::Label<Stmt> {
    fn from(value: trap::Label<Function>) -> Self {
        // SAFETY: this is safe because in the dbscheme Function is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Function>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Function>) -> Self {
        // SAFETY: this is safe because in the dbscheme Function is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Function>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Function>) -> Self {
        // SAFETY: this is safe because in the dbscheme Function is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Function>> for trap::Label<Element> {
    fn from(value: trap::Label<Function>) -> Self {
        // SAFETY: this is safe because in the dbscheme Function is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Function>> for trap::Label<Addressable> {
    fn from(value: trap::Label<Function>) -> Self {
        // SAFETY: this is safe because in the dbscheme Function is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Function>> for trap::Label<ExternItem> {
    fn from(value: trap::Label<Function>) -> Self {
        // SAFETY: this is safe because in the dbscheme Function is a subclass of ExternItem
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Function>> for trap::Label<Callable> {
    fn from(value: trap::Label<Function>) -> Self {
        // SAFETY: this is safe because in the dbscheme Function is a subclass of Callable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct LoopExpr {
    pub id: trap::TrapId<LoopExpr>,
    pub label: Option<trap::Label<Label>>,
    pub loop_body: Option<trap::Label<BlockExpr>>,
    pub attrs: Vec<trap::Label<Attr>>,
}

impl trap::TrapEntry for LoopExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("loop_exprs", vec![id.into()]);
        if let Some(v) = self.label {
            out.add_tuple("labelable_expr_labels", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.loop_body {
            out.add_tuple("looping_expr_loop_bodies", vec![id.into(), v.into()]);
        }
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("loop_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for LoopExpr {
    fn class_name() -> &'static str { "LoopExpr" }
}

impl From<trap::Label<LoopExpr>> for trap::Label<LoopingExpr> {
    fn from(value: trap::Label<LoopExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LoopExpr is a subclass of LoopingExpr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LoopExpr>> for trap::Label<LabelableExpr> {
    fn from(value: trap::Label<LoopExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LoopExpr is a subclass of LabelableExpr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LoopExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<LoopExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LoopExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LoopExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<LoopExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LoopExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LoopExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<LoopExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LoopExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<LoopExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<LoopExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme LoopExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct MacroCall {
    pub id: trap::TrapId<MacroCall>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub path: Option<trap::Label<Path>>,
    pub token_tree: Option<trap::Label<TokenTree>>,
}

impl trap::TrapEntry for MacroCall {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("macro_calls", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("macro_call_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.path {
            out.add_tuple("macro_call_paths", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.token_tree {
            out.add_tuple("macro_call_token_trees", vec![id.into(), v.into()]);
        }
    }
}

impl MacroCall {
    pub fn emit_macro_call_expansion(id: trap::Label<Self>, value: trap::Label<AstNode>, out: &mut trap::Writer) {
        out.add_tuple("macro_call_macro_call_expansions", vec![id.into(), value.into()]);
    }

}

impl trap::TrapClass for MacroCall {
    fn class_name() -> &'static str { "MacroCall" }
}

impl From<trap::Label<MacroCall>> for trap::Label<AssocItem> {
    fn from(value: trap::Label<MacroCall>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroCall is a subclass of AssocItem
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroCall>> for trap::Label<Item> {
    fn from(value: trap::Label<MacroCall>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroCall is a subclass of Item
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroCall>> for trap::Label<Stmt> {
    fn from(value: trap::Label<MacroCall>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroCall is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroCall>> for trap::Label<AstNode> {
    fn from(value: trap::Label<MacroCall>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroCall is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroCall>> for trap::Label<Locatable> {
    fn from(value: trap::Label<MacroCall>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroCall is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroCall>> for trap::Label<Element> {
    fn from(value: trap::Label<MacroCall>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroCall is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroCall>> for trap::Label<Addressable> {
    fn from(value: trap::Label<MacroCall>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroCall is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<MacroCall>> for trap::Label<ExternItem> {
    fn from(value: trap::Label<MacroCall>) -> Self {
        // SAFETY: this is safe because in the dbscheme MacroCall is a subclass of ExternItem
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Static {
    pub id: trap::TrapId<Static>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub body: Option<trap::Label<Expr>>,
    pub is_mut: bool,
    pub is_static: bool,
    pub is_unsafe: bool,
    pub name: Option<trap::Label<Name>>,
    pub type_repr: Option<trap::Label<TypeRepr>>,
    pub visibility: Option<trap::Label<Visibility>>,
}

impl trap::TrapEntry for Static {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("statics", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("static_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.body {
            out.add_tuple("static_bodies", vec![id.into(), v.into()]);
        }
        if self.is_mut {
            out.add_tuple("static_is_mut", vec![id.into()]);
        }
        if self.is_static {
            out.add_tuple("static_is_static", vec![id.into()]);
        }
        if self.is_unsafe {
            out.add_tuple("static_is_unsafe", vec![id.into()]);
        }
        if let Some(v) = self.name {
            out.add_tuple("static_names", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.type_repr {
            out.add_tuple("static_type_reprs", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.visibility {
            out.add_tuple("static_visibilities", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for Static {
    fn class_name() -> &'static str { "Static" }
}

impl From<trap::Label<Static>> for trap::Label<ExternItem> {
    fn from(value: trap::Label<Static>) -> Self {
        // SAFETY: this is safe because in the dbscheme Static is a subclass of ExternItem
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Static>> for trap::Label<Item> {
    fn from(value: trap::Label<Static>) -> Self {
        // SAFETY: this is safe because in the dbscheme Static is a subclass of Item
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Static>> for trap::Label<Stmt> {
    fn from(value: trap::Label<Static>) -> Self {
        // SAFETY: this is safe because in the dbscheme Static is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Static>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Static>) -> Self {
        // SAFETY: this is safe because in the dbscheme Static is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Static>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Static>) -> Self {
        // SAFETY: this is safe because in the dbscheme Static is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Static>> for trap::Label<Element> {
    fn from(value: trap::Label<Static>) -> Self {
        // SAFETY: this is safe because in the dbscheme Static is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Static>> for trap::Label<Addressable> {
    fn from(value: trap::Label<Static>) -> Self {
        // SAFETY: this is safe because in the dbscheme Static is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Struct {
    pub id: trap::TrapId<Struct>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub field_list: Option<trap::Label<FieldList>>,
    pub generic_param_list: Option<trap::Label<GenericParamList>>,
    pub name: Option<trap::Label<Name>>,
    pub visibility: Option<trap::Label<Visibility>>,
    pub where_clause: Option<trap::Label<WhereClause>>,
}

impl trap::TrapEntry for Struct {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("structs", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("struct_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.field_list {
            out.add_tuple("struct_field_lists_", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.generic_param_list {
            out.add_tuple("struct_generic_param_lists", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.name {
            out.add_tuple("struct_names", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.visibility {
            out.add_tuple("struct_visibilities", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.where_clause {
            out.add_tuple("struct_where_clauses", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for Struct {
    fn class_name() -> &'static str { "Struct" }
}

impl From<trap::Label<Struct>> for trap::Label<Adt> {
    fn from(value: trap::Label<Struct>) -> Self {
        // SAFETY: this is safe because in the dbscheme Struct is a subclass of Adt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Struct>> for trap::Label<Item> {
    fn from(value: trap::Label<Struct>) -> Self {
        // SAFETY: this is safe because in the dbscheme Struct is a subclass of Item
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Struct>> for trap::Label<Stmt> {
    fn from(value: trap::Label<Struct>) -> Self {
        // SAFETY: this is safe because in the dbscheme Struct is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Struct>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Struct>) -> Self {
        // SAFETY: this is safe because in the dbscheme Struct is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Struct>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Struct>) -> Self {
        // SAFETY: this is safe because in the dbscheme Struct is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Struct>> for trap::Label<Element> {
    fn from(value: trap::Label<Struct>) -> Self {
        // SAFETY: this is safe because in the dbscheme Struct is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Struct>> for trap::Label<Addressable> {
    fn from(value: trap::Label<Struct>) -> Self {
        // SAFETY: this is safe because in the dbscheme Struct is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct TypeAlias {
    pub id: trap::TrapId<TypeAlias>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub generic_param_list: Option<trap::Label<GenericParamList>>,
    pub is_default: bool,
    pub name: Option<trap::Label<Name>>,
    pub type_repr: Option<trap::Label<TypeRepr>>,
    pub type_bound_list: Option<trap::Label<TypeBoundList>>,
    pub visibility: Option<trap::Label<Visibility>>,
    pub where_clause: Option<trap::Label<WhereClause>>,
}

impl trap::TrapEntry for TypeAlias {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("type_aliases", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("type_alias_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.generic_param_list {
            out.add_tuple("type_alias_generic_param_lists", vec![id.into(), v.into()]);
        }
        if self.is_default {
            out.add_tuple("type_alias_is_default", vec![id.into()]);
        }
        if let Some(v) = self.name {
            out.add_tuple("type_alias_names", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.type_repr {
            out.add_tuple("type_alias_type_reprs", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.type_bound_list {
            out.add_tuple("type_alias_type_bound_lists", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.visibility {
            out.add_tuple("type_alias_visibilities", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.where_clause {
            out.add_tuple("type_alias_where_clauses", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for TypeAlias {
    fn class_name() -> &'static str { "TypeAlias" }
}

impl From<trap::Label<TypeAlias>> for trap::Label<AssocItem> {
    fn from(value: trap::Label<TypeAlias>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeAlias is a subclass of AssocItem
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TypeAlias>> for trap::Label<Item> {
    fn from(value: trap::Label<TypeAlias>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeAlias is a subclass of Item
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TypeAlias>> for trap::Label<Stmt> {
    fn from(value: trap::Label<TypeAlias>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeAlias is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TypeAlias>> for trap::Label<AstNode> {
    fn from(value: trap::Label<TypeAlias>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeAlias is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TypeAlias>> for trap::Label<Locatable> {
    fn from(value: trap::Label<TypeAlias>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeAlias is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TypeAlias>> for trap::Label<Element> {
    fn from(value: trap::Label<TypeAlias>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeAlias is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TypeAlias>> for trap::Label<Addressable> {
    fn from(value: trap::Label<TypeAlias>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeAlias is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<TypeAlias>> for trap::Label<ExternItem> {
    fn from(value: trap::Label<TypeAlias>) -> Self {
        // SAFETY: this is safe because in the dbscheme TypeAlias is a subclass of ExternItem
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct Union {
    pub id: trap::TrapId<Union>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub generic_param_list: Option<trap::Label<GenericParamList>>,
    pub name: Option<trap::Label<Name>>,
    pub struct_field_list: Option<trap::Label<StructFieldList>>,
    pub visibility: Option<trap::Label<Visibility>>,
    pub where_clause: Option<trap::Label<WhereClause>>,
}

impl trap::TrapEntry for Union {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("unions", vec![id.into()]);
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("union_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.generic_param_list {
            out.add_tuple("union_generic_param_lists", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.name {
            out.add_tuple("union_names", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.struct_field_list {
            out.add_tuple("union_struct_field_lists", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.visibility {
            out.add_tuple("union_visibilities", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.where_clause {
            out.add_tuple("union_where_clauses", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for Union {
    fn class_name() -> &'static str { "Union" }
}

impl From<trap::Label<Union>> for trap::Label<Adt> {
    fn from(value: trap::Label<Union>) -> Self {
        // SAFETY: this is safe because in the dbscheme Union is a subclass of Adt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Union>> for trap::Label<Item> {
    fn from(value: trap::Label<Union>) -> Self {
        // SAFETY: this is safe because in the dbscheme Union is a subclass of Item
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Union>> for trap::Label<Stmt> {
    fn from(value: trap::Label<Union>) -> Self {
        // SAFETY: this is safe because in the dbscheme Union is a subclass of Stmt
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Union>> for trap::Label<AstNode> {
    fn from(value: trap::Label<Union>) -> Self {
        // SAFETY: this is safe because in the dbscheme Union is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Union>> for trap::Label<Locatable> {
    fn from(value: trap::Label<Union>) -> Self {
        // SAFETY: this is safe because in the dbscheme Union is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Union>> for trap::Label<Element> {
    fn from(value: trap::Label<Union>) -> Self {
        // SAFETY: this is safe because in the dbscheme Union is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<Union>> for trap::Label<Addressable> {
    fn from(value: trap::Label<Union>) -> Self {
        // SAFETY: this is safe because in the dbscheme Union is a subclass of Addressable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

#[derive(Debug)]
pub struct WhileExpr {
    pub id: trap::TrapId<WhileExpr>,
    pub label: Option<trap::Label<Label>>,
    pub loop_body: Option<trap::Label<BlockExpr>>,
    pub attrs: Vec<trap::Label<Attr>>,
    pub condition: Option<trap::Label<Expr>>,
}

impl trap::TrapEntry for WhileExpr {
    fn extract_id(&mut self) -> trap::TrapId<Self> {
        std::mem::replace(&mut self.id, trap::TrapId::Star)
    }

    fn emit(self, id: trap::Label<Self>, out: &mut trap::Writer) {
        out.add_tuple("while_exprs", vec![id.into()]);
        if let Some(v) = self.label {
            out.add_tuple("labelable_expr_labels", vec![id.into(), v.into()]);
        }
        if let Some(v) = self.loop_body {
            out.add_tuple("looping_expr_loop_bodies", vec![id.into(), v.into()]);
        }
        for (i, v) in self.attrs.into_iter().enumerate() {
            out.add_tuple("while_expr_attrs", vec![id.into(), i.into(), v.into()]);
        }
        if let Some(v) = self.condition {
            out.add_tuple("while_expr_conditions", vec![id.into(), v.into()]);
        }
    }
}

impl trap::TrapClass for WhileExpr {
    fn class_name() -> &'static str { "WhileExpr" }
}

impl From<trap::Label<WhileExpr>> for trap::Label<LoopingExpr> {
    fn from(value: trap::Label<WhileExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme WhileExpr is a subclass of LoopingExpr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<WhileExpr>> for trap::Label<LabelableExpr> {
    fn from(value: trap::Label<WhileExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme WhileExpr is a subclass of LabelableExpr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<WhileExpr>> for trap::Label<Expr> {
    fn from(value: trap::Label<WhileExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme WhileExpr is a subclass of Expr
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<WhileExpr>> for trap::Label<AstNode> {
    fn from(value: trap::Label<WhileExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme WhileExpr is a subclass of AstNode
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<WhileExpr>> for trap::Label<Locatable> {
    fn from(value: trap::Label<WhileExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme WhileExpr is a subclass of Locatable
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}

impl From<trap::Label<WhileExpr>> for trap::Label<Element> {
    fn from(value: trap::Label<WhileExpr>) -> Self {
        // SAFETY: this is safe because in the dbscheme WhileExpr is a subclass of Element
        unsafe {
            Self::from_untyped(value.as_untyped())
        }
    }
}
