// generated by codegen, do not edit
/**
 * This module provides the generated definition of `StructField`.
 * INTERNAL: Do not import directly.
 */

private import codeql.rust.elements.internal.generated.Synth
private import codeql.rust.elements.internal.generated.Raw
import codeql.rust.elements.internal.AstNodeImpl::Impl as AstNodeImpl
import codeql.rust.elements.Attr
import codeql.rust.elements.Expr
import codeql.rust.elements.Name
import codeql.rust.elements.TypeRepr
import codeql.rust.elements.Visibility

/**
 * INTERNAL: This module contains the fully generated definition of `StructField` and should not
 * be referenced directly.
 */
module Generated {
  /**
   * A field in a struct declaration.
   *
   * For example:
   * ```rust
   * struct S { x: i32 }
   * //         ^^^^^^^
   * ```
   * INTERNAL: Do not reference the `Generated::StructField` class directly.
   * Use the subclass `StructField`, where the following predicates are available.
   */
  class StructField extends Synth::TStructField, AstNodeImpl::AstNode {
    override string getAPrimaryQlClass() { result = "StructField" }

    /**
     * Gets the `index`th attr of this struct field (0-based).
     */
    Attr getAttr(int index) {
      result =
        Synth::convertAttrFromRaw(Synth::convertStructFieldToRaw(this)
              .(Raw::StructField)
              .getAttr(index))
    }

    /**
     * Gets any of the attrs of this struct field.
     */
    final Attr getAnAttr() { result = this.getAttr(_) }

    /**
     * Gets the number of attrs of this struct field.
     */
    final int getNumberOfAttrs() { result = count(int i | exists(this.getAttr(i))) }

    /**
     * Gets the default of this struct field, if it exists.
     */
    Expr getDefault() {
      result =
        Synth::convertExprFromRaw(Synth::convertStructFieldToRaw(this)
              .(Raw::StructField)
              .getDefault())
    }

    /**
     * Holds if `getDefault()` exists.
     */
    final predicate hasDefault() { exists(this.getDefault()) }

    /**
     * Holds if this struct field is unsafe.
     */
    predicate isUnsafe() { Synth::convertStructFieldToRaw(this).(Raw::StructField).isUnsafe() }

    /**
     * Gets the name of this struct field, if it exists.
     */
    Name getName() {
      result =
        Synth::convertNameFromRaw(Synth::convertStructFieldToRaw(this).(Raw::StructField).getName())
    }

    /**
     * Holds if `getName()` exists.
     */
    final predicate hasName() { exists(this.getName()) }

    /**
     * Gets the type representation of this struct field, if it exists.
     */
    TypeRepr getTypeRepr() {
      result =
        Synth::convertTypeReprFromRaw(Synth::convertStructFieldToRaw(this)
              .(Raw::StructField)
              .getTypeRepr())
    }

    /**
     * Holds if `getTypeRepr()` exists.
     */
    final predicate hasTypeRepr() { exists(this.getTypeRepr()) }

    /**
     * Gets the visibility of this struct field, if it exists.
     */
    Visibility getVisibility() {
      result =
        Synth::convertVisibilityFromRaw(Synth::convertStructFieldToRaw(this)
              .(Raw::StructField)
              .getVisibility())
    }

    /**
     * Holds if `getVisibility()` exists.
     */
    final predicate hasVisibility() { exists(this.getVisibility()) }
  }
}
