// generated by codegen, do not edit
/**
 * This module provides the generated definition of `TypeBound`.
 * INTERNAL: Do not import directly.
 */

private import codeql.rust.elements.internal.generated.Synth
private import codeql.rust.elements.internal.generated.Raw
import codeql.rust.elements.internal.AstNodeImpl::Impl as AstNodeImpl
import codeql.rust.elements.Lifetime
import codeql.rust.elements.TypeRepr
import codeql.rust.elements.UseBoundGenericArgs

/**
 * INTERNAL: This module contains the fully generated definition of `TypeBound` and should not
 * be referenced directly.
 */
module Generated {
  /**
   * A type bound in a trait or generic parameter.
   *
   * For example:
   * ```rust
   * fn foo<T: Debug>(t: T) {}
   * //        ^^^^^
   * ```
   * INTERNAL: Do not reference the `Generated::TypeBound` class directly.
   * Use the subclass `TypeBound`, where the following predicates are available.
   */
  class TypeBound extends Synth::TTypeBound, AstNodeImpl::AstNode {
    override string getAPrimaryQlClass() { result = "TypeBound" }

    /**
     * Holds if this type bound is async.
     */
    predicate isAsync() { Synth::convertTypeBoundToRaw(this).(Raw::TypeBound).isAsync() }

    /**
     * Holds if this type bound is const.
     */
    predicate isConst() { Synth::convertTypeBoundToRaw(this).(Raw::TypeBound).isConst() }

    /**
     * Gets the lifetime of this type bound, if it exists.
     */
    Lifetime getLifetime() {
      result =
        Synth::convertLifetimeFromRaw(Synth::convertTypeBoundToRaw(this)
              .(Raw::TypeBound)
              .getLifetime())
    }

    /**
     * Holds if `getLifetime()` exists.
     */
    final predicate hasLifetime() { exists(this.getLifetime()) }

    /**
     * Gets the type representation of this type bound, if it exists.
     */
    TypeRepr getTypeRepr() {
      result =
        Synth::convertTypeReprFromRaw(Synth::convertTypeBoundToRaw(this)
              .(Raw::TypeBound)
              .getTypeRepr())
    }

    /**
     * Holds if `getTypeRepr()` exists.
     */
    final predicate hasTypeRepr() { exists(this.getTypeRepr()) }

    /**
     * Gets the use bound generic arguments of this type bound, if it exists.
     */
    UseBoundGenericArgs getUseBoundGenericArgs() {
      result =
        Synth::convertUseBoundGenericArgsFromRaw(Synth::convertTypeBoundToRaw(this)
              .(Raw::TypeBound)
              .getUseBoundGenericArgs())
    }

    /**
     * Holds if `getUseBoundGenericArgs()` exists.
     */
    final predicate hasUseBoundGenericArgs() { exists(this.getUseBoundGenericArgs()) }
  }
}
