## 0.2.1

### New Features

* A number of new classes and methods related to the upcoming Kotlin
  support have been added. These are not yet stable, as Kotlin support
  is still under development.
   * `File::isSourceFile`
   * `File::isJavaSourceFile`
   * `File::isKotlinSourceFile`
   * `Member::getKotlinType`
   * `Element::isCompilerGenerated`
   * `Expr::getKotlinType`
   * `LambdaExpr::isKotlinFunctionN`
   * `Callable::getReturnKotlinType`
   * `Callable::getParameterKotlinType`
   * `Method::isLocal`
   * `Method::getKotlinName`
   * `Field::getKotlinType`
   * `Modifiable::isSealedKotlin`
   * `Modifiable::isInternal`
   * `Variable::getKotlinType`
   * `LocalVariableDecl::getKotlinType`
   * `Parameter::getKotlinType`
   * `Parameter::isExtensionParameter`
   * `Compilation` class
   * `Diagnostic` class
   * `KtInitializerAssignExpr` class
   * `ValueEQExpr` class
   * `ValueNEExpr` class
   * `ValueOrReferenceEqualsExpr` class
   * `ValueOrReferenceNotEqualsExpr` class
   * `ReferenceEqualityTest` class
   * `CastingExpr` class
   * `SafeCastExpr` class
   * `ImplicitCastExpr` class
   * `ImplicitNotNullExpr` class
   * `ImplicitCoercionToUnitExpr` class
   * `UnsafeCoerceExpr` class
   * `PropertyRefExpr` class
   * `NotInstanceOfExpr` class
   * `ExtensionReceiverAccess` class
   * `WhenExpr` class
   * `WhenBranch` class
   * `ClassExpr` class
   * `StmtExpr` class
   * `StringTemplateExpr` class
   * `NotNullExpr` class
   * `TypeNullPointerException` class
   * `KtComment` class
   * `KtCommentSection` class
   * `KotlinType` class
   * `KotlinNullableType` class
   * `KotlinNotnullType` class
   * `KotlinTypeAlias` class
   * `Property` class
   * `DelegatedProperty` class
   * `ExtensionMethod` class
   * `KtInitializerNode` class
   * `KtLoopStmt` class
   * `KtBreakContinueStmt` class
   * `KtBreakStmt` class
   * `KtContinueStmt` class
   * `ClassObject` class
   * `CompanionObject` class
   * `LiveLiteral` class
   * `LiveLiteralMethod` class
   * `CastConversionContext` renamed to `CastingConversionContext`
* The QL class `ValueDiscardingExpr` has been added, representing expressions for which the value of the expression as a whole is discarded.

### Minor Analysis Improvements

* Added models for the libraries OkHttp and Retrofit.
* Add taint models for the following `File` methods:
   * `File::getAbsoluteFile`
   * `File::getCanonicalFile`
   * `File::getAbsolutePath`
   * `File::getCanonicalPath`
* Added a flow step for `toString` calls on tainted `android.text.Editable` objects. 
* Added a data flow step for tainted Android intents that are sent to other activities and accessed there via `getIntent()`.
* Added modeling of MyBatis (`org.apache.ibatis`) Providers, resulting in additional sinks for the queries `java/ognl-injection`, `java/sql-injection`, `java/sql-injection-local` and `java/concatenated-sql-query`.
