## 6.0.0

### Breaking Changes

* The class `ControlFlowNode` (and by extension `BasicBlock`) is no longer
  directly equatable to `Expr` and `Stmt`. Any queries that have been
  exploiting these equalities, for example by using casts, will need minor
  updates in order to fix any compilation errors. Conversions can be inserted
  in either direction depending on what is most convenient. Available
  conversions include `Expr.getControlFlowNode()`, `Stmt.getControlFlowNode()`,
  `ControlFlowNode.asExpr()`, `ControlFlowNode.asStmt()`, and
  `ControlFlowNode.asCall()`. Exit nodes were until now modelled as a
  `ControlFlowNode` equal to its enclosing `Callable`; these are now instead
  modelled by the class `ControlFlow::ExitNode`.

### Minor Analysis Improvements

* Added `java.io.File.getName()` as a path injection sanitizer.
* The data flow library has been updated to track types in a slightly different way: The type of the tainted data (which may be stored into fields, etc.) is tracked more precisely, while the types of intermediate containers for nested contents is tracked less precisely. This may have a slight effect on false positives for complex flow paths.
* Added a sink for "Server-side request forgery" (`java/ssrf`) for the third parameter to org.springframework.web.client.RestTemplate.getForObject, when we cannot statically determine that it does not affect the host in the URL.
