// Adapted from the documentation of https://github.com/sidorares/node-mysql2,
// which is licensed under the MIT license; see file node-mysql2-License.
const mysql = require('mysql2');
 
// create the connection to database
const connection = mysql.createConnection({
  host: 'localhost',
  user: 'root',
  database: 'test'
});
 
// simple query
connection.query(
  'SELECT * FROM `table` WHERE `name` = "Page" AND `age` > 45',
  function(err, results, fields) {
    console.log(results); // results contains rows returned by server
    console.log(fields); // fields contains extra meta data about results, if available
  }
);
 
// with placeholder
connection.query(
  'SELECT * FROM `table` WHERE `name` = ? AND `age` > ?',
  ['Page', 45],
  function(err, results) {
    console.log(results);
  }
);

const conn2 = await mysql.createConnectionPromise();
await conn2.query('SELECT * FROM users');
await conn2.execute('SELECT * FROM users');
