###############################################################################
# @generated
# DO NOT MODIFY: This file is auto-generated by a crate_universe tool. To
# regenerate this file, run the following:
#
#     bazel run @@//misc/bazel/3rdparty:vendor_py_deps
###############################################################################
"""
# `crates_repository` API

- [aliases](#aliases)
- [crate_deps](#crate_deps)
- [all_crate_deps](#all_crate_deps)
- [crate_repositories](#crate_repositories)

"""

load("@bazel_skylib//lib:selects.bzl", "selects")
load("@bazel_tools//tools/build_defs/repo:http.bzl", "http_archive")
load("@bazel_tools//tools/build_defs/repo:utils.bzl", "maybe")

###############################################################################
# MACROS API
###############################################################################

# An identifier that represent common dependencies (unconditional).
_COMMON_CONDITION = ""

def _flatten_dependency_maps(all_dependency_maps):
    """Flatten a list of dependency maps into one dictionary.

    Dependency maps have the following structure:

    ```python
    DEPENDENCIES_MAP = {
        # The first key in the map is a Bazel package
        # name of the workspace this file is defined in.
        "workspace_member_package": {

            # Not all dependencies are supported for all platforms.
            # the condition key is the condition required to be true
            # on the host platform.
            "condition": {

                # An alias to a crate target.     # The label of the crate target the
                # Aliases are only crate names.   # package name refers to.
                "package_name":                   "@full//:label",
            }
        }
    }
    ```

    Args:
        all_dependency_maps (list): A list of dicts as described above

    Returns:
        dict: A dictionary as described above
    """
    dependencies = {}

    for workspace_deps_map in all_dependency_maps:
        for pkg_name, conditional_deps_map in workspace_deps_map.items():
            if pkg_name not in dependencies:
                non_frozen_map = dict()
                for key, values in conditional_deps_map.items():
                    non_frozen_map.update({key: dict(values.items())})
                dependencies.setdefault(pkg_name, non_frozen_map)
                continue

            for condition, deps_map in conditional_deps_map.items():
                # If the condition has not been recorded, do so and continue
                if condition not in dependencies[pkg_name]:
                    dependencies[pkg_name].setdefault(condition, dict(deps_map.items()))
                    continue

                # Alert on any miss-matched dependencies
                inconsistent_entries = []
                for crate_name, crate_label in deps_map.items():
                    existing = dependencies[pkg_name][condition].get(crate_name)
                    if existing and existing != crate_label:
                        inconsistent_entries.append((crate_name, existing, crate_label))
                    dependencies[pkg_name][condition].update({crate_name: crate_label})

    return dependencies

def crate_deps(deps, package_name = None):
    """Finds the fully qualified label of the requested crates for the package where this macro is called.

    Args:
        deps (list): The desired list of crate targets.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()`.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if not deps:
        return []

    if package_name == None:
        package_name = native.package_name()

    # Join both sets of dependencies
    dependencies = _flatten_dependency_maps([
        _NORMAL_DEPENDENCIES,
        _NORMAL_DEV_DEPENDENCIES,
        _PROC_MACRO_DEPENDENCIES,
        _PROC_MACRO_DEV_DEPENDENCIES,
        _BUILD_DEPENDENCIES,
        _BUILD_PROC_MACRO_DEPENDENCIES,
    ]).pop(package_name, {})

    # Combine all conditional packages so we can easily index over a flat list
    # TODO: Perhaps this should actually return select statements and maintain
    # the conditionals of the dependencies
    flat_deps = {}
    for deps_set in dependencies.values():
        for crate_name, crate_label in deps_set.items():
            flat_deps.update({crate_name: crate_label})

    missing_crates = []
    crate_targets = []
    for crate_target in deps:
        if crate_target not in flat_deps:
            missing_crates.append(crate_target)
        else:
            crate_targets.append(flat_deps[crate_target])

    if missing_crates:
        fail("Could not find crates `{}` among dependencies of `{}`. Available dependencies were `{}`".format(
            missing_crates,
            package_name,
            dependencies,
        ))

    return crate_targets

def all_crate_deps(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Finds the fully qualified label of all requested direct crate dependencies \
    for the package where this macro is called.

    If no parameters are set, all normal dependencies are returned. Setting any one flag will
    otherwise impact the contents of the returned list.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_dependency_maps = []
    if normal:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)
    if normal_dev:
        all_dependency_maps.append(_NORMAL_DEV_DEPENDENCIES)
    if proc_macro:
        all_dependency_maps.append(_PROC_MACRO_DEPENDENCIES)
    if proc_macro_dev:
        all_dependency_maps.append(_PROC_MACRO_DEV_DEPENDENCIES)
    if build:
        all_dependency_maps.append(_BUILD_DEPENDENCIES)
    if build_proc_macro:
        all_dependency_maps.append(_BUILD_PROC_MACRO_DEPENDENCIES)

    # Default to always using normal dependencies
    if not all_dependency_maps:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)

    dependencies = _flatten_dependency_maps(all_dependency_maps).pop(package_name, None)

    if not dependencies:
        if dependencies == None:
            fail("Tried to get all_crate_deps for package " + package_name + " but that package had no Cargo.toml file")
        else:
            return []

    crate_deps = list(dependencies.pop(_COMMON_CONDITION, {}).values())
    for condition, deps in dependencies.items():
        crate_deps += selects.with_or({
            tuple(_CONDITIONS[condition]): deps.values(),
            "//conditions:default": [],
        })

    return crate_deps

def aliases(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Produces a map of Crate alias names to their original label

    If no dependency kinds are specified, `normal` and `proc_macro` are used by default.
    Setting any one flag will otherwise determine the contents of the returned dict.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        dict: The aliases of all associated packages
    """
    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_aliases_maps = []
    if normal:
        all_aliases_maps.append(_NORMAL_ALIASES)
    if normal_dev:
        all_aliases_maps.append(_NORMAL_DEV_ALIASES)
    if proc_macro:
        all_aliases_maps.append(_PROC_MACRO_ALIASES)
    if proc_macro_dev:
        all_aliases_maps.append(_PROC_MACRO_DEV_ALIASES)
    if build:
        all_aliases_maps.append(_BUILD_ALIASES)
    if build_proc_macro:
        all_aliases_maps.append(_BUILD_PROC_MACRO_ALIASES)

    # Default to always using normal aliases
    if not all_aliases_maps:
        all_aliases_maps.append(_NORMAL_ALIASES)
        all_aliases_maps.append(_PROC_MACRO_ALIASES)

    aliases = _flatten_dependency_maps(all_aliases_maps).pop(package_name, None)

    if not aliases:
        return dict()

    common_items = aliases.pop(_COMMON_CONDITION, {}).items()

    # If there are only common items in the dictionary, immediately return them
    if not len(aliases.keys()) == 1:
        return dict(common_items)

    # Build a single select statement where each conditional has accounted for the
    # common set of aliases.
    crate_aliases = {"//conditions:default": dict(common_items)}
    for condition, deps in aliases.items():
        condition_triples = _CONDITIONS[condition]
        for triple in condition_triples:
            if triple in crate_aliases:
                crate_aliases[triple].update(deps)
            else:
                crate_aliases.update({triple: dict(deps.items() + common_items)})

    return select(crate_aliases)

###############################################################################
# WORKSPACE MEMBER DEPS AND ALIASES
###############################################################################

_NORMAL_DEPENDENCIES = {
    "python/extractor/tsg-python": {
        _COMMON_CONDITION: {
            "anyhow": Label("@vendor_py__anyhow-1.0.95//:anyhow"),
            "clap": Label("@vendor_py__clap-4.5.30//:clap"),
            "regex": Label("@vendor_py__regex-1.11.1//:regex"),
            "tree-sitter": Label("@vendor_py__tree-sitter-0.20.4//:tree_sitter"),
            "tree-sitter-graph": Label("@vendor_py__tree-sitter-graph-0.7.0//:tree_sitter_graph"),
        },
    },
    "python/extractor/tsg-python/tsp": {
        _COMMON_CONDITION: {
            "tree-sitter": Label("@vendor_py__tree-sitter-0.20.4//:tree_sitter"),
        },
    },
}

_NORMAL_ALIASES = {
    "python/extractor/tsg-python": {
        _COMMON_CONDITION: {
        },
    },
    "python/extractor/tsg-python/tsp": {
        _COMMON_CONDITION: {
        },
    },
}

_NORMAL_DEV_DEPENDENCIES = {
    "python/extractor/tsg-python": {
    },
    "python/extractor/tsg-python/tsp": {
    },
}

_NORMAL_DEV_ALIASES = {
    "python/extractor/tsg-python": {
    },
    "python/extractor/tsg-python/tsp": {
    },
}

_PROC_MACRO_DEPENDENCIES = {
    "python/extractor/tsg-python": {
    },
    "python/extractor/tsg-python/tsp": {
    },
}

_PROC_MACRO_ALIASES = {
    "python/extractor/tsg-python": {
    },
    "python/extractor/tsg-python/tsp": {
    },
}

_PROC_MACRO_DEV_DEPENDENCIES = {
    "python/extractor/tsg-python": {
    },
    "python/extractor/tsg-python/tsp": {
    },
}

_PROC_MACRO_DEV_ALIASES = {
    "python/extractor/tsg-python": {
    },
    "python/extractor/tsg-python/tsp": {
    },
}

_BUILD_DEPENDENCIES = {
    "python/extractor/tsg-python": {
    },
    "python/extractor/tsg-python/tsp": {
        _COMMON_CONDITION: {
            "cc": Label("@vendor_py__cc-1.2.14//:cc"),
        },
    },
}

_BUILD_ALIASES = {
    "python/extractor/tsg-python": {
    },
    "python/extractor/tsg-python/tsp": {
        _COMMON_CONDITION: {
        },
    },
}

_BUILD_PROC_MACRO_DEPENDENCIES = {
    "python/extractor/tsg-python": {
    },
    "python/extractor/tsg-python/tsp": {
    },
}

_BUILD_PROC_MACRO_ALIASES = {
    "python/extractor/tsg-python": {
    },
    "python/extractor/tsg-python/tsp": {
    },
}

_CONDITIONS = {
    "aarch64-apple-darwin": ["@rules_rust//rust/platform:aarch64-apple-darwin"],
    "aarch64-apple-ios": ["@rules_rust//rust/platform:aarch64-apple-ios"],
    "aarch64-apple-ios-sim": ["@rules_rust//rust/platform:aarch64-apple-ios-sim"],
    "aarch64-linux-android": ["@rules_rust//rust/platform:aarch64-linux-android"],
    "aarch64-pc-windows-gnullvm": [],
    "aarch64-pc-windows-msvc": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "aarch64-unknown-fuchsia": ["@rules_rust//rust/platform:aarch64-unknown-fuchsia"],
    "aarch64-unknown-linux-gnu": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu"],
    "aarch64-unknown-nixos-gnu": ["@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "aarch64-unknown-nto-qnx710": ["@rules_rust//rust/platform:aarch64-unknown-nto-qnx710"],
    "aarch64-unknown-uefi": ["@rules_rust//rust/platform:aarch64-unknown-uefi"],
    "arm-unknown-linux-gnueabi": ["@rules_rust//rust/platform:arm-unknown-linux-gnueabi"],
    "armv7-linux-androideabi": ["@rules_rust//rust/platform:armv7-linux-androideabi"],
    "armv7-unknown-linux-gnueabi": ["@rules_rust//rust/platform:armv7-unknown-linux-gnueabi"],
    "cfg(all(any(target_arch = \"x86_64\", target_arch = \"arm64ec\"), target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(all(target_arch = \"aarch64\", target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "cfg(all(target_arch = \"x86\", target_env = \"gnu\", not(target_abi = \"llvm\"), not(windows_raw_dylib)))": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "cfg(all(target_arch = \"x86\", target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "cfg(all(target_arch = \"x86_64\", target_env = \"gnu\", not(target_abi = \"llvm\"), not(windows_raw_dylib)))": ["@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(any())": [],
    "cfg(windows)": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "i686-apple-darwin": ["@rules_rust//rust/platform:i686-apple-darwin"],
    "i686-linux-android": ["@rules_rust//rust/platform:i686-linux-android"],
    "i686-pc-windows-gnullvm": [],
    "i686-pc-windows-msvc": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "i686-unknown-freebsd": ["@rules_rust//rust/platform:i686-unknown-freebsd"],
    "i686-unknown-linux-gnu": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "powerpc-unknown-linux-gnu": ["@rules_rust//rust/platform:powerpc-unknown-linux-gnu"],
    "riscv32imc-unknown-none-elf": ["@rules_rust//rust/platform:riscv32imc-unknown-none-elf"],
    "riscv64gc-unknown-none-elf": ["@rules_rust//rust/platform:riscv64gc-unknown-none-elf"],
    "s390x-unknown-linux-gnu": ["@rules_rust//rust/platform:s390x-unknown-linux-gnu"],
    "thumbv7em-none-eabi": ["@rules_rust//rust/platform:thumbv7em-none-eabi"],
    "thumbv8m.main-none-eabi": ["@rules_rust//rust/platform:thumbv8m.main-none-eabi"],
    "wasm32-unknown-unknown": ["@rules_rust//rust/platform:wasm32-unknown-unknown"],
    "wasm32-wasip1": ["@rules_rust//rust/platform:wasm32-wasip1"],
    "x86_64-apple-darwin": ["@rules_rust//rust/platform:x86_64-apple-darwin"],
    "x86_64-apple-ios": ["@rules_rust//rust/platform:x86_64-apple-ios"],
    "x86_64-linux-android": ["@rules_rust//rust/platform:x86_64-linux-android"],
    "x86_64-pc-windows-gnullvm": [],
    "x86_64-pc-windows-msvc": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "x86_64-unknown-freebsd": ["@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "x86_64-unknown-fuchsia": ["@rules_rust//rust/platform:x86_64-unknown-fuchsia"],
    "x86_64-unknown-linux-gnu": ["@rules_rust//rust/platform:x86_64-unknown-linux-gnu"],
    "x86_64-unknown-nixos-gnu": ["@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "x86_64-unknown-none": ["@rules_rust//rust/platform:x86_64-unknown-none"],
    "x86_64-unknown-uefi": ["@rules_rust//rust/platform:x86_64-unknown-uefi"],
}

###############################################################################

def crate_repositories():
    """A macro for defining repositories for all generated crates.

    Returns:
      A list of repos visible to the module through the module extension.
    """
    maybe(
        http_archive,
        name = "vendor_py__ahash-0.4.8",
        sha256 = "0453232ace82dee0dd0b4c87a59bd90f7b53b314f3e0f61fe2ee7c8a16482289",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ahash/0.4.8/download"],
        strip_prefix = "ahash-0.4.8",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.ahash-0.4.8.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__aho-corasick-1.1.3",
        sha256 = "8e60d3430d3a69478ad0993f19238d2df97c507009a52b3c10addcd7f6bcb916",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/aho-corasick/1.1.3/download"],
        strip_prefix = "aho-corasick-1.1.3",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.aho-corasick-1.1.3.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__anstream-0.6.18",
        sha256 = "8acc5369981196006228e28809f761875c0327210a891e941f4c683b3a99529b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstream/0.6.18/download"],
        strip_prefix = "anstream-0.6.18",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.anstream-0.6.18.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__anstyle-1.0.10",
        sha256 = "55cc3b69f167a1ef2e161439aa98aed94e6028e5f9a59be9a6ffb47aef1651f9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle/1.0.10/download"],
        strip_prefix = "anstyle-1.0.10",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.anstyle-1.0.10.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__anstyle-parse-0.2.6",
        sha256 = "3b2d16507662817a6a20a9ea92df6652ee4f94f914589377d69f3b21bc5798a9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle-parse/0.2.6/download"],
        strip_prefix = "anstyle-parse-0.2.6",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.anstyle-parse-0.2.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__anstyle-query-1.1.2",
        sha256 = "79947af37f4177cfead1110013d678905c37501914fba0efea834c3fe9a8d60c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle-query/1.1.2/download"],
        strip_prefix = "anstyle-query-1.1.2",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.anstyle-query-1.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__anstyle-wincon-3.0.7",
        sha256 = "ca3534e77181a9cc07539ad51f2141fe32f6c3ffd4df76db8ad92346b003ae4e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle-wincon/3.0.7/download"],
        strip_prefix = "anstyle-wincon-3.0.7",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.anstyle-wincon-3.0.7.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__anyhow-1.0.95",
        sha256 = "34ac096ce696dc2fcabef30516bb13c0a68a11d30131d3df6f04711467681b04",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anyhow/1.0.95/download"],
        strip_prefix = "anyhow-1.0.95",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.anyhow-1.0.95.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__cc-1.2.14",
        sha256 = "0c3d1b2e905a3a7b00a6141adb0e4c0bb941d11caf55349d863942a1cc44e3c9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cc/1.2.14/download"],
        strip_prefix = "cc-1.2.14",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.cc-1.2.14.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__cfg-if-1.0.0",
        sha256 = "baf1de4339761588bc0619e3cbc0120ee582ebb74b53b4efbf79117bd2da40fd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cfg-if/1.0.0/download"],
        strip_prefix = "cfg-if-1.0.0",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.cfg-if-1.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__clap-4.5.30",
        sha256 = "92b7b18d71fad5313a1e320fa9897994228ce274b60faa4d694fe0ea89cd9e6d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap/4.5.30/download"],
        strip_prefix = "clap-4.5.30",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.clap-4.5.30.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__clap_builder-4.5.30",
        sha256 = "a35db2071778a7344791a4fb4f95308b5673d219dee3ae348b86642574ecc90c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_builder/4.5.30/download"],
        strip_prefix = "clap_builder-4.5.30",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.clap_builder-4.5.30.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__clap_lex-0.7.4",
        sha256 = "f46ad14479a25103f283c0f10005961cf086d8dc42205bb44c46ac563475dca6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_lex/0.7.4/download"],
        strip_prefix = "clap_lex-0.7.4",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.clap_lex-0.7.4.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__colorchoice-1.0.3",
        sha256 = "5b63caa9aa9397e2d9480a9b13673856c78d8ac123288526c37d7839f2a86990",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/colorchoice/1.0.3/download"],
        strip_prefix = "colorchoice-1.0.3",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.colorchoice-1.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__hashbrown-0.9.1",
        sha256 = "d7afe4a420e3fe79967a00898cc1f4db7c8a49a9333a29f8a4bd76a253d5cd04",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hashbrown/0.9.1/download"],
        strip_prefix = "hashbrown-0.9.1",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.hashbrown-0.9.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__is_terminal_polyfill-1.70.1",
        sha256 = "7943c866cc5cd64cbc25b2e01621d07fa8eb2a1a23160ee81ce38704e97b8ecf",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/is_terminal_polyfill/1.70.1/download"],
        strip_prefix = "is_terminal_polyfill-1.70.1",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.is_terminal_polyfill-1.70.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__itoa-1.0.14",
        sha256 = "d75a2a4b1b190afb6f5425f10f6a8f959d2ea0b9c2b1d79553551850539e4674",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/itoa/1.0.14/download"],
        strip_prefix = "itoa-1.0.14",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.itoa-1.0.14.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__log-0.4.25",
        sha256 = "04cbf5b083de1c7e0222a7a51dbfdba1cbe1c6ab0b15e29fff3f6c077fd9cd9f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/log/0.4.25/download"],
        strip_prefix = "log-0.4.25",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.log-0.4.25.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__memchr-2.7.4",
        sha256 = "78ca9ab1a0babb1e7d5695e3530886289c18cf2f87ec19a575a0abdce112e3a3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/memchr/2.7.4/download"],
        strip_prefix = "memchr-2.7.4",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.memchr-2.7.4.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__once_cell-1.20.3",
        sha256 = "945462a4b81e43c4e3ba96bd7b49d834c6f61198356aa858733bc4acf3cbe62e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/once_cell/1.20.3/download"],
        strip_prefix = "once_cell-1.20.3",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.once_cell-1.20.3.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__proc-macro2-1.0.93",
        sha256 = "60946a68e5f9d28b0dc1c21bb8a97ee7d018a8b322fa57838ba31cc878e22d99",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/proc-macro2/1.0.93/download"],
        strip_prefix = "proc-macro2-1.0.93",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.proc-macro2-1.0.93.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__quote-1.0.38",
        sha256 = "0e4dccaaaf89514f546c693ddc140f729f958c247918a13380cccc6078391acc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/quote/1.0.38/download"],
        strip_prefix = "quote-1.0.38",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.quote-1.0.38.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__regex-1.11.1",
        sha256 = "b544ef1b4eac5dc2db33ea63606ae9ffcfac26c1416a2806ae0bf5f56b201191",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex/1.11.1/download"],
        strip_prefix = "regex-1.11.1",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.regex-1.11.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__regex-automata-0.4.9",
        sha256 = "809e8dc61f6de73b46c85f4c96486310fe304c434cfa43669d7b40f711150908",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex-automata/0.4.9/download"],
        strip_prefix = "regex-automata-0.4.9",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.regex-automata-0.4.9.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__regex-syntax-0.8.5",
        sha256 = "2b15c43186be67a4fd63bee50d0303afffcef381492ebe2c5d87f324e1b8815c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex-syntax/0.8.5/download"],
        strip_prefix = "regex-syntax-0.8.5",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.regex-syntax-0.8.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__ryu-1.0.19",
        sha256 = "6ea1a2d0a644769cc99faa24c3ad26b379b786fe7c36fd3c546254801650e6dd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ryu/1.0.19/download"],
        strip_prefix = "ryu-1.0.19",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.ryu-1.0.19.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__serde-1.0.217",
        sha256 = "02fc4265df13d6fa1d00ecff087228cc0a2b5f3c0e87e258d8b94a156e984c70",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde/1.0.217/download"],
        strip_prefix = "serde-1.0.217",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.serde-1.0.217.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__serde_derive-1.0.217",
        sha256 = "5a9bf7cf98d04a2b28aead066b7496853d4779c9cc183c440dbac457641e19a0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_derive/1.0.217/download"],
        strip_prefix = "serde_derive-1.0.217",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.serde_derive-1.0.217.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__serde_json-1.0.138",
        sha256 = "d434192e7da787e94a6ea7e9670b26a036d0ca41e0b7efb2676dd32bae872949",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_json/1.0.138/download"],
        strip_prefix = "serde_json-1.0.138",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.serde_json-1.0.138.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__shlex-1.3.0",
        sha256 = "0fda2ff0d084019ba4d7c6f371c95d8fd75ce3524c3cb8fb653a3023f6323e64",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/shlex/1.3.0/download"],
        strip_prefix = "shlex-1.3.0",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.shlex-1.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__smallvec-1.14.0",
        sha256 = "7fcf8323ef1faaee30a44a340193b1ac6814fd9b7b4e88e9d4519a3e4abe1cfd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/smallvec/1.14.0/download"],
        strip_prefix = "smallvec-1.14.0",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.smallvec-1.14.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__string-interner-0.12.2",
        sha256 = "383196d1876517ee6f9f0864d1fc1070331b803335d3c6daaa04bbcccd823c08",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/string-interner/0.12.2/download"],
        strip_prefix = "string-interner-0.12.2",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.string-interner-0.12.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__strsim-0.11.1",
        sha256 = "7da8b5736845d9f2fcb837ea5d9e2628564b3b043a70948a3f0b778838c5fb4f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/strsim/0.11.1/download"],
        strip_prefix = "strsim-0.11.1",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.strsim-0.11.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__syn-2.0.98",
        sha256 = "36147f1a48ae0ec2b5b3bc5b537d267457555a10dc06f3dbc8cb11ba3006d3b1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/syn/2.0.98/download"],
        strip_prefix = "syn-2.0.98",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.syn-2.0.98.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__thiserror-1.0.69",
        sha256 = "b6aaf5339b578ea85b50e080feb250a3e8ae8cfcdff9a461c9ec2904bc923f52",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/thiserror/1.0.69/download"],
        strip_prefix = "thiserror-1.0.69",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.thiserror-1.0.69.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__thiserror-impl-1.0.69",
        sha256 = "4fee6c4efc90059e10f81e6d42c60a18f76588c3d74cb83a0b242a2b6c7504c1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/thiserror-impl/1.0.69/download"],
        strip_prefix = "thiserror-impl-1.0.69",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.thiserror-impl-1.0.69.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__tree-sitter-0.20.4",
        sha256 = "4e34327f8eac545e3f037382471b2b19367725a242bba7bc45edb9efb49fe39a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tree-sitter/0.20.4/download"],
        strip_prefix = "tree-sitter-0.20.4",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.tree-sitter-0.20.4.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__tree-sitter-graph-0.7.0",
        sha256 = "639d21e886f581d293de5f5081f09af003c54607ff3fa85efa159b243ba1f97a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tree-sitter-graph/0.7.0/download"],
        strip_prefix = "tree-sitter-graph-0.7.0",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.tree-sitter-graph-0.7.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__unicode-ident-1.0.16",
        sha256 = "a210d160f08b701c8721ba1c726c11662f877ea6b7094007e1ca9a1041945034",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicode-ident/1.0.16/download"],
        strip_prefix = "unicode-ident-1.0.16",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.unicode-ident-1.0.16.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__utf8parse-0.2.2",
        sha256 = "06abde3611657adf66d383f00b093d7faecc7fa57071cce2578660c9f1010821",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/utf8parse/0.2.2/download"],
        strip_prefix = "utf8parse-0.2.2",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.utf8parse-0.2.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__windows-sys-0.59.0",
        sha256 = "1e38bc4d79ed67fd075bcc251a1c39b32a1776bbe92e5bef1f0bf1f8c531853b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-sys/0.59.0/download"],
        strip_prefix = "windows-sys-0.59.0",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.windows-sys-0.59.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__windows-targets-0.52.6",
        sha256 = "9b724f72796e036ab90c1021d4780d4d3d648aca59e491e6b98e725b84e99973",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-targets/0.52.6/download"],
        strip_prefix = "windows-targets-0.52.6",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.windows-targets-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__windows_aarch64_gnullvm-0.52.6",
        sha256 = "32a4622180e7a0ec044bb555404c800bc9fd9ec262ec147edd5989ccd0c02cd3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_gnullvm/0.52.6/download"],
        strip_prefix = "windows_aarch64_gnullvm-0.52.6",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.windows_aarch64_gnullvm-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__windows_aarch64_msvc-0.52.6",
        sha256 = "09ec2a7bb152e2252b53fa7803150007879548bc709c039df7627cabbd05d469",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_msvc/0.52.6/download"],
        strip_prefix = "windows_aarch64_msvc-0.52.6",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.windows_aarch64_msvc-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__windows_i686_gnu-0.52.6",
        sha256 = "8e9b5ad5ab802e97eb8e295ac6720e509ee4c243f69d781394014ebfe8bbfa0b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnu/0.52.6/download"],
        strip_prefix = "windows_i686_gnu-0.52.6",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.windows_i686_gnu-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__windows_i686_gnullvm-0.52.6",
        sha256 = "0eee52d38c090b3caa76c563b86c3a4bd71ef1a819287c19d586d7334ae8ed66",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnullvm/0.52.6/download"],
        strip_prefix = "windows_i686_gnullvm-0.52.6",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.windows_i686_gnullvm-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__windows_i686_msvc-0.52.6",
        sha256 = "240948bc05c5e7c6dabba28bf89d89ffce3e303022809e73deaefe4f6ec56c66",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_msvc/0.52.6/download"],
        strip_prefix = "windows_i686_msvc-0.52.6",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.windows_i686_msvc-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__windows_x86_64_gnu-0.52.6",
        sha256 = "147a5c80aabfbf0c7d901cb5895d1de30ef2907eb21fbbab29ca94c5b08b1a78",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnu/0.52.6/download"],
        strip_prefix = "windows_x86_64_gnu-0.52.6",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.windows_x86_64_gnu-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__windows_x86_64_gnullvm-0.52.6",
        sha256 = "24d5b23dc417412679681396f2b49f3de8c1473deb516bd34410872eff51ed0d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnullvm/0.52.6/download"],
        strip_prefix = "windows_x86_64_gnullvm-0.52.6",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.windows_x86_64_gnullvm-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor_py__windows_x86_64_msvc-0.52.6",
        sha256 = "589f6da84c646204747d1270a2a5661ea66ed1cced2631d546fdfb155959f9ec",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_msvc/0.52.6/download"],
        strip_prefix = "windows_x86_64_msvc-0.52.6",
        build_file = Label("//misc/bazel/3rdparty/py_deps:BUILD.windows_x86_64_msvc-0.52.6.bazel"),
    )

    return [
        struct(repo = "vendor_py__anyhow-1.0.95", is_dev_dep = False),
        struct(repo = "vendor_py__cc-1.2.14", is_dev_dep = False),
        struct(repo = "vendor_py__clap-4.5.30", is_dev_dep = False),
        struct(repo = "vendor_py__regex-1.11.1", is_dev_dep = False),
        struct(repo = "vendor_py__tree-sitter-0.20.4", is_dev_dep = False),
        struct(repo = "vendor_py__tree-sitter-graph-0.7.0", is_dev_dep = False),
    ]
