## 4.0.1

### Minor Analysis Improvements

* C# 13: Added QL library support for *collection* like type `params` parameters.
* Added `remote` flow source models for properties of Blazor components annotated with any of the following attributes from `Microsoft.AspNetCore.Components`:
  - `[SupplyParameterFromForm]`
  - `[SupplyParameterFromQuery]`
* Added the constructor and explicit cast operator of `Microsoft.AspNetCore.Components.MarkupString` as an `html-injection` sink. This will help catch cross-site scripting resulting from using `MarkupString`. 
* Added flow summaries for the `Microsoft.AspNetCore.Mvc.Controller::View` method.
* The data flow library has been updated to track types in a slightly different way: The type of the tainted data (which may be stored into fields, etc.) is tracked more precisely, while the types of intermediate containers for nested contents is tracked less precisely. This may have a slight effect on false positives for complex flow paths.
* The C# extractor now supports *basic* extraction of .NET 9 projects. There might be limited support for extraction of code using the new C# 13 language features.
