/**
 * @name Self assignment
 * @description Assigning a variable to itself has no effect.
 * @kind problem
 * @problem.severity warning
 * @id go/redundant-assignment
 * @tags quality
 *       reliability
 *       correctness
 *       external/cwe/cwe-480
 *       external/cwe/cwe-561
 * @precision high
 */

import Clones

/**
 * An assignment that may be a self assignment.
 */
class PotentialSelfAssignment extends HashRoot, AssignStmt {
  PotentialSelfAssignment() { this.getLhs().getKind() = this.getRhs().getKind() }
}

from PotentialSelfAssignment assgn, HashableNode rhs
where
  rhs = assgn.getRhs() and
  rhs.hash() = assgn.getLhs().(HashableNode).hash()
select assgn, "This statement assigns an $@ to itself.", rhs, "expression"
