## 0.8.7

### New Features

* Added a new library `semmle.code.java.security.Sanitizers` which contains a new sanitizer class `SimpleTypeSanitizer`, which represents nodes which cannot realistically carry taint for most queries (e.g. primitives, their boxed equivalents, and numeric types).
* Converted definitions of `isBarrier` and sanitizer classes to use `SimpleTypeSanitizer` instead of checking if `node.getType()` is `PrimitiveType` or `BoxedType`.

### Minor Analysis Improvements

* Deleted many deprecated predicates and classes with uppercase `EJB`, `JMX`, `NFE`, `DNS` etc. in their names. Use the PascalCased versions instead.
* Deleted the deprecated `semmle/code/java/security/OverlyLargeRangeQuery.qll`, `semmle/code/java/security/regexp/ExponentialBackTracking.qll`, `semmle/code/java/security/regexp/NfaUtils.qll`, and `semmle/code/java/security/regexp/NfaUtils.qll` files.
* Improved models for `java.lang.Throwable` and `java.lang.Exception`, and the `valueOf` method of `java.lang.String`.
* Added taint tracking for the following GSON methods:
  * `com.google.gson.stream.JsonReader` constructor
  * `com.google.gson.stream.JsonWriter` constructor
  * `com.google.gson.JsonObject.getAsJsonArray`
  * `com.google.gson.JsonObject.getAsJsonObject`
  * `com.google.gson.JsonObject.getAsJsonPrimitive`
  * `com.google.gson.JsonParser.parseReader`
  * `com.google.gson.JsonParser.parseString`
* Added a dataflow model for `java.awt.Desktop.browse(URI)`.

### Bug Fixes

* Fixed regular expressions containing flags not being parsed correctly in some cases.
