| Component                       | Vendored-in | License                                  | Comments                                                                                                                                                                                       |
| ------------------------------- | ----------- | ---------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `data/python/stubs/six`         | Y           | MIT, see `data/python/stubs/six/LICENSE` | Stubs for `six` (the Python 2/3 compatibility library), based on the original library but simplified to aid analysis.                                                                          |
| `lark`                          | Y           | MIT, see `lark/LICENSE`                  | Parsing library. Used for extracting `.thrift` files.                                                                                                                                          |
| `tests/tokenizer/shift_jis.py`  | Y           | PSF                                      | Test file copied (with attribution) from the `cpython` source code.                                                                                                                            |
| `tsg-python/tree-sitter-python` | Y           | MIT                                      | Used in `tsg-python` to parse Python files                                                                                                                                                     |
| `tsg-python`                    | Y           | MIT / Apache                             | This is our own creation, so are free to choose what license it is covered by.                                                                                                                 |
| `tree-sitter-graph`             | N           | MIT / Apache                             | Used in `tsg-python` to execute files written in the `tree-sitter-graph` language.                                                                                                             |
| `imp.py`                        | Y           | PSF                                      | Copied and adapted from `Lib/imp.py` from the `cpython` source code, with attribution.                                                                                                         |
| `semmle/data/*.trap`            | Y           | PSF                                      | These files were derived from the C source code of the `cpython` project, and are used in our modelling of built-in objects. No attribution, currently.                                        |
| `semmle/thrift/parse.py`        | Y           | Apache                                   | Includes a grammar based on https://github.com/apache/thrift/blob/master/doc/specs/idl.md, with comment stating this attribution.                                                              |
| `semmle/python/ast.py`          | Y           | PSF                                      | Copied and adapted from `Lib/ast.py` from the `cpython` source code. Not explicitly attributed.                                                                                                |
| `blib2to3`                      | Y           | PSF / MIT                                | A modified version of `blib2to3` from the `psf/black` project (MIT licensed), itself a copy of `lib2to3` from the `cpython` project (PSF licensed), with a thorough attribution for this fact. |
