/**
 * @name Weak KDF salt generation.
 * @description KDF salts must be generated by an approved random number generator (os.urandom)
 * @kind problem
 * @id py/kdf-weak-salt-gen
 * @problem.severity error
 * @precision high
 */

import python
import experimental.cryptography.Concepts
private import experimental.cryptography.utils.Utils as Utils

from KeyDerivationOperation op, DataFlow::Node saltSrc
where
  op.requiresSalt() and
  not API::moduleImport("os").getMember("urandom").getACall() = saltSrc and
  saltSrc = op.getSaltConfigSrc()
select op, "Salt configuration is not from an accepted random source: $@. Must be os.urandom",
  saltSrc, saltSrc.toString()
