## 0.5.0

### Major Analysis Improvements

* Flow through `initialize` constructors is now taken into account. For example, in
  ```rb
  class C
    def initialize(x)
      @field = x
    end
  end

  C.new(y)
  ```
  there will be flow from `y` to the field `@field` on the constructed `C` object.

### Minor Analysis Improvements

* Calls to `Kernel.load`, `Kernel.require`, `Kernel.autoload` are now modeled as sinks for path injection.
* Calls to `mail` and `inbound_mail` in `ActionMailbox` controllers are now considered sources of remote input.
* Calls to `GlobalID::Locator.locate` and its variants are now recognized as instances of `OrmInstantiation`.
* Data flow through the `ActiveSupport` extensions `Enumerable#index_with`, `Enumerable#pick`, `Enumerable#pluck` and `Enumerable#sole`  are now modeled.
* When resolving a method call, the analysis now also searches in sub-classes of the receiver's type.
* Taint flow is now tracked through many common JSON parsing and generation methods.
* The ReDoS libraries in `codeql.ruby.security.regexp` has been moved to a shared pack inside the `shared/` folder, and the previous location has been deprecated.
* String literals and arrays of string literals in case expression patterns are now recognised as barrier guards.
