// generated by codegen, do not edit
/**
 * This module provides the generated definition of `AsmRegOperand`.
 * INTERNAL: Do not import directly.
 */

private import codeql.rust.elements.internal.generated.Synth
private import codeql.rust.elements.internal.generated.Raw
import codeql.rust.elements.AsmDirSpec
import codeql.rust.elements.AsmOperandExpr
import codeql.rust.elements.internal.AsmOperandImpl::Impl as AsmOperandImpl
import codeql.rust.elements.AsmRegSpec

/**
 * INTERNAL: This module contains the fully generated definition of `AsmRegOperand` and should not
 * be referenced directly.
 */
module Generated {
  /**
   * A register operand in an inline assembly block.
   *
   * For example:
   * ```rust
   * use core::arch::asm;
   * asm!("mov {0}, {1}", out(reg) x, in(reg) y);
   * //                            ^         ^
   * ```
   * INTERNAL: Do not reference the `Generated::AsmRegOperand` class directly.
   * Use the subclass `AsmRegOperand`, where the following predicates are available.
   */
  class AsmRegOperand extends Synth::TAsmRegOperand, AsmOperandImpl::AsmOperand {
    override string getAPrimaryQlClass() { result = "AsmRegOperand" }

    /**
     * Gets the asm dir spec of this asm reg operand, if it exists.
     */
    AsmDirSpec getAsmDirSpec() {
      result =
        Synth::convertAsmDirSpecFromRaw(Synth::convertAsmRegOperandToRaw(this)
              .(Raw::AsmRegOperand)
              .getAsmDirSpec())
    }

    /**
     * Holds if `getAsmDirSpec()` exists.
     */
    final predicate hasAsmDirSpec() { exists(this.getAsmDirSpec()) }

    /**
     * Gets the asm operand expression of this asm reg operand, if it exists.
     */
    AsmOperandExpr getAsmOperandExpr() {
      result =
        Synth::convertAsmOperandExprFromRaw(Synth::convertAsmRegOperandToRaw(this)
              .(Raw::AsmRegOperand)
              .getAsmOperandExpr())
    }

    /**
     * Holds if `getAsmOperandExpr()` exists.
     */
    final predicate hasAsmOperandExpr() { exists(this.getAsmOperandExpr()) }

    /**
     * Gets the asm reg spec of this asm reg operand, if it exists.
     */
    AsmRegSpec getAsmRegSpec() {
      result =
        Synth::convertAsmRegSpecFromRaw(Synth::convertAsmRegOperandToRaw(this)
              .(Raw::AsmRegOperand)
              .getAsmRegSpec())
    }

    /**
     * Holds if `getAsmRegSpec()` exists.
     */
    final predicate hasAsmRegSpec() { exists(this.getAsmRegSpec()) }
  }
}
