// generated by codegen, do not edit
/**
 * This module provides the generated definition of `Const`.
 * INTERNAL: Do not import directly.
 */

private import codeql.rust.elements.internal.generated.Synth
private import codeql.rust.elements.internal.generated.Raw
import codeql.rust.elements.internal.AssocItemImpl::Impl as AssocItemImpl
import codeql.rust.elements.Attr
import codeql.rust.elements.Expr
import codeql.rust.elements.GenericParamList
import codeql.rust.elements.Name
import codeql.rust.elements.TypeRepr
import codeql.rust.elements.Visibility
import codeql.rust.elements.WhereClause

/**
 * INTERNAL: This module contains the fully generated definition of `Const` and should not
 * be referenced directly.
 */
module Generated {
  /**
   * A constant item declaration.
   *
   * For example:
   * ```rust
   * const X: i32 = 42;
   * ```
   * INTERNAL: Do not reference the `Generated::Const` class directly.
   * Use the subclass `Const`, where the following predicates are available.
   */
  class Const extends Synth::TConst, AssocItemImpl::AssocItem {
    override string getAPrimaryQlClass() { result = "Const" }

    /**
     * Gets the `index`th attr of this const (0-based).
     */
    Attr getAttr(int index) {
      result = Synth::convertAttrFromRaw(Synth::convertConstToRaw(this).(Raw::Const).getAttr(index))
    }

    /**
     * Gets any of the attrs of this const.
     */
    final Attr getAnAttr() { result = this.getAttr(_) }

    /**
     * Gets the number of attrs of this const.
     */
    final int getNumberOfAttrs() { result = count(int i | exists(this.getAttr(i))) }

    /**
     * Gets the body of this const, if it exists.
     */
    Expr getBody() {
      result = Synth::convertExprFromRaw(Synth::convertConstToRaw(this).(Raw::Const).getBody())
    }

    /**
     * Holds if `getBody()` exists.
     */
    final predicate hasBody() { exists(this.getBody()) }

    /**
     * Gets the generic parameter list of this const, if it exists.
     */
    GenericParamList getGenericParamList() {
      result =
        Synth::convertGenericParamListFromRaw(Synth::convertConstToRaw(this)
              .(Raw::Const)
              .getGenericParamList())
    }

    /**
     * Holds if `getGenericParamList()` exists.
     */
    final predicate hasGenericParamList() { exists(this.getGenericParamList()) }

    /**
     * Holds if this const is const.
     */
    predicate isConst() { Synth::convertConstToRaw(this).(Raw::Const).isConst() }

    /**
     * Holds if this const is default.
     */
    predicate isDefault() { Synth::convertConstToRaw(this).(Raw::Const).isDefault() }

    /**
     * Gets the name of this const, if it exists.
     */
    Name getName() {
      result = Synth::convertNameFromRaw(Synth::convertConstToRaw(this).(Raw::Const).getName())
    }

    /**
     * Holds if `getName()` exists.
     */
    final predicate hasName() { exists(this.getName()) }

    /**
     * Gets the type representation of this const, if it exists.
     */
    TypeRepr getTypeRepr() {
      result =
        Synth::convertTypeReprFromRaw(Synth::convertConstToRaw(this).(Raw::Const).getTypeRepr())
    }

    /**
     * Holds if `getTypeRepr()` exists.
     */
    final predicate hasTypeRepr() { exists(this.getTypeRepr()) }

    /**
     * Gets the visibility of this const, if it exists.
     */
    Visibility getVisibility() {
      result =
        Synth::convertVisibilityFromRaw(Synth::convertConstToRaw(this).(Raw::Const).getVisibility())
    }

    /**
     * Holds if `getVisibility()` exists.
     */
    final predicate hasVisibility() { exists(this.getVisibility()) }

    /**
     * Gets the where clause of this const, if it exists.
     */
    WhereClause getWhereClause() {
      result =
        Synth::convertWhereClauseFromRaw(Synth::convertConstToRaw(this)
              .(Raw::Const)
              .getWhereClause())
    }

    /**
     * Holds if `getWhereClause()` exists.
     */
    final predicate hasWhereClause() { exists(this.getWhereClause()) }

    /**
     * Holds if this constant has an implementation.
     *
     * This is the same as `hasBody` for source code, but for library code (for which we always skip
     * the body), this will hold when the body was present in the original code.
     */
    predicate hasImplementation() {
      Synth::convertConstToRaw(this).(Raw::Const).hasImplementation()
    }
  }
}
