// generated by codegen, do not edit
/**
 * This module provides the generated definition of `ConstParam`.
 * INTERNAL: Do not import directly.
 */

private import codeql.rust.elements.internal.generated.Synth
private import codeql.rust.elements.internal.generated.Raw
import codeql.rust.elements.Attr
import codeql.rust.elements.ConstArg
import codeql.rust.elements.internal.GenericParamImpl::Impl as GenericParamImpl
import codeql.rust.elements.Name
import codeql.rust.elements.TypeRepr

/**
 * INTERNAL: This module contains the fully generated definition of `ConstParam` and should not
 * be referenced directly.
 */
module Generated {
  /**
   * A constant parameter in a generic parameter list.
   *
   * For example:
   * ```rust
   * struct Foo <const N: usize>;
   * //          ^^^^^^^^^^^^^^
   * ```
   * INTERNAL: Do not reference the `Generated::ConstParam` class directly.
   * Use the subclass `ConstParam`, where the following predicates are available.
   */
  class ConstParam extends Synth::TConstParam, GenericParamImpl::GenericParam {
    override string getAPrimaryQlClass() { result = "ConstParam" }

    /**
     * Gets the `index`th attr of this const parameter (0-based).
     */
    Attr getAttr(int index) {
      result =
        Synth::convertAttrFromRaw(Synth::convertConstParamToRaw(this)
              .(Raw::ConstParam)
              .getAttr(index))
    }

    /**
     * Gets any of the attrs of this const parameter.
     */
    final Attr getAnAttr() { result = this.getAttr(_) }

    /**
     * Gets the number of attrs of this const parameter.
     */
    final int getNumberOfAttrs() { result = count(int i | exists(this.getAttr(i))) }

    /**
     * Gets the default val of this const parameter, if it exists.
     */
    ConstArg getDefaultVal() {
      result =
        Synth::convertConstArgFromRaw(Synth::convertConstParamToRaw(this)
              .(Raw::ConstParam)
              .getDefaultVal())
    }

    /**
     * Holds if `getDefaultVal()` exists.
     */
    final predicate hasDefaultVal() { exists(this.getDefaultVal()) }

    /**
     * Holds if this const parameter is const.
     */
    predicate isConst() { Synth::convertConstParamToRaw(this).(Raw::ConstParam).isConst() }

    /**
     * Gets the name of this const parameter, if it exists.
     */
    Name getName() {
      result =
        Synth::convertNameFromRaw(Synth::convertConstParamToRaw(this).(Raw::ConstParam).getName())
    }

    /**
     * Holds if `getName()` exists.
     */
    final predicate hasName() { exists(this.getName()) }

    /**
     * Gets the type representation of this const parameter, if it exists.
     */
    TypeRepr getTypeRepr() {
      result =
        Synth::convertTypeReprFromRaw(Synth::convertConstParamToRaw(this)
              .(Raw::ConstParam)
              .getTypeRepr())
    }

    /**
     * Holds if `getTypeRepr()` exists.
     */
    final predicate hasTypeRepr() { exists(this.getTypeRepr()) }
  }
}
