// generated by codegen, do not edit
/**
 * This module provides the generated definition of `LetStmt`.
 * INTERNAL: Do not import directly.
 */

private import codeql.rust.elements.internal.generated.Synth
private import codeql.rust.elements.internal.generated.Raw
import codeql.rust.elements.Attr
import codeql.rust.elements.Expr
import codeql.rust.elements.LetElse
import codeql.rust.elements.Pat
import codeql.rust.elements.internal.StmtImpl::Impl as StmtImpl
import codeql.rust.elements.TypeRepr

/**
 * INTERNAL: This module contains the fully generated definition of `LetStmt` and should not
 * be referenced directly.
 */
module Generated {
  /**
   * A let statement. For example:
   * ```rust
   * let x = 42;
   * let x: i32 = 42;
   * let x: i32;
   * let x;
   * let (x, y) = (1, 2);
   * let Some(x) = std::env::var("FOO") else {
   *     return;
   * };
   * ```
   * INTERNAL: Do not reference the `Generated::LetStmt` class directly.
   * Use the subclass `LetStmt`, where the following predicates are available.
   */
  class LetStmt extends Synth::TLetStmt, StmtImpl::Stmt {
    override string getAPrimaryQlClass() { result = "LetStmt" }

    /**
     * Gets the `index`th attr of this let statement (0-based).
     */
    Attr getAttr(int index) {
      result =
        Synth::convertAttrFromRaw(Synth::convertLetStmtToRaw(this).(Raw::LetStmt).getAttr(index))
    }

    /**
     * Gets any of the attrs of this let statement.
     */
    final Attr getAnAttr() { result = this.getAttr(_) }

    /**
     * Gets the number of attrs of this let statement.
     */
    final int getNumberOfAttrs() { result = count(int i | exists(this.getAttr(i))) }

    /**
     * Gets the initializer of this let statement, if it exists.
     */
    Expr getInitializer() {
      result =
        Synth::convertExprFromRaw(Synth::convertLetStmtToRaw(this).(Raw::LetStmt).getInitializer())
    }

    /**
     * Holds if `getInitializer()` exists.
     */
    final predicate hasInitializer() { exists(this.getInitializer()) }

    /**
     * Gets the let else of this let statement, if it exists.
     */
    LetElse getLetElse() {
      result =
        Synth::convertLetElseFromRaw(Synth::convertLetStmtToRaw(this).(Raw::LetStmt).getLetElse())
    }

    /**
     * Holds if `getLetElse()` exists.
     */
    final predicate hasLetElse() { exists(this.getLetElse()) }

    /**
     * Gets the pattern of this let statement, if it exists.
     */
    Pat getPat() {
      result = Synth::convertPatFromRaw(Synth::convertLetStmtToRaw(this).(Raw::LetStmt).getPat())
    }

    /**
     * Holds if `getPat()` exists.
     */
    final predicate hasPat() { exists(this.getPat()) }

    /**
     * Gets the type representation of this let statement, if it exists.
     */
    TypeRepr getTypeRepr() {
      result =
        Synth::convertTypeReprFromRaw(Synth::convertLetStmtToRaw(this).(Raw::LetStmt).getTypeRepr())
    }

    /**
     * Holds if `getTypeRepr()` exists.
     */
    final predicate hasTypeRepr() { exists(this.getTypeRepr()) }
  }
}
