// generated by codegen, do not edit
/**
 * This module provides the generated definition of `MatchExpr`.
 * INTERNAL: Do not import directly.
 */

private import codeql.rust.elements.internal.generated.Synth
private import codeql.rust.elements.internal.generated.Raw
import codeql.rust.elements.Attr
import codeql.rust.elements.Expr
import codeql.rust.elements.internal.ExprImpl::Impl as ExprImpl
import codeql.rust.elements.MatchArmList

/**
 * INTERNAL: This module contains the fully generated definition of `MatchExpr` and should not
 * be referenced directly.
 */
module Generated {
  /**
   * A match expression. For example:
   * ```rust
   * match x {
   *     Option::Some(y) => y,
   *     Option::None => 0,
   * }
   * ```
   * ```rust
   * match x {
   *     Some(y) if y != 0 => 1 / y,
   *     _ => 0,
   * }
   * ```
   * INTERNAL: Do not reference the `Generated::MatchExpr` class directly.
   * Use the subclass `MatchExpr`, where the following predicates are available.
   */
  class MatchExpr extends Synth::TMatchExpr, ExprImpl::Expr {
    override string getAPrimaryQlClass() { result = "MatchExpr" }

    /**
     * Gets the `index`th attr of this match expression (0-based).
     */
    Attr getAttr(int index) {
      result =
        Synth::convertAttrFromRaw(Synth::convertMatchExprToRaw(this).(Raw::MatchExpr).getAttr(index))
    }

    /**
     * Gets any of the attrs of this match expression.
     */
    final Attr getAnAttr() { result = this.getAttr(_) }

    /**
     * Gets the number of attrs of this match expression.
     */
    final int getNumberOfAttrs() { result = count(int i | exists(this.getAttr(i))) }

    /**
     * Gets the scrutinee (the expression being matched) of this match expression, if it exists.
     */
    Expr getScrutinee() {
      result =
        Synth::convertExprFromRaw(Synth::convertMatchExprToRaw(this).(Raw::MatchExpr).getScrutinee())
    }

    /**
     * Holds if `getScrutinee()` exists.
     */
    final predicate hasScrutinee() { exists(this.getScrutinee()) }

    /**
     * Gets the match arm list of this match expression, if it exists.
     */
    MatchArmList getMatchArmList() {
      result =
        Synth::convertMatchArmListFromRaw(Synth::convertMatchExprToRaw(this)
              .(Raw::MatchExpr)
              .getMatchArmList())
    }

    /**
     * Holds if `getMatchArmList()` exists.
     */
    final predicate hasMatchArmList() { exists(this.getMatchArmList()) }
  }
}
