// generated by codegen, do not edit
/**
 * This module provides the generated definition of `SelfParam`.
 * INTERNAL: Do not import directly.
 */

private import codeql.rust.elements.internal.generated.Synth
private import codeql.rust.elements.internal.generated.Raw
import codeql.rust.elements.Lifetime
import codeql.rust.elements.Name
import codeql.rust.elements.internal.ParamBaseImpl::Impl as ParamBaseImpl

/**
 * INTERNAL: This module contains the fully generated definition of `SelfParam` and should not
 * be referenced directly.
 */
module Generated {
  /**
   * A `self` parameter. For example `self` in:
   * ```rust
   * struct X;
   * impl X {
   *   fn one(&self) {}
   *   fn two(&mut self) {}
   *   fn three(self) {}
   *   fn four(mut self) {}
   *   fn five<'a>(&'a self) {}
   * }
   * ```
   * INTERNAL: Do not reference the `Generated::SelfParam` class directly.
   * Use the subclass `SelfParam`, where the following predicates are available.
   */
  class SelfParam extends Synth::TSelfParam, ParamBaseImpl::ParamBase {
    override string getAPrimaryQlClass() { result = "SelfParam" }

    /**
     * Holds if this self parameter is reference.
     */
    predicate isRef() { Synth::convertSelfParamToRaw(this).(Raw::SelfParam).isRef() }

    /**
     * Holds if this self parameter is mut.
     */
    predicate isMut() { Synth::convertSelfParamToRaw(this).(Raw::SelfParam).isMut() }

    /**
     * Gets the lifetime of this self parameter, if it exists.
     */
    Lifetime getLifetime() {
      result =
        Synth::convertLifetimeFromRaw(Synth::convertSelfParamToRaw(this)
              .(Raw::SelfParam)
              .getLifetime())
    }

    /**
     * Holds if `getLifetime()` exists.
     */
    final predicate hasLifetime() { exists(this.getLifetime()) }

    /**
     * Gets the name of this self parameter, if it exists.
     */
    Name getName() {
      result =
        Synth::convertNameFromRaw(Synth::convertSelfParamToRaw(this).(Raw::SelfParam).getName())
    }

    /**
     * Holds if `getName()` exists.
     */
    final predicate hasName() { exists(this.getName()) }
  }
}
