// generated by codegen/codegen.py, do not edit
/**
 * This module provides the generated definition of `PackType`.
 * INTERNAL: Do not import directly.
 */

private import codeql.swift.generated.Synth
private import codeql.swift.generated.Raw
import codeql.swift.elements.type.Type
import codeql.swift.elements.type.internal.TypeImpl::Impl as TypeImpl

/**
 * INTERNAL: This module contains the fully generated definition of `PackType` and should not
 * be referenced directly.
 */
module Generated {
  /**
   * An actual type of a pack expression at the instatiation point.
   *
   * In the following example, PackType will appear around `makeTuple` call site as `Pack{String, Int}`:
   * ```
   * func makeTuple<each T>(_ t: repeat each T) -> (repeat each T) { ... }
   * makeTuple("A", 2)
   * ```
   *
   * More details:
   * https://github.com/apple/swift-evolution/blob/main/proposals/0393-parameter-packs.md
   * INTERNAL: Do not reference the `Generated::PackType` class directly.
   * Use the subclass `PackType`, where the following predicates are available.
   */
  class PackType extends Synth::TPackType, TypeImpl::Type {
    override string getAPrimaryQlClass() { result = "PackType" }

    /**
     * Gets the `index`th element of this pack type (0-based).
     *
     * This includes nodes from the "hidden" AST. It can be overridden in subclasses to change the
     * behavior of both the `Immediate` and non-`Immediate` versions.
     */
    Type getImmediateElement(int index) {
      result =
        Synth::convertTypeFromRaw(Synth::convertPackTypeToRaw(this)
              .(Raw::PackType)
              .getElement(index))
    }

    /**
     * Gets the `index`th element of this pack type (0-based).
     */
    final Type getElement(int index) {
      exists(Type immediate |
        immediate = this.getImmediateElement(index) and
        if exists(this.getResolveStep()) then result = immediate else result = immediate.resolve()
      )
    }

    /**
     * Gets any of the elements of this pack type.
     */
    final Type getAnElement() { result = this.getElement(_) }

    /**
     * Gets the number of elements of this pack type.
     */
    final int getNumberOfElements() { result = count(int i | exists(this.getElement(i))) }
  }
}
