// Code generated by depstubber. DO NOT EDIT.
// This is a simple stub for go-micro.dev/v4/client, strictly for use in testing.

// See the LICENSE file for information about the licensing of the original library.
// Source: go-micro.dev/v4/client (exports: Client; functions: Call)

// Package client is a stub of go-micro.dev/v4/client, generated by depstubber.
package client

import (
	context "context"
	time "time"
)

type BackoffFunc func(context.Context, Request, int) (time.Duration, error)

type Cache struct{}

func (_ *Cache) Get(_ context.Context, _ *Request) (interface{}, bool) {
	return nil, false
}

func (_ *Cache) List() map[string]string {
	return nil
}

func (_ *Cache) Set(_ context.Context, _ *Request, _ interface{}, _ time.Duration) {}

func Call(_ context.Context, _ Request, _ interface{}, _ ...CallOption) error {
	return nil
}

type CallFunc func(context.Context, interface{}, Request, interface{}, CallOptions) error

type CallOption func(*CallOptions)

type CallOptions struct {
	Context           context.Context
	Backoff           BackoffFunc
	Retry             RetryFunc
	SelectOptions     []interface{}
	Address           []string
	CallWrappers      []CallWrapper
	ConnectionTimeout time.Duration
	RequestTimeout    time.Duration
	StreamTimeout     time.Duration
	CacheExpiry       time.Duration
	DialTimeout       time.Duration
	Retries           int
	ServiceToken      bool
	ConnClose         bool
}

type CallWrapper func(CallFunc) CallFunc

type Client interface {
	Call(_ context.Context, _ Request, _ interface{}, _ ...CallOption) error
	Init(_ ...Option) error
	NewMessage(_ string, _ interface{}, _ ...MessageOption) Message
	NewRequest(_ string, _ string, _ interface{}, _ ...RequestOption) Request
	Options() Options
	Publish(_ context.Context, _ Message, _ ...PublishOption) error
	Stream(_ context.Context, _ Request, _ ...CallOption) (Stream, error)
	String() string
}

type Message interface {
	ContentType() string
	Payload() interface{}
	Topic() string
}

type MessageOption func(*MessageOptions)

type MessageOptions struct {
	ContentType string
}

type Option func(*Options)

type Options struct {
	CallOptions CallOptions
	Router      Router
	Registry    interface{}
	Selector    interface{}
	Transport   interface{}
	Broker      interface{}
	Logger      interface{}
	Context     context.Context
	Codecs      map[string]interface{}
	Cache       *Cache
	ContentType string
	Wrappers    []Wrapper
	PoolSize    int
	PoolTTL     time.Duration
}

type PublishOption func(*PublishOptions)

type PublishOptions struct {
	Context  context.Context
	Exchange string
}

type Request interface {
	Body() interface{}
	Codec() interface{}
	ContentType() string
	Endpoint() string
	Method() string
	Service() string
	Stream() bool
}

type RequestOption func(*RequestOptions)

type RequestOptions struct {
	Context     context.Context
	ContentType string
	Stream      bool
}

type Response interface {
	Codec() interface{}
	Header() map[string]string
	Read() ([]byte, error)
}

type RetryFunc func(context.Context, Request, int, error) (bool, error)

type Router interface {
	SendRequest(_ context.Context, _ Request) (Response, error)
}

type Stream interface {
	Close() error
	CloseSend() error
	Context() context.Context
	Error() error
	Recv(_ interface{}) error
	Request() Request
	Response() Response
	Send(_ interface{}) error
}

type Wrapper func(Client) Client
