/**
 * @name Inefficient empty string test
 * @description Checking a string for equality with an empty string is inefficient.
 * @kind problem
 * @problem.severity recommendation
 * @precision high
 * @id java/inefficient-empty-string-test
 * @tags quality
 *       maintainability
 *       readability
 */

import java

from MethodCall mc
where
  mc.getQualifier().getType() instanceof TypeString and
  mc.getMethod().hasName("equals") and
  (
    mc.getArgument(0).(StringLiteral).getValue() = "" or
    mc.getQualifier().(StringLiteral).getValue() = ""
  )
select mc, "Inefficient comparison to empty string, check for zero length instead."
