## 0.3.3

### New Queries

* Added a new query, `java/android/implicitly-exported-component`, to detect if components are implicitly exported in the Android manifest.
* A new query "Use of RSA algorithm without OAEP" (`java/rsa-without-oaep`) has been added. This query finds uses of RSA encryption that don't use the OAEP scheme.
* Added a new query, `java/android/debuggable-attribute-enabled`, to detect if the `android:debuggable` attribute is enabled in the Android manifest.
* The query "Using a static initialization vector for encryption" (`java/static-initialization-vector`) has been promoted from experimental to the main query pack. This query was originally [submitted as an experimental query by @artem-smotrakov](https://github.com/github/codeql/pull/6357).
* A new query `java/partial-path-traversal` finds partial path traversal vulnerabilities resulting from incorrectly using 
`String#startsWith` to compare canonical paths. 
* Added a new query, `java/suspicious-regexp-range`, to detect character ranges in regular expressions that seem to match 
  too many characters.

### Query Metadata Changes

* The queries `java/redos` and `java/polynomial-redos` now have a tag for CWE-1333. 

### Minor Analysis Improvements

* The query `java/static-initialization-vector` no longer requires a `Cipher` object to be initialized with `ENCRYPT_MODE` to be considered a valid sink. Also, several new sanitizers were added.
* Improved sanitizers for `java/sensitive-log`, which removes some false positives and improves performance a bit.
