// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

package com.azure.identity;

import com.azure.core.credential.TokenCredential;

/**
 * An AAD credential that acquires a token with a client secret for an AAD application.
 *
 * <p><strong>Sample: Construct a simple ClientSecretCredential</strong></p>
 * {@codesnippet com.azure.identity.credential.clientsecretcredential.construct}
 *
 * <p><strong>Sample: Construct a ClientSecretCredential behind a proxy</strong></p>
 * {@codesnippet com.azure.identity.credential.clientsecretcredential.constructwithproxy}
 */
public class ClientSecretCredential implements TokenCredential {
}
