## 0.7.1

### New Features

* The `DataFlow::StateConfigSig` signature module has gained default implementations for `isBarrier/2` and `isAdditionalFlowStep/4`. 
  Hence it is no longer needed to provide `none()` implementations of these predicates if they are not needed.

### Major Analysis Improvements

* The API graph library (`codeql.ruby.ApiGraphs`) has been significantly improved, with better support for inheritance,
  and data-flow nodes can now be converted to API nodes by calling `.track()` or `.backtrack()` on the node.
  API graphs allow for efficient modelling of how a given value is used by the code base, or how values produced by the code base
  are consumed by a library. See the documentation for `API::Node` for details and examples.

### Minor Analysis Improvements

* Data flow configurations can now include a predicate `neverSkip(Node node)`
  in order to ensure inclusion of certain nodes in the path explanations. The
  predicate defaults to the end-points of the additional flow steps provided in
  the configuration, which means that such steps now always are visible by
  default in path explanations.
* The `'QUERY_STRING'` field of a Rack `env` parameter is now recognized as a source of remote user input.
* Query parameters and cookies from `Rack::Response` objects are recognized as potential sources of remote flow input.
* Calls to `Rack::Utils.parse_query` now propagate taint.
