// generated by codegen, do not edit
/**
 * This module provides the generated definition of `AsmOperandExpr`.
 * INTERNAL: Do not import directly.
 */

private import codeql.rust.elements.internal.generated.Synth
private import codeql.rust.elements.internal.generated.Raw
import codeql.rust.elements.internal.AstNodeImpl::Impl as AstNodeImpl
import codeql.rust.elements.Expr

/**
 * INTERNAL: This module contains the fully generated definition of `AsmOperandExpr` and should not
 * be referenced directly.
 */
module Generated {
  /**
   * An operand expression in an inline assembly block.
   *
   * For example:
   * ```rust
   * use core::arch::asm;
   * asm!("mov {0}, {1}", out(reg) x, in(reg) y);
   * //                            ^          ^
   * ```
   * INTERNAL: Do not reference the `Generated::AsmOperandExpr` class directly.
   * Use the subclass `AsmOperandExpr`, where the following predicates are available.
   */
  class AsmOperandExpr extends Synth::TAsmOperandExpr, AstNodeImpl::AstNode {
    override string getAPrimaryQlClass() { result = "AsmOperandExpr" }

    /**
     * Gets the in expression of this asm operand expression, if it exists.
     */
    Expr getInExpr() {
      result =
        Synth::convertExprFromRaw(Synth::convertAsmOperandExprToRaw(this)
              .(Raw::AsmOperandExpr)
              .getInExpr())
    }

    /**
     * Holds if `getInExpr()` exists.
     */
    final predicate hasInExpr() { exists(this.getInExpr()) }

    /**
     * Gets the out expression of this asm operand expression, if it exists.
     */
    Expr getOutExpr() {
      result =
        Synth::convertExprFromRaw(Synth::convertAsmOperandExprToRaw(this)
              .(Raw::AsmOperandExpr)
              .getOutExpr())
    }

    /**
     * Holds if `getOutExpr()` exists.
     */
    final predicate hasOutExpr() { exists(this.getOutExpr()) }
  }
}
