// generated by codegen, do not edit
/**
 * This module provides the generated definition of `LiteralExpr`.
 * INTERNAL: Do not import directly.
 */

private import codeql.rust.elements.internal.generated.Synth
private import codeql.rust.elements.internal.generated.Raw
import codeql.rust.elements.Attr
import codeql.rust.elements.internal.ExprImpl::Impl as ExprImpl

/**
 * INTERNAL: This module contains the fully generated definition of `LiteralExpr` and should not
 * be referenced directly.
 */
module Generated {
  /**
   * A literal expression. For example:
   * ```rust
   * 42;
   * 42.0;
   * "Hello, world!";
   * b"Hello, world!";
   * 'x';
   * b'x';
   * r"Hello, world!";
   * true;
   * ```
   * INTERNAL: Do not reference the `Generated::LiteralExpr` class directly.
   * Use the subclass `LiteralExpr`, where the following predicates are available.
   */
  class LiteralExpr extends Synth::TLiteralExpr, ExprImpl::Expr {
    override string getAPrimaryQlClass() { result = "LiteralExpr" }

    /**
     * Gets the `index`th attr of this literal expression (0-based).
     */
    Attr getAttr(int index) {
      result =
        Synth::convertAttrFromRaw(Synth::convertLiteralExprToRaw(this)
              .(Raw::LiteralExpr)
              .getAttr(index))
    }

    /**
     * Gets any of the attrs of this literal expression.
     */
    final Attr getAnAttr() { result = this.getAttr(_) }

    /**
     * Gets the number of attrs of this literal expression.
     */
    final int getNumberOfAttrs() { result = count(int i | exists(this.getAttr(i))) }

    /**
     * Gets the text value of this literal expression, if it exists.
     */
    string getTextValue() {
      result = Synth::convertLiteralExprToRaw(this).(Raw::LiteralExpr).getTextValue()
    }

    /**
     * Holds if `getTextValue()` exists.
     */
    final predicate hasTextValue() { exists(this.getTextValue()) }
  }
}
