// generated by codegen, do not edit
/**
 * This module provides the generated definition of `RangeExpr`.
 * INTERNAL: Do not import directly.
 */

private import codeql.rust.elements.internal.generated.Synth
private import codeql.rust.elements.internal.generated.Raw
import codeql.rust.elements.Attr
import codeql.rust.elements.Expr
import codeql.rust.elements.internal.ExprImpl::Impl as ExprImpl

/**
 * INTERNAL: This module contains the fully generated definition of `RangeExpr` and should not
 * be referenced directly.
 */
module Generated {
  /**
   * A range expression. For example:
   * ```rust
   * let x = 1..=10;
   * let x = 1..10;
   * let x = 10..;
   * let x = ..10;
   * let x = ..=10;
   * let x = ..;
   * ```
   * INTERNAL: Do not reference the `Generated::RangeExpr` class directly.
   * Use the subclass `RangeExpr`, where the following predicates are available.
   */
  class RangeExpr extends Synth::TRangeExpr, ExprImpl::Expr {
    override string getAPrimaryQlClass() { result = "RangeExpr" }

    /**
     * Gets the `index`th attr of this range expression (0-based).
     */
    Attr getAttr(int index) {
      result =
        Synth::convertAttrFromRaw(Synth::convertRangeExprToRaw(this).(Raw::RangeExpr).getAttr(index))
    }

    /**
     * Gets any of the attrs of this range expression.
     */
    final Attr getAnAttr() { result = this.getAttr(_) }

    /**
     * Gets the number of attrs of this range expression.
     */
    final int getNumberOfAttrs() { result = count(int i | exists(this.getAttr(i))) }

    /**
     * Gets the end of this range expression, if it exists.
     */
    Expr getEnd() {
      result =
        Synth::convertExprFromRaw(Synth::convertRangeExprToRaw(this).(Raw::RangeExpr).getEnd())
    }

    /**
     * Holds if `getEnd()` exists.
     */
    final predicate hasEnd() { exists(this.getEnd()) }

    /**
     * Gets the operator name of this range expression, if it exists.
     */
    string getOperatorName() {
      result = Synth::convertRangeExprToRaw(this).(Raw::RangeExpr).getOperatorName()
    }

    /**
     * Holds if `getOperatorName()` exists.
     */
    final predicate hasOperatorName() { exists(this.getOperatorName()) }

    /**
     * Gets the start of this range expression, if it exists.
     */
    Expr getStart() {
      result =
        Synth::convertExprFromRaw(Synth::convertRangeExprToRaw(this).(Raw::RangeExpr).getStart())
    }

    /**
     * Holds if `getStart()` exists.
     */
    final predicate hasStart() { exists(this.getStart()) }
  }
}
