// generated by codegen, do not edit
/**
 * This module provides the generated definition of `StmtList`.
 * INTERNAL: Do not import directly.
 */

private import codeql.rust.elements.internal.generated.Synth
private import codeql.rust.elements.internal.generated.Raw
import codeql.rust.elements.internal.AstNodeImpl::Impl as AstNodeImpl
import codeql.rust.elements.Attr
import codeql.rust.elements.Expr
import codeql.rust.elements.Stmt

/**
 * INTERNAL: This module contains the fully generated definition of `StmtList` and should not
 * be referenced directly.
 */
module Generated {
  /**
   * A list of statements in a block, with an optional tail expression at the
   * end that determines the block's value.
   *
   * For example:
   * ```rust
   * {
   *     let x = 1;
   *     let y = 2;
   *     x + y
   * }
   * //  ^^^^^^^^^
   * ```
   * INTERNAL: Do not reference the `Generated::StmtList` class directly.
   * Use the subclass `StmtList`, where the following predicates are available.
   */
  class StmtList extends Synth::TStmtList, AstNodeImpl::AstNode {
    override string getAPrimaryQlClass() { result = "StmtList" }

    /**
     * Gets the `index`th attr of this statement list (0-based).
     */
    Attr getAttr(int index) {
      result =
        Synth::convertAttrFromRaw(Synth::convertStmtListToRaw(this).(Raw::StmtList).getAttr(index))
    }

    /**
     * Gets any of the attrs of this statement list.
     */
    final Attr getAnAttr() { result = this.getAttr(_) }

    /**
     * Gets the number of attrs of this statement list.
     */
    final int getNumberOfAttrs() { result = count(int i | exists(this.getAttr(i))) }

    /**
     * Gets the `index`th statement of this statement list (0-based).
     *
     * The statements of a `StmtList` do not include any tail expression, which
     * can be accessed with predicates such as `getTailExpr`.
     */
    Stmt getStatement(int index) {
      result =
        Synth::convertStmtFromRaw(Synth::convertStmtListToRaw(this)
              .(Raw::StmtList)
              .getStatement(index))
    }

    /**
     * Gets any of the statements of this statement list.
     */
    final Stmt getAStatement() { result = this.getStatement(_) }

    /**
     * Gets the number of statements of this statement list.
     */
    final int getNumberOfStatements() { result = count(int i | exists(this.getStatement(i))) }

    /**
     * Gets the tail expression of this statement list, if it exists.
     *
     * The tail expression is the expression at the end of a block, that
     * determines the block's value.
     */
    Expr getTailExpr() {
      result =
        Synth::convertExprFromRaw(Synth::convertStmtListToRaw(this).(Raw::StmtList).getTailExpr())
    }

    /**
     * Holds if `getTailExpr()` exists.
     */
    final predicate hasTailExpr() { exists(this.getTailExpr()) }
  }
}
