// generated by codegen, do not edit
/**
 * This module provides the generated definition of `StructPatField`.
 * INTERNAL: Do not import directly.
 */

private import codeql.rust.elements.internal.generated.Synth
private import codeql.rust.elements.internal.generated.Raw
import codeql.rust.elements.internal.AstNodeImpl::Impl as AstNodeImpl
import codeql.rust.elements.Attr
import codeql.rust.elements.NameRef
import codeql.rust.elements.Pat

/**
 * INTERNAL: This module contains the fully generated definition of `StructPatField` and should not
 * be referenced directly.
 */
module Generated {
  /**
   * A field in a struct pattern. For example `a: 1` in:
   * ```rust
   * let Foo { a: 1, b: 2 } = foo;
   * ```
   * INTERNAL: Do not reference the `Generated::StructPatField` class directly.
   * Use the subclass `StructPatField`, where the following predicates are available.
   */
  class StructPatField extends Synth::TStructPatField, AstNodeImpl::AstNode {
    override string getAPrimaryQlClass() { result = "StructPatField" }

    /**
     * Gets the `index`th attr of this struct pattern field (0-based).
     */
    Attr getAttr(int index) {
      result =
        Synth::convertAttrFromRaw(Synth::convertStructPatFieldToRaw(this)
              .(Raw::StructPatField)
              .getAttr(index))
    }

    /**
     * Gets any of the attrs of this struct pattern field.
     */
    final Attr getAnAttr() { result = this.getAttr(_) }

    /**
     * Gets the number of attrs of this struct pattern field.
     */
    final int getNumberOfAttrs() { result = count(int i | exists(this.getAttr(i))) }

    /**
     * Gets the identifier of this struct pattern field, if it exists.
     */
    NameRef getIdentifier() {
      result =
        Synth::convertNameRefFromRaw(Synth::convertStructPatFieldToRaw(this)
              .(Raw::StructPatField)
              .getIdentifier())
    }

    /**
     * Holds if `getIdentifier()` exists.
     */
    final predicate hasIdentifier() { exists(this.getIdentifier()) }

    /**
     * Gets the pattern of this struct pattern field, if it exists.
     */
    Pat getPat() {
      result =
        Synth::convertPatFromRaw(Synth::convertStructPatFieldToRaw(this)
              .(Raw::StructPatField)
              .getPat())
    }

    /**
     * Holds if `getPat()` exists.
     */
    final predicate hasPat() { exists(this.getPat()) }
  }
}
