// generated by codegen, do not edit
/**
 * This module provides the generated definition of `Trait`.
 * INTERNAL: Do not import directly.
 */

private import codeql.rust.elements.internal.generated.Synth
private import codeql.rust.elements.internal.generated.Raw
import codeql.rust.elements.AssocItemList
import codeql.rust.elements.Attr
import codeql.rust.elements.GenericParamList
import codeql.rust.elements.internal.ItemImpl::Impl as ItemImpl
import codeql.rust.elements.Name
import codeql.rust.elements.TypeBoundList
import codeql.rust.elements.Visibility
import codeql.rust.elements.WhereClause

/**
 * INTERNAL: This module contains the fully generated definition of `Trait` and should not
 * be referenced directly.
 */
module Generated {
  /**
   * A Trait. For example:
   * ```
   * trait Frobinizable {
   *   type Frobinator;
   *   type Result: Copy;
   *   fn frobinize_with(&mut self, frobinator: &Self::Frobinator) -> Result;
   * }
   *
   * pub trait Foo<T: Frobinizable> where T::Frobinator: Eq {}
   * ```
   * INTERNAL: Do not reference the `Generated::Trait` class directly.
   * Use the subclass `Trait`, where the following predicates are available.
   */
  class Trait extends Synth::TTrait, ItemImpl::Item {
    override string getAPrimaryQlClass() { result = "Trait" }

    /**
     * Gets the assoc item list of this trait, if it exists.
     */
    AssocItemList getAssocItemList() {
      result =
        Synth::convertAssocItemListFromRaw(Synth::convertTraitToRaw(this)
              .(Raw::Trait)
              .getAssocItemList())
    }

    /**
     * Holds if `getAssocItemList()` exists.
     */
    final predicate hasAssocItemList() { exists(this.getAssocItemList()) }

    /**
     * Gets the `index`th attr of this trait (0-based).
     */
    Attr getAttr(int index) {
      result = Synth::convertAttrFromRaw(Synth::convertTraitToRaw(this).(Raw::Trait).getAttr(index))
    }

    /**
     * Gets any of the attrs of this trait.
     */
    final Attr getAnAttr() { result = this.getAttr(_) }

    /**
     * Gets the number of attrs of this trait.
     */
    final int getNumberOfAttrs() { result = count(int i | exists(this.getAttr(i))) }

    /**
     * Gets the generic parameter list of this trait, if it exists.
     */
    GenericParamList getGenericParamList() {
      result =
        Synth::convertGenericParamListFromRaw(Synth::convertTraitToRaw(this)
              .(Raw::Trait)
              .getGenericParamList())
    }

    /**
     * Holds if `getGenericParamList()` exists.
     */
    final predicate hasGenericParamList() { exists(this.getGenericParamList()) }

    /**
     * Holds if this trait is auto.
     */
    predicate isAuto() { Synth::convertTraitToRaw(this).(Raw::Trait).isAuto() }

    /**
     * Holds if this trait is unsafe.
     */
    predicate isUnsafe() { Synth::convertTraitToRaw(this).(Raw::Trait).isUnsafe() }

    /**
     * Gets the name of this trait, if it exists.
     */
    Name getName() {
      result = Synth::convertNameFromRaw(Synth::convertTraitToRaw(this).(Raw::Trait).getName())
    }

    /**
     * Holds if `getName()` exists.
     */
    final predicate hasName() { exists(this.getName()) }

    /**
     * Gets the type bound list of this trait, if it exists.
     */
    TypeBoundList getTypeBoundList() {
      result =
        Synth::convertTypeBoundListFromRaw(Synth::convertTraitToRaw(this)
              .(Raw::Trait)
              .getTypeBoundList())
    }

    /**
     * Holds if `getTypeBoundList()` exists.
     */
    final predicate hasTypeBoundList() { exists(this.getTypeBoundList()) }

    /**
     * Gets the visibility of this trait, if it exists.
     */
    Visibility getVisibility() {
      result =
        Synth::convertVisibilityFromRaw(Synth::convertTraitToRaw(this).(Raw::Trait).getVisibility())
    }

    /**
     * Holds if `getVisibility()` exists.
     */
    final predicate hasVisibility() { exists(this.getVisibility()) }

    /**
     * Gets the where clause of this trait, if it exists.
     */
    WhereClause getWhereClause() {
      result =
        Synth::convertWhereClauseFromRaw(Synth::convertTraitToRaw(this)
              .(Raw::Trait)
              .getWhereClause())
    }

    /**
     * Holds if `getWhereClause()` exists.
     */
    final predicate hasWhereClause() { exists(this.getWhereClause()) }
  }
}
