#pragma once

#include <string>
#include <vector>
#include <filesystem>

#include "swift/extractor/infra/file/TargetFile.h"

namespace codeql {
struct SwiftExtractorConfiguration {
  // The location for storing TRAP files to be imported by CodeQL engine.
  std::filesystem::path trapDir;
  // The location for storing extracted source files.
  std::filesystem::path sourceArchiveDir;
  // A temporary directory that exists during database creation, but is deleted once the DB is
  // finalized.
  std::filesystem::path scratchDir;

  // The original arguments passed to the extractor. Used for debugging.
  std::vector<const char*> frontendOptions;

  // A temporary directory that contains TRAP files before they are moved into their final
  // destination.
  std::filesystem::path getTempTrapDir() const { return scratchDir / "swift-trap-temp"; }

  // A temporary directory that contains build artifacts generated by the extractor during the
  // overall extraction process.
  std::filesystem::path getTempArtifactDir() const {
    return scratchDir / "swift-extraction-artifacts";
  }
};

}  // namespace codeql
