/**
 * @name Total lines of user written C/C++ code in the database
 * @description The total number of lines of C/C++ code from the source code directory, excluding auto-generated files. This query counts the lines of code, excluding whitespace or comments. Note: If external libraries are included in the codebase either in a checked-in virtual environment or as vendored code, that will currently be counted as user written code.
 * @kind metric
 * @tags summary
 *       lines-of-code
 *       debug
 * @id cpp/summary/lines-of-user-code
 */

import cpp
import semmle.code.cpp.AutogeneratedFile

select sum(File f |
    f.fromSource() and exists(f.getRelativePath()) and not f instanceof AutogeneratedFile
  |
    f.getMetrics().getNumberOfLinesOfCode()
  )
