/**
 * @name Dead field
 * @description Fields that are never read are likely unnecessary.
 * @kind problem
 * @problem.severity recommendation
 * @precision medium
 * @id java/dead-field
 * @tags quality
 *       maintainability
 *       useless-code
 *       external/cwe/cwe-561
 */

import java
import semmle.code.java.deadcode.DeadCode

from DeadField f, Element origin, string reason
where
  not f.getFile().isKotlinSourceFile() and
  not origin.getFile().isKotlinSourceFile() and
  not f.isInDeadScope() and
  if f.getAnAccess() instanceof FieldRead
  then (
    if exists(getADeadRoot(f.getAnAccess().(FieldRead).getEnclosingCallable()))
    then (
      origin = getADeadRoot(f.getAnAccess().(FieldRead).getEnclosingCallable()) and
      reason = " is only read from dead code originating at $@."
    ) else (
      origin = f and
      reason = " is only read from a dead-code cycle."
    )
  ) else (
    origin = f and
    reason = " is entirely unread."
  )
select f, "The field " + f.getName() + reason, origin, origin.getName()
