/**
 * @id py/examples/conditional-expression
 * @name Conditional expressions
 * @description Finds conditional expressions of the form '... if ... else ...'
 *              where the classes of the sub-expressions differ
 * @tags conditional
 *       expression
 *       ternary
 */

import python
private import LegacyPointsTo

from IfExp e, ClassObject cls1, ClassObject cls2
where
  e.getBody().(ExprWithPointsTo).refersTo(_, cls1, _) and
  e.getOrelse().(ExprWithPointsTo).refersTo(_, cls2, _) and
  cls1 != cls2
select e
