//! Generated by `ast-generator`, do not edit by hand.
use super::base::Translator;
use super::mappings::{Emission, HasTrapClass, TextValue};
use crate::generated;
use crate::trap::{Label, TrapId};
use ra_ap_syntax::ast::{
    HasArgList, HasAttrs, HasGenericArgs, HasGenericParams, HasLoopBody, HasModuleItem, HasName,
    HasTypeBounds, HasVisibility, RangeItem,
};
#[rustfmt::skip]
use ra_ap_syntax::{AstNode, ast};
impl Translator<'_> {
    pub(crate) fn emit_asm_operand(
        &mut self,
        node: &ast::AsmOperand,
    ) -> Option<Label<generated::AsmOperand>> {
        let label = match node {
            ast::AsmOperand::AsmConst(inner) => self.emit_asm_const(inner).map(Into::into),
            ast::AsmOperand::AsmLabel(inner) => self.emit_asm_label(inner).map(Into::into),
            ast::AsmOperand::AsmRegOperand(inner) => {
                self.emit_asm_reg_operand(inner).map(Into::into)
            }
            ast::AsmOperand::AsmSym(inner) => self.emit_asm_sym(inner).map(Into::into),
        }?;
        Some(label)
    }
    pub(crate) fn emit_asm_piece(
        &mut self,
        node: &ast::AsmPiece,
    ) -> Option<Label<generated::AsmPiece>> {
        let label = match node {
            ast::AsmPiece::AsmClobberAbi(inner) => self.emit_asm_clobber_abi(inner).map(Into::into),
            ast::AsmPiece::AsmOperandNamed(inner) => {
                self.emit_asm_operand_named(inner).map(Into::into)
            }
            ast::AsmPiece::AsmOptions(inner) => self.emit_asm_options(inner).map(Into::into),
        }?;
        Some(label)
    }
    pub(crate) fn emit_assoc_item(
        &mut self,
        node: &ast::AssocItem,
    ) -> Option<Label<generated::AssocItem>> {
        if let Some(label) = self.pre_emit(node) {
            return Some(label);
        }
        let label = match node {
            ast::AssocItem::Const(inner) => self.emit_const(inner).map(Into::into),
            ast::AssocItem::Fn(inner) => self.emit_fn(inner).map(Into::into),
            ast::AssocItem::MacroCall(inner) => self.emit_macro_call(inner).map(Into::into),
            ast::AssocItem::TypeAlias(inner) => self.emit_type_alias(inner).map(Into::into),
        }?;
        self.post_emit(node, label);
        Some(label)
    }
    pub(crate) fn emit_expr(&mut self, node: &ast::Expr) -> Option<Label<generated::Expr>> {
        let label = match node {
            ast::Expr::ArrayExpr(inner) => self.emit_array_expr(inner).map(Into::into),
            ast::Expr::AsmExpr(inner) => self.emit_asm_expr(inner).map(Into::into),
            ast::Expr::AwaitExpr(inner) => self.emit_await_expr(inner).map(Into::into),
            ast::Expr::BecomeExpr(inner) => self.emit_become_expr(inner).map(Into::into),
            ast::Expr::BinExpr(inner) => self.emit_bin_expr(inner).map(Into::into),
            ast::Expr::BlockExpr(inner) => self.emit_block_expr(inner).map(Into::into),
            ast::Expr::BreakExpr(inner) => self.emit_break_expr(inner).map(Into::into),
            ast::Expr::CallExpr(inner) => self.emit_call_expr(inner).map(Into::into),
            ast::Expr::CastExpr(inner) => self.emit_cast_expr(inner).map(Into::into),
            ast::Expr::ClosureExpr(inner) => self.emit_closure_expr(inner).map(Into::into),
            ast::Expr::ContinueExpr(inner) => self.emit_continue_expr(inner).map(Into::into),
            ast::Expr::FieldExpr(inner) => self.emit_field_expr(inner).map(Into::into),
            ast::Expr::ForExpr(inner) => self.emit_for_expr(inner).map(Into::into),
            ast::Expr::FormatArgsExpr(inner) => self.emit_format_args_expr(inner).map(Into::into),
            ast::Expr::IfExpr(inner) => self.emit_if_expr(inner).map(Into::into),
            ast::Expr::IndexExpr(inner) => self.emit_index_expr(inner).map(Into::into),
            ast::Expr::LetExpr(inner) => self.emit_let_expr(inner).map(Into::into),
            ast::Expr::Literal(inner) => self.emit_literal(inner).map(Into::into),
            ast::Expr::LoopExpr(inner) => self.emit_loop_expr(inner).map(Into::into),
            ast::Expr::MacroExpr(inner) => self.emit_macro_expr(inner).map(Into::into),
            ast::Expr::MatchExpr(inner) => self.emit_match_expr(inner).map(Into::into),
            ast::Expr::MethodCallExpr(inner) => self.emit_method_call_expr(inner).map(Into::into),
            ast::Expr::OffsetOfExpr(inner) => self.emit_offset_of_expr(inner).map(Into::into),
            ast::Expr::ParenExpr(inner) => self.emit_paren_expr(inner).map(Into::into),
            ast::Expr::PathExpr(inner) => self.emit_path_expr(inner).map(Into::into),
            ast::Expr::PrefixExpr(inner) => self.emit_prefix_expr(inner).map(Into::into),
            ast::Expr::RangeExpr(inner) => self.emit_range_expr(inner).map(Into::into),
            ast::Expr::RecordExpr(inner) => self.emit_record_expr(inner).map(Into::into),
            ast::Expr::RefExpr(inner) => self.emit_ref_expr(inner).map(Into::into),
            ast::Expr::ReturnExpr(inner) => self.emit_return_expr(inner).map(Into::into),
            ast::Expr::TryExpr(inner) => self.emit_try_expr(inner).map(Into::into),
            ast::Expr::TupleExpr(inner) => self.emit_tuple_expr(inner).map(Into::into),
            ast::Expr::UnderscoreExpr(inner) => self.emit_underscore_expr(inner).map(Into::into),
            ast::Expr::WhileExpr(inner) => self.emit_while_expr(inner).map(Into::into),
            ast::Expr::YeetExpr(inner) => self.emit_yeet_expr(inner).map(Into::into),
            ast::Expr::YieldExpr(inner) => self.emit_yield_expr(inner).map(Into::into),
        }?;
        Some(label)
    }
    pub(crate) fn emit_extern_item(
        &mut self,
        node: &ast::ExternItem,
    ) -> Option<Label<generated::ExternItem>> {
        if let Some(label) = self.pre_emit(node) {
            return Some(label);
        }
        let label = match node {
            ast::ExternItem::Fn(inner) => self.emit_fn(inner).map(Into::into),
            ast::ExternItem::MacroCall(inner) => self.emit_macro_call(inner).map(Into::into),
            ast::ExternItem::Static(inner) => self.emit_static(inner).map(Into::into),
            ast::ExternItem::TypeAlias(inner) => self.emit_type_alias(inner).map(Into::into),
        }?;
        self.post_emit(node, label);
        Some(label)
    }
    pub(crate) fn emit_field_list(
        &mut self,
        node: &ast::FieldList,
    ) -> Option<Label<generated::FieldList>> {
        let label = match node {
            ast::FieldList::RecordFieldList(inner) => {
                self.emit_record_field_list(inner).map(Into::into)
            }
            ast::FieldList::TupleFieldList(inner) => {
                self.emit_tuple_field_list(inner).map(Into::into)
            }
        }?;
        Some(label)
    }
    pub(crate) fn emit_generic_arg(
        &mut self,
        node: &ast::GenericArg,
    ) -> Option<Label<generated::GenericArg>> {
        let label = match node {
            ast::GenericArg::AssocTypeArg(inner) => self.emit_assoc_type_arg(inner).map(Into::into),
            ast::GenericArg::ConstArg(inner) => self.emit_const_arg(inner).map(Into::into),
            ast::GenericArg::LifetimeArg(inner) => self.emit_lifetime_arg(inner).map(Into::into),
            ast::GenericArg::TypeArg(inner) => self.emit_type_arg(inner).map(Into::into),
        }?;
        Some(label)
    }
    pub(crate) fn emit_generic_param(
        &mut self,
        node: &ast::GenericParam,
    ) -> Option<Label<generated::GenericParam>> {
        let label = match node {
            ast::GenericParam::ConstParam(inner) => self.emit_const_param(inner).map(Into::into),
            ast::GenericParam::LifetimeParam(inner) => {
                self.emit_lifetime_param(inner).map(Into::into)
            }
            ast::GenericParam::TypeParam(inner) => self.emit_type_param(inner).map(Into::into),
        }?;
        Some(label)
    }
    pub(crate) fn emit_pat(&mut self, node: &ast::Pat) -> Option<Label<generated::Pat>> {
        let label = match node {
            ast::Pat::BoxPat(inner) => self.emit_box_pat(inner).map(Into::into),
            ast::Pat::ConstBlockPat(inner) => self.emit_const_block_pat(inner).map(Into::into),
            ast::Pat::IdentPat(inner) => self.emit_ident_pat(inner).map(Into::into),
            ast::Pat::LiteralPat(inner) => self.emit_literal_pat(inner).map(Into::into),
            ast::Pat::MacroPat(inner) => self.emit_macro_pat(inner).map(Into::into),
            ast::Pat::OrPat(inner) => self.emit_or_pat(inner).map(Into::into),
            ast::Pat::ParenPat(inner) => self.emit_paren_pat(inner).map(Into::into),
            ast::Pat::PathPat(inner) => self.emit_path_pat(inner).map(Into::into),
            ast::Pat::RangePat(inner) => self.emit_range_pat(inner).map(Into::into),
            ast::Pat::RecordPat(inner) => self.emit_record_pat(inner).map(Into::into),
            ast::Pat::RefPat(inner) => self.emit_ref_pat(inner).map(Into::into),
            ast::Pat::RestPat(inner) => self.emit_rest_pat(inner).map(Into::into),
            ast::Pat::SlicePat(inner) => self.emit_slice_pat(inner).map(Into::into),
            ast::Pat::TuplePat(inner) => self.emit_tuple_pat(inner).map(Into::into),
            ast::Pat::TupleStructPat(inner) => self.emit_tuple_struct_pat(inner).map(Into::into),
            ast::Pat::WildcardPat(inner) => self.emit_wildcard_pat(inner).map(Into::into),
        }?;
        Some(label)
    }
    pub(crate) fn emit_stmt(&mut self, node: &ast::Stmt) -> Option<Label<generated::Stmt>> {
        let label = match node {
            ast::Stmt::ExprStmt(inner) => self.emit_expr_stmt(inner).map(Into::into),
            ast::Stmt::Item(inner) => self.emit_item(inner).map(Into::into),
            ast::Stmt::LetStmt(inner) => self.emit_let_stmt(inner).map(Into::into),
        }?;
        Some(label)
    }
    pub(crate) fn emit_type(&mut self, node: &ast::Type) -> Option<Label<generated::TypeRepr>> {
        let label = match node {
            ast::Type::ArrayType(inner) => self.emit_array_type(inner).map(Into::into),
            ast::Type::DynTraitType(inner) => self.emit_dyn_trait_type(inner).map(Into::into),
            ast::Type::FnPtrType(inner) => self.emit_fn_ptr_type(inner).map(Into::into),
            ast::Type::ForType(inner) => self.emit_for_type(inner).map(Into::into),
            ast::Type::ImplTraitType(inner) => self.emit_impl_trait_type(inner).map(Into::into),
            ast::Type::InferType(inner) => self.emit_infer_type(inner).map(Into::into),
            ast::Type::MacroType(inner) => self.emit_macro_type(inner).map(Into::into),
            ast::Type::NeverType(inner) => self.emit_never_type(inner).map(Into::into),
            ast::Type::ParenType(inner) => self.emit_paren_type(inner).map(Into::into),
            ast::Type::PathType(inner) => self.emit_path_type(inner).map(Into::into),
            ast::Type::PtrType(inner) => self.emit_ptr_type(inner).map(Into::into),
            ast::Type::RefType(inner) => self.emit_ref_type(inner).map(Into::into),
            ast::Type::SliceType(inner) => self.emit_slice_type(inner).map(Into::into),
            ast::Type::TupleType(inner) => self.emit_tuple_type(inner).map(Into::into),
        }?;
        Some(label)
    }
    pub(crate) fn emit_use_bound_generic_arg(
        &mut self,
        node: &ast::UseBoundGenericArg,
    ) -> Option<Label<generated::UseBoundGenericArg>> {
        let label = match node {
            ast::UseBoundGenericArg::Lifetime(inner) => self.emit_lifetime(inner).map(Into::into),
            ast::UseBoundGenericArg::NameRef(inner) => self.emit_name_ref(inner).map(Into::into),
        }?;
        Some(label)
    }
    pub(crate) fn emit_item(&mut self, node: &ast::Item) -> Option<Label<generated::Item>> {
        if let Some(label) = self.pre_emit(node) {
            return Some(label);
        }
        let label = match node {
            ast::Item::AsmExpr(inner) => self.emit_asm_expr(inner).map(Into::into),
            ast::Item::Const(inner) => self.emit_const(inner).map(Into::into),
            ast::Item::Enum(inner) => self.emit_enum(inner).map(Into::into),
            ast::Item::ExternBlock(inner) => self.emit_extern_block(inner).map(Into::into),
            ast::Item::ExternCrate(inner) => self.emit_extern_crate(inner).map(Into::into),
            ast::Item::Fn(inner) => self.emit_fn(inner).map(Into::into),
            ast::Item::Impl(inner) => self.emit_impl(inner).map(Into::into),
            ast::Item::MacroCall(inner) => self.emit_macro_call(inner).map(Into::into),
            ast::Item::MacroDef(inner) => self.emit_macro_def(inner).map(Into::into),
            ast::Item::MacroRules(inner) => self.emit_macro_rules(inner).map(Into::into),
            ast::Item::Module(inner) => self.emit_module(inner).map(Into::into),
            ast::Item::Static(inner) => self.emit_static(inner).map(Into::into),
            ast::Item::Struct(inner) => self.emit_struct(inner).map(Into::into),
            ast::Item::Trait(inner) => self.emit_trait(inner).map(Into::into),
            ast::Item::TraitAlias(inner) => self.emit_trait_alias(inner).map(Into::into),
            ast::Item::TypeAlias(inner) => self.emit_type_alias(inner).map(Into::into),
            ast::Item::Union(inner) => self.emit_union(inner).map(Into::into),
            ast::Item::Use(inner) => self.emit_use(inner).map(Into::into),
        }?;
        self.post_emit(node, label);
        Some(label)
    }
    pub(crate) fn emit_abi(&mut self, node: &ast::Abi) -> Option<Label<generated::Abi>> {
        let abi_string = node.try_get_text();
        let label = self.trap.emit(generated::Abi {
            id: TrapId::Star,
            abi_string,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_arg_list(
        &mut self,
        node: &ast::ArgList,
    ) -> Option<Label<generated::ArgList>> {
        let args = node.args().filter_map(|x| self.emit_expr(&x)).collect();
        let label = self.trap.emit(generated::ArgList {
            id: TrapId::Star,
            args,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_array_expr(
        &mut self,
        node: &ast::ArrayExpr,
    ) -> Option<Label<generated::ArrayExprInternal>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let exprs = node.exprs().filter_map(|x| self.emit_expr(&x)).collect();
        let is_semicolon = node.semicolon_token().is_some();
        let label = self.trap.emit(generated::ArrayExprInternal {
            id: TrapId::Star,
            attrs,
            exprs,
            is_semicolon,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_array_type(
        &mut self,
        node: &ast::ArrayType,
    ) -> Option<Label<generated::ArrayTypeRepr>> {
        let const_arg = node.const_arg().and_then(|x| self.emit_const_arg(&x));
        let element_type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let label = self.trap.emit(generated::ArrayTypeRepr {
            id: TrapId::Star,
            const_arg,
            element_type_repr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_asm_clobber_abi(
        &mut self,
        node: &ast::AsmClobberAbi,
    ) -> Option<Label<generated::AsmClobberAbi>> {
        let label = self
            .trap
            .emit(generated::AsmClobberAbi { id: TrapId::Star });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_asm_const(
        &mut self,
        node: &ast::AsmConst,
    ) -> Option<Label<generated::AsmConst>> {
        let expr = node.expr().and_then(|x| self.emit_expr(&x));
        let is_const = node.const_token().is_some();
        let label = self.trap.emit(generated::AsmConst {
            id: TrapId::Star,
            expr,
            is_const,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_asm_dir_spec(
        &mut self,
        node: &ast::AsmDirSpec,
    ) -> Option<Label<generated::AsmDirSpec>> {
        let label = self.trap.emit(generated::AsmDirSpec { id: TrapId::Star });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_asm_expr(
        &mut self,
        node: &ast::AsmExpr,
    ) -> Option<Label<generated::AsmExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let asm_pieces = node
            .asm_pieces()
            .filter_map(|x| self.emit_asm_piece(&x))
            .collect();
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let template = node.template().filter_map(|x| self.emit_expr(&x)).collect();
        let label = self.trap.emit(generated::AsmExpr {
            id: TrapId::Star,
            asm_pieces,
            attrs,
            template,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_asm_label(
        &mut self,
        node: &ast::AsmLabel,
    ) -> Option<Label<generated::AsmLabel>> {
        let block_expr = node.block_expr().and_then(|x| self.emit_block_expr(&x));
        let label = self.trap.emit(generated::AsmLabel {
            id: TrapId::Star,
            block_expr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_asm_operand_expr(
        &mut self,
        node: &ast::AsmOperandExpr,
    ) -> Option<Label<generated::AsmOperandExpr>> {
        let in_expr = node.in_expr().and_then(|x| self.emit_expr(&x));
        let out_expr = node.out_expr().and_then(|x| self.emit_expr(&x));
        let label = self.trap.emit(generated::AsmOperandExpr {
            id: TrapId::Star,
            in_expr,
            out_expr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_asm_operand_named(
        &mut self,
        node: &ast::AsmOperandNamed,
    ) -> Option<Label<generated::AsmOperandNamed>> {
        let asm_operand = node.asm_operand().and_then(|x| self.emit_asm_operand(&x));
        let name = node.name().and_then(|x| self.emit_name(&x));
        let label = self.trap.emit(generated::AsmOperandNamed {
            id: TrapId::Star,
            asm_operand,
            name,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_asm_option(
        &mut self,
        node: &ast::AsmOption,
    ) -> Option<Label<generated::AsmOption>> {
        let is_raw = node.raw_token().is_some();
        let label = self.trap.emit(generated::AsmOption {
            id: TrapId::Star,
            is_raw,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_asm_options(
        &mut self,
        node: &ast::AsmOptions,
    ) -> Option<Label<generated::AsmOptionsList>> {
        let asm_options = node
            .asm_options()
            .filter_map(|x| self.emit_asm_option(&x))
            .collect();
        let label = self.trap.emit(generated::AsmOptionsList {
            id: TrapId::Star,
            asm_options,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_asm_reg_operand(
        &mut self,
        node: &ast::AsmRegOperand,
    ) -> Option<Label<generated::AsmRegOperand>> {
        let asm_dir_spec = node.asm_dir_spec().and_then(|x| self.emit_asm_dir_spec(&x));
        let asm_operand_expr = node
            .asm_operand_expr()
            .and_then(|x| self.emit_asm_operand_expr(&x));
        let asm_reg_spec = node.asm_reg_spec().and_then(|x| self.emit_asm_reg_spec(&x));
        let label = self.trap.emit(generated::AsmRegOperand {
            id: TrapId::Star,
            asm_dir_spec,
            asm_operand_expr,
            asm_reg_spec,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_asm_reg_spec(
        &mut self,
        node: &ast::AsmRegSpec,
    ) -> Option<Label<generated::AsmRegSpec>> {
        let identifier = node.name_ref().and_then(|x| self.emit_name_ref(&x));
        let label = self.trap.emit(generated::AsmRegSpec {
            id: TrapId::Star,
            identifier,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_asm_sym(&mut self, node: &ast::AsmSym) -> Option<Label<generated::AsmSym>> {
        let path = node.path().and_then(|x| self.emit_path(&x));
        let label = self.trap.emit(generated::AsmSym {
            id: TrapId::Star,
            path,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_assoc_item_list(
        &mut self,
        node: &ast::AssocItemList,
    ) -> Option<Label<generated::AssocItemList>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let assoc_items = node
            .assoc_items()
            .filter_map(|x| self.emit_assoc_item(&x))
            .collect();
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let label = self.trap.emit(generated::AssocItemList {
            id: TrapId::Star,
            assoc_items,
            attrs,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_assoc_type_arg(
        &mut self,
        node: &ast::AssocTypeArg,
    ) -> Option<Label<generated::AssocTypeArg>> {
        let const_arg = node.const_arg().and_then(|x| self.emit_const_arg(&x));
        let generic_arg_list = node
            .generic_arg_list()
            .and_then(|x| self.emit_generic_arg_list(&x));
        let identifier = node.name_ref().and_then(|x| self.emit_name_ref(&x));
        let param_list = node.param_list().and_then(|x| self.emit_param_list(&x));
        let ret_type = node.ret_type().and_then(|x| self.emit_ret_type(&x));
        let return_type_syntax = node
            .return_type_syntax()
            .and_then(|x| self.emit_return_type_syntax(&x));
        let type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let type_bound_list = node
            .type_bound_list()
            .and_then(|x| self.emit_type_bound_list(&x));
        let label = self.trap.emit(generated::AssocTypeArg {
            id: TrapId::Star,
            const_arg,
            generic_arg_list,
            identifier,
            param_list,
            ret_type,
            return_type_syntax,
            type_repr,
            type_bound_list,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_attr(&mut self, node: &ast::Attr) -> Option<Label<generated::Attr>> {
        let meta = node.meta().and_then(|x| self.emit_meta(&x));
        let label = self.trap.emit(generated::Attr {
            id: TrapId::Star,
            meta,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_await_expr(
        &mut self,
        node: &ast::AwaitExpr,
    ) -> Option<Label<generated::AwaitExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let expr = node.expr().and_then(|x| self.emit_expr(&x));
        let label = self.trap.emit(generated::AwaitExpr {
            id: TrapId::Star,
            attrs,
            expr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_become_expr(
        &mut self,
        node: &ast::BecomeExpr,
    ) -> Option<Label<generated::BecomeExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let expr = node.expr().and_then(|x| self.emit_expr(&x));
        let label = self.trap.emit(generated::BecomeExpr {
            id: TrapId::Star,
            attrs,
            expr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_bin_expr(
        &mut self,
        node: &ast::BinExpr,
    ) -> Option<Label<generated::BinaryExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let lhs = node.lhs().and_then(|x| self.emit_expr(&x));
        let operator_name = node.try_get_text();
        let rhs = node.rhs().and_then(|x| self.emit_expr(&x));
        let label = self.trap.emit(generated::BinaryExpr {
            id: TrapId::Star,
            attrs,
            lhs,
            operator_name,
            rhs,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_block_expr(
        &mut self,
        node: &ast::BlockExpr,
    ) -> Option<Label<generated::BlockExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let is_async = node.async_token().is_some();
        let is_const = node.const_token().is_some();
        let is_gen = node.gen_token().is_some();
        let is_move = node.move_token().is_some();
        let is_try = node.try_token().is_some();
        let is_unsafe = node.unsafe_token().is_some();
        let label = node.label().and_then(|x| self.emit_label(&x));
        let stmt_list = node.stmt_list().and_then(|x| self.emit_stmt_list(&x));
        let label = self.trap.emit(generated::BlockExpr {
            id: TrapId::Star,
            attrs,
            is_async,
            is_const,
            is_gen,
            is_move,
            is_try,
            is_unsafe,
            label,
            stmt_list,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_box_pat(&mut self, node: &ast::BoxPat) -> Option<Label<generated::BoxPat>> {
        let pat = node.pat().and_then(|x| self.emit_pat(&x));
        let label = self.trap.emit(generated::BoxPat {
            id: TrapId::Star,
            pat,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_break_expr(
        &mut self,
        node: &ast::BreakExpr,
    ) -> Option<Label<generated::BreakExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let expr = node.expr().and_then(|x| self.emit_expr(&x));
        let lifetime = node.lifetime().and_then(|x| self.emit_lifetime(&x));
        let label = self.trap.emit(generated::BreakExpr {
            id: TrapId::Star,
            attrs,
            expr,
            lifetime,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_call_expr(
        &mut self,
        node: &ast::CallExpr,
    ) -> Option<Label<generated::CallExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let arg_list = node.arg_list().and_then(|x| self.emit_arg_list(&x));
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let function = node.expr().and_then(|x| self.emit_expr(&x));
        let label = self.trap.emit(generated::CallExpr {
            id: TrapId::Star,
            arg_list,
            attrs,
            function,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_cast_expr(
        &mut self,
        node: &ast::CastExpr,
    ) -> Option<Label<generated::CastExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let expr = node.expr().and_then(|x| self.emit_expr(&x));
        let type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let label = self.trap.emit(generated::CastExpr {
            id: TrapId::Star,
            attrs,
            expr,
            type_repr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_closure_expr(
        &mut self,
        node: &ast::ClosureExpr,
    ) -> Option<Label<generated::ClosureExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let closure_body = node.body().and_then(|x| self.emit_expr(&x));
        let for_binder = node.for_binder().and_then(|x| self.emit_for_binder(&x));
        let is_async = node.async_token().is_some();
        let is_const = node.const_token().is_some();
        let is_gen = node.gen_token().is_some();
        let is_move = node.move_token().is_some();
        let is_static = node.static_token().is_some();
        let param_list = node.param_list().and_then(|x| self.emit_param_list(&x));
        let ret_type = node.ret_type().and_then(|x| self.emit_ret_type(&x));
        let label = self.trap.emit(generated::ClosureExpr {
            id: TrapId::Star,
            attrs,
            closure_body,
            for_binder,
            is_async,
            is_const,
            is_gen,
            is_move,
            is_static,
            param_list,
            ret_type,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_const(&mut self, node: &ast::Const) -> Option<Label<generated::Const>> {
        if let Some(label) = self.pre_emit(node) {
            return Some(label);
        }
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let body = if self.should_skip_bodies() {
            None
        } else {
            node.body().and_then(|x| self.emit_expr(&x))
        };
        let generic_param_list = node
            .generic_param_list()
            .and_then(|x| self.emit_generic_param_list(&x));
        let is_const = node.const_token().is_some();
        let is_default = node.default_token().is_some();
        let name = node.name().and_then(|x| self.emit_name(&x));
        let type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let visibility = node.visibility().and_then(|x| self.emit_visibility(&x));
        let where_clause = node.where_clause().and_then(|x| self.emit_where_clause(&x));
        let label = self.trap.emit(generated::Const {
            id: TrapId::Star,
            attrs,
            body,
            generic_param_list,
            is_const,
            is_default,
            name,
            type_repr,
            visibility,
            where_clause,
        });
        self.emit_location(label, node);
        self.post_emit(node, label);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_const_arg(
        &mut self,
        node: &ast::ConstArg,
    ) -> Option<Label<generated::ConstArg>> {
        let expr = node.expr().and_then(|x| self.emit_expr(&x));
        let label = self.trap.emit(generated::ConstArg {
            id: TrapId::Star,
            expr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_const_block_pat(
        &mut self,
        node: &ast::ConstBlockPat,
    ) -> Option<Label<generated::ConstBlockPat>> {
        let block_expr = node.block_expr().and_then(|x| self.emit_block_expr(&x));
        let is_const = node.const_token().is_some();
        let label = self.trap.emit(generated::ConstBlockPat {
            id: TrapId::Star,
            block_expr,
            is_const,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_const_param(
        &mut self,
        node: &ast::ConstParam,
    ) -> Option<Label<generated::ConstParam>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let default_val = node.default_val().and_then(|x| self.emit_const_arg(&x));
        let is_const = node.const_token().is_some();
        let name = node.name().and_then(|x| self.emit_name(&x));
        let type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let label = self.trap.emit(generated::ConstParam {
            id: TrapId::Star,
            attrs,
            default_val,
            is_const,
            name,
            type_repr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_continue_expr(
        &mut self,
        node: &ast::ContinueExpr,
    ) -> Option<Label<generated::ContinueExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let lifetime = node.lifetime().and_then(|x| self.emit_lifetime(&x));
        let label = self.trap.emit(generated::ContinueExpr {
            id: TrapId::Star,
            attrs,
            lifetime,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_dyn_trait_type(
        &mut self,
        node: &ast::DynTraitType,
    ) -> Option<Label<generated::DynTraitTypeRepr>> {
        let type_bound_list = node
            .type_bound_list()
            .and_then(|x| self.emit_type_bound_list(&x));
        let label = self.trap.emit(generated::DynTraitTypeRepr {
            id: TrapId::Star,
            type_bound_list,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_enum(&mut self, node: &ast::Enum) -> Option<Label<generated::Enum>> {
        if let Some(label) = self.pre_emit(node) {
            return Some(label);
        }
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let generic_param_list = node
            .generic_param_list()
            .and_then(|x| self.emit_generic_param_list(&x));
        let name = node.name().and_then(|x| self.emit_name(&x));
        let variant_list = node.variant_list().and_then(|x| self.emit_variant_list(&x));
        let visibility = node.visibility().and_then(|x| self.emit_visibility(&x));
        let where_clause = node.where_clause().and_then(|x| self.emit_where_clause(&x));
        let label = self.trap.emit(generated::Enum {
            id: TrapId::Star,
            attrs,
            generic_param_list,
            name,
            variant_list,
            visibility,
            where_clause,
        });
        self.emit_location(label, node);
        self.post_emit(node, label);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_expr_stmt(
        &mut self,
        node: &ast::ExprStmt,
    ) -> Option<Label<generated::ExprStmt>> {
        let expr = node.expr().and_then(|x| self.emit_expr(&x));
        let label = self.trap.emit(generated::ExprStmt {
            id: TrapId::Star,
            expr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_extern_block(
        &mut self,
        node: &ast::ExternBlock,
    ) -> Option<Label<generated::ExternBlock>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let abi = node.abi().and_then(|x| self.emit_abi(&x));
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let extern_item_list = node
            .extern_item_list()
            .and_then(|x| self.emit_extern_item_list(&x));
        let is_unsafe = node.unsafe_token().is_some();
        let label = self.trap.emit(generated::ExternBlock {
            id: TrapId::Star,
            abi,
            attrs,
            extern_item_list,
            is_unsafe,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_extern_crate(
        &mut self,
        node: &ast::ExternCrate,
    ) -> Option<Label<generated::ExternCrate>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let identifier = node.name_ref().and_then(|x| self.emit_name_ref(&x));
        let rename = node.rename().and_then(|x| self.emit_rename(&x));
        let visibility = node.visibility().and_then(|x| self.emit_visibility(&x));
        let label = self.trap.emit(generated::ExternCrate {
            id: TrapId::Star,
            attrs,
            identifier,
            rename,
            visibility,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_extern_item_list(
        &mut self,
        node: &ast::ExternItemList,
    ) -> Option<Label<generated::ExternItemList>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let extern_items = node
            .extern_items()
            .filter_map(|x| self.emit_extern_item(&x))
            .collect();
        let label = self.trap.emit(generated::ExternItemList {
            id: TrapId::Star,
            attrs,
            extern_items,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_field_expr(
        &mut self,
        node: &ast::FieldExpr,
    ) -> Option<Label<generated::FieldExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let container = node.expr().and_then(|x| self.emit_expr(&x));
        let identifier = node.name_ref().and_then(|x| self.emit_name_ref(&x));
        let label = self.trap.emit(generated::FieldExpr {
            id: TrapId::Star,
            attrs,
            container,
            identifier,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_fn(&mut self, node: &ast::Fn) -> Option<Label<generated::Function>> {
        if let Some(label) = self.pre_emit(node) {
            return Some(label);
        }
        if self.should_be_excluded(node) {
            return None;
        }
        let abi = node.abi().and_then(|x| self.emit_abi(&x));
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let function_body = if self.should_skip_bodies() {
            None
        } else {
            node.body().and_then(|x| self.emit_block_expr(&x))
        };
        let generic_param_list = node
            .generic_param_list()
            .and_then(|x| self.emit_generic_param_list(&x));
        let is_async = node.async_token().is_some();
        let is_const = node.const_token().is_some();
        let is_default = node.default_token().is_some();
        let is_gen = node.gen_token().is_some();
        let is_unsafe = node.unsafe_token().is_some();
        let name = node.name().and_then(|x| self.emit_name(&x));
        let param_list = node.param_list().and_then(|x| self.emit_param_list(&x));
        let ret_type = node.ret_type().and_then(|x| self.emit_ret_type(&x));
        let visibility = node.visibility().and_then(|x| self.emit_visibility(&x));
        let where_clause = node.where_clause().and_then(|x| self.emit_where_clause(&x));
        let label = self.trap.emit(generated::Function {
            id: TrapId::Star,
            abi,
            attrs,
            function_body,
            generic_param_list,
            is_async,
            is_const,
            is_default,
            is_gen,
            is_unsafe,
            name,
            param_list,
            ret_type,
            visibility,
            where_clause,
        });
        self.emit_location(label, node);
        self.post_emit(node, label);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_fn_ptr_type(
        &mut self,
        node: &ast::FnPtrType,
    ) -> Option<Label<generated::FnPtrTypeRepr>> {
        let abi = node.abi().and_then(|x| self.emit_abi(&x));
        let is_async = node.async_token().is_some();
        let is_const = node.const_token().is_some();
        let is_unsafe = node.unsafe_token().is_some();
        let param_list = node.param_list().and_then(|x| self.emit_param_list(&x));
        let ret_type = node.ret_type().and_then(|x| self.emit_ret_type(&x));
        let label = self.trap.emit(generated::FnPtrTypeRepr {
            id: TrapId::Star,
            abi,
            is_async,
            is_const,
            is_unsafe,
            param_list,
            ret_type,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_for_binder(
        &mut self,
        node: &ast::ForBinder,
    ) -> Option<Label<generated::ForBinder>> {
        let generic_param_list = node
            .generic_param_list()
            .and_then(|x| self.emit_generic_param_list(&x));
        let label = self.trap.emit(generated::ForBinder {
            id: TrapId::Star,
            generic_param_list,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_for_expr(
        &mut self,
        node: &ast::ForExpr,
    ) -> Option<Label<generated::ForExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let iterable = node.iterable().and_then(|x| self.emit_expr(&x));
        let label = node.label().and_then(|x| self.emit_label(&x));
        let loop_body = node.loop_body().and_then(|x| self.emit_block_expr(&x));
        let pat = node.pat().and_then(|x| self.emit_pat(&x));
        let label = self.trap.emit(generated::ForExpr {
            id: TrapId::Star,
            attrs,
            iterable,
            label,
            loop_body,
            pat,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_for_type(
        &mut self,
        node: &ast::ForType,
    ) -> Option<Label<generated::ForTypeRepr>> {
        let for_binder = node.for_binder().and_then(|x| self.emit_for_binder(&x));
        let type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let label = self.trap.emit(generated::ForTypeRepr {
            id: TrapId::Star,
            for_binder,
            type_repr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_format_args_arg(
        &mut self,
        node: &ast::FormatArgsArg,
    ) -> Option<Label<generated::FormatArgsArg>> {
        let expr = node.expr().and_then(|x| self.emit_expr(&x));
        let name = node.name().and_then(|x| self.emit_name(&x));
        let label = self.trap.emit(generated::FormatArgsArg {
            id: TrapId::Star,
            expr,
            name,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_format_args_expr(
        &mut self,
        node: &ast::FormatArgsExpr,
    ) -> Option<Label<generated::FormatArgsExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let args = node
            .args()
            .filter_map(|x| self.emit_format_args_arg(&x))
            .collect();
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let template = node.template().and_then(|x| self.emit_expr(&x));
        let label = self.trap.emit(generated::FormatArgsExpr {
            id: TrapId::Star,
            args,
            attrs,
            template,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_generic_arg_list(
        &mut self,
        node: &ast::GenericArgList,
    ) -> Option<Label<generated::GenericArgList>> {
        let generic_args = node
            .generic_args()
            .filter_map(|x| self.emit_generic_arg(&x))
            .collect();
        let label = self.trap.emit(generated::GenericArgList {
            id: TrapId::Star,
            generic_args,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_generic_param_list(
        &mut self,
        node: &ast::GenericParamList,
    ) -> Option<Label<generated::GenericParamList>> {
        let generic_params = node
            .generic_params()
            .filter_map(|x| self.emit_generic_param(&x))
            .collect();
        let label = self.trap.emit(generated::GenericParamList {
            id: TrapId::Star,
            generic_params,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_ident_pat(
        &mut self,
        node: &ast::IdentPat,
    ) -> Option<Label<generated::IdentPat>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let is_mut = node.mut_token().is_some();
        let is_ref = node.ref_token().is_some();
        let name = node.name().and_then(|x| self.emit_name(&x));
        let pat = node.pat().and_then(|x| self.emit_pat(&x));
        let label = self.trap.emit(generated::IdentPat {
            id: TrapId::Star,
            attrs,
            is_mut,
            is_ref,
            name,
            pat,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_if_expr(&mut self, node: &ast::IfExpr) -> Option<Label<generated::IfExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let condition = node.condition().and_then(|x| self.emit_expr(&x));
        let else_ = node.else_branch().and_then(|x| self.emit_else_branch(&x));
        let then = node.then_branch().and_then(|x| self.emit_block_expr(&x));
        let label = self.trap.emit(generated::IfExpr {
            id: TrapId::Star,
            attrs,
            condition,
            else_,
            then,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_impl(&mut self, node: &ast::Impl) -> Option<Label<generated::Impl>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let assoc_item_list = node
            .assoc_item_list()
            .and_then(|x| self.emit_assoc_item_list(&x));
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let generic_param_list = node
            .generic_param_list()
            .and_then(|x| self.emit_generic_param_list(&x));
        let is_const = node.const_token().is_some();
        let is_default = node.default_token().is_some();
        let is_unsafe = node.unsafe_token().is_some();
        let self_ty = node.self_ty().and_then(|x| self.emit_type(&x));
        let trait_ = node.trait_().and_then(|x| self.emit_type(&x));
        let visibility = node.visibility().and_then(|x| self.emit_visibility(&x));
        let where_clause = node.where_clause().and_then(|x| self.emit_where_clause(&x));
        let label = self.trap.emit(generated::Impl {
            id: TrapId::Star,
            assoc_item_list,
            attrs,
            generic_param_list,
            is_const,
            is_default,
            is_unsafe,
            self_ty,
            trait_,
            visibility,
            where_clause,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_impl_trait_type(
        &mut self,
        node: &ast::ImplTraitType,
    ) -> Option<Label<generated::ImplTraitTypeRepr>> {
        let type_bound_list = node
            .type_bound_list()
            .and_then(|x| self.emit_type_bound_list(&x));
        let label = self.trap.emit(generated::ImplTraitTypeRepr {
            id: TrapId::Star,
            type_bound_list,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_index_expr(
        &mut self,
        node: &ast::IndexExpr,
    ) -> Option<Label<generated::IndexExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let base = node.base().and_then(|x| self.emit_expr(&x));
        let index = node.index().and_then(|x| self.emit_expr(&x));
        let label = self.trap.emit(generated::IndexExpr {
            id: TrapId::Star,
            attrs,
            base,
            index,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_infer_type(
        &mut self,
        node: &ast::InferType,
    ) -> Option<Label<generated::InferTypeRepr>> {
        let label = self
            .trap
            .emit(generated::InferTypeRepr { id: TrapId::Star });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_item_list(
        &mut self,
        node: &ast::ItemList,
    ) -> Option<Label<generated::ItemList>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let items = node.items().filter_map(|x| self.emit_item(&x)).collect();
        let label = self.trap.emit(generated::ItemList {
            id: TrapId::Star,
            attrs,
            items,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_label(&mut self, node: &ast::Label) -> Option<Label<generated::Label>> {
        let lifetime = node.lifetime().and_then(|x| self.emit_lifetime(&x));
        let label = self.trap.emit(generated::Label {
            id: TrapId::Star,
            lifetime,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_let_else(
        &mut self,
        node: &ast::LetElse,
    ) -> Option<Label<generated::LetElse>> {
        let block_expr = node.block_expr().and_then(|x| self.emit_block_expr(&x));
        let label = self.trap.emit(generated::LetElse {
            id: TrapId::Star,
            block_expr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_let_expr(
        &mut self,
        node: &ast::LetExpr,
    ) -> Option<Label<generated::LetExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let scrutinee = node.expr().and_then(|x| self.emit_expr(&x));
        let pat = node.pat().and_then(|x| self.emit_pat(&x));
        let label = self.trap.emit(generated::LetExpr {
            id: TrapId::Star,
            attrs,
            scrutinee,
            pat,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_let_stmt(
        &mut self,
        node: &ast::LetStmt,
    ) -> Option<Label<generated::LetStmt>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let initializer = node.initializer().and_then(|x| self.emit_expr(&x));
        let let_else = node.let_else().and_then(|x| self.emit_let_else(&x));
        let pat = node.pat().and_then(|x| self.emit_pat(&x));
        let type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let label = self.trap.emit(generated::LetStmt {
            id: TrapId::Star,
            attrs,
            initializer,
            let_else,
            pat,
            type_repr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_lifetime(
        &mut self,
        node: &ast::Lifetime,
    ) -> Option<Label<generated::Lifetime>> {
        let text = node.try_get_text();
        let label = self.trap.emit(generated::Lifetime {
            id: TrapId::Star,
            text,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_lifetime_arg(
        &mut self,
        node: &ast::LifetimeArg,
    ) -> Option<Label<generated::LifetimeArg>> {
        let lifetime = node.lifetime().and_then(|x| self.emit_lifetime(&x));
        let label = self.trap.emit(generated::LifetimeArg {
            id: TrapId::Star,
            lifetime,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_lifetime_param(
        &mut self,
        node: &ast::LifetimeParam,
    ) -> Option<Label<generated::LifetimeParam>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let lifetime = node.lifetime().and_then(|x| self.emit_lifetime(&x));
        let type_bound_list = node
            .type_bound_list()
            .and_then(|x| self.emit_type_bound_list(&x));
        let label = self.trap.emit(generated::LifetimeParam {
            id: TrapId::Star,
            attrs,
            lifetime,
            type_bound_list,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_literal(
        &mut self,
        node: &ast::Literal,
    ) -> Option<Label<generated::LiteralExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let text_value = node.try_get_text();
        let label = self.trap.emit(generated::LiteralExpr {
            id: TrapId::Star,
            attrs,
            text_value,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_literal_pat(
        &mut self,
        node: &ast::LiteralPat,
    ) -> Option<Label<generated::LiteralPat>> {
        let literal = node.literal().and_then(|x| self.emit_literal(&x));
        let label = self.trap.emit(generated::LiteralPat {
            id: TrapId::Star,
            literal,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_loop_expr(
        &mut self,
        node: &ast::LoopExpr,
    ) -> Option<Label<generated::LoopExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let label = node.label().and_then(|x| self.emit_label(&x));
        let loop_body = node.loop_body().and_then(|x| self.emit_block_expr(&x));
        let label = self.trap.emit(generated::LoopExpr {
            id: TrapId::Star,
            attrs,
            label,
            loop_body,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_macro_call(
        &mut self,
        node: &ast::MacroCall,
    ) -> Option<Label<generated::MacroCall>> {
        if let Some(label) = self.pre_emit(node) {
            return Some(label);
        }
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let path = node.path().and_then(|x| self.emit_path(&x));
        let token_tree = if self.should_skip_bodies() {
            None
        } else {
            node.token_tree().and_then(|x| self.emit_token_tree(&x))
        };
        let label = self.trap.emit(generated::MacroCall {
            id: TrapId::Star,
            attrs,
            path,
            token_tree,
        });
        self.emit_location(label, node);
        self.post_emit(node, label);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_macro_def(
        &mut self,
        node: &ast::MacroDef,
    ) -> Option<Label<generated::MacroDef>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let args = if self.should_skip_bodies() {
            None
        } else {
            node.args().and_then(|x| self.emit_token_tree(&x))
        };
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let body = if self.should_skip_bodies() {
            None
        } else {
            node.body().and_then(|x| self.emit_token_tree(&x))
        };
        let name = node.name().and_then(|x| self.emit_name(&x));
        let visibility = node.visibility().and_then(|x| self.emit_visibility(&x));
        let label = self.trap.emit(generated::MacroDef {
            id: TrapId::Star,
            args,
            attrs,
            body,
            name,
            visibility,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_macro_expr(
        &mut self,
        node: &ast::MacroExpr,
    ) -> Option<Label<generated::MacroExpr>> {
        let macro_call = node.macro_call().and_then(|x| self.emit_macro_call(&x));
        let label = self.trap.emit(generated::MacroExpr {
            id: TrapId::Star,
            macro_call,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_macro_items(
        &mut self,
        node: &ast::MacroItems,
    ) -> Option<Label<generated::MacroItems>> {
        let items = node.items().filter_map(|x| self.emit_item(&x)).collect();
        let label = self.trap.emit(generated::MacroItems {
            id: TrapId::Star,
            items,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_macro_pat(
        &mut self,
        node: &ast::MacroPat,
    ) -> Option<Label<generated::MacroPat>> {
        let macro_call = node.macro_call().and_then(|x| self.emit_macro_call(&x));
        let label = self.trap.emit(generated::MacroPat {
            id: TrapId::Star,
            macro_call,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_macro_rules(
        &mut self,
        node: &ast::MacroRules,
    ) -> Option<Label<generated::MacroRules>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let name = node.name().and_then(|x| self.emit_name(&x));
        let token_tree = node.token_tree().and_then(|x| self.emit_token_tree(&x));
        let visibility = node.visibility().and_then(|x| self.emit_visibility(&x));
        let label = self.trap.emit(generated::MacroRules {
            id: TrapId::Star,
            attrs,
            name,
            token_tree,
            visibility,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_macro_type(
        &mut self,
        node: &ast::MacroType,
    ) -> Option<Label<generated::MacroTypeRepr>> {
        let macro_call = node.macro_call().and_then(|x| self.emit_macro_call(&x));
        let label = self.trap.emit(generated::MacroTypeRepr {
            id: TrapId::Star,
            macro_call,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_match_arm(
        &mut self,
        node: &ast::MatchArm,
    ) -> Option<Label<generated::MatchArm>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let expr = node.expr().and_then(|x| self.emit_expr(&x));
        let guard = node.guard().and_then(|x| self.emit_match_guard(&x));
        let pat = node.pat().and_then(|x| self.emit_pat(&x));
        let label = self.trap.emit(generated::MatchArm {
            id: TrapId::Star,
            attrs,
            expr,
            guard,
            pat,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_match_arm_list(
        &mut self,
        node: &ast::MatchArmList,
    ) -> Option<Label<generated::MatchArmList>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let arms = node
            .arms()
            .filter_map(|x| self.emit_match_arm(&x))
            .collect();
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let label = self.trap.emit(generated::MatchArmList {
            id: TrapId::Star,
            arms,
            attrs,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_match_expr(
        &mut self,
        node: &ast::MatchExpr,
    ) -> Option<Label<generated::MatchExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let scrutinee = node.expr().and_then(|x| self.emit_expr(&x));
        let match_arm_list = node
            .match_arm_list()
            .and_then(|x| self.emit_match_arm_list(&x));
        let label = self.trap.emit(generated::MatchExpr {
            id: TrapId::Star,
            attrs,
            scrutinee,
            match_arm_list,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_match_guard(
        &mut self,
        node: &ast::MatchGuard,
    ) -> Option<Label<generated::MatchGuard>> {
        let condition = node.condition().and_then(|x| self.emit_expr(&x));
        let label = self.trap.emit(generated::MatchGuard {
            id: TrapId::Star,
            condition,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_meta(&mut self, node: &ast::Meta) -> Option<Label<generated::Meta>> {
        if let Some(label) = self.pre_emit(node) {
            return Some(label);
        }
        let expr = node.expr().and_then(|x| self.emit_expr(&x));
        let is_unsafe = node.unsafe_token().is_some();
        let path = node.path().and_then(|x| self.emit_path(&x));
        let token_tree = node.token_tree().and_then(|x| self.emit_token_tree(&x));
        let label = self.trap.emit(generated::Meta {
            id: TrapId::Star,
            expr,
            is_unsafe,
            path,
            token_tree,
        });
        self.emit_location(label, node);
        self.post_emit(node, label);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_method_call_expr(
        &mut self,
        node: &ast::MethodCallExpr,
    ) -> Option<Label<generated::MethodCallExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let arg_list = node.arg_list().and_then(|x| self.emit_arg_list(&x));
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let generic_arg_list = node
            .generic_arg_list()
            .and_then(|x| self.emit_generic_arg_list(&x));
        let identifier = node.name_ref().and_then(|x| self.emit_name_ref(&x));
        let receiver = node.receiver().and_then(|x| self.emit_expr(&x));
        let label = self.trap.emit(generated::MethodCallExpr {
            id: TrapId::Star,
            arg_list,
            attrs,
            generic_arg_list,
            identifier,
            receiver,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_module(&mut self, node: &ast::Module) -> Option<Label<generated::Module>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let item_list = node.item_list().and_then(|x| self.emit_item_list(&x));
        let name = node.name().and_then(|x| self.emit_name(&x));
        let visibility = node.visibility().and_then(|x| self.emit_visibility(&x));
        let label = self.trap.emit(generated::Module {
            id: TrapId::Star,
            attrs,
            item_list,
            name,
            visibility,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_name(&mut self, node: &ast::Name) -> Option<Label<generated::Name>> {
        let text = node.try_get_text();
        let label = self.trap.emit(generated::Name {
            id: TrapId::Star,
            text,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_name_ref(
        &mut self,
        node: &ast::NameRef,
    ) -> Option<Label<generated::NameRef>> {
        let text = node.try_get_text();
        let label = self.trap.emit(generated::NameRef {
            id: TrapId::Star,
            text,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_never_type(
        &mut self,
        node: &ast::NeverType,
    ) -> Option<Label<generated::NeverTypeRepr>> {
        let label = self
            .trap
            .emit(generated::NeverTypeRepr { id: TrapId::Star });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_offset_of_expr(
        &mut self,
        node: &ast::OffsetOfExpr,
    ) -> Option<Label<generated::OffsetOfExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let fields = node
            .fields()
            .filter_map(|x| self.emit_name_ref(&x))
            .collect();
        let type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let label = self.trap.emit(generated::OffsetOfExpr {
            id: TrapId::Star,
            attrs,
            fields,
            type_repr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_or_pat(&mut self, node: &ast::OrPat) -> Option<Label<generated::OrPat>> {
        let pats = node.pats().filter_map(|x| self.emit_pat(&x)).collect();
        let label = self.trap.emit(generated::OrPat {
            id: TrapId::Star,
            pats,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_param(&mut self, node: &ast::Param) -> Option<Label<generated::Param>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let pat = if self.should_skip_bodies() {
            None
        } else {
            node.pat().and_then(|x| self.emit_pat(&x))
        };
        let type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let label = self.trap.emit(generated::Param {
            id: TrapId::Star,
            attrs,
            pat,
            type_repr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_param_list(
        &mut self,
        node: &ast::ParamList,
    ) -> Option<Label<generated::ParamList>> {
        let params = node.params().filter_map(|x| self.emit_param(&x)).collect();
        let self_param = node.self_param().and_then(|x| self.emit_self_param(&x));
        let label = self.trap.emit(generated::ParamList {
            id: TrapId::Star,
            params,
            self_param,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_paren_expr(
        &mut self,
        node: &ast::ParenExpr,
    ) -> Option<Label<generated::ParenExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let expr = node.expr().and_then(|x| self.emit_expr(&x));
        let label = self.trap.emit(generated::ParenExpr {
            id: TrapId::Star,
            attrs,
            expr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_paren_pat(
        &mut self,
        node: &ast::ParenPat,
    ) -> Option<Label<generated::ParenPat>> {
        let pat = node.pat().and_then(|x| self.emit_pat(&x));
        let label = self.trap.emit(generated::ParenPat {
            id: TrapId::Star,
            pat,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_paren_type(
        &mut self,
        node: &ast::ParenType,
    ) -> Option<Label<generated::ParenTypeRepr>> {
        let type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let label = self.trap.emit(generated::ParenTypeRepr {
            id: TrapId::Star,
            type_repr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_parenthesized_arg_list(
        &mut self,
        node: &ast::ParenthesizedArgList,
    ) -> Option<Label<generated::ParenthesizedArgList>> {
        let type_args = node
            .type_args()
            .filter_map(|x| self.emit_type_arg(&x))
            .collect();
        let label = self.trap.emit(generated::ParenthesizedArgList {
            id: TrapId::Star,
            type_args,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_path(&mut self, node: &ast::Path) -> Option<Label<generated::Path>> {
        let qualifier = node.qualifier().and_then(|x| self.emit_path(&x));
        let segment = node.segment().and_then(|x| self.emit_path_segment(&x));
        let label = self.trap.emit(generated::Path {
            id: TrapId::Star,
            qualifier,
            segment,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_path_expr(
        &mut self,
        node: &ast::PathExpr,
    ) -> Option<Label<generated::PathExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let path = node.path().and_then(|x| self.emit_path(&x));
        let label = self.trap.emit(generated::PathExpr {
            id: TrapId::Star,
            attrs,
            path,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_path_pat(
        &mut self,
        node: &ast::PathPat,
    ) -> Option<Label<generated::PathPat>> {
        let path = node.path().and_then(|x| self.emit_path(&x));
        let label = self.trap.emit(generated::PathPat {
            id: TrapId::Star,
            path,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_path_segment(
        &mut self,
        node: &ast::PathSegment,
    ) -> Option<Label<generated::PathSegment>> {
        if let Some(label) = self.pre_emit(node) {
            return Some(label);
        }
        let generic_arg_list = node
            .generic_arg_list()
            .and_then(|x| self.emit_generic_arg_list(&x));
        let identifier = node.name_ref().and_then(|x| self.emit_name_ref(&x));
        let parenthesized_arg_list = node
            .parenthesized_arg_list()
            .and_then(|x| self.emit_parenthesized_arg_list(&x));
        let ret_type = node.ret_type().and_then(|x| self.emit_ret_type(&x));
        let return_type_syntax = node
            .return_type_syntax()
            .and_then(|x| self.emit_return_type_syntax(&x));
        let label = self.trap.emit(generated::PathSegment {
            id: TrapId::Star,
            generic_arg_list,
            identifier,
            parenthesized_arg_list,
            ret_type,
            return_type_syntax,
        });
        self.emit_location(label, node);
        self.post_emit(node, label);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_path_type(
        &mut self,
        node: &ast::PathType,
    ) -> Option<Label<generated::PathTypeRepr>> {
        let path = node.path().and_then(|x| self.emit_path(&x));
        let label = self.trap.emit(generated::PathTypeRepr {
            id: TrapId::Star,
            path,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_prefix_expr(
        &mut self,
        node: &ast::PrefixExpr,
    ) -> Option<Label<generated::PrefixExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let expr = node.expr().and_then(|x| self.emit_expr(&x));
        let operator_name = node.try_get_text();
        let label = self.trap.emit(generated::PrefixExpr {
            id: TrapId::Star,
            attrs,
            expr,
            operator_name,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_ptr_type(
        &mut self,
        node: &ast::PtrType,
    ) -> Option<Label<generated::PtrTypeRepr>> {
        let is_const = node.const_token().is_some();
        let is_mut = node.mut_token().is_some();
        let type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let label = self.trap.emit(generated::PtrTypeRepr {
            id: TrapId::Star,
            is_const,
            is_mut,
            type_repr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_range_expr(
        &mut self,
        node: &ast::RangeExpr,
    ) -> Option<Label<generated::RangeExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let end = node.end().and_then(|x| self.emit_expr(&x));
        let operator_name = node.try_get_text();
        let start = node.start().and_then(|x| self.emit_expr(&x));
        let label = self.trap.emit(generated::RangeExpr {
            id: TrapId::Star,
            attrs,
            end,
            operator_name,
            start,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_range_pat(
        &mut self,
        node: &ast::RangePat,
    ) -> Option<Label<generated::RangePat>> {
        let end = node.end().and_then(|x| self.emit_pat(&x));
        let operator_name = node.try_get_text();
        let start = node.start().and_then(|x| self.emit_pat(&x));
        let label = self.trap.emit(generated::RangePat {
            id: TrapId::Star,
            end,
            operator_name,
            start,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_record_expr(
        &mut self,
        node: &ast::RecordExpr,
    ) -> Option<Label<generated::StructExpr>> {
        let path = node.path().and_then(|x| self.emit_path(&x));
        let struct_expr_field_list = node
            .record_expr_field_list()
            .and_then(|x| self.emit_record_expr_field_list(&x));
        let label = self.trap.emit(generated::StructExpr {
            id: TrapId::Star,
            path,
            struct_expr_field_list,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_record_expr_field(
        &mut self,
        node: &ast::RecordExprField,
    ) -> Option<Label<generated::StructExprField>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let expr = node.expr().and_then(|x| self.emit_expr(&x));
        let identifier = node.name_ref().and_then(|x| self.emit_name_ref(&x));
        let label = self.trap.emit(generated::StructExprField {
            id: TrapId::Star,
            attrs,
            expr,
            identifier,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_record_expr_field_list(
        &mut self,
        node: &ast::RecordExprFieldList,
    ) -> Option<Label<generated::StructExprFieldList>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let fields = node
            .fields()
            .filter_map(|x| self.emit_record_expr_field(&x))
            .collect();
        let spread = node.spread().and_then(|x| self.emit_expr(&x));
        let label = self.trap.emit(generated::StructExprFieldList {
            id: TrapId::Star,
            attrs,
            fields,
            spread,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_record_field(
        &mut self,
        node: &ast::RecordField,
    ) -> Option<Label<generated::StructField>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let default = node.expr().and_then(|x| self.emit_expr(&x));
        let is_unsafe = node.unsafe_token().is_some();
        let name = node.name().and_then(|x| self.emit_name(&x));
        let type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let visibility = node.visibility().and_then(|x| self.emit_visibility(&x));
        let label = self.trap.emit(generated::StructField {
            id: TrapId::Star,
            attrs,
            default,
            is_unsafe,
            name,
            type_repr,
            visibility,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_record_field_list(
        &mut self,
        node: &ast::RecordFieldList,
    ) -> Option<Label<generated::StructFieldList>> {
        let fields = node
            .fields()
            .filter_map(|x| self.emit_record_field(&x))
            .collect();
        let label = self.trap.emit(generated::StructFieldList {
            id: TrapId::Star,
            fields,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_record_pat(
        &mut self,
        node: &ast::RecordPat,
    ) -> Option<Label<generated::StructPat>> {
        let path = node.path().and_then(|x| self.emit_path(&x));
        let struct_pat_field_list = node
            .record_pat_field_list()
            .and_then(|x| self.emit_record_pat_field_list(&x));
        let label = self.trap.emit(generated::StructPat {
            id: TrapId::Star,
            path,
            struct_pat_field_list,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_record_pat_field(
        &mut self,
        node: &ast::RecordPatField,
    ) -> Option<Label<generated::StructPatField>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let identifier = node.name_ref().and_then(|x| self.emit_name_ref(&x));
        let pat = node.pat().and_then(|x| self.emit_pat(&x));
        let label = self.trap.emit(generated::StructPatField {
            id: TrapId::Star,
            attrs,
            identifier,
            pat,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_record_pat_field_list(
        &mut self,
        node: &ast::RecordPatFieldList,
    ) -> Option<Label<generated::StructPatFieldList>> {
        let fields = node
            .fields()
            .filter_map(|x| self.emit_record_pat_field(&x))
            .collect();
        let rest_pat = node.rest_pat().and_then(|x| self.emit_rest_pat(&x));
        let label = self.trap.emit(generated::StructPatFieldList {
            id: TrapId::Star,
            fields,
            rest_pat,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_ref_expr(
        &mut self,
        node: &ast::RefExpr,
    ) -> Option<Label<generated::RefExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let expr = node.expr().and_then(|x| self.emit_expr(&x));
        let is_const = node.const_token().is_some();
        let is_mut = node.mut_token().is_some();
        let is_raw = node.raw_token().is_some();
        let label = self.trap.emit(generated::RefExpr {
            id: TrapId::Star,
            attrs,
            expr,
            is_const,
            is_mut,
            is_raw,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_ref_pat(&mut self, node: &ast::RefPat) -> Option<Label<generated::RefPat>> {
        let is_mut = node.mut_token().is_some();
        let pat = node.pat().and_then(|x| self.emit_pat(&x));
        let label = self.trap.emit(generated::RefPat {
            id: TrapId::Star,
            is_mut,
            pat,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_ref_type(
        &mut self,
        node: &ast::RefType,
    ) -> Option<Label<generated::RefTypeRepr>> {
        let is_mut = node.mut_token().is_some();
        let lifetime = node.lifetime().and_then(|x| self.emit_lifetime(&x));
        let type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let label = self.trap.emit(generated::RefTypeRepr {
            id: TrapId::Star,
            is_mut,
            lifetime,
            type_repr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_rename(&mut self, node: &ast::Rename) -> Option<Label<generated::Rename>> {
        let name = node.name().and_then(|x| self.emit_name(&x));
        let label = self.trap.emit(generated::Rename {
            id: TrapId::Star,
            name,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_rest_pat(
        &mut self,
        node: &ast::RestPat,
    ) -> Option<Label<generated::RestPat>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let label = self.trap.emit(generated::RestPat {
            id: TrapId::Star,
            attrs,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_ret_type(
        &mut self,
        node: &ast::RetType,
    ) -> Option<Label<generated::RetTypeRepr>> {
        let type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let label = self.trap.emit(generated::RetTypeRepr {
            id: TrapId::Star,
            type_repr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_return_expr(
        &mut self,
        node: &ast::ReturnExpr,
    ) -> Option<Label<generated::ReturnExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let expr = node.expr().and_then(|x| self.emit_expr(&x));
        let label = self.trap.emit(generated::ReturnExpr {
            id: TrapId::Star,
            attrs,
            expr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_return_type_syntax(
        &mut self,
        node: &ast::ReturnTypeSyntax,
    ) -> Option<Label<generated::ReturnTypeSyntax>> {
        let label = self
            .trap
            .emit(generated::ReturnTypeSyntax { id: TrapId::Star });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_self_param(
        &mut self,
        node: &ast::SelfParam,
    ) -> Option<Label<generated::SelfParam>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let is_ref = node.amp_token().is_some();
        let is_mut = node.mut_token().is_some();
        let lifetime = node.lifetime().and_then(|x| self.emit_lifetime(&x));
        let name = node.name().and_then(|x| self.emit_name(&x));
        let type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let label = self.trap.emit(generated::SelfParam {
            id: TrapId::Star,
            attrs,
            is_ref,
            is_mut,
            lifetime,
            name,
            type_repr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_slice_pat(
        &mut self,
        node: &ast::SlicePat,
    ) -> Option<Label<generated::SlicePat>> {
        let pats = node.pats().filter_map(|x| self.emit_pat(&x)).collect();
        let label = self.trap.emit(generated::SlicePat {
            id: TrapId::Star,
            pats,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_slice_type(
        &mut self,
        node: &ast::SliceType,
    ) -> Option<Label<generated::SliceTypeRepr>> {
        let type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let label = self.trap.emit(generated::SliceTypeRepr {
            id: TrapId::Star,
            type_repr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_source_file(
        &mut self,
        node: &ast::SourceFile,
    ) -> Option<Label<generated::SourceFile>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let items = node.items().filter_map(|x| self.emit_item(&x)).collect();
        let label = self.trap.emit(generated::SourceFile {
            id: TrapId::Star,
            attrs,
            items,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_static(&mut self, node: &ast::Static) -> Option<Label<generated::Static>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let body = if self.should_skip_bodies() {
            None
        } else {
            node.body().and_then(|x| self.emit_expr(&x))
        };
        let is_mut = node.mut_token().is_some();
        let is_static = node.static_token().is_some();
        let is_unsafe = node.unsafe_token().is_some();
        let name = node.name().and_then(|x| self.emit_name(&x));
        let type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let visibility = node.visibility().and_then(|x| self.emit_visibility(&x));
        let label = self.trap.emit(generated::Static {
            id: TrapId::Star,
            attrs,
            body,
            is_mut,
            is_static,
            is_unsafe,
            name,
            type_repr,
            visibility,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_stmt_list(
        &mut self,
        node: &ast::StmtList,
    ) -> Option<Label<generated::StmtList>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let statements = node
            .statements()
            .filter_map(|x| self.emit_stmt(&x))
            .collect();
        let tail_expr = node.tail_expr().and_then(|x| self.emit_expr(&x));
        let label = self.trap.emit(generated::StmtList {
            id: TrapId::Star,
            attrs,
            statements,
            tail_expr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_struct(&mut self, node: &ast::Struct) -> Option<Label<generated::Struct>> {
        if let Some(label) = self.pre_emit(node) {
            return Some(label);
        }
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let field_list = node.field_list().and_then(|x| self.emit_field_list(&x));
        let generic_param_list = node
            .generic_param_list()
            .and_then(|x| self.emit_generic_param_list(&x));
        let name = node.name().and_then(|x| self.emit_name(&x));
        let visibility = node.visibility().and_then(|x| self.emit_visibility(&x));
        let where_clause = node.where_clause().and_then(|x| self.emit_where_clause(&x));
        let label = self.trap.emit(generated::Struct {
            id: TrapId::Star,
            attrs,
            field_list,
            generic_param_list,
            name,
            visibility,
            where_clause,
        });
        self.emit_location(label, node);
        self.post_emit(node, label);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_token_tree(
        &mut self,
        node: &ast::TokenTree,
    ) -> Option<Label<generated::TokenTree>> {
        let label = self.trap.emit(generated::TokenTree { id: TrapId::Star });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_trait(&mut self, node: &ast::Trait) -> Option<Label<generated::Trait>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let assoc_item_list = node
            .assoc_item_list()
            .and_then(|x| self.emit_assoc_item_list(&x));
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let generic_param_list = node
            .generic_param_list()
            .and_then(|x| self.emit_generic_param_list(&x));
        let is_auto = node.auto_token().is_some();
        let is_unsafe = node.unsafe_token().is_some();
        let name = node.name().and_then(|x| self.emit_name(&x));
        let type_bound_list = node
            .type_bound_list()
            .and_then(|x| self.emit_type_bound_list(&x));
        let visibility = node.visibility().and_then(|x| self.emit_visibility(&x));
        let where_clause = node.where_clause().and_then(|x| self.emit_where_clause(&x));
        let label = self.trap.emit(generated::Trait {
            id: TrapId::Star,
            assoc_item_list,
            attrs,
            generic_param_list,
            is_auto,
            is_unsafe,
            name,
            type_bound_list,
            visibility,
            where_clause,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_trait_alias(
        &mut self,
        node: &ast::TraitAlias,
    ) -> Option<Label<generated::TraitAlias>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let generic_param_list = node
            .generic_param_list()
            .and_then(|x| self.emit_generic_param_list(&x));
        let name = node.name().and_then(|x| self.emit_name(&x));
        let type_bound_list = node
            .type_bound_list()
            .and_then(|x| self.emit_type_bound_list(&x));
        let visibility = node.visibility().and_then(|x| self.emit_visibility(&x));
        let where_clause = node.where_clause().and_then(|x| self.emit_where_clause(&x));
        let label = self.trap.emit(generated::TraitAlias {
            id: TrapId::Star,
            attrs,
            generic_param_list,
            name,
            type_bound_list,
            visibility,
            where_clause,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_try_expr(
        &mut self,
        node: &ast::TryExpr,
    ) -> Option<Label<generated::TryExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let expr = node.expr().and_then(|x| self.emit_expr(&x));
        let label = self.trap.emit(generated::TryExpr {
            id: TrapId::Star,
            attrs,
            expr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_tuple_expr(
        &mut self,
        node: &ast::TupleExpr,
    ) -> Option<Label<generated::TupleExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let fields = node.fields().filter_map(|x| self.emit_expr(&x)).collect();
        let label = self.trap.emit(generated::TupleExpr {
            id: TrapId::Star,
            attrs,
            fields,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_tuple_field(
        &mut self,
        node: &ast::TupleField,
    ) -> Option<Label<generated::TupleField>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let visibility = node.visibility().and_then(|x| self.emit_visibility(&x));
        let label = self.trap.emit(generated::TupleField {
            id: TrapId::Star,
            attrs,
            type_repr,
            visibility,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_tuple_field_list(
        &mut self,
        node: &ast::TupleFieldList,
    ) -> Option<Label<generated::TupleFieldList>> {
        let fields = node
            .fields()
            .filter_map(|x| self.emit_tuple_field(&x))
            .collect();
        let label = self.trap.emit(generated::TupleFieldList {
            id: TrapId::Star,
            fields,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_tuple_pat(
        &mut self,
        node: &ast::TuplePat,
    ) -> Option<Label<generated::TuplePat>> {
        let fields = node.fields().filter_map(|x| self.emit_pat(&x)).collect();
        let label = self.trap.emit(generated::TuplePat {
            id: TrapId::Star,
            fields,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_tuple_struct_pat(
        &mut self,
        node: &ast::TupleStructPat,
    ) -> Option<Label<generated::TupleStructPat>> {
        let fields = node.fields().filter_map(|x| self.emit_pat(&x)).collect();
        let path = node.path().and_then(|x| self.emit_path(&x));
        let label = self.trap.emit(generated::TupleStructPat {
            id: TrapId::Star,
            fields,
            path,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_tuple_type(
        &mut self,
        node: &ast::TupleType,
    ) -> Option<Label<generated::TupleTypeRepr>> {
        let fields = node.fields().filter_map(|x| self.emit_type(&x)).collect();
        let label = self.trap.emit(generated::TupleTypeRepr {
            id: TrapId::Star,
            fields,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_type_alias(
        &mut self,
        node: &ast::TypeAlias,
    ) -> Option<Label<generated::TypeAlias>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let generic_param_list = node
            .generic_param_list()
            .and_then(|x| self.emit_generic_param_list(&x));
        let is_default = node.default_token().is_some();
        let name = node.name().and_then(|x| self.emit_name(&x));
        let type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let type_bound_list = node
            .type_bound_list()
            .and_then(|x| self.emit_type_bound_list(&x));
        let visibility = node.visibility().and_then(|x| self.emit_visibility(&x));
        let where_clause = node.where_clause().and_then(|x| self.emit_where_clause(&x));
        let label = self.trap.emit(generated::TypeAlias {
            id: TrapId::Star,
            attrs,
            generic_param_list,
            is_default,
            name,
            type_repr,
            type_bound_list,
            visibility,
            where_clause,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_type_arg(
        &mut self,
        node: &ast::TypeArg,
    ) -> Option<Label<generated::TypeArg>> {
        let type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let label = self.trap.emit(generated::TypeArg {
            id: TrapId::Star,
            type_repr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_type_bound(
        &mut self,
        node: &ast::TypeBound,
    ) -> Option<Label<generated::TypeBound>> {
        let for_binder = node.for_binder().and_then(|x| self.emit_for_binder(&x));
        let is_async = node.async_token().is_some();
        let is_const = node.const_token().is_some();
        let lifetime = node.lifetime().and_then(|x| self.emit_lifetime(&x));
        let type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let use_bound_generic_args = node
            .use_bound_generic_args()
            .and_then(|x| self.emit_use_bound_generic_args(&x));
        let label = self.trap.emit(generated::TypeBound {
            id: TrapId::Star,
            for_binder,
            is_async,
            is_const,
            lifetime,
            type_repr,
            use_bound_generic_args,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_type_bound_list(
        &mut self,
        node: &ast::TypeBoundList,
    ) -> Option<Label<generated::TypeBoundList>> {
        let bounds = node
            .bounds()
            .filter_map(|x| self.emit_type_bound(&x))
            .collect();
        let label = self.trap.emit(generated::TypeBoundList {
            id: TrapId::Star,
            bounds,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_type_param(
        &mut self,
        node: &ast::TypeParam,
    ) -> Option<Label<generated::TypeParam>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let default_type = node.default_type().and_then(|x| self.emit_type(&x));
        let name = node.name().and_then(|x| self.emit_name(&x));
        let type_bound_list = node
            .type_bound_list()
            .and_then(|x| self.emit_type_bound_list(&x));
        let label = self.trap.emit(generated::TypeParam {
            id: TrapId::Star,
            attrs,
            default_type,
            name,
            type_bound_list,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_underscore_expr(
        &mut self,
        node: &ast::UnderscoreExpr,
    ) -> Option<Label<generated::UnderscoreExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let label = self.trap.emit(generated::UnderscoreExpr {
            id: TrapId::Star,
            attrs,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_union(&mut self, node: &ast::Union) -> Option<Label<generated::Union>> {
        if let Some(label) = self.pre_emit(node) {
            return Some(label);
        }
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let generic_param_list = node
            .generic_param_list()
            .and_then(|x| self.emit_generic_param_list(&x));
        let name = node.name().and_then(|x| self.emit_name(&x));
        let struct_field_list = node
            .record_field_list()
            .and_then(|x| self.emit_record_field_list(&x));
        let visibility = node.visibility().and_then(|x| self.emit_visibility(&x));
        let where_clause = node.where_clause().and_then(|x| self.emit_where_clause(&x));
        let label = self.trap.emit(generated::Union {
            id: TrapId::Star,
            attrs,
            generic_param_list,
            name,
            struct_field_list,
            visibility,
            where_clause,
        });
        self.emit_location(label, node);
        self.post_emit(node, label);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_use(&mut self, node: &ast::Use) -> Option<Label<generated::Use>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let use_tree = node.use_tree().and_then(|x| self.emit_use_tree(&x));
        let visibility = node.visibility().and_then(|x| self.emit_visibility(&x));
        let label = self.trap.emit(generated::Use {
            id: TrapId::Star,
            attrs,
            use_tree,
            visibility,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_use_bound_generic_args(
        &mut self,
        node: &ast::UseBoundGenericArgs,
    ) -> Option<Label<generated::UseBoundGenericArgs>> {
        let use_bound_generic_args = node
            .use_bound_generic_args()
            .filter_map(|x| self.emit_use_bound_generic_arg(&x))
            .collect();
        let label = self.trap.emit(generated::UseBoundGenericArgs {
            id: TrapId::Star,
            use_bound_generic_args,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_use_tree(
        &mut self,
        node: &ast::UseTree,
    ) -> Option<Label<generated::UseTree>> {
        let is_glob = node.star_token().is_some();
        let path = node.path().and_then(|x| self.emit_path(&x));
        let rename = node.rename().and_then(|x| self.emit_rename(&x));
        let use_tree_list = node
            .use_tree_list()
            .and_then(|x| self.emit_use_tree_list(&x));
        let label = self.trap.emit(generated::UseTree {
            id: TrapId::Star,
            is_glob,
            path,
            rename,
            use_tree_list,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_use_tree_list(
        &mut self,
        node: &ast::UseTreeList,
    ) -> Option<Label<generated::UseTreeList>> {
        let use_trees = node
            .use_trees()
            .filter_map(|x| self.emit_use_tree(&x))
            .collect();
        let label = self.trap.emit(generated::UseTreeList {
            id: TrapId::Star,
            use_trees,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_variant(
        &mut self,
        node: &ast::Variant,
    ) -> Option<Label<generated::Variant>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let discriminant = node.expr().and_then(|x| self.emit_expr(&x));
        let field_list = node.field_list().and_then(|x| self.emit_field_list(&x));
        let name = node.name().and_then(|x| self.emit_name(&x));
        let visibility = node.visibility().and_then(|x| self.emit_visibility(&x));
        let label = self.trap.emit(generated::Variant {
            id: TrapId::Star,
            attrs,
            discriminant,
            field_list,
            name,
            visibility,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_variant_list(
        &mut self,
        node: &ast::VariantList,
    ) -> Option<Label<generated::VariantList>> {
        let variants = node
            .variants()
            .filter_map(|x| self.emit_variant(&x))
            .collect();
        let label = self.trap.emit(generated::VariantList {
            id: TrapId::Star,
            variants,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_visibility(
        &mut self,
        node: &ast::Visibility,
    ) -> Option<Label<generated::Visibility>> {
        let path = node.path().and_then(|x| self.emit_path(&x));
        let label = self.trap.emit(generated::Visibility {
            id: TrapId::Star,
            path,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_where_clause(
        &mut self,
        node: &ast::WhereClause,
    ) -> Option<Label<generated::WhereClause>> {
        let predicates = node
            .predicates()
            .filter_map(|x| self.emit_where_pred(&x))
            .collect();
        let label = self.trap.emit(generated::WhereClause {
            id: TrapId::Star,
            predicates,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_where_pred(
        &mut self,
        node: &ast::WherePred,
    ) -> Option<Label<generated::WherePred>> {
        let for_binder = node.for_binder().and_then(|x| self.emit_for_binder(&x));
        let lifetime = node.lifetime().and_then(|x| self.emit_lifetime(&x));
        let type_repr = node.ty().and_then(|x| self.emit_type(&x));
        let type_bound_list = node
            .type_bound_list()
            .and_then(|x| self.emit_type_bound_list(&x));
        let label = self.trap.emit(generated::WherePred {
            id: TrapId::Star,
            for_binder,
            lifetime,
            type_repr,
            type_bound_list,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_while_expr(
        &mut self,
        node: &ast::WhileExpr,
    ) -> Option<Label<generated::WhileExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let condition = node.condition().and_then(|x| self.emit_expr(&x));
        let label = node.label().and_then(|x| self.emit_label(&x));
        let loop_body = node.loop_body().and_then(|x| self.emit_block_expr(&x));
        let label = self.trap.emit(generated::WhileExpr {
            id: TrapId::Star,
            attrs,
            condition,
            label,
            loop_body,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_wildcard_pat(
        &mut self,
        node: &ast::WildcardPat,
    ) -> Option<Label<generated::WildcardPat>> {
        let label = self.trap.emit(generated::WildcardPat { id: TrapId::Star });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_yeet_expr(
        &mut self,
        node: &ast::YeetExpr,
    ) -> Option<Label<generated::YeetExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let expr = node.expr().and_then(|x| self.emit_expr(&x));
        let label = self.trap.emit(generated::YeetExpr {
            id: TrapId::Star,
            attrs,
            expr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
    pub(crate) fn emit_yield_expr(
        &mut self,
        node: &ast::YieldExpr,
    ) -> Option<Label<generated::YieldExpr>> {
        if self.should_be_excluded(node) {
            return None;
        }
        let attrs = node.attrs().filter_map(|x| self.emit_attr(&x)).collect();
        let expr = node.expr().and_then(|x| self.emit_expr(&x));
        let label = self.trap.emit(generated::YieldExpr {
            id: TrapId::Star,
            attrs,
            expr,
        });
        self.emit_location(label, node);
        self.emit_tokens(node, label.into(), node.syntax().children_with_tokens());
        Some(label)
    }
}
impl HasTrapClass for ast::AssocItem {
    type TrapClass = generated::AssocItem;
}
impl HasTrapClass for ast::ExternItem {
    type TrapClass = generated::ExternItem;
}
impl HasTrapClass for ast::Item {
    type TrapClass = generated::Item;
}
impl HasTrapClass for ast::Const {
    type TrapClass = generated::Const;
}
impl HasTrapClass for ast::Enum {
    type TrapClass = generated::Enum;
}
impl HasTrapClass for ast::Fn {
    type TrapClass = generated::Function;
}
impl HasTrapClass for ast::MacroCall {
    type TrapClass = generated::MacroCall;
}
impl HasTrapClass for ast::Meta {
    type TrapClass = generated::Meta;
}
impl HasTrapClass for ast::PathSegment {
    type TrapClass = generated::PathSegment;
}
impl HasTrapClass for ast::Struct {
    type TrapClass = generated::Struct;
}
impl HasTrapClass for ast::Union {
    type TrapClass = generated::Union;
}
