// generated by codegen, do not edit
/**
 * This module provides the generated definition of `ClosureExpr`.
 * INTERNAL: Do not import directly.
 */

private import codeql.rust.elements.internal.generated.Synth
private import codeql.rust.elements.internal.generated.Raw
import codeql.rust.elements.internal.CallableImpl::Impl as CallableImpl
import codeql.rust.elements.Expr
import codeql.rust.elements.internal.ExprImpl::Impl as ExprImpl
import codeql.rust.elements.ForBinder
import codeql.rust.elements.RetTypeRepr

/**
 * INTERNAL: This module contains the fully generated definition of `ClosureExpr` and should not
 * be referenced directly.
 */
module Generated {
  /**
   * A closure expression. For example:
   * ```rust
   * |x| x + 1;
   * move |x: i32| -> i32 { x + 1 };
   * async |x: i32, y| x + y;
   * #[coroutine]
   * |x| yield x;
   * #[coroutine]
   * static |x| yield x;
   * for<T: std::fmt::Debug> |x: T| {
   *     println!("{:?}", x);
   * };
   * ```
   * INTERNAL: Do not reference the `Generated::ClosureExpr` class directly.
   * Use the subclass `ClosureExpr`, where the following predicates are available.
   */
  class ClosureExpr extends Synth::TClosureExpr, ExprImpl::Expr, CallableImpl::Callable {
    override string getAPrimaryQlClass() { result = "ClosureExpr" }

    /**
     * Gets the closure body of this closure expression, if it exists.
     */
    Expr getClosureBody() {
      result =
        Synth::convertExprFromRaw(Synth::convertClosureExprToRaw(this)
              .(Raw::ClosureExpr)
              .getClosureBody())
    }

    /**
     * Holds if `getClosureBody()` exists.
     */
    final predicate hasClosureBody() { exists(this.getClosureBody()) }

    /**
     * Gets the for binder of this closure expression, if it exists.
     */
    ForBinder getForBinder() {
      result =
        Synth::convertForBinderFromRaw(Synth::convertClosureExprToRaw(this)
              .(Raw::ClosureExpr)
              .getForBinder())
    }

    /**
     * Holds if `getForBinder()` exists.
     */
    final predicate hasForBinder() { exists(this.getForBinder()) }

    /**
     * Holds if this closure expression is async.
     */
    predicate isAsync() { Synth::convertClosureExprToRaw(this).(Raw::ClosureExpr).isAsync() }

    /**
     * Holds if this closure expression is const.
     */
    predicate isConst() { Synth::convertClosureExprToRaw(this).(Raw::ClosureExpr).isConst() }

    /**
     * Holds if this closure expression is gen.
     */
    predicate isGen() { Synth::convertClosureExprToRaw(this).(Raw::ClosureExpr).isGen() }

    /**
     * Holds if this closure expression is move.
     */
    predicate isMove() { Synth::convertClosureExprToRaw(this).(Raw::ClosureExpr).isMove() }

    /**
     * Holds if this closure expression is static.
     */
    predicate isStatic() { Synth::convertClosureExprToRaw(this).(Raw::ClosureExpr).isStatic() }

    /**
     * Gets the ret type of this closure expression, if it exists.
     */
    RetTypeRepr getRetType() {
      result =
        Synth::convertRetTypeReprFromRaw(Synth::convertClosureExprToRaw(this)
              .(Raw::ClosureExpr)
              .getRetType())
    }

    /**
     * Holds if `getRetType()` exists.
     */
    final predicate hasRetType() { exists(this.getRetType()) }
  }
}
