// generated by codegen, do not edit
/**
 * This module provides the generated definition of `Static`.
 * INTERNAL: Do not import directly.
 */

private import codeql.rust.elements.internal.generated.Synth
private import codeql.rust.elements.internal.generated.Raw
import codeql.rust.elements.Attr
import codeql.rust.elements.Expr
import codeql.rust.elements.internal.ExternItemImpl::Impl as ExternItemImpl
import codeql.rust.elements.Name
import codeql.rust.elements.TypeRepr
import codeql.rust.elements.Visibility

/**
 * INTERNAL: This module contains the fully generated definition of `Static` and should not
 * be referenced directly.
 */
module Generated {
  /**
   * A static item declaration.
   *
   * For example:
   * ```rust
   * static X: i32 = 42;
   * ```
   * INTERNAL: Do not reference the `Generated::Static` class directly.
   * Use the subclass `Static`, where the following predicates are available.
   */
  class Static extends Synth::TStatic, ExternItemImpl::ExternItem {
    override string getAPrimaryQlClass() { result = "Static" }

    /**
     * Gets the `index`th attr of this static (0-based).
     */
    Attr getAttr(int index) {
      result =
        Synth::convertAttrFromRaw(Synth::convertStaticToRaw(this).(Raw::Static).getAttr(index))
    }

    /**
     * Gets any of the attrs of this static.
     */
    final Attr getAnAttr() { result = this.getAttr(_) }

    /**
     * Gets the number of attrs of this static.
     */
    final int getNumberOfAttrs() { result = count(int i | exists(this.getAttr(i))) }

    /**
     * Gets the body of this static, if it exists.
     */
    Expr getBody() {
      result = Synth::convertExprFromRaw(Synth::convertStaticToRaw(this).(Raw::Static).getBody())
    }

    /**
     * Holds if `getBody()` exists.
     */
    final predicate hasBody() { exists(this.getBody()) }

    /**
     * Holds if this static is mut.
     */
    predicate isMut() { Synth::convertStaticToRaw(this).(Raw::Static).isMut() }

    /**
     * Holds if this static is static.
     */
    predicate isStatic() { Synth::convertStaticToRaw(this).(Raw::Static).isStatic() }

    /**
     * Holds if this static is unsafe.
     */
    predicate isUnsafe() { Synth::convertStaticToRaw(this).(Raw::Static).isUnsafe() }

    /**
     * Gets the name of this static, if it exists.
     */
    Name getName() {
      result = Synth::convertNameFromRaw(Synth::convertStaticToRaw(this).(Raw::Static).getName())
    }

    /**
     * Holds if `getName()` exists.
     */
    final predicate hasName() { exists(this.getName()) }

    /**
     * Gets the type representation of this static, if it exists.
     */
    TypeRepr getTypeRepr() {
      result =
        Synth::convertTypeReprFromRaw(Synth::convertStaticToRaw(this).(Raw::Static).getTypeRepr())
    }

    /**
     * Holds if `getTypeRepr()` exists.
     */
    final predicate hasTypeRepr() { exists(this.getTypeRepr()) }

    /**
     * Gets the visibility of this static, if it exists.
     */
    Visibility getVisibility() {
      result =
        Synth::convertVisibilityFromRaw(Synth::convertStaticToRaw(this)
              .(Raw::Static)
              .getVisibility())
    }

    /**
     * Holds if `getVisibility()` exists.
     */
    final predicate hasVisibility() { exists(this.getVisibility()) }
  }
}
