// generated by codegen/codegen.py, do not edit
/**
 * This module provides the generated definition of `AvailabilitySpec`.
 * INTERNAL: Do not import directly.
 */

private import codeql.swift.generated.Synth
private import codeql.swift.generated.Raw
import codeql.swift.elements.internal.AstNodeImpl::Impl as AstNodeImpl

/**
 * INTERNAL: This module contains the fully generated definition of `AvailabilitySpec` and should not
 * be referenced directly.
 */
module Generated {
  /**
   * An availability spec, that is, part of an `AvailabilityInfo` condition. For example `iOS 12` and `*` in:
   * ```
   * if #available(iOS 12, *)
   * ```
   * INTERNAL: Do not reference the `Generated::AvailabilitySpec` class directly.
   * Use the subclass `AvailabilitySpec`, where the following predicates are available.
   */
  class AvailabilitySpec extends Synth::TAvailabilitySpec, AstNodeImpl::AstNode {
    override string getAPrimaryQlClass() { result = "AvailabilitySpec" }

    /**
     * Gets the platform of this availability spec, if it exists.
     */
    string getPlatform() {
      result = Synth::convertAvailabilitySpecToRaw(this).(Raw::AvailabilitySpec).getPlatform()
    }

    /**
     * Holds if `getPlatform()` exists.
     */
    final predicate hasPlatform() { exists(this.getPlatform()) }

    /**
     * Gets the version of this availability spec, if it exists.
     */
    string getVersion() {
      result = Synth::convertAvailabilitySpecToRaw(this).(Raw::AvailabilitySpec).getVersion()
    }

    /**
     * Holds if `getVersion()` exists.
     */
    final predicate hasVersion() { exists(this.getVersion()) }

    /**
     * Holds if this availability spec is wildcard.
     */
    predicate isWildcard() {
      Synth::convertAvailabilitySpecToRaw(this).(Raw::AvailabilitySpec).isWildcard()
    }
  }
}
