/*!
 Name: vue-upload-component 
Component URI: https://github.com/lian-yue/vue-upload-component#readme 
Version: 3.0.39 
Author: LianYue 
License: Apache-2.0 
Description: Vue.js file upload component, Multi-file upload, Upload directory, Drag upload, Drag the directory, Upload multiple files at the same time, html4 (IE 9), `PUT` method, Customize the filter 
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t(require("vue")):"function"==typeof define&&define.amd?define(["vue"],t):(e="undefined"!=typeof globalThis?globalThis:e||self).VueUploadComponent=t(e.Vue)}(this,function(e){"use strict";function t(e){return e&&"object"==typeof e&&"default"in e?e:{default:e}}var n,l=t(e);return function(e){function c(e){return function(e){if(Array.isArray(e))return r(e)}(e)||function(e){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(e))return Array.from(e)}(e)||function(e,t){if(!e)return;if("string"==typeof e)return r(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return r(e,t)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function r(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}function t(t,e){var n,r=Object.keys(t);return Object.getOwnPropertySymbols&&(n=Object.getOwnPropertySymbols(t),e&&(n=n.filter(function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable})),r.push.apply(r,n)),r}function d(r){for(var e=1;e<arguments.length;e++){var i=null!=arguments[e]?arguments[e]:{};e%2?t(Object(i),!0).forEach(function(e){var t,n;t=r,e=i[n=e],n in t?Object.defineProperty(t,n,{value:e,enumerable:!0,configurable:!0,writable:!0}):t[n]=e}):Object.getOwnPropertyDescriptors?Object.defineProperties(r,Object.getOwnPropertyDescriptors(i)):t(Object(i)).forEach(function(e){Object.defineProperty(r,e,Object.getOwnPropertyDescriptor(i,e))})}return r}function o(e){return(o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function i(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}function s(e){var r,t,n=u(e);return r=n,t=e.body,new Promise(function(e,n){r.onload=function(){if(200<=r.status&&r.status<300){var t;try{t=JSON.parse(r.response)}catch(e){t=r.response}e(t)}else n(r.response)},r.onerror=function(){return n(r.response)},r.send(JSON.stringify(t))})}var a,u,n;e.exports=(a=l.default,u=function(t){var n=new XMLHttpRequest;return n.open(t.method||"GET",t.url),n.responseType="json",t.headers&&Object.keys(t.headers).forEach(function(e){n.setRequestHeader(e,t.headers[e])}),n},n={headers:{},action:"",minSize:1048576,maxActive:3,maxRetries:5,handler:function(){function n(e,t){!function(e){if(!(e instanceof n))throw new TypeError("Cannot call a class as a function")}(this),this.file=e,this.options=t,this.chunks=[],this.sessionId=null,this.chunkSize=null,this.speedInterval=null}var e,t,r;return e=n,(t=[{key:"createChunks",value:function(){this.chunks=[];for(var e=0,t=this.chunkSize;e<this.fileSize;)this.chunks.push({blob:this.file.file.slice(e,t),startOffset:e,active:!1,retries:this.maxRetries}),t=(e=t)+this.chunkSize}},{key:"updateFileProgress",value:function(){this.file.progress=this.progress}},{key:"pause",value:function(){this.file.active=!1,this.stopChunks()}},{key:"stopChunks",value:function(){this.chunksUploading.forEach(function(e){e.xhr.abort(),e.active=!1}),this.stopSpeedCalc()}},{key:"resume",value:function(){this.file.active=!0,this.startChunking()}},{key:"upload",value:function(){var n=this;return this.promise=new Promise(function(e,t){n.resolve=e,n.reject=t}),this.start(),this.promise}},{key:"start",value:function(){var t=this;s({method:"POST",headers:Object.assign({},this.headers,{"Content-Type":"application/json"}),url:this.action,body:Object.assign(this.startBody,{phase:"start",mime_type:this.fileType,size:this.fileSize,name:this.fileName})}).then(function(e){return"success"!==e.status?(t.file.response=e,t.reject("server")):(t.sessionId=e.data.session_id,t.chunkSize=e.data.end_offset,t.createChunks(),void t.startChunking())}).catch(function(e){t.file.response=e,t.reject("server")})}},{key:"startChunking",value:function(){for(var e=0;e<this.maxActiveChunks;e++)this.uploadNextChunk();this.startSpeedCalc()}},{key:"uploadNextChunk",value:function(){if(this.file.active)return this.hasChunksToUpload?this.uploadChunk(this.chunksToUpload[0]):0===this.chunksUploading.length?this.finish():void 0}},{key:"uploadChunk",value:function(t){var n=this;t.progress=0,t.active=!0,this.updateFileProgress(),t.xhr=u({method:"POST",headers:this.headers,url:this.action}),t.xhr.upload.addEventListener("progress",function(e){e.lengthComputable&&(t.progress=Math.round(e.loaded/e.total*100))},!1),function(r,e){var t,i=new FormData;for(t in e)i.append(t,e[t]);return new Promise(function(e,n){r.onload=function(){if(200<=r.status&&r.status<300){var t;try{t=JSON.parse(r.response)}catch(e){t=r.response}e(t)}else n(r.response)},r.onerror=function(){return n(r.response)},r.send(i)})}(t.xhr,Object.assign(this.uploadBody,{phase:"upload",session_id:this.sessionId,start_offset:t.startOffset,chunk:t.blob})).then(function(e){if(t.active=!1,"success"===e.status)t.uploaded=!0;else if(t.retries--<=0)return n.stopChunks(),n.reject("upload");n.uploadNextChunk()}).catch(function(){return t.active=!1,t.retries--<=0?(n.stopChunks(),n.reject("upload")):void n.uploadNextChunk()})}},{key:"finish",value:function(){var t=this;this.updateFileProgress(),this.stopSpeedCalc(),s({method:"POST",headers:Object.assign({},this.headers,{"Content-Type":"application/json"}),url:this.action,body:Object.assign(this.finishBody,{phase:"finish",session_id:this.sessionId})}).then(function(e){return"success"!==(t.file.response=e).status?t.reject("server"):void t.resolve(e)}).catch(function(e){t.file.response=e,t.reject("server")})}},{key:"startSpeedCalc",value:function(){var t=this,n=this.file.speed=0;this.speedInterval||(this.speedInterval=window.setInterval(function(){var e=t.progress/100*t.fileSize;t.file.speed=e-n,n=e},1e3))}},{key:"stopSpeedCalc",value:function(){this.speedInterval&&window.clearInterval(this.speedInterval),this.speedInterval=null,this.file.speed=0}},{key:"maxRetries",get:function(){return parseInt(this.options.maxRetries,10)}},{key:"maxActiveChunks",get:function(){return parseInt(this.options.maxActive,10)}},{key:"fileType",get:function(){return this.file.type}},{key:"fileSize",get:function(){return this.file.size}},{key:"fileName",get:function(){return this.file.name}},{key:"action",get:function(){return this.options.action||null}},{key:"startBody",get:function(){return this.options.startBody||{}}},{key:"uploadBody",get:function(){return this.options.uploadBody||{}}},{key:"finishBody",get:function(){return this.options.finishBody||{}}},{key:"headers",get:function(){return this.options.headers||{}}},{key:"readyToUpload",get:function(){return!!this.chunks}},{key:"progress",get:function(){var n=this,e=this.chunksUploaded.length/this.chunks.length*100,t=this.chunksUploading.reduce(function(e,t){return e+(0|t.progress)/n.chunks.length},0);return Math.min(e+t,100)}},{key:"chunksToUpload",get:function(){return this.chunks.filter(function(e){return!e.active&&!e.uploaded})}},{key:"hasChunksToUpload",get:function(){return 0<this.chunksToUpload.length}},{key:"chunksUploading",get:function(){return this.chunks.filter(function(e){return!!e.xhr&&!!e.active})}},{key:"chunksUploaded",get:function(){return this.chunks.filter(function(e){return!!e.uploaded})}}])&&i(e.prototype,t),r&&i(e,r),n}()},e=a.defineComponent({props:{inputId:{type:String},name:{type:String,default:"file"},accept:{type:String},capture:{},disabled:{default:!1},multiple:{type:Boolean,default:!1},maximum:{type:Number},addIndex:{type:[Boolean,Number]},directory:{type:Boolean},createDirectory:{type:Boolean,default:!1},postAction:{type:String},putAction:{type:String},customAction:{type:Function},headers:{type:Object,default:function(){return{}}},data:{type:Object,default:function(){return{}}},timeout:{type:Number,default:0},drop:{default:!1},dropDirectory:{type:Boolean,default:!0},size:{type:Number,default:0},extensions:{type:[RegExp,String,Array],default:function(){return[]}},modelValue:{type:Array,default:function(){return[]}},thread:{type:Number,default:1},chunkEnabled:{type:Boolean,default:!1},chunk:{type:Object,default:function(){return n}}},emits:["update:modelValue","input-filter","input-file"],data:function(){return{files:this.modelValue,features:{html5:!0,directory:!1,drop:!1},active:!1,dropActive:!1,uploading:0,destroy:!1,maps:{},dropElement:null}},mounted:function(){var e=this,t=document.createElement("input");if(t.type="file",t.multiple=!0,window.FormData&&t.files?("boolean"!=typeof t.webkitdirectory&&"boolean"!=typeof t.directory||(this.features.directory=!0),this.features.html5&&void 0!==t.ondrop&&(this.features.drop=!0)):this.features.html5=!1,this.maps={},this.files)for(var n=0;n<this.files.length;n++){var r=this.files[n];this.maps[r.id]=r}this.$nextTick(function(){e.$parent?(e.$parent.$forceUpdate(),e.$parent.$nextTick(function(){e.watchDrop(e.drop)})):e.watchDrop(e.drop)})},beforeUnmount:function(){this.destroy=!0,this.active=!1,this.watchDrop(!1)},computed:{uploaded:function(){for(var e,t=0;t<this.files.length;t++)if((e=this.files[t]).fileObject&&!e.error&&!e.success)return!1;return!0},chunkOptions:function(){return Object.assign(n,this.chunk)},className:function(){return["file-uploads",this.features.html5?"file-uploads-html5":"file-uploads-html4",this.features.directory&&this.directory?"file-uploads-directory":void 0,this.features.drop&&this.drop?"file-uploads-drop":void 0,this.disabled?"file-uploads-disabled":void 0]},forId:function(){return this.inputId||this.name},iMaximum:function(){return void 0===this.maximum?this.multiple?0:1:this.maximum},iExtensions:function(){if(this.extensions){if(this.extensions instanceof RegExp)return this.extensions;var e=[];return e=(e="string"==typeof this.extensions?this.extensions.split(","):this.extensions).map(function(e){return e.trim()}).filter(function(e){return e}),new RegExp("\\.("+e.join("|").replace(/\./g,"\\.")+")$","i")}}},watch:{active:function(e){this.watchActive(e)},dropActive:function(){this.$parent&&this.$parent.$forceUpdate()},drop:function(e){this.watchDrop(e)},modelValue:function(e){if(this.files!==e){this.files=e;var t=this.maps;this.maps={};for(var n,r,i=0;i<this.files.length;i++){var o=this.files[i];this.maps[o.id]=o}for(n in this.maps){var s=this.maps[n],a=t[n];s!==a&&this.emitFile(s,a)}for(r in t)this.maps[r]||this.emitFile(void 0,t[r])}}},methods:{newId:function(){return Math.random().toString(36).substr(2)},clear:function(){if(this.files.length){var e=this.files;this.files=[],this.maps={},this.emitInput();for(var t=0;t<e.length;t++)this.emitFile(void 0,e[t])}return!0},get:function(e){return!!e&&("object"===o(e)?this.maps[e.id||""]||!1:this.maps[e]||!1)},add:function(e,t){var n=e instanceof Array?e:[e];void 0===t&&(t=this.addIndex);for(var r,i=[],o=0;o<n.length;o++){var s=n[o];this.features.html5&&s instanceof Blob&&(s={id:"",file:s,size:s.size,name:s.webkitRelativePath||s.relativePath||s.name||"unknown",type:s.type});var a=!1;if(!1===s.fileObject||(s.fileObject||"undefined"!=typeof Element&&s.el instanceof HTMLInputElement||"undefined"!=typeof Blob&&s.file instanceof Blob)&&(a=!0),a&&((s=d(d({fileObject:!0,size:-1,name:"Filename",type:"",active:!1,error:"",success:!1,putAction:this.putAction,postAction:this.postAction,timeout:this.timeout},s),{},{response:{},progress:"0.00",speed:0})).data=d(d({},this.data),s.data||{}),s.headers=d(d({},this.headers),s.headers||{})),s.id||(s.id=this.newId()),!this.emitFilter(s,void 0)){if(1<this.iMaximum&&i.length+this.files.length>=this.iMaximum)break;if(i.push(s),1===this.iMaximum)break}}if(i.length){1===this.iMaximum&&this.clear(),!0===t||0===t?r=i.concat(this.files):t?(r=this.files.concat([])).splice.apply(r,[t,0].concat(i)):r=this.files.concat(i),this.files=r;for(var u=0;u<i.length;u++){var l=i[u];this.maps[l.id]=l}this.emitInput();for(var c=0;c<i.length;c++)this.emitFile(i[c],void 0);return e instanceof Array?i:i[0]}},addInputFile:function(e){var t=this,n=[],r=(this.iMaximum,e.webkitEntries||e.entries||void 0);if(null!=r&&r.length)return this.getFileSystemEntry(r).then(function(e){return t.add(e)});if(e.files)for(var i=0;i<e.files.length;i++){var o=e.files[i];n.push({id:"",size:o.size,name:o.webkitRelativePath||o.relativePath||o.name,type:o.type,file:o})}else{r=e.value.replace(/\\/g,"/").split("/");r&&r.length||(r=[e.value]),delete e.__vuex__,n.push({id:"",name:r[r.length-1],el:e})}return Promise.resolve(this.add(n))},addDataTransfer:function(e){var t,n=this;if(null!=e&&null!==(t=e.items)&&void 0!==t&&t.length){for(var r=[],i=0;i<e.items.length;i++){var o=e.items[i],s=void 0;(s=o.getAsEntry?o.getAsEntry()||o.getAsFile():o.webkitGetAsEntry&&o.webkitGetAsEntry()||o.getAsFile())&&r.push(s)}return this.getFileSystemEntry(r).then(function(e){return n.add(e)})}var a=this.iMaximum,u=[];if(e.files.length){for(var l=0;l<e.files.length&&(u.push(e.files[l]),!(0<a&&u.length>=a));l++);return Promise.resolve(this.add(u))}return Promise.resolve([])},getFileSystemEntry:function(a){var u=this,l=1<arguments.length&&void 0!==arguments[1]?arguments[1]:"";return new Promise(function(i){var r,o,e,s=u.iMaximum;a?a instanceof Array?(r=[],function t(n){var e=a[n];if(!e||0<s&&r.length>=s)return i(r);u.getFileSystemEntry(e,l).then(function(e){r.push.apply(r,c(e)),t(n+1)})}(0)):a instanceof Blob?i([{id:"",size:a.size,name:l+a.name,type:a.type,file:a}]):a.isFile?a.file(function(e){i([{id:"",size:e.size,name:l+e.name,type:e.type,file:e}])}):a.isDirectory&&u.dropDirectory?(o=[],u.createDirectory&&o.push({id:"",name:l+a.name,size:0,type:"text/directory",file:new File([],l+a.name,{type:"text/directory"})}),e=a.createReader(),function r(){e.readEntries(function(e){(function t(n){return!e[n]&&0===n||0<s&&o.length>=s?i(o):e[n]?void u.getFileSystemEntry(e[n],l+a.name+"/").then(function(e){o.push.apply(o,c(e)),t(n+1)}):r()})(0)})}()):i([]):i([])})},replace:function(e,t){var n=this.get(e),r=this.get(t);if(!n||!r||n===r)return!1;var i=this.files.concat([]),e=i.indexOf(n),t=i.indexOf(r);return-1!==e&&-1!==t&&(i[e]=r,i[t]=n,this.files=i,this.emitInput(),!0)},remove:function(e){var t=this.get(e);if(t){if(this.emitFilter(void 0,t))return!1;var n=this.files.concat([]),e=n.indexOf(t);if(-1===e)return console.error("remove",t),!1;n.splice(e,1),this.files=n,delete this.maps[t.id],this.emitInput(),this.emitFile(void 0,t)}return t},update:function(e,t){var n=this.get(e);if(n){var r=d(d({},n),t);if(!n.fileObject||!n.active||r.active||r.error||r.success||(r.error="abort"),this.emitFilter(r,n))return!1;e=this.files.concat([]),t=e.indexOf(n);return-1===t?(console.error("update",n),!1):(e.splice(t,1,r),this.files=e,delete this.maps[n.id],this.maps[r.id]=r,this.emitInput(),this.emitFile(r,n),r)}return!1},emitFilter:function(e,t){var n=!1;return this.$emit("input-filter",e,t,function(){return n=!(0<arguments.length&&void 0!==arguments[0])||arguments[0]}),n},emitFile:function(t,e){var n=this;this.$emit("input-file",t,e),null==t||!t.fileObject||!t.active||e&&e.active?t&&t.fileObject&&t.active||!e||!e.fileObject||!e.active||this.uploading--:(this.uploading++,this.$nextTick(function(){setTimeout(function(){t&&n.upload(t).then(function(){null!==(t=t&&(n.get(t)||void 0))&&void 0!==t&&t.fileObject&&n.update(t,{active:!1,success:!t.error})}).catch(function(e){t&&n.update(t,{active:!1,success:!1,error:e.code||e.error||e.message||e})})},Math.ceil(50*Math.random()+50))})),!this.active||Boolean(t)===Boolean(e)&&t.active===e.active||this.watchActive(!0)},emitInput:function(){this.$emit("update:modelValue",this.files)},upload:function(e){e=this.get(e);if(!e)return Promise.reject(new Error("not_exists"));if(!e.fileObject)return Promise.reject(new Error("file_object"));if(e.error)return e.error instanceof Error?Promise.reject(e.error):Promise.reject(new Error(e.error));if(e.success)return Promise.resolve(e);this.extensions;if(e.name&&this.iExtensions&&-1===e.name.search(this.iExtensions))return Promise.reject(new Error("extension"));if(0<this.size&&void 0!==e.size&&0<=e.size&&e.size>this.size)return Promise.reject(new Error("size"));if(this.customAction)return this.customAction(e,this);if(this.features.html5){if(this.shouldUseChunkUpload(e))return this.uploadChunk(e);if(e.putAction)return this.uploadPut(e);if(e.postAction)return this.uploadHtml5(e)}return e.postAction?this.uploadHtml4(e):Promise.reject(new Error("No action configured"))},shouldUseChunkUpload:function(e){return this.chunkEnabled&&!!this.chunkOptions.handler&&e.size&&e.size>this.chunkOptions.minSize},uploadChunk:function(t){var e=this.chunkOptions.handler;return t.chunk=new e(t,this.chunkOptions),t.chunk.upload().then(function(e){return t})},uploadPut:function(e){var t,n,r=[];for(n in e.data)null!=(t=e.data[n])&&r.push(encodeURIComponent(n)+"="+encodeURIComponent(t));var i=e.putAction||"",o=r.length?(-1===i.indexOf("?")?"?":"&")+r.join("&"):"",s=new XMLHttpRequest;return s.open("PUT",i+o),this.uploadXhr(s,e,e.file)},uploadHtml5:function(e){var t,n,r=new window.FormData;for(n in e.data)(t=e.data[n])&&"object"===o(t)&&"function"!=typeof t.toString?t instanceof File?r.append(n,t,t.name):r.append(n,JSON.stringify(t)):null!=t&&r.append(n,t);r.append(this.name,e.file,e.file.name||e.file.filename||e.name);var i=new XMLHttpRequest;return i.open("POST",e.postAction||""),this.uploadXhr(i,e,r)},uploadXhr:function(s,e,n){var a=this,u=e,r=0,i=0;s.upload.onprogress=function(e){var t;u&&(u=a.get(u),e.lengthComputable&&u&&u.fileObject&&u.active&&((t=Math.round(Date.now()/1e3))!==r&&(r=t,u=a.update(u,{progress:(e.loaded/e.total*100).toFixed(2),speed:e.loaded-i}),i=e.loaded)))};var l=window.setInterval(function(){if(u&&((u=a.get(u))&&null!==u&&void 0!==u&&u.fileObject&&!u.success&&!u.error&&u.active))return;l&&(clearInterval(l),l=void 0);try{s.abort(),s.timeout=1}catch(e){}},100);return new Promise(function(r,i){if(u){var o,e,t=function(e){if(!o){if(o=!0,l&&(clearInterval(l),l=void 0),!u)return i(new Error("not_exists"));if(!(u=a.get(u)))return i(new Error("not_exists"));if(!u.fileObject)return i(new Error("file_object"));if(u.error)return u.error instanceof Error?i(u.error):i(new Error(u.error));if(!u.active)return i(new Error("abort"));if(u.success)return r(u);var t,n={};switch(e.type){case"timeout":case"abort":n.error=e.type;break;case"error":s.status?500<=s.status?n.error="server":400<=s.status&&(n.error="denied"):n.error="network";break;default:500<=s.status?n.error="server":400<=s.status?n.error="denied":n.progress="100.00"}return s.responseText&&((t=s.getResponseHeader("Content-Type"))&&-1!==t.indexOf("/json")?n.response=JSON.parse(s.responseText):n.response=s.responseText),(u=a.update(u,n))?u.error?u.error instanceof Error?i(u.error):i(new Error(u.error)):r(u):i(new Error("abort"))}};for(e in s.onload=t,s.onerror=t,s.onabort=t,s.ontimeout=t,u.timeout&&(s.timeout=u.timeout),u.headers)s.setRequestHeader(e,u.headers[e]);(u=a.update(u,{xhr:s}))&&s.send(n)}else i(new Error("not_exists"))})},uploadHtml4:function(e){var a=this,u=e;if(!u)return Promise.reject(new Error("not_exists"));function l(e){27===e.keyCode&&e.preventDefault()}var c=document.createElement("iframe");c.id="upload-iframe-"+u.id,c.name="upload-iframe-"+u.id,c.src="about:blank",c.setAttribute("style","width:1px;height:1px;top:-999em;position:absolute; margin-top:-999em;");var t,n=document.createElement("form");for(t in n.setAttribute("action",u.postAction||""),n.name="upload-form-"+u.id,n.setAttribute("method","POST"),n.setAttribute("target","upload-iframe-"+u.id),n.setAttribute("enctype","multipart/form-data"),u.data){var r,i=u.data[t];i&&"object"===o(i)&&"function"!=typeof i.toString&&(i=JSON.stringify(i)),null!=i&&((r=document.createElement("input")).type="hidden",r.name=t,r.value=i,n.appendChild(r))}n.appendChild(u.el),document.body.appendChild(c).appendChild(n);return new Promise(function(o,s){setTimeout(function(){if(u){if(!(u=a.update(u,{iframe:c})))return s(new Error("not_exists"));var r,i=window.setInterval(function(){(u=u&&a.get(u))&&u.fileObject&&!u.success&&!u.error&&u.active||(i&&(clearInterval(i),i=void 0),c.onabort({type:u?"abort":"not_exists"}))},100),e=function(e){if(!r){if(r=!0,i&&(clearInterval(i),i=void 0),document.body.removeEventListener("keydown",l),!u)return s(new Error("not_exists"));if(!(u=a.get(u)))return s(new Error("not_exists"));if(!u.fileObject)return s(new Error("file_object"));if(u.error)return u.error instanceof Error?s(u.error):s(new Error(u.error));if(!u.active)return s(new Error("abort"));if(u.success)return o(u);var t=function(){var t;try{c.contentWindow&&(t=c.contentWindow.document)}catch(e){}if(!t)try{t=c.contentDocument||c.document}catch(e){t=c.document}return null!==t&&void 0!==t&&t.body?t.body.innerHTML:null}(),n={};if("string"==typeof e)return s(new Error(e));switch(e.type){case"abort":n.error="abort";break;case"error":u.error?n.error=u.error:n.error=null===t?"network":"denied";break;default:u.error?n.error=u.error:null===t?n.error="network":n.progress="100.00"}if(null!==t){if(t&&"{"===t.substr(0,1)&&"}"===t.substr(t.length-1,1))try{t=JSON.parse(t)}catch(e){}n.response=t}return(u=a.update(u,n))?null!==u&&void 0!==u&&u.error?u.error instanceof Error?s(u.error):s(new Error(u.error)):o(u):s(new Error("not_exists"))}};c.onload=e,c.onerror=e,c.onabort=e,document.body.addEventListener("keydown",l),n.submit()}else s(new Error("not_exists"))},50)}).then(function(e){var t;return null==c||null!==(t=c.parentNode)&&void 0!==t&&t.removeChild(c),e}).catch(function(e){var t;return null==c||null!==(t=c.parentNode)&&void 0!==t&&t.removeChild(c),e})},watchActive:function(e){for(var t,n=0;t=this.files[n];)if(n++,t.fileObject)if(e&&!this.destroy){if(this.uploading>=this.thread||this.uploading&&!this.features.html5)break;t.active||t.error||t.success||this.update(t,{active:!0})}else t.active&&this.update(t,{active:!1});else;0===this.uploading&&(this.active=!1)},watchDrop:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:void 0;if(this.features.drop&&e!==t){if(this.dropElement)try{document.removeEventListener("dragenter",this.onDragenter,!1),document.removeEventListener("dragleave",this.onDragleave,!1),document.removeEventListener("drop",this.onDocumentDrop,!1),this.dropElement.removeEventListener("dragover",this.onDragover,!1),this.dropElement.removeEventListener("drop",this.onDrop,!1)}catch(e){}t=null;e&&("string"==typeof e?document.querySelector(e)||this.$root.$el.querySelector(e):t=!0===e?this.$parent.$el:e),this.dropElement=t,this.dropElement&&(document.addEventListener("dragenter",this.onDragenter,!1),document.addEventListener("dragleave",this.onDragleave,!1),document.addEventListener("drop",this.onDocumentDrop,!1),this.dropElement.addEventListener("dragover",this.onDragover,!1),this.dropElement.addEventListener("drop",this.onDrop,!1))}},onDragenter:function(e){var t;e.preventDefault(),this.dropActive||!e.dataTransfer||(null!=(e=e.dataTransfer)&&null!==(t=e.files)&&void 0!==t&&t.length||!e.types||e.types.indexOf&&-1!==e.types.indexOf("Files")||null!==(t=e.types)&&void 0!==t&&t.contains&&e.types.contains("Files"))&&(this.dropActive=!0)},onDragleave:function(e){e.preventDefault(),this.dropActive&&("HTML"===e.target.nodeName||e.target===e.explicitOriginalTarget||!e.fromElement&&(e.clientX<=0||e.clientY<=0||e.clientX>=window.innerWidth||e.clientY>=window.innerHeight))&&(this.dropActive=!1)},onDragover:function(e){e.preventDefault()},onDocumentDrop:function(){this.dropActive=!1},onDrop:function(e){e.preventDefault(),e.dataTransfer&&this.addDataTransfer(e.dataTransfer)},inputOnChange:async function(e){var i=this;if(!(e.target instanceof HTMLInputElement))return Promise.reject(new Error("not HTMLInputElement"));function t(e){var t,n,r;return o.files?(o.value="",o.files.length&&!/safari/i.test(navigator.userAgent)&&(o.type="",o.type="file")):((r=(n=document.getElementById(i.forId)).cloneNode(!0)).value="",r.type="file",r.onChange=i.inputOnChange,null!==(t=n.parentNode)&&void 0!==t&&t.replaceChild(r,n),i.$refs.input=r),e}var o=e.target;return this.addInputFile(e.target).then(t).catch(t)}}}),function(e,t){void 0===t&&(t={});var n,r=t.insertAt;e&&"undefined"!=typeof document&&(n=document.head||document.getElementsByTagName("head")[0],(t=document.createElement("style")).type="text/css","top"===r&&n.firstChild?n.insertBefore(t,n.firstChild):n.appendChild(t),t.styleSheet?t.styleSheet.cssText=e:t.appendChild(document.createTextNode(e)))}("\n.file-uploads {\n  overflow: hidden;\n  position: relative;\n  text-align: center;\n  display: inline-block;\n}\n.file-uploads.file-uploads-html4 input, .file-uploads.file-uploads-html5 label {\n  /* background fix ie  click */\n  background: #fff;\n  opacity: 0;\n  font-size: 20em;\n  z-index: 1;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  position: absolute;\n  width: 100%;\n  height: 100%;\n}\n.file-uploads.file-uploads-html5 input, .file-uploads.file-uploads-html4 label {\n  /* background fix ie  click */\n  background: rgba(255, 255, 255, 0);\n  overflow: hidden;\n  position: fixed;\n  width: 1px;\n  height: 1px;\n  z-index: -1;\n  opacity: 0;\n}\n"),e.render=function(e,t,n,r,i,o){return a.openBlock(),a.createBlock("span",{class:e.className},[a.renderSlot(e.$slots,"default"),a.createVNode("label",{for:e.forId},null,8,["for"]),a.createVNode("input",{ref:"input",type:"file",name:e.name,id:e.forId,accept:e.accept,capture:e.capture,disabled:e.disabled,webkitdirectory:e.directory&&e.features.directory,allowdirs:e.directory&&e.features.directory,directory:e.directory&&e.features.directory,multiple:e.multiple&&e.features.html5,onChange:t[1]||(t[1]=function(){return e.inputOnChange&&e.inputOnChange.apply(e,arguments)})},null,40,["name","id","accept","capture","disabled","webkitdirectory","allowdirs","directory","multiple"])],2)},e)}(n={exports:{}}),n.exports});
//# sourceMappingURL=vue-upload-component.min.js.map
