/*!
 Name: vue-upload-component 
Component URI: https://github.com/lian-yue/vue-upload-component#readme 
Version: 3.1.5 
Author: LianYue 
License: Apache-2.0 
Description: Vue.js file upload component, Multi-file upload, Upload directory, Drag upload, Drag the directory, Upload multiple files at the same time, html4 (IE 9), `PUT` method, Customize the filter 
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t(require("vue")):"function"==typeof define&&define.amd?define(["vue"],t):(e="undefined"!=typeof globalThis?globalThis:e||self).VueUploadComponent=t(e.Vue)}(this,(function(e){"use strict";function t(e){return e&&"object"==typeof e&&"default"in e?e:{default:e}}var r=t(e),n=("undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self&&self,{exports:{}});
/*!
	 Name: vue-upload-component 
	Component URI: https://github.com/lian-yue/vue-upload-component#readme 
	Version: 3.1.5 
	Author: LianYue 
	License: Apache-2.0 
	Description: Vue.js file upload component, Multi-file upload, Upload directory, Drag upload, Drag the directory, Upload multiple files at the same time, html4 (IE 9), `PUT` method, Customize the filter 
	 */
return function(e,t){e.exports=function(e){function t(e){return o(e)||i(e)||n(e)||r()}function r(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function n(e,t){if(e){if("string"==typeof e)return s(e,t);var r=Object.prototype.toString.call(e).slice(8,-1);return"Object"===r&&e.constructor&&(r=e.constructor.name),"Map"===r||"Set"===r?Array.from(e):"Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r)?s(e,t):void 0}}function i(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}function o(e){if(Array.isArray(e))return s(e)}function s(e,t){(null==t||t>e.length)&&(t=e.length);for(var r=0,n=new Array(t);r<t;r++)n[r]=e[r];return n}function a(e,t){var r=Object.keys(e);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(e);t&&(n=n.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),r.push.apply(r,n)}return r}function u(e){for(var t=1;t<arguments.length;t++){var r=null!=arguments[t]?arguments[t]:{};t%2?a(Object(r),!0).forEach((function(t){l(e,t,r[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(r)):a(Object(r)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(r,t))}))}return e}function l(e,t,r){return t in e?Object.defineProperty(e,t,{value:r,enumerable:!0,configurable:!0,writable:!0}):e[t]=r,e}function c(e){return c="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},c(e)}function f(e,t){var r=Object.keys(e);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(e);t&&(n=n.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),r.push.apply(r,n)}return r}function d(e){for(var t=1;t<arguments.length;t++){var r=null!=arguments[t]?arguments[t]:{};t%2?f(Object(r),!0).forEach((function(t){v(e,t,r[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(r)):f(Object(r)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(r,t))}))}return e}function h(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function p(e,t){for(var r=0;r<t.length;r++){var n=t[r];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}function m(e,t,r){return t&&p(e.prototype,t),r&&p(e,r),Object.defineProperty(e,"prototype",{writable:!1}),e}function v(e,t,r){return t in e?Object.defineProperty(e,t,{value:r,enumerable:!0,configurable:!0,writable:!0}):e[t]=r,e}var y=function(e){var t=new XMLHttpRequest;return t.open(e.method||"GET",e.url),t.responseType="json",e.headers&&Object.keys(e.headers).forEach((function(r){t.setRequestHeader(r,e.headers[r])})),t},g=function(e,t){return new Promise((function(r,n){e.onload=function(){if(e.status>=200&&e.status<300){var t;try{t=JSON.parse(e.response)}catch(r){t=e.response}r(t)}else n(e.response)},e.onerror=function(){return n(e.response)},e.send(JSON.stringify(t))}))},b=function(e,t){var r=new FormData;for(var n in t)r.append(n,t[n]);return new Promise((function(t,n){e.onload=function(){if(e.status>=200&&e.status<300){var r;try{r=JSON.parse(e.response)}catch(t){r=e.response}t(r)}else n(e.response)},e.onerror=function(){return n(e.response)},e.send(r)}))};function k(e){var t=y(e);return g(t,e.body)}var w={headers:{},action:"",minSize:1048576,maxActive:3,maxRetries:5,handler:function(){function e(t,r){h(this,e),this.file=t,this.options=r,this.chunks=[],this.sessionId=null,this.chunkSize=null,this.speedInterval=null}return m(e,[{key:"maxRetries",get:function(){return parseInt(this.options.maxRetries,10)}},{key:"maxActiveChunks",get:function(){return parseInt(this.options.maxActive,10)}},{key:"fileType",get:function(){return this.file.type}},{key:"fileSize",get:function(){return this.file.size}},{key:"fileName",get:function(){return this.file.name}},{key:"action",get:function(){return this.options.action||null}},{key:"startBody",get:function(){return this.options.startBody||{}}},{key:"uploadBody",get:function(){return this.options.uploadBody||{}}},{key:"finishBody",get:function(){return this.options.finishBody||{}}},{key:"headers",get:function(){return this.options.headers||{}}},{key:"readyToUpload",get:function(){return!!this.chunks}},{key:"progress",get:function(){var e=this,t=this.chunksUploaded.length/this.chunks.length*100,r=this.chunksUploading.reduce((function(t,r){return t+(0|r.progress)/e.chunks.length}),0);return Math.min(t+r,100)}},{key:"chunksToUpload",get:function(){return this.chunks.filter((function(e){return!e.active&&!e.uploaded}))}},{key:"hasChunksToUpload",get:function(){return this.chunksToUpload.length>0}},{key:"chunksUploading",get:function(){return this.chunks.filter((function(e){return!!e.xhr&&!!e.active}))}},{key:"chunksUploaded",get:function(){return this.chunks.filter((function(e){return!!e.uploaded}))}},{key:"createChunks",value:function(){this.chunks=[];for(var e=0,t=this.chunkSize;e<this.fileSize;)this.chunks.push({blob:this.file.file.slice(e,t),startOffset:e,active:!1,retries:this.maxRetries}),t=(e=t)+this.chunkSize}},{key:"updateFileProgress",value:function(){this.file.progress=this.progress}},{key:"pause",value:function(){this.file.active=!1,this.stopChunks()}},{key:"stopChunks",value:function(){this.chunksUploading.forEach((function(e){e.xhr.abort(),e.active=!1})),this.stopSpeedCalc()}},{key:"resume",value:function(){this.file.active=!0,this.startChunking()}},{key:"upload",value:function(){var e=this;return this.promise=new Promise((function(t,r){e.resolve=t,e.reject=r})),this.start(),this.promise}},{key:"start",value:function(){var e=this;k({method:"POST",headers:d(d({},this.headers),{},{"Content-Type":"application/json"}),url:this.action,body:Object.assign(this.startBody,{phase:"start",mime_type:this.fileType,size:this.fileSize,name:this.fileName})}).then((function(t){if("success"!==t.status)return e.file.response=t,e.reject("server");e.sessionId=t.data.session_id,e.chunkSize=t.data.end_offset,e.createChunks(),e.startChunking()})).catch((function(t){e.file.response=t,e.reject("server")}))}},{key:"startChunking",value:function(){for(var e=0;e<this.maxActiveChunks;e++)this.uploadNextChunk();this.startSpeedCalc()}},{key:"uploadNextChunk",value:function(){if(this.file.active){if(this.hasChunksToUpload)return this.uploadChunk(this.chunksToUpload[0]);if(0===this.chunksUploading.length)return this.finish()}}},{key:"uploadChunk",value:function(e){var t=this;e.progress=0,e.active=!0,this.updateFileProgress(),e.xhr=y({method:"POST",headers:this.headers,url:this.action}),e.xhr.upload.addEventListener("progress",(function(t){t.lengthComputable&&(e.progress=Math.round(t.loaded/t.total*100))}),!1),b(e.xhr,Object.assign(this.uploadBody,{phase:"upload",session_id:this.sessionId,start_offset:e.startOffset,chunk:e.blob})).then((function(r){if(e.active=!1,"success"===r.status)e.uploaded=!0;else if(e.retries--<=0)return t.stopChunks(),t.reject("upload");t.uploadNextChunk()})).catch((function(){if(e.active=!1,e.retries--<=0)return t.stopChunks(),t.reject("upload");t.uploadNextChunk()}))}},{key:"finish",value:function(){var e=this;this.updateFileProgress(),this.stopSpeedCalc(),k({method:"POST",headers:d(d({},this.headers),{},{"Content-Type":"application/json"}),url:this.action,body:Object.assign(this.finishBody,{phase:"finish",session_id:this.sessionId})}).then((function(t){if(e.file.response=t,"success"!==t.status)return e.reject("server");e.resolve(t)})).catch((function(t){e.file.response=t,e.reject("server")}))}},{key:"startSpeedCalc",value:function(){var e=this;this.file.speed=0;var t=0;this.speedInterval||(this.speedInterval=window.setInterval((function(){var r=e.progress/100*e.fileSize;e.file.speed=r-t,t=r}),1e3))}},{key:"stopSpeedCalc",value:function(){this.speedInterval&&window.clearInterval(this.speedInterval),this.speedInterval=null,this.file.speed=0}}]),e}()},x=e.defineComponent({props:{inputId:{type:String},name:{type:String,default:"file"},accept:{type:String},capture:{},disabled:{default:!1},multiple:{type:Boolean,default:!1},maximum:{type:Number},addIndex:{type:[Boolean,Number]},directory:{type:Boolean},createDirectory:{type:Boolean,default:!1},postAction:{type:String},putAction:{type:String},customAction:{type:Function},headers:{type:Object,default:function(){return{}}},data:{type:Object,default:function(){return{}}},timeout:{type:Number,default:0},drop:{default:!1},dropDirectory:{type:Boolean,default:!0},size:{type:Number,default:0},extensions:{type:[RegExp,String,Array],default:function(){return[]}},modelValue:{type:Array,default:function(){return[]}},thread:{type:Number,default:1},chunkEnabled:{type:Boolean,default:!1},chunk:{type:Object,default:function(){return w}}},emits:["update:modelValue","input-filter","input-file"],data:function(){return{files:this.modelValue,features:{html5:!0,directory:!1,drop:!1},active:!1,dropActive:!1,uploading:0,destroy:!1,maps:{},dropElement:null,dropTimeout:null,reload:!1}},mounted:function(){var e=this,t=document.createElement("input");if(t.type="file",t.multiple=!0,window.FormData&&t.files?("boolean"!=typeof t.webkitdirectory&&"boolean"!=typeof t.directory||(this.features.directory=!0),this.features.html5&&void 0!==t.ondrop&&(this.features.drop=!0)):this.features.html5=!1,this.maps={},this.files)for(var r=0;r<this.files.length;r++){var n=this.files[r];this.maps[n.id]=n}this.$nextTick((function(){e.$parent?(e.$parent.$forceUpdate(),e.$parent.$nextTick((function(){e.watchDrop(e.drop)}))):e.watchDrop(e.drop)}))},beforeUnmount:function(){this.destroy=!0,this.active=!1,this.watchDrop(!1),this.watchActive(!1)},computed:{uploaded:function(){for(var e,t=0;t<this.files.length;t++)if((e=this.files[t]).fileObject&&!e.error&&!e.success)return!1;return!0},chunkOptions:function(){return Object.assign(w,this.chunk)},className:function(){return["file-uploads",this.features.html5?"file-uploads-html5":"file-uploads-html4",this.features.directory&&this.directory?"file-uploads-directory":void 0,this.features.drop&&this.drop?"file-uploads-drop":void 0,this.disabled?"file-uploads-disabled":void 0]},forId:function(){return this.inputId||this.name},iMaximum:function(){return void 0===this.maximum?this.multiple?0:1:this.maximum},iExtensions:function(){if(this.extensions){if(this.extensions instanceof RegExp)return this.extensions;if(this.extensions.length){var e=[];return e=(e="string"==typeof this.extensions?this.extensions.split(","):this.extensions).map((function(e){return e.trim()})).filter((function(e){return e})),new RegExp("\\.("+e.join("|").replace(/\./g,"\\.")+")$","i")}}},iDirectory:function(){if(this.directory&&this.features.directory)return!0}},watch:{active:function(e){this.watchActive(e)},dropActive:function(e){this.watchDropActive(e),this.$parent&&this.$parent.$forceUpdate()},drop:function(e){this.watchDrop(e)},modelValue:function(e){if(this.files!==e){this.files=e;var t=this.maps;this.maps={};for(var r=0;r<this.files.length;r++){var n=this.files[r];this.maps[n.id]=n}for(var i in this.maps){var o=this.maps[i],s=t[i];o!==s&&this.emitFile(o,s)}for(var a in t)this.maps[a]||this.emitFile(void 0,t[a])}}},methods:{newId:function(){return Math.random().toString(36).substr(2)},clear:function(){if(this.files.length){var e=this.files;this.files=[],this.maps={},this.emitInput();for(var t=0;t<e.length;t++)this.emitFile(void 0,e[t])}return!0},get:function(e){return!!e&&("object"===c(e)?this.maps[e.id||""]||!1:this.maps[e]||!1)},add:function(e,r){var n;n=e instanceof Array?e:[e],void 0===r&&(r=this.addIndex);for(var i=[],o=0;o<n.length;o++){var s=n[o];this.features.html5&&s instanceof Blob&&(s={id:"",file:s,size:s.size,name:s.webkitRelativePath||s.relativePath||s.name||"unknown",type:s.type});var a=!1;if(!1===(s=s).fileObject||(s.fileObject||"undefined"!=typeof Element&&s.el instanceof HTMLInputElement||"undefined"!=typeof Blob&&s.file instanceof Blob)&&(a=!0),a&&((s=u(u({fileObject:!0,size:-1,name:"Filename",type:"",active:!1,error:"",success:!1,putAction:this.putAction,postAction:this.postAction,timeout:this.timeout},s),{},{response:{},progress:"0.00",speed:0})).data=u(u({},this.data),s.data?s.data:{}),s.headers=u(u({},this.headers),s.headers?s.headers:{})),s.id||(s.id=this.newId()),!this.emitFilter(s,void 0)){if(this.iMaximum>1&&i.length+this.files.length>=this.iMaximum)break;if(i.push(s),1===this.iMaximum)break}}if(i.length){var l;if(1===this.iMaximum&&this.clear(),!0===r||0===r)l=i.concat(this.files);else if(r){var c;(c=l=this.files.concat([])).splice.apply(c,[r,0].concat(t(i)))}else l=this.files.concat(i);this.files=l;var f=0;!0===r||0===r?f=0:r?r>=0?f=r+i.length>this.files.length?this.files.length-i.length:r:(f=this.files.length-i.length+r)<0&&(f=0):f=this.files.length-i.length,i=this.files.slice(f,f+i.length);for(var d=0;d<i.length;d++){var h=i[d];this.maps[h.id]=h}this.emitInput();for(var p=0;p<i.length;p++)this.emitFile(i[p],void 0);return e instanceof Array?i:i[0]}},addInputFile:function(e){var t=this,r=[];this.iMaximum;var n=e.webkitEntries||e.entries||void 0;if(null!=n&&n.length)return this.getFileSystemEntry(n).then((function(e){return t.add(e)}));if(e.files)for(var i=0;i<e.files.length;i++){var o=e.files[i];r.push({id:"",size:o.size,name:o.webkitRelativePath||o.relativePath||o.name,type:o.type,file:o})}else{var s=e.value.replace(/\\/g,"/").split("/");s&&s.length||(s=[e.value]),delete e.__vuex__,r.push({id:"",name:s[s.length-1],el:e})}return Promise.resolve(this.add(r))},addDataTransfer:function(e){var t,r=this;if(null!=e&&null!==(t=e.items)&&void 0!==t&&t.length){for(var n=[],i=0;i<e.items.length;i++){var o=e.items[i],s=void 0;(s=o.getAsEntry?o.getAsEntry()||o.getAsFile():o.webkitGetAsEntry&&o.webkitGetAsEntry()||o.getAsFile())&&n.push(s)}return this.getFileSystemEntry(n).then((function(e){return r.add(e)}))}var a=this.iMaximum,u=[];if(e.files.length){for(var l=0;l<e.files.length&&(u.push(e.files[l]),!(a>0&&u.length>=a));l++);return Promise.resolve(this.add(u))}return Promise.resolve([])},getFileSystemEntry:function(e){var r=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"";return new Promise((function(i){var o=r.iMaximum;if(e)if(e instanceof Array){var s=[];!function a(u){var l=e[u];if(!l||o>0&&s.length>=o)return i(s);r.getFileSystemEntry(l,n).then((function(e){s.push.apply(s,t(e)),a(u+1)}))}(0)}else if(e instanceof Blob)i([{id:"",size:e.size,name:n+e.name,type:e.type,file:e}]);else if(e.isFile)e.file((function(e){i([{id:"",size:e.size,name:n+e.name,type:e.type,file:e}])}));else if(e.isDirectory&&r.dropDirectory){var a=e,u=[];r.createDirectory&&u.push({id:"",name:n+a.name,size:0,type:"text/directory",file:new File([],n+a.name,{type:"text/directory"})});var l=a.createReader(),c=function e(){l.readEntries((function(s){!function l(c){return!s[c]&&0===c||o>0&&u.length>=o?i(u):s[c]?void r.getFileSystemEntry(s[c],n+a.name+"/").then((function(e){u.push.apply(u,t(e)),l(c+1)})):e()}(0)}))};c()}else i([]);else i([])}))},replace:function(e,t){var r=this.get(e),n=this.get(t);if(!r||!n||r===n)return!1;var i=this.files.concat([]),o=i.indexOf(r),s=i.indexOf(n);return-1!==o&&-1!==s&&(i[o]=n,i[s]=r,this.files=i,this.emitInput(),!0)},remove:function(e){var t=this.get(e);if(t){if(this.emitFilter(void 0,t))return!1;var r=this.files.concat([]),n=r.indexOf(t);if(-1===n)return console.error("remove",t),!1;r.splice(n,1),this.files=r,delete this.maps[t.id],this.emitInput(),this.emitFile(void 0,t)}return t},update:function(e,t){var r=this.get(e);if(r){var n=u(u({},r),t);if(!r.fileObject||!r.active||n.active||n.error||n.success||(n.error="abort"),this.emitFilter(n,r))return!1;var i=this.files.concat([]),o=i.indexOf(r);return-1===o?(console.error("update",r),!1):(i.splice(o,1,n),this.files=i,n=this.files[o],delete this.maps[r.id],this.maps[n.id]=n,this.emitInput(),this.emitFile(n,r),n)}return!1},emitFilter:function(e,t){var r=!1;return this.$emit("input-filter",e,t,(function(){return r=!(arguments.length>0&&void 0!==arguments[0])||arguments[0]})),r},emitFile:function(e,t){var r,n=this;this.$emit("input-file",e,t),null===(r=e)||void 0===r||!r.fileObject||!e.active||t&&t.active?e&&e.fileObject&&e.active||!t||!t.fileObject||!t.active||this.uploading--:(this.uploading++,this.$nextTick((function(){setTimeout((function(){e&&n.upload(e).then((function(){var t;e&&(e=n.get(e)||void 0),null!==(t=e)&&void 0!==t&&t.fileObject&&n.update(e,{active:!1,success:!e.error})})).catch((function(t){e&&n.update(e,{active:!1,success:!1,error:t.code||t.error||t.message||t})}))}),Math.ceil(50*Math.random()+50))}))),!this.active||Boolean(e)===Boolean(t)&&e.active===t.active||this.watchActive(!0)},emitInput:function(){this.$emit("update:modelValue",this.files)},upload:function(e){var t=this.get(e);if(!t)return Promise.reject(new Error("not_exists"));if(!t.fileObject)return Promise.reject(new Error("file_object"));if(t.error)return t.error instanceof Error?Promise.reject(t.error):Promise.reject(new Error(t.error));if(t.success)return Promise.resolve(t);if(t.name&&this.iExtensions&&"text/directory"!==t.type&&-1===t.name.search(this.iExtensions))return Promise.reject(new Error("extension"));if(this.size>0&&void 0!==t.size&&t.size>=0&&t.size>this.size&&"text/directory"!==t.type)return Promise.reject(new Error("size"));if(this.customAction)return this.customAction(t,this);if(this.features.html5){if(this.shouldUseChunkUpload(t))return this.uploadChunk(t);if(t.putAction)return this.uploadPut(t);if(t.postAction)return this.uploadHtml5(t)}return t.postAction?this.uploadHtml4(t):Promise.reject(new Error("No action configured"))},shouldUseChunkUpload:function(e){return this.chunkEnabled&&!!this.chunkOptions.handler&&e.size&&e.size>this.chunkOptions.minSize},uploadChunk:function(e){var t=this.chunkOptions.handler;return e.chunk=new t(e,this.chunkOptions),e.chunk.upload().then((function(t){return e}))},uploadPut:function(e){var t,r=[];for(var n in e.data)null!=(t=e.data[n])&&r.push(encodeURIComponent(n)+"="+encodeURIComponent(t));var i=e.putAction||"",o=r.length?(-1===i.indexOf("?")?"?":"&")+r.join("&"):"",s=new XMLHttpRequest;return s.open("PUT",i+o),this.uploadXhr(s,e,e.file)},uploadHtml5:function(e){var t,r=new window.FormData;for(var n in e.data)(t=e.data[n])&&"object"===c(t)&&"function"!=typeof t.toString?t instanceof File?r.append(n,t,t.name):r.append(n,JSON.stringify(t)):null!=t&&r.append(n,t);r.append(this.name,e.file,e.name||e.file.name||e.file.filename);var i=new XMLHttpRequest;return i.open("POST",e.postAction||""),this.uploadXhr(i,e,r)},uploadXhr:function(e,t,r){var n=this,i=t,o=0,s=0;e.upload.onprogress=function(e){if(i&&(i=n.get(i),e.lengthComputable&&i&&i.fileObject&&i.active)){var t=Math.round(Date.now()/1e3);t!==o&&(o=t,i=n.update(i,{progress:(e.loaded/e.total*100).toFixed(2),speed:e.loaded-s}),s=e.loaded)}};var a=window.setInterval((function(){var t;if(!(i&&(i=n.get(i))&&null!==(t=i)&&void 0!==t&&t.fileObject)||i.success||i.error||!i.active){a&&(clearInterval(a),a=void 0);try{e.abort(),e.timeout=1}catch(e){}}}),100);return new Promise((function(t,o){if(i){var s,u=function(r){if(!s){if(s=!0,a&&(clearInterval(a),a=void 0),!i)return o(new Error("not_exists"));if(!(i=n.get(i)))return o(new Error("not_exists"));if(!i.fileObject)return o(new Error("file_object"));if(i.error)return i.error instanceof Error?o(i.error):o(new Error(i.error));if(!i.active)return o(new Error("abort"));if(i.success)return t(i);var u={};switch(r.type){case"timeout":case"abort":u.error=r.type;break;case"error":e.status?e.status>=500?u.error="server":e.status>=400&&(u.error="denied"):u.error="network";break;default:e.status>=500?u.error="server":e.status>=400?u.error="denied":u.progress="100.00"}if(e.responseText){var l=e.getResponseHeader("Content-Type");l&&-1!==l.indexOf("/json")?u.response=JSON.parse(e.responseText):u.response=e.responseText}return(i=n.update(i,u))?i.error?i.error instanceof Error?o(i.error):o(new Error(i.error)):t(i):o(new Error("abort"))}};for(var l in e.onload=u,e.onerror=u,e.onabort=u,e.ontimeout=u,i.timeout&&(e.timeout=i.timeout),i.headers)e.setRequestHeader(l,i.headers[l]);(i=n.update(i,{xhr:e}))&&e.send(r)}else o(new Error("not_exists"))}))},uploadHtml4:function(e){var t=this,r=e;if(!r)return Promise.reject(new Error("not_exists"));var n=function(e){27===e.keyCode&&e.preventDefault()},i=document.createElement("iframe");i.id="upload-iframe-"+r.id,i.name="upload-iframe-"+r.id,i.src="about:blank",i.setAttribute("style","width:1px;height:1px;top:-999em;position:absolute; margin-top:-999em;");var o=document.createElement("form");for(var s in o.setAttribute("action",r.postAction||""),o.name="upload-form-"+r.id,o.setAttribute("method","POST"),o.setAttribute("target","upload-iframe-"+r.id),o.setAttribute("enctype","multipart/form-data"),r.data){var a=r.data[s];if(a&&"object"===c(a)&&"function"!=typeof a.toString&&(a=JSON.stringify(a)),null!=a){var u=document.createElement("input");u.type="hidden",u.name=s,u.value=a,o.appendChild(u)}}o.appendChild(r.el),document.body.appendChild(i).appendChild(o);var l=function(){var e,t;try{i.contentWindow&&(t=i.contentWindow.document)}catch(e){}if(!t)try{t=i.contentDocument?i.contentDocument:i.document}catch(e){t=i.document}return null!==(e=t)&&void 0!==e&&e.body?t.body.innerHTML:null};return new Promise((function(e,s){setTimeout((function(){if(r){if(!(r=t.update(r,{iframe:i})))return s(new Error("not_exists"));var a,u=window.setInterval((function(){r&&(r=t.get(r))&&r.fileObject&&!r.success&&!r.error&&r.active||(u&&(clearInterval(u),u=void 0),i.onabort({type:r?"abort":"not_exists"}))}),100),c=function(i){var o;if(!a){if(a=!0,u&&(clearInterval(u),u=void 0),document.body.removeEventListener("keydown",n),!r)return s(new Error("not_exists"));if(!(r=t.get(r)))return s(new Error("not_exists"));if(!r.fileObject)return s(new Error("file_object"));if(r.error)return r.error instanceof Error?s(r.error):s(new Error(r.error));if(!r.active)return s(new Error("abort"));if(r.success)return e(r);var c=l(),f={};if("string"==typeof i)return s(new Error(i));switch(i.type){case"abort":f.error="abort";break;case"error":r.error?f.error=r.error:f.error=null===c?"network":"denied";break;default:r.error?f.error=r.error:null===c?f.error="network":f.progress="100.00"}if(null!==c){if(c&&"{"===c.substr(0,1)&&"}"===c.substr(c.length-1,1))try{c=JSON.parse(c)}catch(e){}f.response=c}return(r=t.update(r,f))?null!==(o=r)&&void 0!==o&&o.error?r.error instanceof Error?s(r.error):s(new Error(r.error)):e(r):s(new Error("not_exists"))}};i.onload=c,i.onerror=c,i.onabort=c,document.body.addEventListener("keydown",n),o.submit()}else s(new Error("not_exists"))}),50)})).then((function(e){var t;return null==i||null===(t=i.parentNode)||void 0===t||t.removeChild(i),e})).catch((function(e){var t;return null==i||null===(t=i.parentNode)||void 0===t||t.removeChild(i),e}))},watchActive:function(e){for(var t,r=0;t=this.files[r];)if(r++,t.fileObject)if(e&&!this.destroy){if(this.uploading>=this.thread||this.uploading&&!this.features.html5)break;t.active||t.error||t.success||this.update(t,{active:!0})}else t.active&&this.update(t,{active:!1});0===this.uploading&&(this.active=!1)},watchDrop:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:void 0;if(this.features.drop&&e!==t){if(this.dropElement)try{document.removeEventListener("dragenter",this.onDocumentDragenter,!1),document.removeEventListener("dragleave",this.onDocumentDragleave,!1),document.removeEventListener("dragover",this.onDocumentDragover,!1),document.removeEventListener("drop",this.onDocumentDrop,!1),this.dropElement.removeEventListener("dragover",this.onDragover,!1),this.dropElement.removeEventListener("drop",this.onDrop,!1)}catch(e){}var r=null;if(e)if("string"==typeof e)r=document.querySelector(e)||this.$root.$el.querySelector(e);else if(!0===e){var n,i;(r=this.$parent.$el)&&8!==(null===(n=r)||void 0===n?void 0:n.nodeType)||(r=this.$root.$el)&&8!==(null===(i=r)||void 0===i?void 0:i.nodeType)||(r=document.body)}else r=e;this.dropElement=r,this.dropElement&&(document.addEventListener("dragenter",this.onDocumentDragenter,!1),document.addEventListener("dragleave",this.onDocumentDragleave,!1),document.addEventListener("dragover",this.onDocumentDragover,!1),document.addEventListener("drop",this.onDocumentDrop,!1),this.dropElement.addEventListener("dragover",this.onDragover,!1),this.dropElement.addEventListener("drop",this.onDrop,!1))}},watchDropActive:function(e,t){e!==t&&(this.dropTimeout&&(clearTimeout(this.dropTimeout),this.dropTimeout=null),e&&(this.dropTimeout=setTimeout(this.onDocumentDrop,1e3)))},onDocumentDragenter:function(e){var t,r;if(!this.dropActive&&e.dataTransfer){var n=e.dataTransfer;null!=n&&null!==(t=n.files)&&void 0!==t&&t.length?this.dropActive=!0:n.types?(n.types.indexOf&&-1!==n.types.indexOf("Files")||null!==(r=n.types)&&void 0!==r&&r.contains&&n.types.contains("Files"))&&(this.dropActive=!0):this.dropActive=!0,this.dropActive&&this.watchDropActive(!0)}},onDocumentDragleave:function(e){this.dropActive&&(e.target===e.explicitOriginalTarget||!e.fromElement&&(e.clientX<=0||e.clientY<=0||e.clientX>=window.innerWidth||e.clientY>=window.innerHeight))&&(this.dropActive=!1,this.watchDropActive(!1))},onDocumentDragover:function(){this.watchDropActive(!0)},onDocumentDrop:function(){this.dropActive=!1,this.watchDropActive(!1)},onDragover:function(e){e.preventDefault()},onDrop:function(e){e.preventDefault(),e.dataTransfer&&this.addDataTransfer(e.dataTransfer)},inputOnChange:async function(e){var t=this;if(!(e.target instanceof HTMLInputElement))return Promise.reject(new Error("not HTMLInputElement"));e.target;var r=function(e){return t.reload=!0,t.$nextTick((function(){t.reload=!1})),e};return this.addInputFile(e.target).then(r).catch(r)}}}),E=["for"],O=["name","id","accept","capture","disabled","webkitdirectory","allowdirs","directory","multiple"];function j(t,r,n,i,o,s){return e.openBlock(),e.createElementBlock("span",{class:e.normalizeClass(t.className)},[e.renderSlot(t.$slots,"default"),e.createElementVNode("label",{for:t.forId},null,8,E),t.reload?e.createCommentVNode("",!0):(e.openBlock(),e.createElementBlock("input",{key:0,ref:"input",type:"file",name:t.name,id:t.forId,accept:t.accept,capture:t.capture,disabled:t.disabled,webkitdirectory:t.iDirectory,allowdirs:t.iDirectory,directory:t.iDirectory,multiple:t.multiple&&t.features.html5,onChange:r[0]||(r[0]=function(){return t.inputOnChange&&t.inputOnChange.apply(t,arguments)})},null,40,O))],2)}function D(e,t){void 0===t&&(t={});var r=t.insertAt;if(e&&"undefined"!=typeof document){var n=document.head||document.getElementsByTagName("head")[0],i=document.createElement("style");i.type="text/css","top"===r&&n.firstChild?n.insertBefore(i,n.firstChild):n.appendChild(i),i.styleSheet?i.styleSheet.cssText=e:i.appendChild(document.createTextNode(e))}}return D("\n.file-uploads {\n  overflow: hidden;\n  position: relative;\n  text-align: center;\n  display: inline-block;\n}\n.file-uploads.file-uploads-html4 input,\n.file-uploads.file-uploads-html5 label {\n  /* background fix ie  click */\n  background: #fff;\n  opacity: 0;\n  font-size: 20em;\n  z-index: 1;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  position: absolute;\n  width: 100%;\n  height: 100%;\n}\n.file-uploads.file-uploads-html5 input,\n.file-uploads.file-uploads-html4 label {\n  /* background fix ie  click */\n  background: rgba(255, 255, 255, 0);\n  overflow: hidden;\n  position: fixed;\n  width: 1px;\n  height: 1px;\n  z-index: -1;\n  opacity: 0;\n}\n"),x.render=j,x}(r.default)}(n),n.exports}));
//# sourceMappingURL=vue-upload-component.min.js.map
