'use strict';
import * as React from 'react';
import {render, initRoot, togglePanel} from '../components/render';
import {onActivateSubscriptions, onDeactivateSubscriptionsAndUnmount, addToStatusBar} from './subscriptions';
import {setAtomGlobals} from './editor';

class Main {
  root: HTMLElement;
  constructor() {
    global.coderoad = {};
    setAtomGlobals();
    this.root = initRoot();
  }
  activate(): void {
    // create atom panel
    atom.workspace.addRightPanel({
      item: this.root
    });
    onActivateSubscriptions();
    // render React component
    render(this.root);
  }
  consumeStatusBar(statusBar){
    this.statusBarTile = addToStatusBar(statusBar);
  }
  deactivate(): void {
    if (this.statusBarTile) {
      this.statusBarTile.dispose();
      this.statusBarTile = null;
    }
    onDeactivateSubscriptionsAndUnmount();
  }
  toggle(): void {
    togglePanel();
  }
};
export = new Main();
