<p align="center">
  <a href="https://coderoad.github.io/">
    <img alt="CodeRoad Logo" src="https://user-images.githubusercontent.com/9423525/89562564-26b4f780-d7e8-11ea-9eb0-3109b0e55d3b.png" width="100" />
  </a>
</p>
<h1 align="center">
CodeRoad
</h1>

<p align="center">
  <a href="https://marketplace.visualstudio.com/items?itemName=CodeRoad.coderoad" alt="Version"><img src="https://vsmarketplacebadge.apphb.com/version/Coderoad.coderoad.svg" /></a>
  <a href="https://marketplace.visualstudio.com/items?itemName=CodeRoad.coderoad" alt="Installs"><img src="https://vsmarketplacebadge.apphb.com/installs/Coderoad.coderoad.svg" /></a>
   <a href="https://marketplace.visualstudio.com/items?itemName=CodeRoad.coderoad" alt="Downloads"><img src="https://vsmarketplacebadge.apphb.com/downloads/Coderoad.coderoad.svg" /></a>
</p>

CodeRoad is a VSCode extension that allows you to create and play interactive coding tutorials in your editor.

Works with a variety of languages: JavaScript, Python, Bash, SQL, with more to come.

![CodeRoad Example](./docs/static/gif/coderoad-example.gif)

---

## [📖 Documentation](https://coderoad.github.io/docs/overview)

- [Create a Tutorial](https://coderoad.github.io/docs/build-tutorial)
- [Develop the Extension](https://coderoad.github.io/docs/development)

## How CodeRoad Works

1. Text is written in Markdown. [🔗](https://github.com/coderoad/fcc-learn-npm/blob/master/TUTORIAL.md)
2. Tutorials are built on Git using a TDD pattern. [🔗](https://github.com/coderoad/fcc-learn-npm/commits/v0.4.2)
3. Hooks & actions give flexible access to the command line & VSCode API. [📖](https://coderoad.github.io/docs/hooks-actions/)

▶️ &nbsp;[See a video explaining how CodeRoad works](http://www.youtube.com/watch?v=htrbKlgAvuE 'How CodeRoad Works')

📖 &nbsp;[Learn more](https://coderoad.github.io/docs/how-coderoad-works)

---

## Getting Started

### Requirements

- OS: MacOS, Linux, Windows
- VSCode 1.39.2+
- Git

### Install

1. install CodeRoad from [the VSCode Marketplace](https://marketplace.visualstudio.com/items?itemName=CodeRoad.coderoad).
2. reload the window (`ctrl/cmd + R`) to get started.

### Start

![CodeRoad Example](./docs/static/gif/launch-coderoad.gif)

To start the extension, inside VSCode:

- Open an **empty** VSCode workspace (a project folder)
- Launch the app from the VSCode command palette. How?

  - select “View” > “Command Palette” from the top panel OR press `cmd/ctrl + shift + P`
  - in the command palette popup, search for and run `CodeRoad:Start`

---

## Contributing

CodeRoad is an ambitious project, we're always looking for contributors :)

See [CONTRIBUTING.md](./CONTRIBUTING.md).

## License

[AGPL v3](./LICENSE.md)

## Contact & Support

- Create a [GitHub issue](https://github.com/coderoad/coderoad-vscode/issues/new/choose) for bug reports, feature requests, or questions
- Reach out at `coderoadapp@gmail.com`
- Leave [a review](https://marketplace.visualstudio.com/items?itemName=CodeRoad.coderoad&ssr=false#review-details) in the VSCode Marketplace
- Add a ⭐️ star on GitHub to support the project!
